define([ "require", "backbone", "table-dragger", "hbs!tmpl/search/SearchResultLayoutView_tmpl", "modules/Modal", "models/VEntity", "utils/Utils", "utils/Globals", "collection/VSearchList", "models/VCommon", "utils/CommonViewFunction", "utils/Messages", "utils/Enums", "utils/UrlLinks" ], function(require, Backbone, tableDragger, SearchResultLayoutViewTmpl, Modal, VEntity, Utils, Globals, VSearchList, VCommon, CommonViewFunction, Messages, Enums, UrlLinks) {
    "use strict";
    var SearchResultLayoutView = Backbone.Marionette.LayoutView.extend({
        _viewName: "SearchResultLayoutView",
        template: SearchResultLayoutViewTmpl,
        regions: {
            RTagLayoutView: "#r_tagLayoutView",
            RSearchLayoutView: "#r_searchLayoutView",
            REntityTableLayoutView: "#r_searchResultTableLayoutView",
            RSearchQuery: "#r_searchQuery"
        },
        ui: {
            tagClick: '[data-id="tagClick"]',
            termClick: '[data-id="termClick"]',
            addTag: '[data-id="addTag"]',
            addTerm: '[data-id="addTerm"]',
            paginationDiv: '[data-id="paginationDiv"]',
            previousData: "[data-id='previousData']",
            nextData: "[data-id='nextData']",
            pageRecordText: "[data-id='pageRecordText']",
            addAssignTag: "[data-id='addAssignTag']",
            createEntity: "[data-id='createEntity']",
            checkDeletedEntity: "[data-id='checkDeletedEntity']",
            checkSubClassification: "[data-id='checkSubClassification']",
            checkSubType: "[data-id='checkSubType']",
            colManager: "[data-id='colManager']",
            containerCheckBox: "[data-id='containerCheckBox']",
            columnEmptyInfo: "[data-id='columnEmptyInfo']",
            showPage: "[data-id='showPage']",
            gotoPage: "[data-id='gotoPage']",
            gotoPagebtn: "[data-id='gotoPagebtn']",
            activePage: "[data-id='activePage']"
        },
        templateHelpers: function() {
            return {
                entityCreate: Globals.entityCreate,
                searchType: this.searchType,
                fromView: this.fromView,
                isGlossaryView: "glossary" == this.fromView,
                isSearchTab: Utils.getUrlState.isSearchTab()
            };
        },
        events: function() {
            var events = {}, that = this;
            return events["click " + this.ui.tagClick] = function(e) {
                var scope = $(e.currentTarget);
                "i" == e.target.nodeName.toLocaleLowerCase() ? this.onClickTagCross(e) : this.triggerUrl({
                    url: "#!/tag/tagAttribute/" + scope.text(),
                    urlParams: null,
                    mergeBrowserUrl: !1,
                    trigger: !0,
                    updateTabState: null
                });
            }, events["click " + this.ui.termClick] = function(e) {
                var scope = $(e.currentTarget);
                "i" == e.target.nodeName.toLocaleLowerCase() ? this.onClickTermCross(e) : this.triggerUrl({
                    url: "#!/glossary/" + scope.find("i").data("termguid"),
                    urlParams: {
                        gType: "term",
                        viewType: "term",
                        fromView: "entity"
                    },
                    mergeBrowserUrl: !1,
                    trigger: !0,
                    updateTabState: null
                });
            }, events["keyup " + this.ui.gotoPage] = function(e) {
                var code = e.which;
                parseInt(e.currentTarget.value);
                e.currentTarget.value ? that.ui.gotoPagebtn.attr("disabled", !1) : that.ui.gotoPagebtn.attr("disabled", !0), 
                13 == code && e.currentTarget.value && that.gotoPagebtn();
            }, events["change " + this.ui.showPage] = "changePageLimit", events["click " + this.ui.gotoPagebtn] = "gotoPagebtn", 
            events["click " + this.ui.addTag] = "checkedValue", events["click " + this.ui.addTerm] = "onClickAddTermBtn", 
            events["click " + this.ui.addAssignTag] = "checkedValue", events["click " + this.ui.nextData] = "onClicknextData", 
            events["click " + this.ui.previousData] = "onClickpreviousData", events["click " + this.ui.createEntity] = "onClickCreateEntity", 
            events["click " + this.ui.checkDeletedEntity] = "onCheckExcludeIncludeResult", events["click " + this.ui.checkSubClassification] = "onCheckExcludeIncludeResult", 
            events["click " + this.ui.checkSubType] = "onCheckExcludeIncludeResult", events;
        },
        initialize: function(options) {
            if (_.extend(this, _.pick(options, "value", "guid", "initialView", "isTypeTagNotExists", "classificationDefCollection", "entityDefCollection", "typeHeaders", "searchVent", "enumDefCollection", "tagCollection", "searchTableColumns", "isDisable", "fromView", "glossaryCollection", "termName")), 
            this.entityModel = new VEntity(), this.searchCollection = new VSearchList(), this.limit = 25, 
            this.asyncFetchCounter = 0, this.offset = 0, this.bindEvents(), this.arr = [], this.searchType = "Basic Search", 
            this.columnOrder = null, this.value) {
                if (this.value.searchType && "dsl" == this.value.searchType && (this.searchType = "Advanced Search"), 
                this.value.pageLimit) {
                    var pageLimit = parseInt(this.value.pageLimit, 10);
                    _.isNaN(pageLimit) || 0 == pageLimit || pageLimit <= -1 ? (this.value.pageLimit = this.limit, 
                    this.triggerUrl()) : this.limit = pageLimit;
                }
                if (this.value.pageOffset) {
                    var pageOffset = parseInt(this.value.pageOffset, 10);
                    _.isNaN(pageOffset) || pageLimit <= -1 ? (this.value.pageOffset = this.offset, this.triggerUrl()) : this.offset = pageOffset;
                }
            }
        },
        bindEvents: function() {
            var that = this;
            this.listenTo(this.searchCollection, "backgrid:selected", function(model, checked) {
                this.arr = [], checked === !0 ? model.set("isEnable", !0) : model.set("isEnable", !1), 
                this.searchCollection.find(function(item) {
                    if (item.get("isEnable")) {
                        var obj = item.toJSON();
                        that.arr.push({
                            id: obj.guid,
                            model: obj
                        });
                    }
                }), this.arr.length > 0 ? this.$(".multiSelectTag").show() : this.$(".multiSelectTag").hide();
            }), this.listenTo(this.searchCollection, "error", function(model, response) {
                this.hideLoader({
                    type: "error"
                });
                var responseJSON = response && response.responseJSON ? response.responseJSON : null, errorText = responseJSON && (responseJSON.errorMessage || responseJSON.message || responseJSON.error) || "Invalid Expression";
                errorText && (Utils.notifyError({
                    content: errorText
                }), this.$(".searchTable > .well").html("<center>" + errorText + "</center>"));
            }, this), this.listenTo(this.searchCollection, "state-changed", function(state) {
                if (Utils.getUrlState.isSearchTab()) {
                    this.updateColumnList(state);
                    var excludeDefaultColumn = [];
                    this.value && this.value.type && (excludeDefaultColumn = _.without(this.searchTableColumns[this.value.type], "selected", "name", "description", "typeName", "owner", "tag", "term"), 
                    null === this.searchTableColumns[this.value.type] ? this.ui.columnEmptyInfo.show() : this.ui.columnEmptyInfo.hide()), 
                    this.columnOrder = this.getColumnOrder(this.REntityTableLayoutView.$el.find(".colSort th.renderable")), 
                    this.triggerUrl();
                    var attributes = this.searchCollection.filterObj.attributes;
                    excludeDefaultColumn && attributes && (excludeDefaultColumn.length > attributes.length || _.difference(excludeDefaultColumn, attributes).length) && this.fetchCollection(this.value);
                }
            }, this), this.listenTo(this.searchVent, "search:refresh", function(model, response) {
                this.fetchCollection();
            }, this);
        },
        onRender: function() {
            if (this.commonTableOptions = {
                collection: this.searchCollection,
                includePagination: !1,
                includeFooterRecords: !1,
                includeColumnManager: !(!Utils.getUrlState.isSearchTab() || !this.value || "basic" !== this.value.searchType || this.value.profileDBView),
                includeOrderAbleColumns: !1,
                includeSizeAbleColumns: !1,
                includeTableLoader: !1,
                columnOpts: {
                    opts: {
                        initialColumnsVisible: null,
                        saveState: !1
                    },
                    visibilityControlOpts: {
                        buttonTemplate: _.template("<button class='btn btn-action btn-sm pull-right'>Columns&nbsp<i class='fa fa-caret-down'></i></button>")
                    },
                    el: this.ui.colManager
                },
                gridOpts: {
                    emptyText: "No Record found!",
                    className: "table table-hover backgrid table-quickMenu colSort"
                },
                filterOpts: {},
                paginatorOpts: {}
            }, this.initialView) Globals.entityTypeConfList && this.$(".entityLink").show(), 
            this.isTypeTagNotExists && Utils.notifyError({
                content: Messages.search.notExists
            }); else {
                var value = {};
                this.value ? (value = this.value, value && value.includeDE && this.ui.checkDeletedEntity.prop("checked", !0), 
                value && value.excludeSC && this.ui.checkSubClassification.prop("checked", !0), 
                value && value.excludeST && this.ui.checkSubType.prop("checked", !0)) : value = {
                    query: null,
                    searchType: "basic"
                }, this.updateColumnList(), this.value && this.searchTableColumns && null === this.searchTableColumns[this.value.type] ? this.ui.columnEmptyInfo.show() : this.ui.columnEmptyInfo.hide(), 
                this.fetchCollection(value, _.extend({
                    fromUrl: !0
                }, this.value && this.value.pageOffset ? {
                    next: !0
                } : null)), this.ui.showPage.select2({
                    data: _.sortBy(_.union([ 25, 50, 100, 150, 200, 250, 300, 350, 400, 450, 500 ], [ this.limit ])),
                    tags: !0,
                    dropdownCssClass: "number-input",
                    multiple: !1
                }), this.value && this.value.pageLimit && this.ui.showPage.val(this.limit).trigger("change", {
                    skipViewChange: !0
                });
            }
        },
        getColumnOrderWithPosition: function() {
            var that = this;
            return _.map(that.columnOrder, function(value, key) {
                return key + "::" + value;
            }).join(",");
        },
        triggerUrl: function(options) {
            Utils.setUrl(_.extend({
                url: Utils.getUrlState.getQueryUrl().queyParams[0],
                urlParams: this.columnOrder ? _.extend(this.value, {
                    uiParameters: this.getColumnOrderWithPosition()
                }) : this.value,
                mergeBrowserUrl: !1,
                trigger: !1,
                updateTabState: !0
            }, options));
        },
        updateColumnList: function(updatedList) {
            if (updatedList) {
                var listOfColumns = [];
                _.map(updatedList, function(obj) {
                    obj.name;
                    obj.renderable && listOfColumns.push(obj.name);
                }), listOfColumns = _.sortBy(listOfColumns), this.value.attributes = listOfColumns.length ? listOfColumns.join(",") : null, 
                this.value && this.value.type && this.searchTableColumns && (this.searchTableColumns[this.value.type] = listOfColumns.length ? listOfColumns : null);
            } else this.value && this.value.type && this.searchTableColumns && this.value.attributes && (this.searchTableColumns[this.value.type] = this.value.attributes.split(","));
        },
        fetchCollection: function(value, options) {
            var that = this, isPostMethod = this.value && "basic" === this.value.searchType, isSearchTab = Utils.getUrlState.isSearchTab(), tagFilters = null, entityFilters = null;
            if (isSearchTab && (tagFilters = CommonViewFunction.attributeFilter.generateAPIObj(this.value.tagFilters), 
            entityFilters = CommonViewFunction.attributeFilter.generateAPIObj(this.value.entityFilters)), 
            isPostMethod && isSearchTab) var excludeDefaultColumn = this.value.type && this.searchTableColumns ? _.without(this.searchTableColumns[this.value.type], "selected", "name", "description", "typeName", "owner", "tag") : null, filterObj = {
                entityFilters: entityFilters,
                tagFilters: tagFilters,
                attributes: excludeDefaultColumn ? excludeDefaultColumn : null
            };
            this.showLoader(), Globals.searchApiCallRef && 1 === Globals.searchApiCallRef.readyState && Globals.searchApiCallRef.abort();
            var apiObj = {
                skipDefaultError: !0,
                sort: !1,
                success: function(dataOrCollection, response) {
                    if (!that.isDestroyed) {
                        that.ui.gotoPage.val(""), that.ui.gotoPage.parent().removeClass("has-error"), that.ui.gotoPagebtn.prop("disabled", !0), 
                        Globals.searchApiCallRef = void 0;
                        var isFirstPage = 0 === that.offset, dataLength = 0, goToPage = that.ui.gotoPage.val();
                        if (that.ui.pageRecordText instanceof jQuery) {
                            if (dataLength = isPostMethod && dataOrCollection && dataOrCollection.entities ? dataOrCollection.entities.length : dataOrCollection.length, 
                            !dataLength && that.offset >= that.limit && (options && options.next || goToPage) && options && !options.fromUrl) {
                                that.hideLoader();
                                var pageNumber = that.activePage + 1;
                                return goToPage ? (pageNumber = goToPage, that.offset = (that.activePage - 1) * that.limit) : (that.ui.nextData.attr("disabled", !0), 
                                that.offset = that.offset - that.limit), that.value && (that.value.pageOffset = that.offset, 
                                that.triggerUrl()), void Utils.notifyInfo({
                                    html: !0,
                                    content: Messages.search.noRecordForPage + "<b>" + Utils.getNumberSuffix({
                                        number: pageNumber,
                                        sup: !0
                                    }) + "</b> page"
                                });
                            }
                            if (isPostMethod && (that.searchCollection.referredEntities = dataOrCollection.referredEntities, 
                            Utils.findAndMergeRefEntity({
                                attributeObject: dataOrCollection.entities,
                                referredEntities: dataOrCollection.referredEntities
                            }), that.searchCollection.reset(dataOrCollection.entities, {
                                silent: !0
                            })), dataLength < that.limit ? that.ui.nextData.attr("disabled", !0) : that.ui.nextData.attr("disabled", !1), 
                            isFirstPage && (!dataLength || dataLength < that.limit) ? that.ui.paginationDiv.hide() : that.ui.paginationDiv.show(), 
                            isFirstPage ? (that.ui.previousData.attr("disabled", !0), that.pageFrom = 1, that.pageTo = that.limit) : that.ui.previousData.attr("disabled", !1), 
                            options && options.next ? (that.pageTo = that.offset + that.limit, that.pageFrom = that.offset + 1) : !isFirstPage && options && options.previous && (that.pageTo = that.pageTo - that.limit, 
                            that.pageFrom = that.pageTo - that.limit + 1), that.ui.pageRecordText.html("Showing  <u>" + that.searchCollection.models.length + " records</u> From " + that.pageFrom + " - " + that.pageTo), 
                            that.activePage = Math.round(that.pageTo / that.limit), that.ui.activePage.attr("title", "Page " + that.activePage), 
                            that.ui.activePage.text(that.activePage), that.renderTableLayoutView(), Utils.getUrlState.isSearchTab() && value && !value.profileDBView) {
                                var searchString = 'Results for: <span class="filterQuery">' + CommonViewFunction.generateQueryOfFilter(that.value) + "</span>";
                                Globals.entityCreate && Globals.entityTypeConfList && Utils.getUrlState.isSearchTab() && (searchString += '<p>If you do not find the entity in search result below then you can<a href="javascript:void(0)" data-id="createEntity"> create new entity</a></p>'), 
                                that.$(".searchResult").html(searchString);
                            }
                        }
                    }
                },
                silent: !0,
                reset: !0
            };
            if (this.value) var checkBoxValue = {
                excludeDeletedEntities: !this.value.includeDE,
                includeSubClassifications: !this.value.excludeSC,
                includeSubTypes: !this.value.excludeST,
                includeClassificationAttributes: !0
            };
            if (value) {
                if (value.searchType && (this.searchCollection.url = UrlLinks.searchApiUrl(value.searchType)), 
                _.extend(this.searchCollection.queryParams, {
                    limit: this.limit,
                    offset: this.offset,
                    query: _.trim(value.query),
                    typeName: value.type || null,
                    classification: value.tag || null,
                    termName: value.term || null
                }), value.profileDBView && value.typeName && value.guid) {
                    var profileParam = {};
                    profileParam.guid = value.guid, profileParam.relation = "hive_db" === value.typeName ? "__hive_table.db" : "__hbase_table.namespace", 
                    profileParam.sortBy = "name", profileParam.sortOrder = "ASCENDING", _.extend(this.searchCollection.queryParams, profileParam);
                }
                isPostMethod ? (this.searchCollection.filterObj = _.extend({}, filterObj), apiObj.data = _.extend(checkBoxValue, filterObj, _.pick(this.searchCollection.queryParams, "query", "excludeDeletedEntities", "limit", "offset", "typeName", "classification", "termName")), 
                Globals.searchApiCallRef = this.searchCollection.getBasicRearchResult(apiObj)) : (apiObj.data = null, 
                this.searchCollection.filterObj = null, this.value.profileDBView && _.extend(this.searchCollection.queryParams, checkBoxValue), 
                Globals.searchApiCallRef = this.searchCollection.fetch(apiObj));
            } else isPostMethod ? (apiObj.data = _.extend(checkBoxValue, filterObj, _.pick(this.searchCollection.queryParams, "query", "excludeDeletedEntities", "limit", "offset", "typeName", "classification", "termName")), 
            Globals.searchApiCallRef = this.searchCollection.getBasicRearchResult(apiObj)) : (apiObj.data = null, 
            this.value.profileDBView && _.extend(this.searchCollection.queryParams, checkBoxValue), 
            Globals.searchApiCallRef = this.searchCollection.fetch(apiObj));
        },
        renderSearchQueryView: function() {
            var that = this;
            require([ "views/search/SearchQueryView" ], function(SearchQueryView) {
                that.RSearchQuery.show(new SearchQueryView({
                    value: that.value,
                    searchVent: that.searchVent
                }));
            });
        },
        renderTableLayoutView: function(col) {
            var that = this;
            require([ "utils/TableLayout" ], function(TableLayout) {
                if (that.value.uiParameters) var savedColumnOrder = _.object(that.value.uiParameters.split(",").map(function(a) {
                    return a.split("::");
                }));
                var columnCollection = Backgrid.Columns.extend({
                    sortKey: "displayOrder",
                    comparator: function(item) {
                        return item.get(this.sortKey) || 999;
                    },
                    setPositions: function() {
                        return _.each(this.models, function(model, index) {
                            model.set("displayOrder", (null == savedColumnOrder ? index : parseInt(savedColumnOrder[model.get("label")])) + 1, {
                                silent: !0
                            });
                        }), this;
                    }
                }), columns = new columnCollection(that.searchCollection.dynamicTable ? that.getDaynamicColumns(that.searchCollection.toJSON()) : that.getFixedDslColumn());
                columns.setPositions().sort();
                var table = new TableLayout(_.extend({}, that.commonTableOptions, {
                    columns: columns
                }));
                that.REntityTableLayoutView && (that.REntityTableLayoutView.show(table), "dsl" !== that.value.searchType ? that.ui.containerCheckBox.show() : that.ui.containerCheckBox.hide(), 
                that.$(".ellipsis .inputAssignTag").hide(), table.trigger("grid:refresh"), that.isDisable !== !0 && tableDragger(document.querySelector(".colSort")).on("drop", function(from, to, el) {
                    that.columnOrder = that.getColumnOrder(el.querySelectorAll("th.renderable")), table.trigger("grid:refresh:update"), 
                    that.triggerUrl();
                }), that.checkTableFetch());
            });
        },
        getColumnOrder: function(arr) {
            for (var obj = {}, i = 0; i < arr.length; ++i) {
                var innerText = arr[i].innerText.trim();
                obj["" == innerText ? "Select" : innerText] = i;
            }
            return obj;
        },
        checkTableFetch: function() {
            this.asyncFetchCounter <= 0 && (this.hideLoader(), Utils.generatePopover({
                el: this.$('[data-id="showMoreLess"]'),
                contentClass: "popover-tag-term",
                viewFixedPopover: !0,
                popoverOptions: {
                    container: null,
                    content: function() {
                        return $(this).find(".popup-tag-term").children().clone();
                    }
                }
            }));
        },
        getFixedDslColumn: function() {
            var that = this, columnToShow = null, col = {};
            if (this.value && "basic" === this.value.searchType && this.searchTableColumns && void 0 !== this.searchTableColumns[this.value.type] && (columnToShow = null == this.searchTableColumns[this.value.type] ? [] : this.searchTableColumns[this.value.type]), 
            col.Check = {
                name: "selected",
                label: "Select",
                cell: "select-row",
                resizeable: !1,
                orderable: !1,
                renderable: !columnToShow || _.contains(columnToShow, "selected"),
                headerCell: "select-all"
            }, col.name = {
                label: this.value && this.value.profileDBView ? "Table Name" : "Name",
                cell: "html",
                editable: !1,
                sortable: !1,
                resizeable: !0,
                orderable: !0,
                renderable: !0,
                className: "searchTableName",
                formatter: _.extend({}, Backgrid.CellFormatter.prototype, {
                    fromRaw: function(rawValue, model) {
                        var obj = model.toJSON(), nameHtml = "", name = Utils.getName(obj);
                        return nameHtml = obj.guid ? "-1" == obj.guid ? '<span title="' + name + '">' + name + "</span>" : '<a title="' + name + '" href="#!/detailPage/' + obj.guid + (that.fromView ? "?from=" + that.fromView : "") + '">' + name + "</a>" : '<span title="' + name + '">' + name + "</span>", 
                        obj.status && Enums.entityStateReadOnly[obj.status] ? (nameHtml += '<button type="button" title="Deleted" class="btn btn-action btn-md deleteBtn"><i class="fa fa-trash"></i></button>', 
                        '<div class="readOnly readOnlyLink">' + nameHtml + "</div>") : nameHtml;
                    }
                })
            }, col.owner = {
                label: "Owner",
                cell: "String",
                editable: !1,
                sortable: !1,
                resizeable: !0,
                orderable: !0,
                renderable: !0,
                formatter: _.extend({}, Backgrid.CellFormatter.prototype, {
                    fromRaw: function(rawValue, model) {
                        var obj = model.toJSON();
                        if (obj && obj.attributes && obj.attributes.owner) return obj.attributes.owner;
                    }
                })
            }, this.value && this.value.profileDBView && (col.createTime = {
                label: "Date Created",
                cell: "Html",
                editable: !1,
                sortable: !1,
                formatter: _.extend({}, Backgrid.CellFormatter.prototype, {
                    fromRaw: function(rawValue, model) {
                        var obj = model.toJSON();
                        return obj && obj.attributes && obj.attributes.createTime ? new Date(obj.attributes.createTime) : "-";
                    }
                })
            }), this.value && !this.value.profileDBView && (col.description = {
                label: "Description",
                cell: "String",
                editable: !1,
                sortable: !1,
                resizeable: !0,
                orderable: !0,
                renderable: !0,
                formatter: _.extend({}, Backgrid.CellFormatter.prototype, {
                    fromRaw: function(rawValue, model) {
                        var obj = model.toJSON();
                        if (obj && obj.attributes && obj.attributes.description) return obj.attributes.description;
                    }
                })
            }, col.typeName = {
                label: "Type",
                cell: "Html",
                editable: !1,
                sortable: !1,
                resizeable: !0,
                orderable: !0,
                renderable: !columnToShow || _.contains(columnToShow, "typeName"),
                formatter: _.extend({}, Backgrid.CellFormatter.prototype, {
                    fromRaw: function(rawValue, model) {
                        var obj = model.toJSON();
                        if (obj && obj.typeName) return '<a title="Search ' + obj.typeName + '" href="#!/search/searchResult?query=' + obj.typeName + ' &searchType=dsl&dslChecked=true">' + obj.typeName + "</a>";
                    }
                })
            }, this.getTagCol({
                col: col,
                columnToShow: columnToShow
            }), _.contains([ "glossary" ], this.fromView) || this.getTermCol({
                col: col,
                columnToShow: columnToShow
            }), this.value && "basic" === this.value.searchType)) {
                var def = this.entityDefCollection.fullCollection.find({
                    name: this.value.type
                });
                if (def) {
                    var attrObj = Utils.getNestedSuperTypeObj({
                        data: def.toJSON(),
                        collection: this.entityDefCollection,
                        attrMerge: !0
                    });
                    _.each(attrObj, function(obj, key) {
                        var key = obj.name, isRenderable = _.contains(columnToShow, key);
                        return "name" == key || "description" == key || "owner" == key ? void (columnToShow && (col[key].renderable = isRenderable)) : void (col[obj.name] = {
                            label: obj.name.capitalize(),
                            cell: "Html",
                            editable: !1,
                            sortable: !1,
                            resizeable: !0,
                            orderable: !0,
                            renderable: isRenderable,
                            formatter: _.extend({}, Backgrid.CellFormatter.prototype, {
                                fromRaw: function(rawValue, model) {
                                    var modelObj = model.toJSON();
                                    if (modelObj && modelObj.attributes && !_.isUndefined(modelObj.attributes[key])) {
                                        var tempObj = {
                                            scope: that,
                                            attributeDefs: [ obj ],
                                            valueObject: {},
                                            isTable: !1
                                        };
                                        return tempObj.valueObject[key] = modelObj.attributes[key], CommonViewFunction.propertyTable(tempObj);
                                    }
                                }
                            })
                        });
                    });
                }
            }
            return this.searchCollection.constructor.getTableCols(col, this.searchCollection);
        },
        getDaynamicColumns: function(valueObj) {
            var that = this, col = {};
            if (valueObj && valueObj.length) {
                var firstObj = _.first(valueObj);
                _.each(_.keys(firstObj), function(key) {
                    col[key] = {
                        label: key.capitalize(),
                        cell: "Html",
                        editable: !1,
                        sortable: !1,
                        resizeable: !0,
                        orderable: !0,
                        formatter: _.extend({}, Backgrid.CellFormatter.prototype, {
                            fromRaw: function(rawValue, model) {
                                var modelObj = model.toJSON();
                                if ("name" == key) {
                                    var nameHtml = "", name = modelObj[key];
                                    return nameHtml = modelObj.guid ? '<a title="' + name + '" href="#!/detailPage/' + modelObj.guid + (that.fromView ? "?from=" + that.fromView : "") + '">' + name + "</a>" : '<span title="' + name + '">' + name + "</span>", 
                                    modelObj.status && Enums.entityStateReadOnly[modelObj.status] ? (nameHtml += '<button type="button" title="Deleted" class="btn btn-action btn-md deleteBtn"><i class="fa fa-trash"></i></button>', 
                                    '<div class="readOnly readOnlyLink">' + nameHtml + "</div>") : nameHtml;
                                }
                                if (modelObj && !_.isUndefined(modelObj[key])) {
                                    var tempObj = {
                                        scope: that,
                                        valueObject: {},
                                        isTable: !1
                                    };
                                    return tempObj.valueObject[key] = modelObj[key], CommonViewFunction.propertyTable(tempObj);
                                }
                            }
                        })
                    };
                });
            }
            return this.searchCollection.constructor.getTableCols(col, this.searchCollection);
        },
        getTagCol: function(options) {
            var columnToShow = options.columnToShow, col = options.col;
            col && (col.tag = {
                label: "Classifications",
                cell: "Html",
                editable: !1,
                sortable: !1,
                resizeable: !0,
                orderable: !0,
                renderable: !columnToShow || _.contains(columnToShow, "tag"),
                className: "searchTag",
                formatter: _.extend({}, Backgrid.CellFormatter.prototype, {
                    fromRaw: function(rawValue, model) {
                        var obj = model.toJSON();
                        if ("-1" != obj.guid) return obj.status && Enums.entityStateReadOnly[obj.status] ? '<div class="readOnly">' + CommonViewFunction.tagForTable(obj) : CommonViewFunction.tagForTable(obj);
                    }
                })
            });
        },
        getTermCol: function(options) {
            var columnToShow = options.columnToShow, col = options.col;
            col && (col.term = {
                label: "Term",
                cell: "Html",
                editable: !1,
                sortable: !1,
                resizeable: !0,
                orderable: !0,
                renderable: !columnToShow || _.contains(columnToShow, "term"),
                className: "searchTag",
                formatter: _.extend({}, Backgrid.CellFormatter.prototype, {
                    fromRaw: function(rawValue, model) {
                        var obj = model.toJSON();
                        if ("-1" != obj.guid) return obj.typeName && !_.startsWith(obj.typeName, "AtlasGlossary") ? obj.status && Enums.entityStateReadOnly[obj.status] ? '<div class="readOnly">' + CommonViewFunction.termForTable(obj) : CommonViewFunction.termForTable(obj) : void 0;
                    }
                })
            });
        },
        addTagModalView: function(guid, multiple) {
            var that = this;
            require([ "views/tag/AddTagModalView" ], function(AddTagModalView) {
                new AddTagModalView({
                    guid: guid,
                    multiple: multiple,
                    callback: function() {
                        that.fetchCollection(), that.arr = [];
                    },
                    tagList: that.getTagList(guid, multiple),
                    showLoader: that.showLoader.bind(that),
                    hideLoader: that.hideLoader.bind(that),
                    collection: that.classificationDefCollection,
                    enumDefCollection: that.enumDefCollection
                });
            });
        },
        getTagList: function(guid, multiple) {
            if (multiple && 0 !== multiple.length) return [];
            var model = this.searchCollection.find(function(item) {
                var obj = item.toJSON();
                if (obj.guid === guid) return !0;
            });
            if (!model) return [];
            var obj = model.toJSON();
            return _.compact(_.map(obj.classifications, function(val) {
                if (val.entityGuid == guid) return val.typeName;
            }));
        },
        showLoader: function() {
            this.$(".fontLoader:not(.for-ignore)").addClass("show"), this.$(".tableOverlay").addClass("show");
        },
        hideLoader: function(options) {
            this.$(".fontLoader:not(.for-ignore)").removeClass("show"), options && "error" === options.type ? this.$(".ellipsis,.pagination-box").hide() : this.$(".ellipsis,.pagination-box").show(), 
            this.$(".tableOverlay").removeClass("show");
        },
        checkedValue: function(e) {
            var guid = "", that = this, isTagMultiSelect = $(e.currentTarget).hasClass("multiSelectTag");
            isTagMultiSelect && this.arr && this.arr.length ? that.addTagModalView(guid, this.arr) : (guid = that.$(e.currentTarget).data("guid"), 
            that.addTagModalView(guid));
        },
        onClickAddTermBtn: function(e) {
            var that = this, entityGuid = $(e.currentTarget).data("guid"), associatedTerms = this.searchCollection.find({
                guid: entityGuid
            }).get("meanings");
            require([ "views/glossary/AssignTermLayoutView" ], function(AssignTermLayoutView) {
                new AssignTermLayoutView({
                    guid: entityGuid,
                    associatedTerms: associatedTerms,
                    callback: function() {
                        that.fetchCollection();
                    },
                    glossaryCollection: that.glossaryCollection
                });
            });
        },
        onClickTagCross: function(e) {
            var that = this, tagName = $(e.target).data("name"), guid = $(e.target).data("guid"), entityGuid = $(e.target).data("entityguid"), assetName = $(e.target).data("assetname");
            CommonViewFunction.deleteTag({
                tagName: tagName,
                guid: guid,
                associatedGuid: guid != entityGuid ? entityGuid : null,
                msg: "<div class='ellipsis'>Remove: <b>" + _.escape(tagName) + "</b> assignment from <b>" + assetName + " ?</b></div>",
                titleMessage: Messages.removeTag,
                okText: "Remove",
                showLoader: that.showLoader.bind(that),
                hideLoader: that.hideLoader.bind(that),
                callback: function() {
                    that.fetchCollection();
                }
            });
        },
        onClickTermCross: function(e) {
            var $el = $(e.target), termGuid = $el.data("termguid"), guid = $el.data("guid"), termName = $(e.currentTarget).text(), assetname = $el.data("assetname"), meanings = this.searchCollection.find({
                guid: guid
            }).get("meanings"), that = this, termObj = _.find(meanings, {
                termGuid: termGuid
            });
            CommonViewFunction.removeCategoryTermAssociation({
                termGuid: termGuid,
                model: {
                    guid: guid,
                    relationshipGuid: termObj.relationGuid
                },
                collection: that.glossaryCollection,
                msg: "<div class='ellipsis'>Remove: <b>" + _.escape(termName) + "</b> assignment from <b>" + assetname + "?</b></div>",
                titleMessage: Messages.glossary.removeTermfromEntity,
                isEntityView: !0,
                buttonText: "Remove",
                callback: function() {
                    that.fetchCollection();
                }
            });
        },
        onClicknextData: function() {
            this.offset = this.offset + this.limit, _.extend(this.searchCollection.queryParams, {
                offset: this.offset
            }), this.value && (this.value.pageOffset = this.offset, this.triggerUrl()), this.fetchCollection(null, {
                next: !0
            });
        },
        onClickpreviousData: function() {
            this.offset = this.offset - this.limit, this.offset <= -1 && (this.offset = 0), 
            _.extend(this.searchCollection.queryParams, {
                offset: this.offset
            }), this.value && (this.value.pageOffset = this.offset, this.triggerUrl()), this.fetchCollection(null, {
                previous: !0
            });
        },
        onClickCreateEntity: function(e) {
            var that = this;
            $(e.currentTarget).blur(), require([ "views/entity/CreateEntityLayoutView" ], function(CreateEntityLayoutView) {
                new CreateEntityLayoutView({
                    entityDefCollection: that.entityDefCollection,
                    typeHeaders: that.typeHeaders,
                    callback: function() {
                        that.fetchCollection();
                    }
                });
            });
        },
        onCheckExcludeIncludeResult: function(e) {
            var flag = !1, val = $(e.currentTarget).attr("data-value");
            e.target.checked && (flag = !0), this.value && (this.value[val] = flag, this.triggerUrl()), 
            _.extend(this.searchCollection.queryParams, {
                limit: this.limit,
                offset: this.offset
            }), this.fetchCollection();
        },
        changePageLimit: function(e, obj) {
            if (!obj || obj && !obj.skipViewChange) {
                var limit = parseInt(this.ui.showPage.val());
                if (0 == limit) return void this.ui.showPage.data("select2").$container.addClass("has-error");
                this.ui.showPage.data("select2").$container.removeClass("has-error"), this.limit = limit, 
                this.offset = 0, this.value && (this.value.pageLimit = this.limit, this.value.pageOffset = this.offset, 
                this.triggerUrl()), _.extend(this.searchCollection.queryParams, {
                    limit: this.limit,
                    offset: this.offset
                }), this.fetchCollection();
            }
        },
        gotoPagebtn: function(e) {
            var goToPage = parseInt(this.ui.gotoPage.val());
            _.isNaN(goToPage) || goToPage <= -1 || (this.offset = (goToPage - 1) * this.limit, 
            this.offset <= -1 && (this.offset = 0), _.extend(this.searchCollection.queryParams, {
                limit: this.limit,
                offset: this.offset
            }), this.offset == this.pageFrom - 1 ? Utils.notifyInfo({
                content: Messages.search.onSamePage
            }) : (this.value && (this.value.pageOffset = this.offset, this.triggerUrl()), this.fetchCollection(null, {
                next: !0
            })));
        }
    });
    return SearchResultLayoutView;
});