define([ "require", "backbone", "hbs!tmpl/search/QueryBuilder_tmpl", "utils/Utils", "utils/CommonViewFunction", "utils/Enums", "query-builder", "daterangepicker" ], function(require, Backbone, QueryBuilder_Tmpl, Utils, CommonViewFunction, Enums) {
    var QueryBuilderView = Backbone.Marionette.LayoutView.extend({
        _viewName: "QueryBuilderView",
        template: QueryBuilder_Tmpl,
        regions: {},
        ui: {
            builder: "#builder"
        },
        events: function() {
            var events = {};
            return events;
        },
        initialize: function(options) {
            _.extend(this, _.pick(options, "attrObj", "value", "typeHeaders", "entityDefCollection", "enumDefCollection", "tag", "searchTableFilters")), 
            this.attrObj = _.sortBy(this.attrObj, "name"), this.filterType = this.tag ? "tagFilters" : "entityFilters";
        },
        bindEvents: function() {},
        getOperator: function(type) {
            var obj = {
                operators: null
            };
            return "string" === type && (obj.operators = [ "=", "!=", "contains", "begins_with", "ends_with" ]), 
            "date" !== type && "int" !== type && "byte" !== type && "short" !== type && "long" !== type && "float" !== type && "double" !== type || (obj.operators = [ "=", "!=", ">", "<", ">=", "<=" ]), 
            "enum" !== type && "boolean" !== type || (obj.operators = [ "=", "!=" ]), obj.operators && (obj.operators = obj.operators.concat([ "is_null", "not_null" ])), 
            obj;
        },
        isPrimitive: function(type) {
            return "int" === type || "byte" === type || "short" === type || "long" === type || "float" === type || "double" === type || "string" === type || "boolean" === type || "date" === type;
        },
        getObjDef: function(attrObj, rules) {
            var obj = {
                id: attrObj.name,
                label: _.escape(attrObj.name.capitalize() + " (" + attrObj.typeName + ")"),
                type: _.escape(attrObj.typeName)
            };
            if ("date" === obj.type) {
                if (obj.plugin = "daterangepicker", obj.plugin_config = {
                    singleDatePicker: !0,
                    showDropdowns: !0,
                    timePicker: !0,
                    locale: {
                        format: "MM/DD/YYYY h:mm A"
                    }
                }, rules) {
                    var valueObj = _.find(rules, {
                        id: obj.id
                    });
                    valueObj && (obj.plugin_config.startDate = valueObj.value);
                }
                return _.extend(obj, this.getOperator(obj.type)), obj;
            }
            if (this.isPrimitive(obj.type)) return "boolean" === obj.type && (obj.input = "select", 
            obj.values = [ "true", "false" ]), _.extend(obj, this.getOperator(obj.type)), _.has(Enums.regex.RANGE_CHECK, obj.type) && (obj.validation = {
                min: Enums.regex.RANGE_CHECK[obj.type].min,
                max: Enums.regex.RANGE_CHECK[obj.type].max
            }, "double" === obj.type || "float" === obj.type ? obj.type = "double" : "int" !== obj.type && "byte" !== obj.type && "short" !== obj.type && "long" !== obj.type || (obj.type = "integer")), 
            obj;
            var enumObj = this.enumDefCollection.fullCollection.find({
                name: obj.type
            });
            if (enumObj) {
                obj.type = "string", obj.input = "select";
                var value = [];
                return _.each(enumObj.get("elementDefs"), function(o) {
                    value.push(o.value);
                }), obj.values = value, _.extend(obj, this.getOperator("enum")), obj;
            }
        },
        onRender: function() {
            var that = this, filters = [];
            if (this.value) var rules_widgets = CommonViewFunction.attributeFilter.extractUrl({
                value: this.searchTableFilters[this.filterType][this.tag ? this.value.tag : this.value.type],
                formatDate: !0
            });
            _.each(this.attrObj, function(obj) {
                var returnObj = that.getObjDef(obj, rules_widgets);
                returnObj && filters.push(returnObj);
            }), filters = _.uniq(filters, "id"), filters && !_.isEmpty(filters) ? (this.ui.builder.queryBuilder({
                plugins: [ "bt-tooltip-errors" ],
                filters: filters,
                select_placeholder: "--Select Attribute--",
                allow_empty: !0,
                conditions: [ "AND", "OR" ],
                allow_groups: !0,
                allow_empty: !0,
                operators: [ {
                    type: "=",
                    nb_inputs: 1,
                    multiple: !1,
                    apply_to: [ "number", "string", "boolean", "enum" ]
                }, {
                    type: "!=",
                    nb_inputs: 1,
                    multiple: !1,
                    apply_to: [ "number", "string", "boolean", "enum" ]
                }, {
                    type: ">",
                    nb_inputs: 1,
                    multiple: !1,
                    apply_to: [ "number", "string", "boolean" ]
                }, {
                    type: "<",
                    nb_inputs: 1,
                    multiple: !1,
                    apply_to: [ "number", "string", "boolean" ]
                }, {
                    type: ">=",
                    nb_inputs: 1,
                    multiple: !1,
                    apply_to: [ "number", "string", "boolean" ]
                }, {
                    type: "<=",
                    nb_inputs: 1,
                    multiple: !1,
                    apply_to: [ "number", "string", "boolean" ]
                }, {
                    type: "contains",
                    nb_inputs: 1,
                    multiple: !1,
                    apply_to: [ "string" ]
                }, {
                    type: "begins_with",
                    nb_inputs: 1,
                    multiple: !1,
                    apply_to: [ "string" ]
                }, {
                    type: "ends_with",
                    nb_inputs: 1,
                    multiple: !1,
                    apply_to: [ "string" ]
                }, {
                    type: "is_null",
                    nb_inputs: !1,
                    multiple: !1,
                    apply_to: [ "number", "string", "boolean", "enum" ]
                }, {
                    type: "not_null",
                    nb_inputs: !1,
                    multiple: !1,
                    apply_to: [ "number", "string", "boolean", "enum" ]
                } ],
                lang: {
                    add_rule: "Add filter",
                    add_group: "Add filter group",
                    operators: {
                        not_null: "is not null"
                    }
                },
                icons: {
                    add_rule: "fa fa-plus",
                    remove_rule: "fa fa-times",
                    error: "fa fa-exclamation-triangle"
                },
                rules: rules_widgets
            }), this.$(".rules-group-header .btn-group.pull-right.group-actions").toggleClass("pull-left")) : this.ui.builder.html("<h4>No Attributes are available !</h4>");
        }
    });
    return QueryBuilderView;
});