define([ "require", "" ], function(require) {
    "use strict";
    var LinegaeUtils = {};
    return LinegaeUtils.DragNode = function(options) {
        var g = options.g, svg = options.svg, guid = options.guid, edgePathEl = options.edgeEl;
        return {
            init: function() {
                var that = this;
                svg.selectAll("g.node rect").attr("id", function(d) {
                    return "node" + d;
                }), svg.selectAll("g.edgePath path").attr("id", function(e) {
                    return e.v + "-" + e.w;
                }), svg.selectAll("g.edgeLabel g").attr("id", function(e) {
                    return "label_" + e.v + "-" + e.w;
                }), g.nodes().forEach(function(v) {
                    var node = g.node(v);
                    node.customId = "node" + v;
                }), g.edges().forEach(function(e) {
                    var edge = g.edge(e.v, e.w);
                    edge.customId = e.v + "-" + e.w;
                });
                var nodeDrag = d3.behavior.drag().on("dragstart", this.dragstart).on("drag", function(d) {
                    that.dragmove(this, d);
                }), edgeDrag = d3.behavior.drag().on("dragstart", this.dragstart).on("drag", function(d) {
                    that.translateEdge(g.edge(d.v, d.w), d3.event.dx, d3.event.dy), $("#" + g.edge(d.v, d.w).customId).attr("d", that.calcPoints(d));
                });
                nodeDrag.call(svg.selectAll("g.node")), edgeDrag.call(svg.selectAll("g.edgePath"));
            },
            dragstart: function(d) {
                d3.event.sourceEvent.stopPropagation();
            },
            dragmove: function(elem, d) {
                var that = this, node = d3.select(elem), selectedNode = g.node(d), prevX = selectedNode.x, prevY = selectedNode.y;
                selectedNode.x += d3.event.dx, selectedNode.y += d3.event.dy, node.attr("transform", "translate(" + selectedNode.x + "," + selectedNode.y + ")");
                var dx = selectedNode.x - prevX, dy = selectedNode.y - prevY;
                g.edges().forEach(function(e) {
                    if (e.v == d || e.w == d) {
                        var edge = g.edge(e.v, e.w);
                        that.translateEdge(g.edge(e.v, e.w), dx, dy), $("#" + edge.customId).attr("d", that.calcPoints(e));
                        var label = $("#label_" + edge.customId), xforms = label.attr("transform");
                        if ("" != xforms) {
                            var parts = /translate\(\s*([^\s,)]+)[ ,]?([^\s,)]+)?/.exec(xforms), X = parseInt(parts[1]) + dx, Y = parseInt(parts[2]) + dy;
                            isNaN(Y) && (Y = dy), label.attr("transform", "translate(" + X + "," + Y + ")");
                        }
                    }
                }), LinegaeUtils.refreshGraphForIE({
                    edgeEl: edgePathEl
                });
            },
            translateEdge: function(e, dx, dy) {
                e.points.forEach(function(p) {
                    p.x = p.x + dx, p.y = p.y + dy;
                });
            },
            calcPoints: function(e) {
                var edge = g.edge(e.v, e.w), tail = g.node(e.v), head = g.node(e.w), points = edge.points.slice(1, edge.points.length - 1);
                edge.points.slice(1, edge.points.length - 1);
                return points.unshift(this.intersectRect(tail, points[0])), points.push(this.intersectRect(head, points[points.length - 1])), 
                d3.svg.line().x(function(d) {
                    return d.x;
                }).y(function(d) {
                    return d.y;
                }).interpolate("basis")(points);
            },
            intersectRect: function(node, point) {
                var x = node.x, y = node.y, dx = point.x - x, dy = point.y - y, w = node.id == guid ? 24 : 21, h = node.id == guid ? 24 : 21, sx = 0, sy = 0;
                return Math.abs(dy) * w > Math.abs(dx) * h ? (dy < 0 && (h = -h), sx = 0 === dy ? 0 : h * dx / dy, 
                sy = h) : (dx < 0 && (w = -w), sx = w, sy = 0 === dx ? 0 : w * dy / dx), {
                    x: x + sx,
                    y: y + sy
                };
            }
        };
    }, LinegaeUtils.refreshGraphForSafari = function(options) {
        var edgePathEl = options.edgeEl;
        edgePathEl.each(function(argument) {
            var eleRef = this, childNode = $(this).find("pattern");
            setTimeout(function(argument) {
                $(eleRef).find("defs").append(childNode);
            }, 500);
        });
    }, LinegaeUtils.refreshGraphForIE = function(options) {
        var edgePathEl = options.edgeEl, IEGraphRenderDone = 0;
        edgePathEl.each(function(argument) {
            var childNode = $(this).find("marker");
            $(this).find("marker").remove();
            var eleRef = this;
            ++IEGraphRenderDone, setTimeout(function(argument) {
                $(eleRef).find("defs").append(childNode), --IEGraphRenderDone, 0 === IEGraphRenderDone && (this.$(".fontLoader").hide(), 
                this.$("svg").fadeTo(1e3, 1));
            }, 1e3);
        });
    }, LinegaeUtils.centerNode = function(options) {
        var nodeID = options.guid, svg = options.svg, g = options.g, afterCenterZoomed = options.afterCenterZoomed, zoom = d3.behavior.zoom(), svgGroup = svg.find("g"), edgePathEl = options.edgeEl, zoomBind = function() {
            svgGroup.attr("transform", "translate(" + d3.event.translate + ")scale(" + d3.event.scale + ")");
        }, selectedNode = $(svg).find("g.nodes").find(">g#" + nodeID);
        return {
            init: function() {
                if (selectedNode.length > 0) {
                    selectedNode = selectedNode;
                    var matrix = selectedNode.attr("transform").replace(/[^0-9\-.,]/g, "").split(",");
                    if ("IE" === platform.name || "Microsoft Edge" === platform.name) var matrix = selectedNode.attr("transform").replace(/[a-z\()]/g, "").split(" ");
                    var x = matrix[0], y = matrix[1];
                } else {
                    selectedNode = $(svg).find("g.nodes").find("g").eq(1);
                    var x = g.graph().width / 2, y = g.graph().height / 2;
                }
                var viewerWidth = $(svg).width(), viewerHeight = $(svg).height(), zoomListener = (d3.select("g").node().getBBox(), 
                zoom.scaleExtent([ .01, 50 ]).on("zoom", zoomBind)), scale = 1.2, xa = -(x * scale - viewerWidth / 2), ya = -(y * scale - viewerHeight / 2);
                zoom.translate([ xa, ya ]), d3.select("g").transition().duration(350).attr("transform", "translate(" + xa + "," + ya + ")scale(" + scale + ")"), 
                zoomListener.scale(scale), zoomListener.translate([ xa, ya ]), zoom.scale(scale), 
                afterCenterZoomed({
                    newScale: scale,
                    newTranslate: [ xa, ya ]
                }), LinegaeUtils.refreshGraphForIE({
                    edgeEl: edgePathEl
                });
            }
        };
    }, LinegaeUtils.onHoverFade = function(options) {
        var d = (options.opacity, options.selectedNode), nodesToHighlight = options.highlight, svg = options.svg, isConnected = function(a, b, o) {
            if (a === o || b && b.length && b.indexOf(o) != -1) return !0;
        }, node = svg.selectAll(".node"), path = svg.selectAll(".edgePath");
        return {
            init: function() {
                node.classed("hover-active", function(selectedNode, i, nodes) {
                    return !!isConnected(d, nodesToHighlight, selectedNode);
                }), path.classed("hover-active-node", function(c) {
                    var _thisOpacity = c.v === d || c.w === d ? 1 : 0;
                    return !!_thisOpacity;
                });
            }
        };
    }, LinegaeUtils.base64Encode = function(options) {
        for (var c1, c2, c3, str = options.data, CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/", out = "", i = 0, len = str.length; i < len; ) {
            if (c1 = 255 & str.charCodeAt(i++), i == len) {
                out += CHARS.charAt(c1 >> 2), out += CHARS.charAt((3 & c1) << 4), out += "==";
                break;
            }
            if (c2 = str.charCodeAt(i++), i == len) {
                out += CHARS.charAt(c1 >> 2), out += CHARS.charAt((3 & c1) << 4 | (240 & c2) >> 4), 
                out += CHARS.charAt((15 & c2) << 2), out += "=";
                break;
            }
            c3 = str.charCodeAt(i++), out += CHARS.charAt(c1 >> 2), out += CHARS.charAt((3 & c1) << 4 | (240 & c2) >> 4), 
            out += CHARS.charAt((15 & c2) << 2 | (192 & c3) >> 6), out += CHARS.charAt(63 & c3);
        }
        return out;
    }, LinegaeUtils;
});