define([ "require", "backbone", "hbs!tmpl/glossary/GlossaryLayoutView_tmpl", "utils/Utils", "utils/Messages", "utils/Globals", "utils/CommonViewFunction", "jstree" ], function(require, Backbone, GlossaryLayoutViewTmpl, Utils, Messages, Globals, CommonViewFunction) {
    "use strict";
    var GlossaryLayoutView = Backbone.Marionette.LayoutView.extend({
        _viewName: "GlossaryLayoutView",
        template: GlossaryLayoutViewTmpl,
        regions: {},
        templateHelpers: function() {
            return {
                isAssignView: this.isAssignView,
                isAssignAttributeRelationView: this.isAssignAttributeRelationView
            };
        },
        ui: {
            createGlossary: "[data-id='createGlossary']",
            refreshGlossary: "[data-id='refreshGlossary']",
            searchTerm: "[data-id='searchTerm']",
            searchCategory: "[data-id='searchCategory']",
            glossaryView: 'input[name="glossaryView"]',
            termTree: "[data-id='termTree']",
            categoryTree: "[data-id='categoryTree']"
        },
        events: function() {
            var events = {};
            return events["change " + this.ui.glossaryView] = "glossaryViewToggle", events["click " + this.ui.createGlossary] = function(e) {
                var that = this;
                e && $(e.currentTarget).attr("disabled", "true"), CommonViewFunction.createEditGlossaryCategoryTerm({
                    isGlossaryView: !0,
                    collection: this.glossaryCollection,
                    callback: function() {
                        that.ui.createGlossary.removeAttr("disabled"), that.getGlossary();
                    },
                    onModalClose: function() {
                        that.ui.createGlossary.removeAttr("disabled");
                    }
                });
            }, events["click " + this.ui.refreshGlossary] = "getGlossary", events["keyup " + this.ui.searchTerm] = function() {
                this.ui.termTree.jstree("search", this.ui.searchTerm.val());
            }, events["keyup " + this.ui.searchCategory] = function() {
                this.ui.categoryTree.jstree("search", this.ui.searchCategory.val());
            }, events;
        },
        initialize: function(options) {
            _.extend(this, _.pick(options, "associatedTerms", "guid", "value", "glossaryCollection", "glossary", "isAssignTermView", "isAssignCategoryView", "isAssignEntityView", "isAssignAttributeRelationView")), 
            this.viewType = "term", this.isAssignView = this.isAssignTermView || this.isAssignCategoryView || this.isAssignEntityView || this.isAssignAttributeRelationView, 
            this.bindEvents(), this.query = {
                term: {},
                category: {}
            }, Utils.getUrlState.isGlossaryTab() && this.value && this.value.viewType && (this.viewType = this.value.viewType, 
            this.query[this.viewType] = _.extend({}, this.value, {
                guid: this.guid
            }));
        },
        bindEvents: function() {
            var that = this;
            this.listenTo(this.glossaryCollection.fullCollection, "reset add change", function(skip) {
                this.generateTree(), this.setValues();
            }, this), this.listenTo(this.glossaryCollection, "update:details", function(options) {
                var isGlossaryUpdate = options.isGlossaryUpdate;
                if (isGlossaryUpdate) this.ui.termTree.jstree(!0).refresh && this.ui.termTree.jstree(!0).refresh(), 
                this.ui.categoryTree.jstree(!0).refresh && this.ui.categoryTree.jstree(!0).refresh(); else {
                    var $tree = this.ui["term" == this.viewType ? "termTree" : "categoryTree"];
                    $tree.jstree(!0).refresh && ($tree.jstree(!0).refresh(), this.setValues({
                        trigger: !1
                    }));
                }
            }, this), this.isAssignView || $("body").on("click", ".termPopoverOptions li, .categoryPopoverOptions li", function(e) {
                that.$(".termPopover,.categoryPopover").popover("hide"), that[$(this).find("a").data("fn")](e);
            });
        },
        onRender: function() {
            this.isAssignCategoryView && (this.$(".category-view").show(), this.$(".term-view").hide()), 
            this.isAssignView && this.glossaryCollection.fullCollection.length ? this.generateTree() : this.getGlossary();
        },
        setValues: function(options) {
            "category" == this.viewType ? this.ui.glossaryView.prop("checked") || this.ui.glossaryView.prop("checked", !0).trigger("change", options) : this.ui.glossaryView.prop("checked") && this.ui.glossaryView.prop("checked", !1).trigger("change", options);
        },
        glossaryViewToggle: function(e, options) {
            var that = this;
            e.currentTarget.checked ? (this.$(".category-view").show(), this.$(".term-view").hide(), 
            this.viewType = "category") : (this.$(".term-view").show(), this.$(".category-view").hide(), 
            this.viewType = "term");
            var setDefaultSelector = function() {
                if (that.value) {
                    var model = null;
                    model = that.value.gId ? that.glossaryCollection.fullCollection.get(that.value.gId) : that.glossaryCollection.fullCollection.first(), 
                    model = model.toJSON ? model.toJSON() : model, that.glossary.selectedItem = {
                        type: "Glossary",
                        guid: model.guid,
                        id: model.guid,
                        model: model,
                        text: model.name,
                        gType: "glossary"
                    };
                }
            };
            if (Utils.getUrlState.isGlossaryTab()) {
                var obj = this.query[this.viewType], $tree = this.ui["term" == this.viewType ? "termTree" : "categoryTree"];
                if (obj.guid) {
                    var node = $tree.jstree(!0).get_node(obj.guid);
                    node && (this.glossary.selectedItem = node.original, $tree.jstree("activate_node", obj.guid));
                } else setDefaultSelector(), $tree.jstree("activate_node", that.glossary.selectedItem.guid);
                this.query[this.viewType] = _.extend(obj, _.pick(this.glossary.selectedItem, "model", "guid", "gType", "type"), {
                    viewType: this.viewType,
                    isNodeNotFoundAtLoad: this.query[this.viewType].isNodeNotFoundAtLoad
                });
                var url = _.isEmpty(this.glossary.selectedItem) ? "#!/glossary" : "#!/glossary/" + this.glossary.selectedItem.guid;
                Utils.setUrl({
                    url: url,
                    urlParams: _.extend({}, _.omit(obj, "guid", "model", "type", "isNodeNotFoundAtLoad")),
                    mergeBrowserUrl: !1,
                    trigger: !(options && !_.isUndefined(options.trigger)) || options.trigger,
                    updateTabState: !0
                });
            }
        },
        getGlossary: function() {
            this.glossaryCollection.fetch({
                reset: !0
            });
        },
        generateCategoryData: function(options) {
            return _.map(options.data, function(obj) {
                return {
                    text: _.escape(obj.displayText),
                    icon: "fa fa-files-o",
                    guid: obj.categoryGuid,
                    id: obj.categoryGuid,
                    glossaryId: options.node.glossaryId,
                    glossaryName: options.node.glossaryName,
                    model: obj,
                    type: "GlossaryCategory",
                    gType: "category",
                    children: !0
                };
            });
        },
        getCategory: function(options) {
            var that = this;
            this.glossaryCollection.getCategory({
                guid: options.node.guid,
                related: !0,
                ajaxOptions: {
                    success: function(data) {
                        data && data.children ? options.callback(that.generateCategoryData(_.extend({}, {
                            data: data.children
                        }, options))) : options.callback([]);
                    },
                    cust_error: function() {
                        options.callback([]);
                    }
                }
            });
        },
        generateData: function(opt) {
            var that = this, associatedTerms = (that.guid, that.associatedTerms), type = opt.type;
            opt.type == this.viewType && (this.query[opt.type].isNodeNotFoundAtLoad = !0);
            var getSelectedState = function(options) {
                var objGuid = options.objGuid, node = options.node, index = options.index;
                if (that.isAssignView) return {
                    opened: !0
                };
                if (that.guid) {
                    if (that.guid == objGuid) return that.query[that.viewType].isNodeNotFoundAtLoad = !1, 
                    that.glossary.selectedItem = node, that.query[that.viewType].model = node.model, 
                    that.query[that.viewType].type = node.type, {
                        opened: !0,
                        selected: !0
                    };
                } else {
                    that.query[that.viewType].isNodeNotFoundAtLoad = !1;
                    var selectedItem = {
                        type: "Glossary",
                        gType: "glossary",
                        model: that.glossaryCollection.fullCollection.first().toJSON()
                    };
                    if (selectedItem.text = selectedItem.model.name, selectedItem.guid = selectedItem.model.guid, 
                    0 == index && selectedItem.guid == objGuid) return that.glossary.selectedItem = selectedItem, 
                    that.query[that.viewType].model = selectedItem.model, that.query[that.viewType].type = selectedItem.type, 
                    {
                        opened: !0,
                        selected: !0
                    };
                }
            };
            return this.glossaryCollection.fullCollection.map(function(model, i) {
                var obj = model.toJSON(), parent = {
                    text: _.escape(obj.name),
                    icon: "fa fa-folder-o",
                    guid: obj.guid,
                    id: obj.guid,
                    model: obj,
                    type: obj.typeName ? obj.typeName : "Glossary",
                    gType: "glossary",
                    children: []
                };
                return parent.state = getSelectedState({
                    index: i,
                    node: parent,
                    objGuid: obj.guid
                }), "category" == type && obj.categories && _.each(obj.categories, function(category) {
                    if (!category.parentCategoryGuid) {
                        var typeName = category.typeName || "GlossaryCategory", guid = category.categoryGuid, categoryObj = {
                            text: _.escape(category.displayText),
                            type: typeName,
                            gType: "category",
                            guid: guid,
                            id: guid,
                            parent: obj,
                            glossaryId: obj.guid,
                            glossaryName: obj.name,
                            model: category,
                            children: !0,
                            icon: "fa fa-files-o"
                        };
                        categoryObj.state = getSelectedState({
                            index: i,
                            node: categoryObj,
                            objGuid: guid
                        }), parent.children.push(categoryObj);
                    }
                }), "term" == type && obj.terms && _.each(obj.terms, function(term) {
                    if (associatedTerms) {
                        var associatedTermFound = _.find(associatedTerms, function(obj, index) {
                            if ((obj.termGuid ? obj.termGuid : obj.guid) == term.termGuid) return obj;
                        });
                        if (associatedTermFound) return;
                    }
                    var typeName = term.typeName || "GlossaryTerm", guid = term.termGuid, termObj = {
                        text: _.escape(term.displayText),
                        type: typeName,
                        gType: "term",
                        guid: guid,
                        id: guid,
                        parent: obj,
                        glossaryName: obj.name,
                        glossaryId: obj.guid,
                        model: term,
                        icon: "fa fa-file-o"
                    };
                    termObj.state = getSelectedState({
                        index: i,
                        node: termObj,
                        objGuid: guid
                    }), parent.children.push(termObj);
                }), parent;
            });
        },
        manualRender: function(options) {
            if (_.extend(this, _.omit(options, "isTrigger")), this.value && this.value.viewType && (this.viewType = this.value.viewType), 
            this.guid && this.value && (this.value.fromView && this.value.fromView || this.value.updateView)) {
                var $tree = this.ui["term" == this.viewType ? "termTree" : "categoryTree"], node = $tree.jstree(!0).get_node(this.guid);
                node && ($tree.jstree("activate_node", this.guid, {
                    skipTrigger: !0
                }), delete this.value.fromView, delete this.value.updateView, this.glossary.selectedItem = node.original, 
                this.query[this.viewType] = _.extend({}, _.pick(this.glossary.selectedItem, "model", "guid", "gType", "type"), {
                    viewType: this.viewType
                }), Utils.setUrl({
                    url: "#!/glossary/" + this.guid,
                    urlParams: this.value,
                    mergeBrowserUrl: !1,
                    trigger: !1,
                    updateTabState: !0
                }), this.glossaryCollection.trigger("update:details", {
                    isGlossaryUpdate: "glossary" == this.value.gType
                }));
            } else this.setValues();
            options.isTrigger && this.triggerUrl();
        },
        generateTree: function() {
            var $termTree = this.ui.termTree, $categoryTree = this.ui.categoryTree, that = this, getTreeConfig = (that.guid, 
            function(options) {
                return {
                    plugins: [ "search", "themes", "core", "wholerow", "sort", "conditionalselect" ],
                    conditionalselect: function(node) {
                        var obj = node && node.original && node.original.type;
                        if (obj) return that.isAssignView ? "Glossary" != obj : "NoAction" != obj;
                    },
                    search: {
                        show_only_matches: !0
                    },
                    core: {
                        data: function(node, cb) {
                            "#" === node.id ? cb(that.generateData(options)) : that.getCategory({
                                node: node.original,
                                callback: cb
                            });
                        },
                        themes: {
                            name: that.isAssignView ? "default" : "default-dark",
                            dots: !0
                        }
                    }
                };
            }), treeLoaded = function(options) {
                if (1 == that.query[options.type].isNodeNotFoundAtLoad) {
                    var id = that.glossary.selectedItem.guid;
                    options.$el.jstree("activate_node", id);
                }
            }, createAction = function(options) {
                var $el = options.el, type = options.type, popoverClassName = "term" == type ? "termPopover" : "categoryPopover";
                if (!that.isAssignView) {
                    var wholerowEl = $el.find("li[role='treeitem'] > .jstree-wholerow:not(:has(>div.tools))");
                    wholerowEl.append('<div class="tools"><i class="fa fa-ellipsis-h ' + popoverClassName + '"></i></div>'), 
                    "term" == type ? that.createTermAction() : "category" == type && that.createCategoryAction();
                }
            }, initializeTree = function(options) {
                var $el = options.el, type = options.type;
                $el.jstree(getTreeConfig({
                    type: type
                })).on("load_node.jstree", function(e, data) {
                    createAction(_.extend({}, options, data));
                }).on("open_node.jstree", function(e, data) {
                    createAction(_.extend({}, options, data));
                }).on("select_node.jstree", function(e, data) {
                    if (that.isAssignView) that.glossary.selectedItem = data.node.original, that.glossaryCollection.trigger("node_selected"); else {
                        var popoverClassName = "term" == type ? ".termPopover" : ".categoryPopover", currentClickedPopoverEl = "";
                        if (data.event && (currentClickedPopoverEl = $(data.event.currentTarget).parent().hasClass("jstree-leaf") ? $(data.event.currentTarget).parent().find(popoverClassName) : $(data.event.currentTarget).parent().find(">div " + popoverClassName), 
                        $(popoverClassName).not(currentClickedPopoverEl).popover("hide")), 1 == that.query[type].isNodeNotFoundAtLoad) that.query[type].isNodeNotFoundAtLoad = !1; else if (type == that.viewType) {
                            if (data && data.event && data.event.skipTrigger) return;
                            that.glossary.selectedItem.guid !== data.node.original.guid && (that.glossary.selectedItem = data.node.original, 
                            that.triggerUrl());
                        }
                    }
                }).on("search.jstree", function(e, data) {
                    createAction(_.extend({}, options, data));
                }).on("clear_search.jstree", function(e, data) {
                    createAction(_.extend({}, options, data));
                }).bind("loaded.jstree", function(e, data) {
                    1 == that.query[type].isNodeNotFoundAtLoad && treeLoaded({
                        $el: $el,
                        type: type
                    });
                });
            }, initializeTermTree = function() {
                $termTree.data("jstree") ? ($(".termPopover").popover("destroy"), $termTree.jstree(!0).refresh()) : initializeTree({
                    el: $termTree,
                    type: "term"
                });
            }, initializeCategoryTree = function() {
                $categoryTree.data("jstree") ? ($(".categoryPopover").popover("destroy"), $categoryTree.jstree(!0).refresh()) : initializeTree({
                    el: $categoryTree,
                    type: "category"
                });
            };
            this.isAssignView ? this.isAssignTermView || this.isAssignEntityView || this.isAssignAttributeRelationView ? initializeTermTree() : this.isAssignCategoryView && initializeCategoryTree() : (initializeTermTree(), 
            initializeCategoryTree()), Utils.getUrlState.isGlossaryTab() && this.triggerUrl(), 
            this.glossaryCollection.trigger("render:done");
        },
        createTermAction: function() {
            var that = this;
            Utils.generatePopover({
                el: this.$(".termPopover"),
                contentClass: "termPopoverOptions",
                popoverOptions: {
                    content: function() {
                        var node = that.query[that.viewType], liString = "";
                        return liString = "Glossary" == node.type ? "<li data-type=" + node.type + " class='listTerm'><i class='fa fa-plus'></i> <a href='javascript:void(0)' data-fn='createSubNode'>Create Term</a></li><li data-type=" + node.type + " class='listTerm'><i class='fa fa-trash-o'></i><a href='javascript:void(0)' data-fn='deleteNode'>Delete Glossary</a></li>" : "<li data-type=" + node.type + " class='listTerm'><i class='fa fa-trash-o'></i><a href='javascript:void(0)' data-fn='deleteNode'>Delete Term</a></li>", 
                        "<ul>" + liString + "</ul>";
                    }
                }
            });
        },
        createCategoryAction: function() {
            var that = this;
            Utils.generatePopover({
                el: this.$(".categoryPopover"),
                contentClass: "categoryPopoverOptions",
                popoverOptions: {
                    content: function() {
                        var node = that.query[that.viewType], liString = "";
                        return liString = "Glossary" == node.type ? "<li data-type=" + node.type + " class='listTerm'><i class='fa fa-plus'></i> <a href='javascript:void(0)' data-fn='createSubNode'>Create Category</a></li><li data-type=" + node.type + " class='listTerm'><i class='fa fa-trash-o'></i><a href='javascript:void(0)' data-fn='deleteNode'>Delete Glossary</a></li>" : "<li data-type=" + node.type + " class='listTerm'><i class='fa fa-plus'></i> <a href='javascript:void(0)' data-fn='createSubNode'>Create Sub-Category</a></li><li data-type=" + node.type + " class='listTerm'><i class='fa fa-trash-o'></i><a href='javascript:void(0)' data-fn='deleteNode'>Delete Category</a></li>", 
                        "<ul>" + liString + "</ul>";
                    }
                }
            });
        },
        createSubNode: function(opt) {
            var that = this, type = this.glossary.selectedItem.type;
            "Glossary" != type && "GlossaryCategory" != type || "category" != this.viewType ? CommonViewFunction.createEditGlossaryCategoryTerm({
                isTermView: !0,
                callback: function() {
                    that.getGlossary();
                },
                collection: that.glossaryCollection,
                node: this.glossary.selectedItem
            }) : CommonViewFunction.createEditGlossaryCategoryTerm({
                isCategoryView: !0,
                collection: that.glossaryCollection,
                callback: function() {
                    "glossary" == that.value.gType ? that.getGlossary() : that.ui.categoryTree.jstree(!0).refresh();
                },
                node: this.glossary.selectedItem
            });
        },
        deleteNode: function(opt) {
            var that = this, messageType = "", type = this.glossary.selectedItem.type, guid = this.glossary.selectedItem.guid, gId = this.glossary.selectedItem.glossaryId, options = {
                success: function(rModel, response) {
                    gId || (gId = guid);
                    var glossary = that.glossaryCollection.fullCollection.get(gId);
                    that.value && ("term" == that.value.gType ? glossary.set("terms", _.reject(glossary.get("terms"), function(obj) {
                        return obj.termGuid == guid;
                    }), {
                        silent: !0
                    }) : "category" == that.value.gType ? glossary.set("categories", _.reject(glossary.get("categories"), function(obj) {
                        return obj.categoryGuid == guid;
                    }), {
                        silent: !0
                    }) : (glossary = that.glossaryCollection.fullCollection.first(), gId = glossary ? glossary.get("guid") : null)), 
                    Utils.notifySuccess({
                        content: messageType + Messages.deleteSuccessMessage
                    });
                    var url = gId ? "#!/glossary/" + gId : "#!/glossary";
                    null == gId && (that.glossary.selectedItem = {}, that.value = null, that.query = {
                        term: {},
                        category: {}
                    }, that.ui.categoryTree.jstree(!0).refresh(), that.ui.termTree.jstree(!0).refresh()), 
                    Utils.setUrl({
                        url: url,
                        mergeBrowserUrl: !1,
                        trigger: !0,
                        urlParams: gId ? _.extend({}, that.value, {
                            gType: "glossary",
                            updateView: !0,
                            gId: null
                        }) : null,
                        updateTabState: !0
                    });
                }
            }, notifyObj = {
                modal: !0,
                ok: function(argument) {
                    "Glossary" == type ? that.glossaryCollection.fullCollection.get(guid).destroy(options, {
                        silent: !0,
                        reset: !1
                    }) : "GlossaryCategory" == type ? new that.glossaryCollection.model().deleteCategory(guid, options) : "GlossaryTerm" == type && new that.glossaryCollection.model().deleteTerm(guid, options);
                },
                cancel: function(argument) {}
            };
            "Glossary" == type ? messageType = "Glossary" : "GlossaryCategory" == type ? messageType = "Category" : "GlossaryTerm" == type && (messageType = "Term"), 
            notifyObj.text = "Are you sure you want to delete the " + messageType, Utils.notifyConfirm(notifyObj);
        },
        triggerUrl: function(options) {
            if (!this.isAssignView) {
                var selectedItem = this.glossary.selectedItem;
                if (this.glossaryCollection.length && (_.isEmpty(selectedItem) || this.query[this.viewType].isNodeNotFoundAtLoad)) {
                    var model = selectedItem.model;
                    model && !_.isUndefined(model.parentCategory || model.parentCategoryGuid) && (selectedItem = {
                        model: this.glossaryCollection.first().toJSON()
                    }, selectedItem.guid = selectedItem.model.guid, selectedItem.type = "Glossary", 
                    selectedItem.gType = "glossary", selectedItem.text = model.name, this.glossary.selectedItem = selectedItem, 
                    this.query[this.viewType].model = selectedItem.model, this.query[this.viewType].gType = "glossary", 
                    this.query[this.viewType].type = "Glossary", delete this.query[this.viewType].gId);
                }
                if (!_.isEmpty(selectedItem) && (Utils.getUrlState.isGlossaryTab() || Utils.getUrlState.isDetailPage())) {
                    var obj = {};
                    selectedItem.glossaryId ? obj.gId = selectedItem.glossaryId : "Glossary" == selectedItem.type && (obj.gId = selectedItem.guid), 
                    this.query[this.viewType] = _.extend(obj, _.omit(this.value, "gId"), _.pick(this.glossary.selectedItem, "model", "type", "gType", "guid"), {
                        viewType: this.viewType,
                        isNodeNotFoundAtLoad: this.query[this.viewType].isNodeNotFoundAtLoad
                    }), Utils.setUrl({
                        url: "#!/glossary/" + obj.guid,
                        mergeBrowserUrl: !1,
                        trigger: !0,
                        urlParams: _.omit(obj, "model", "guid", "type", "isNodeNotFoundAtLoad"),
                        updateTabState: !0
                    });
                }
            }
        }
    });
    return GlossaryLayoutView;
});