define([ "require", "backbone", "hbs!tmpl/entity/EntityDetailTableLayoutView_tmpl", "utils/CommonViewFunction", "models/VEntity" ], function(require, Backbone, EntityDetailTableLayoutView_tmpl, CommonViewFunction, VEntity) {
    "use strict";
    var EntityDetailTableLayoutView = Backbone.Marionette.LayoutView.extend({
        _viewName: "EntityDetailTableLayoutView",
        template: EntityDetailTableLayoutView_tmpl,
        regions: {},
        ui: {
            detailValue: "[data-id='detailValue']"
        },
        events: function() {
            var events = {};
            return events;
        },
        initialize: function(options) {
            _.extend(this, _.pick(options, "entity", "typeHeaders", "attributeDefs", "attributes")), 
            this.entityModel = new VEntity({});
        },
        bindEvents: function() {},
        onRender: function() {
            this.entityTableGenerate();
        },
        entityTableGenerate: function() {
            var table = CommonViewFunction.propertyTable({
                scope: this,
                valueObject: this.entity.attributes,
                attributeDefs: this.attributeDefs
            });
            this.ui.detailValue.append(table);
        }
    });
    return EntityDetailTableLayoutView;
});