define([ "require", "backbone", "hbs!tmpl/audit/AuditTableLayoutView_tmpl", "collection/VEntityList", "utils/Enums", "utils/UrlLinks" ], function(require, Backbone, AuditTableLayoutView_tmpl, VEntityList, Enums, UrlLinks) {
    "use strict";
    var AuditTableLayoutView = Backbone.Marionette.LayoutView.extend({
        _viewName: "AuditTableLayoutView",
        template: AuditTableLayoutView_tmpl,
        regions: {
            RAuditTableLayoutView: "#r_auditTableLayoutView"
        },
        ui: {
            auditCreate: "[data-id='auditCreate']",
            previousAuditData: "[data-id='previousAuditData']",
            nextAuditData: "[data-id='nextAuditData']",
            pageRecordText: "[data-id='pageRecordText']",
            activePage: "[data-id='activePage']"
        },
        events: function() {
            var events = {};
            return events["click " + this.ui.auditCreate] = "onClickAuditCreate", events["click " + this.ui.nextAuditData] = "onClickNextAuditData", 
            events["click " + this.ui.previousAuditData] = "onClickPreviousAuditData", events;
        },
        initialize: function(options) {
            _.extend(this, _.pick(options, "guid", "entity", "entityName", "attributeDefs")), 
            this.entityCollection = new VEntityList(), this.limit = 26, this.entityCollection.url = UrlLinks.entityCollectionaudit(this.guid), 
            this.entityCollection.modelAttrName = "events", this.entityModel = new this.entityCollection.model(), 
            this.pervOld = [], this.commonTableOptions = {
                collection: this.entityCollection,
                includeFilter: !1,
                includePagination: !1,
                includePageSize: !1,
                includeFooterRecords: !1,
                gridOpts: {
                    className: "table table-hover backgrid table-quickMenu",
                    emptyText: "No records found!"
                },
                filterOpts: {},
                paginatorOpts: {}
            }, this.currPage = 1;
        },
        onRender: function() {
            $.extend(this.entityCollection.queryParams, {
                count: this.limit
            }), this.fetchCollection({
                next: this.ui.nextAuditData,
                nextClick: !1,
                previous: this.ui.previousAuditData
            }), this.entityCollection.comparator = function(model) {
                return -model.get("timestamp");
            };
        },
        bindEvents: function() {},
        getToOffset: function() {
            return (this.limit - 1) * this.currPage;
        },
        getFromOffset: function(toOffset) {
            return toOffset - this.limit + 2;
        },
        renderOffset: function(options) {
            var entityLength;
            options.nextClick ? (options.previous.removeAttr("disabled"), 0 != this.entityCollection.length && this.currPage++) : options.previousClick && (options.next.removeAttr("disabled"), 
            this.currPage > 1 && this.entityCollection.models.length && this.currPage--), entityLength = this.entityCollection.models.length === this.limit ? this.entityCollection.models.length - 1 : this.entityCollection.models.length, 
            this.ui.activePage.attr("title", "Page " + this.currPage), this.ui.activePage.text(this.currPage);
            var toOffset = this.getToOffset();
            this.ui.pageRecordText.html("Showing  <u>" + entityLength + " records</u> From " + this.getFromOffset(toOffset) + " - " + toOffset);
        },
        fetchCollection: function(options) {
            var that = this;
            this.$(".fontLoader").show(), this.$(".tableOverlay").show(), that.entityCollection.models.length > 1 && options.nextClick && this.pervOld.push(that.entityCollection.first().get("eventKey")), 
            this.entityCollection.fetch({
                success: function() {
                    that.ui.pageRecordText instanceof jQuery && (that.entityCollection.models.length < that.limit && (options.previous.attr("disabled", !0), 
                    options.next.attr("disabled", !0)), that.renderOffset(options), that.entityCollection.sort(), 
                    that.entityCollection.models.length && (that.entityCollection && that.entityCollection.models.length < that.limit && 1 == that.currPage && that.next == that.entityCollection.last().get("eventKey") ? (options.next.attr("disabled", !0), 
                    options.previous.removeAttr("disabled")) : (that.next = that.entityCollection.last().get("eventKey"), 
                    0 === that.pervOld.length && options.previous.attr("disabled", !0))), that.renderTableLayoutView(), 
                    that.$(".fontLoader").hide(), that.$(".tableOverlay").hide(), that.$(".auditTable").show());
                },
                silent: !0
            });
        },
        renderTableLayoutView: function() {
            var that = this;
            require([ "utils/TableLayout" ], function(TableLayout) {
                var cols = new Backgrid.Columns(that.getAuditTableColumns());
                that.RAuditTableLayoutView.show(new TableLayout(_.extend({}, that.commonTableOptions, {
                    columns: cols
                }))), that.entityCollection.models.length < that.limit || that.RAuditTableLayoutView.$el.find("table tr").last().hide();
            });
        },
        getAuditTableColumns: function() {
            return this.entityCollection.constructor.getTableCols({
                user: {
                    label: "Users",
                    cell: "html",
                    editable: !1,
                    sortable: !1
                },
                timestamp: {
                    label: "Timestamp",
                    cell: "html",
                    editable: !1,
                    sortable: !1,
                    formatter: _.extend({}, Backgrid.CellFormatter.prototype, {
                        fromRaw: function(rawValue, model) {
                            return new Date(rawValue);
                        }
                    })
                },
                action: {
                    label: "Actions",
                    cell: "html",
                    editable: !1,
                    sortable: !1,
                    formatter: _.extend({}, Backgrid.CellFormatter.prototype, {
                        fromRaw: function(rawValue, model) {
                            return Enums.auditAction[rawValue] ? Enums.auditAction[rawValue] : rawValue;
                        }
                    })
                },
                tool: {
                    label: "Tools",
                    cell: "html",
                    editable: !1,
                    sortable: !1,
                    formatter: _.extend({}, Backgrid.CellFormatter.prototype, {
                        fromRaw: function(rawValue, model) {
                            return '<div class="btn btn-action btn-sm" data-id="auditCreate" data-action="' + Enums.auditAction[model.get("action")] + '" data-modalId="' + model.get("eventKey") + '">Detail</div>';
                        }
                    })
                }
            }, this.entityCollection);
        },
        onClickAuditCreate: function(e) {
            var that = this;
            require([ "modules/Modal", "views/audit/CreateAuditTableLayoutView" ], function(Modal, CreateAuditTableLayoutView) {
                that.action = $(e.target).data("action"), $(e.target).attr("disabled", !0);
                var eventModel = that.entityCollection.fullCollection.findWhere({
                    eventKey: $(e.currentTarget).data("modalid")
                }).toJSON(), collectionModel = new that.entityCollection.model(eventModel), view = new CreateAuditTableLayoutView({
                    guid: that.guid,
                    entityModel: collectionModel,
                    action: that.action,
                    entity: that.entity,
                    entityName: that.entityName,
                    attributeDefs: that.attributeDefs
                }), modal = new Modal({
                    title: that.action,
                    content: view,
                    okCloses: !0,
                    showFooter: !0
                }).open();
                view.on("closeModal", function() {
                    modal.trigger("cancel");
                }), view.$el.on("click", "td a", function() {
                    modal.trigger("cancel");
                }), view.on("hidden.bs.modal", function() {
                    that.$('.btn-action[data-id="auditCreate"]').attr("disabled", !1);
                });
            });
        },
        onClickNextAuditData: function() {
            var that = this;
            this.ui.previousAuditData.removeAttr("disabled"), $.extend(this.entityCollection.queryParams, {
                startKey: function() {
                    return that.next;
                }
            }), this.fetchCollection({
                next: this.ui.nextAuditData,
                nextClick: !0,
                previous: this.ui.previousAuditData
            });
        },
        onClickPreviousAuditData: function() {
            var that = this;
            this.ui.nextAuditData.removeAttr("disabled"), $.extend(this.entityCollection.queryParams, {
                startKey: function() {
                    return that.pervOld.pop();
                }
            }), this.fetchCollection({
                next: this.ui.nextAuditData,
                previousClick: !0,
                previous: this.ui.previousAuditData
            });
        }
    });
    return AuditTableLayoutView;
});