define([ "require", "utils/Utils", "marionette", "backgrid", "asBreadcrumbs", "jquery-placeholder" ], function(require, Utils) {
    "use strict";
    Backbone.$.ajaxSetup({
        cache: !1
    });
    var oldBackboneSync = Backbone.sync;
    Backbone.sync = function(method, model, options) {
        var that = this;
        if (options.queryParam) {
            var generateQueryParam = $.param(options.queryParam);
            options.url.indexOf("?") !== -1 ? options.url = options.url + "&" + generateQueryParam : options.url = options.url + "?" + generateQueryParam;
        }
        return oldBackboneSync.apply(this, [ method, model, _.extend(options, {
            error: function(response) {
                options.skipDefaultError || Utils.defaultErrorHandler(that, response), that.trigger("error", that, response), 
                options.cust_error && options.cust_error(that, response);
            }
        }) ]);
    }, String.prototype.trunc = String.prototype.trunc || function(n) {
        return this.length > n ? this.substr(0, n - 1) + "..." : this;
    }, String.prototype.capitalize = function() {
        return this.charAt(0).toUpperCase() + this.slice(1);
    };
    var cellInit = Backgrid.Cell.prototype.initialize;
    Backgrid.Cell.prototype.initialize = function() {
        cellInit.apply(this, arguments);
        var className = this.column.get("className"), rowClassName = this.column.get("rowClassName");
        rowClassName && this.$el.addClass(rowClassName), className && this.$el.addClass(className);
    }, Backgrid.HeaderRow = Backgrid.HeaderRow.extend({
        render: function() {
            var that = this;
            return Backgrid.HeaderRow.__super__.render.apply(this, arguments), _.each(this.columns.models, function(modelValue) {
                var elAttr = modelValue.get("elAttr"), elAttrObj = null;
                elAttr && (_.isFunction(elAttr) ? elAttrObj = elAttr(modelValue) : _.isObject(elAttr) && (elAttrObj = _.isArray(elAttr) ? elAttr : [ elAttr ]), 
                _.each(elAttrObj, function(val) {
                    that.$el.find("." + modelValue.get("name")).data(val);
                })), modelValue.get("width") && that.$el.find("." + modelValue.get("name")).css("min-width", modelValue.get("width") + "px"), 
                modelValue.get("toolTip") && that.$el.find("." + modelValue.get("name")).attr("title", modelValue.get("toolTip"));
            }), this;
        }
    });
    var BackgridHeaderInitializeMethod = (Backgrid.HtmlCell = Backgrid.Cell.extend({
        className: "html-cell",
        render: function() {
            this.$el.empty();
            var rawValue = this.model.get(this.column.get("name")), formattedValue = this.formatter.fromRaw(rawValue, this.model);
            return this.$el.append(formattedValue), this.delegateEvents(), this;
        }
    }), function(options) {
        this.columns = options.columns, this.columns instanceof Backbone.Collection || (this.columns = new Backgrid.Columns(this.columns)), 
        this.createHeaderRow(), this.listenTo(this.columns, "sort", _.bind(function() {
            this.createHeaderRow(), this.render();
        }, this));
    }), BackgridHeaderCreateHeaderRowMethod = function() {
        this.row = new Backgrid.HeaderRow({
            columns: this.columns,
            collection: this.collection
        });
    }, BackgridHeaderRenderMethod = function() {
        return this.$el.empty(), this.$el.append(this.row.render().$el), this.delegateEvents(), 
        this.trigger("backgrid:header:rendered", this), this;
    };
    Backgrid.Header.prototype.initialize = BackgridHeaderInitializeMethod, Backgrid.Header.prototype.createHeaderRow = BackgridHeaderCreateHeaderRowMethod, 
    Backgrid.Header.prototype.render = BackgridHeaderRenderMethod;
    var UriCell = Backgrid.UriCell = Backgrid.Cell.extend({
        className: "uri-cell",
        title: null,
        target: "_blank",
        initialize: function(options) {
            UriCell.__super__.initialize.apply(this, arguments), this.title = options.title || this.title, 
            this.target = options.target || this.target;
        },
        render: function() {
            this.$el.empty();
            var rawValue = this.model.get(this.column.get("name")), href = _.isFunction(this.column.get("href")) ? this.column.get("href")(this.model) : this.column.get("href"), klass = this.column.get("klass"), formattedValue = this.formatter.fromRaw(rawValue, this.model);
            if (this.$el.append($("<a>", {
                tabIndex: -1,
                href: href,
                title: this.title || formattedValue,
                class: klass
            }).text(formattedValue)), this.column.has("iconKlass")) {
                var iconKlass = this.column.get("iconKlass"), iconTitle = this.column.get("iconTitle");
                this.$el.find("a").append('<i class="' + iconKlass + '" title="' + iconTitle + '"></i>');
            }
            return this.delegateEvents(), this;
        }
    });
});