define([ "require", "utils/Utils", "d3", "marionette" ], function(require, Utils, d3) {
    "use strict";
    _.mixin({
        numberFormatWithComa: function(number) {
            return d3.format(",")(number);
        },
        isEmptyArray: function(val) {
            return !(!val || !_.isArray(val)) && _.isEmpty(val);
        },
        toArrayifObject: function(val) {
            return _.isObject(val) ? [ val ] : val;
        },
        startsWith: function(str, matchStr) {
            return str && matchStr && _.isString(str) && _.isString(matchStr) ? 0 === str.lastIndexOf(matchStr, 0) : void 0;
        },
        isUndefinedNull: function(val) {
            return !(!_.isUndefined(val) && !_.isNull(val));
        },
        trim: function(val) {
            return val && val.trim ? val.trim() : val;
        },
        isTypePrimitive: function(type) {
            return "int" === type || "byte" === type || "short" === type || "long" === type || "float" === type || "double" === type || "string" === type || "boolean" === type || "date" === type;
        }
    });
    var getPopoverEl = function(e) {
        return $(e.target).parent().data("bs.popover") || $(e.target).data("bs.popover") || $(e.target).parents(".popover").length;
    };
    if ($(document).on("click DOMMouseScroll mousewheel", function(e) {
        if (e.originalEvent) {
            var isPopOverEl = getPopoverEl(e);
            isPopOverEl ? isPopOverEl.$tip && $(".popover").not(isPopOverEl.$tip).popover("hide") : $(".popover").popover("hide");
        }
    }), $("body").on("hidden.bs.popover", function(e) {
        $(e.target).data("bs.popover").inState = {
            click: !1,
            hover: !1,
            focus: !1
        };
    }), $("body").on("show.bs.popover", '[data-js="popover"]', function() {
        $(".popover").not(this).popover("hide");
    }), $("body").on("keypress", "input.number-input,.number-input .select2-search__field", function(e) {
        if (8 != e.which && 0 != e.which && (e.which < 48 || e.which > 57)) return !1;
    }), $("body").on("keypress", "input.number-input-negative,.number-input-negative .select2-search__field", function(e) {
        if (8 != e.which && 0 != e.which && (e.which < 48 || e.which > 57)) {
            if (45 != e.which) return !1;
            if (this.value.length) return !1;
        }
    }), $("body").on("keypress", "input.number-input-exponential,.number-input-exponential .select2-search__field", function(e) {
        if (8 != e.which && 0 != e.which && (e.which < 48 || e.which > 57) && 69 != e.which && 101 != e.which && 43 != e.which && 45 != e.which && 46 != e.which && 190 != e.which) return !1;
    }), $("body").on("click", ".dropdown-menu.dropdown-changetitle li a", function() {
        $(this).parents("li").find(".btn:first-child").html($(this).text() + ' <span class="caret"></span>');
    }), $("body").on("click", ".btn", function() {
        $(this).blur();
    }), $.fn.select2.amd.define("ServiceTypeFilterDropdownAdapter", [ "select2/utils", "select2/dropdown", "select2/dropdown/attachBody", "select2/dropdown/attachContainer", "select2/dropdown/search", "select2/dropdown/minimumResultsForSearch", "select2/dropdown/closeOnSelect" ], function(Utils, Dropdown, AttachBody, AttachContainer, Search, MinimumResultsForSearch, CloseOnSelect) {
        var dropdownWithSearch = Utils.Decorate(Utils.Decorate(Dropdown, CloseOnSelect), Search);
        dropdownWithSearch.prototype.render = function() {
            var $rendered = Dropdown.prototype.render.call(this), placeholder = this.options.get("placeholderForSearch") || "", $search = $('<span class="select2-search select2-search--dropdown"><div class="row"><div class="col-md-10"><input class="select2-search__field" placeholder="' + placeholder + '" type="search" tabindex="-1" autocomplete="off" autocorrect="off" autocapitalize="off" spellcheck="false" role="textbox" /></div><div class="col-md-2"><button type="button" style="margin-left: -20px" class="btn btn-action btn-sm filter " title="Type Filter"><i class="fa fa-filter"></i></button></div></div></span>');
            if (!this.options.options.getFilterBox) throw "In order to render the filter options adapter needed getFilterBox function";
            var $Filter = $('<ul class="type-filter-ul"></ul>');
            return this.$Filter = $Filter, this.$Filter.append(this.options.options.getFilterBox()), 
            this.$Filter.hide(), this.$searchContainer = $search, $Filter.find('input[type="checkbox"]:checked').length ? $search.find("button.filter").addClass("active") : $search.find("button.filter").removeClass("active"), 
            this.$search = $search.find("input"), $rendered.prepend($search), $rendered.append($Filter), 
            $rendered;
        };
        var oldDropdownWithSearchBindRef = dropdownWithSearch.prototype.bind;
        dropdownWithSearch.prototype.bind = function(container, $container) {
            var self = this;
            oldDropdownWithSearchBindRef.call(this, container, $container);
            var self = this;
            this.$Filter.on("click", "li", function() {
                var itemCallback = self.options.options.onFilterItemSelect;
                itemCallback && itemCallback(this);
            }), this.$searchContainer.find("button.filter").click(function() {
                container.$dropdown.find(".select2-search").hide(150), container.$dropdown.find(".select2-results").hide(150), 
                self.$Filter.html(self.options.options.getFilterBox()), self.$Filter.show();
            }), this.$Filter.on("click", "button.filterDone", function() {
                container.$dropdown.find(".select2-search").show(150), container.$dropdown.find(".select2-results").show(150), 
                self.$Filter.hide();
                var filterSubmitCallback = self.options.options.onFilterSubmit;
                filterSubmitCallback && filterSubmitCallback({
                    filterVal: _.map(self.$Filter.find('input[type="checkbox"]:checked'), function(item) {
                        return $(item).data("value");
                    })
                });
            }), container.$element.on("hideFilter", function() {
                container.$dropdown.find(".select2-search").show(), container.$dropdown.find(".select2-results").show(), 
                self.$Filter.hide();
            });
        };
        var adapter = Utils.Decorate(dropdownWithSearch, AttachContainer);
        return adapter = Utils.Decorate(adapter, AttachBody);
    }), !("placeholder" in HTMLInputElement.prototype)) {
        var originalRender = Backbone.Marionette.LayoutView.prototype.render;
        Backbone.Marionette.LayoutView.prototype.render = function() {
            originalRender.apply(this, arguments), this.$("input, textarea").placeholder();
        };
    }
    $("body").on("click", "pre.code-block .expand-collapse-button", function(e) {
        var $el = $(this).parents(".code-block");
        $el.hasClass("shrink") ? $el.removeClass("shrink") : $el.addClass("shrink");
    }), $("body").tooltip({
        selector: "[title]",
        placement: "bottom",
        container: "body"
    });
});