define([ "require", "utils/Utils", "modules/Modal", "utils/Messages", "utils/Enums", "moment" ], function(require, Utils, Modal, Messages, Enums, moment) {
    "use strict";
    var CommonViewFunction = {};
    return CommonViewFunction.deleteTag = function(options) {
        require([ "models/VTag" ], function(VTag) {
            if (options && options.guid && options.tagName) {
                var tagModel = new VTag(), notifyObj = {
                    modal: !0,
                    text: options.msg,
                    title: options.titleMessage,
                    okText: options.okText,
                    ok: function(argument) {
                        options.showLoader && options.showLoader(), tagModel.deleteAssociation(options.guid, options.tagName, options.associatedGuid, {
                            skipDefaultError: !0,
                            success: function(data) {
                                Utils.notifySuccess({
                                    content: "Classification " + options.tagName + Messages.removeSuccessMessage
                                }), options.callback && options.callback(), options.collection && options.collection.fetch({
                                    reset: !0
                                });
                            },
                            cust_error: function(model, response) {
                                var message = options.tagName + Messages.deleteErrorMessage;
                                response && response.responseJSON && (message = response.responseJSON.errorMessage), 
                                options.hideLoader && options.hideLoader(), Utils.notifyError({
                                    content: message
                                });
                            }
                        });
                    },
                    cancel: function(argument) {
                        options.hideLoader && options.hideLoader();
                    }
                };
                Utils.notifyConfirm(notifyObj);
            }
        });
    }, CommonViewFunction.propertyTable = function(options) {
        var scope = options.scope, sortBy = options.sortBy, valueObject = options.valueObject, extractJSON = options.extractJSON, isTable = !!_.isUndefined(options.isTable) || options.isTable, attributeDefs = options.attributeDefs, formatIntVal = options.formatIntVal, showListCount = options.showListCount || !0, numberFormat = options.numberFormat || _.numberFormatWithComa, table = "", getValue = function(val) {
            return val ? !_.isNumber(val) && _.isNaN(parseInt(val)) || !formatIntVal ? val : numberFormat(val) : "N/A";
        }, fetchInputOutputValue = function(id, defEntity) {
            scope.entityModel.getEntityHeader(id, {
                success: function(serverData) {
                    var value = "", deleteButton = "", data = serverData;
                    value = Utils.getName(data);
                    var id = "";
                    data.guid && (Enums.entityStateReadOnly[data.status || data.entityStatus] && (deleteButton += '<button title="Deleted" class="btn btn-action btn-md deleteBtn"><i class="fa fa-trash"></i></button>'), 
                    id = data.guid), value.length > 0 ? scope.$('td div[data-id="' + id + '"]').html('<a href="#!/detailPage/' + id + '">' + getValue(value) + "</a>") : scope.$('td div[data-id="' + id + '"]').html('<a href="#!/detailPage/' + id + '">' + _.escape(id) + "</a>"), 
                    deleteButton.length && (scope.$('td div[data-id="' + id + '"]').addClass("block readOnlyLink"), 
                    scope.$('td div[data-id="' + id + '"]').append(deleteButton));
                },
                cust_error: function(error, xhr) {
                    403 == xhr.status ? scope.$('td div[data-id="' + id + '"]').html('<div><span class="text-danger"><i class="fa fa-exclamation-triangle" aria-hidden="true"></i> Not Authorized</span></div>') : defEntity && defEntity.options && "true" === defEntity.options.isSoftReference ? scope.$('td div[data-id="' + id + '"]').html("<div> " + id + "</div>") : scope.$('td div[data-id="' + id + '"]').html('<div><span class="text-danger"><i class="fa fa-exclamation-triangle" aria-hidden="true"></i> ' + Messages.defaultErrorMessage + "</span></div>");
                },
                complete: function() {}
            });
        }, extractObject = function(opt) {
            var valueOfArray = [], keyValue = opt.keyValue, defEntity = (opt.key, opt.defEntity);
            !_.isArray(keyValue) && _.isObject(keyValue) && (keyValue = [ keyValue ]);
            for (var subLink = "", i = 0; i < keyValue.length; i++) {
                var inputOutputField = keyValue[i], id = inputOutputField.guid || (_.isObject(inputOutputField.id) ? inputOutputField.id.id : inputOutputField.id), tempLink = "", status = inputOutputField.status || inputOutputField.entityStatus || (_.isObject(inputOutputField.id) ? inputOutputField.id.state : inputOutputField.state), readOnly = Enums.entityStateReadOnly[status];
                if (!inputOutputField.attributes && inputOutputField.values && (inputOutputField.attributes = inputOutputField.values), 
                _.isString(inputOutputField) || _.isBoolean(inputOutputField) || _.isNumber(inputOutputField)) {
                    var tempVarfor$check = inputOutputField.toString();
                    tempVarfor$check.indexOf("$") == -1 && valueOfArray.push('<span class="json-string">' + getValue(_.escape(inputOutputField)) + "</span>");
                } else if (_.isObject(inputOutputField) && !id) {
                    var attributesList = inputOutputField;
                    if (scope.typeHeaders && inputOutputField.typeName) {
                        var typeNameCategory = scope.typeHeaders.fullCollection.findWhere({
                            name: inputOutputField.typeName
                        });
                        attributesList.attributes && typeNameCategory && "STRUCT" === typeNameCategory.get("category") && (attributesList = attributesList.attributes);
                    }
                    if (extractJSON && extractJSON.extractKey) {
                        var newAttributesList = {};
                        _.each(attributesList, function(objValue, objKey) {
                            var value = _.isObject(objValue) ? objValue : _.escape(objValue), tempVarfor$check = objKey.toString();
                            tempVarfor$check.indexOf("$") == -1 && (_.isObject(extractJSON.extractKey) ? _.each(extractJSON.extractKey, function(extractKey) {
                                objKey === extractKey && (newAttributesList[_.escape(objKey)] = value);
                            }) : _.isString(extractJSON.extractKey) && extractJSON.extractKey === objKey && (newAttributesList[_.escape(objKey)] = value));
                        }), valueOfArray.push(Utils.JSONPrettyPrint(newAttributesList));
                    } else valueOfArray.push(Utils.JSONPrettyPrint(attributesList));
                }
                if (id && inputOutputField) {
                    var name = Utils.getName(inputOutputField);
                    if ("-" !== name && name !== id || inputOutputField.attributes) tempLink += '<a href="#!/detailPage/' + id + '">' + name + "</a>"; else {
                        var fetch = !0, fetchId = _.isObject(id) ? id.id : id;
                        fetchInputOutputValue(fetchId, defEntity), tempLink += '<div data-id="' + fetchId + '"><div class="value-loader"></div></div>';
                    }
                }
                readOnly ? fetch ? (fetch = !1, subLink += tempLink) : (tempLink += '<button title="Deleted" class="btn btn-action btn-md deleteBtn"><i class="fa fa-trash"></i></button>', 
                subLink += '<div class="block readOnlyLink">' + tempLink + "</div>") : tempLink.search("href") != -1 ? subLink += "<div>" + tempLink + "</div>" : tempLink.length && (subLink += tempLink);
            }
            return valueOfArray.length && (subLink = valueOfArray.join(", ")), subLink;
        }, valueObjectKeysList = _.keys(valueObject);
        return (_.isUndefined(sortBy) || 1 == sortBy) && (valueObjectKeysList = _.sortBy(valueObjectKeysList)), 
        valueObjectKeysList.map(function(key) {
            if (key = _.escape(key), "profileData" != key) {
                var keyValue = valueObject[key], listCount = showListCount && _.isArray(keyValue) && keyValue.length > 0 ? " (" + numberFormat(keyValue.length) + ")" : "", defEntity = _.find(attributeDefs, {
                    name: key
                });
                if (defEntity && defEntity.typeName) {
                    var defEntityType = defEntity.typeName.toLocaleLowerCase();
                    "date" === defEntityType ? keyValue = new Date(keyValue) : _.isObject(keyValue) && (keyValue = extractObject({
                        keyValue: keyValue,
                        key: key,
                        defEntity: defEntity
                    }));
                } else _.isObject(keyValue) && (keyValue = extractObject({
                    keyValue: keyValue,
                    key: key
                }));
                var val = "";
                if (val = _.isObject(valueObject[key]) ? keyValue : Utils.isUrl(keyValue) ? '<a target="_blank" class="blue-link" href="' + keyValue + '">' + keyValue + "</a>" : "guid" === key || "__guid" === key ? '<a title="' + key + '" href="#!/detailPage/' + keyValue + '">' + keyValue + "</a>" : _.escape(keyValue), 
                isTable) {
                    var htmlTag = '<div class="scroll-y">' + getValue(val) + "</div>";
                    if (_.isObject(valueObject[key]) && !_.isEmpty(valueObject[key])) {
                        var matchedLinkString = val.match(/href|value-loader\w*/g), matchedJson = val.match(/json-value|json-string\w*/g), isMatchLinkStringIsSingle = matchedLinkString && matchedLinkString.length <= 5, isMatchJSONStringIsSingle = matchedJson && 1 == matchedJson.length, expandCollapseButton = "";
                        (matchedJson && !isMatchJSONStringIsSingle || matchedLinkString && !isMatchLinkStringIsSingle) && (expandCollapseButton = '<button class="expand-collapse-button"><i class="fa"></i></button>', 
                        htmlTag = '<pre class="shrink code-block ' + (isMatchJSONStringIsSingle ? "fixed-height" : "") + '">' + expandCollapseButton + "<code>" + val + "</code></pre>");
                    }
                    table += "<tr><td>" + (_.escape(key) + listCount) + "</td><td>" + htmlTag + "</td></tr>";
                } else table += "<div>" + val + "</div>";
            }
        }), table && table.length > 0 ? table : '<tr class="empty"><td colspan="22"><span>No Record found!</span></td></tr>';
    }, CommonViewFunction.tagForTable = function(obj) {
        var traits = obj.classifications, tagHtml = "", addTag = "", popTag = "", count = 0, entityName = Utils.getName(obj);
        return traits && traits.map(function(tag) {
            var className = "btn btn-action btn-sm btn-blue btn-icon", deleteIcon = "";
            obj.guid === tag.entityGuid ? deleteIcon = '<i class="fa fa-times" data-id="delete"  data-assetname="' + entityName + '"data-name="' + tag.typeName + '" data-type="tag" data-guid="' + obj.guid + '" ></i>' : obj.guid !== tag.entityGuid && "DELETED" === tag.entityStatus ? deleteIcon = '<i class="fa fa-times" data-id="delete"  data-assetname="' + entityName + '"data-name="' + tag.typeName + '" data-type="tag" data-entityguid="' + tag.entityGuid + '" data-guid="' + obj.guid + '" ></i>' : className += " propagte-classification";
            var tagString = '<a class="' + className + '" data-id="tagClick"><span title="' + tag.typeName + '">' + tag.typeName + "</span>" + deleteIcon + "</a>";
            count >= 1 ? popTag += tagString : tagHtml += tagString, ++count;
        }), Enums.entityStateReadOnly[obj.status || obj.entityStatus] || (addTag += obj.guid ? '<a href="javascript:void(0)" data-id="addTag" class="btn btn-action btn-sm assignTag" data-guid="' + obj.guid + '" ><i class="fa fa-plus"></i></a>' : '<a href="javascript:void(0)" data-id="addTag" class="btn btn-action btn-sm assignTag"><i style="right:0" class="fa fa-plus"></i></a>'), 
        count > 1 && (addTag += '<div data-id="showMoreLess" class="btn btn-action btn-sm assignTag"><i class="fa fa-ellipsis-h" aria-hidden="true"></i><div class="popup-tag-term">' + popTag + "</div></div>"), 
        '<div class="tagList btn-inline btn-fixed-width">' + tagHtml + addTag + "</div>";
    }, CommonViewFunction.termForTable = function(obj) {
        var terms = obj.meanings, termHtml = "", addTerm = "", popTerm = "", count = 0, entityName = Utils.getName(obj);
        return terms && terms.map(function(term) {
            var className = "btn btn-action btn-sm btn-blue btn-icon", deleteIcon = '<i class="fa fa-times" data-id="delete"  data-assetname="' + entityName + '"data-name="' + term.displayText + '" data-type="term" data-guid="' + obj.guid + '" data-termGuid="' + term.termGuid + '" ></i>', termString = '<a class="' + className + '" data-id="termClick"><span title="' + _.escape(term.displayText) + '">' + _.escape(term.displayText) + "</span>" + deleteIcon + "</a>";
            count >= 1 ? popTerm += termString : termHtml += termString, ++count;
        }), Enums.entityStateReadOnly[obj.status || obj.entityStatus] || (addTerm += obj.guid ? '<a href="javascript:void(0)" data-id="addTerm" class="btn btn-action btn-sm assignTag" data-guid="' + obj.guid + '" ><i class="fa fa-plus"></i></a>' : '<a href="javascript:void(0)" data-id="addTerm" class="btn btn-action btn-sm assignTag"><i style="right:0" class="fa fa-plus"></i></a>'), 
        count > 1 && (addTerm += '<div data-id="showMoreLess" class="btn btn-action btn-sm assignTerm"><i class="fa fa-ellipsis-h" aria-hidden="true"></i><div class="popup-tag-term">' + popTerm + "</div></div>"), 
        '<div class="tagList btn-inline btn-fixed-width">' + termHtml + addTerm + "</div>";
    }, CommonViewFunction.generateQueryOfFilter = function(value) {
        function objToString(filterObj) {
            var generatedQuery = _.map(filterObj.rules, function(obj, key) {
                return _.has(obj, "condition") ? '&nbsp<span class="operator">' + obj.condition + "</span>&nbsp(" + objToString(obj) + ")" : '<span class="key">' + _.escape(obj.id) + '</span>&nbsp<span class="operator">' + _.escape(obj.operator) + '</span>&nbsp<span class="value">' + _.escape(obj.value) + "</span>";
            });
            return generatedQuery;
        }
        var entityFilters = CommonViewFunction.attributeFilter.extractUrl({
            value: value.entityFilters,
            formatDate: !0
        }), tagFilters = CommonViewFunction.attributeFilter.extractUrl({
            value: value.tagFilters,
            formatDate: !0
        }), queryArray = [];
        if (value.type) {
            var typeKeyValue = '<span class="key">Type:</span>&nbsp<span class="value">' + _.escape(value.type) + "</span>";
            if (entityFilters) {
                var conditionForEntity = 1 == entityFilters.rules.length ? "" : "AND";
                typeKeyValue += '&nbsp<span class="operator">' + conditionForEntity + '</span>&nbsp(<span class="operator">' + entityFilters.condition + "</span>&nbsp(" + objToString(entityFilters) + "))";
            }
            queryArray.push(typeKeyValue);
        }
        if (value.tag) {
            var tagKeyValue = '<span class="key">Classification:</span>&nbsp<span class="value">' + _.escape(value.tag) + "</span>";
            if (tagFilters) {
                var conditionFortag = 1 == tagFilters.rules.length ? "" : "AND";
                tagKeyValue += '&nbsp<span class="operator">' + conditionFortag + '</span>&nbsp(<span class="operator">' + tagFilters.condition + "</span>&nbsp(" + objToString(tagFilters) + "))";
            }
            queryArray.push(tagKeyValue);
        }
        if (value.term) {
            var tagKeyValue = '<span class="key">Term:</span>&nbsp<span class="value">' + _.escape(value.term) + "</span>";
            queryArray.push(tagKeyValue);
        }
        return value.query && queryArray.push('<span class="key">Query:</span>&nbsp<span class="value">' + _.trim(_.escape(value.query)) + "</span>&nbsp"), 
        1 == queryArray.length ? queryArray.join() : "<span>(</span>&nbsp" + queryArray.join("<span>&nbsp)</span>&nbsp<span>AND</span>&nbsp<span>(</span>&nbsp") + "&nbsp<span>)</span>";
    }, CommonViewFunction.generateObjectForSaveSearchApi = function(options) {
        var obj = {
            name: options.name,
            guid: options.guid
        }, value = options.value;
        if (value) return _.each(Enums.extractFromUrlForSearch, function(svalue, skey) {
            _.isObject(svalue) ? _.each(svalue, function(v, k) {
                var val = value[k];
                _.isUndefinedNull(val) || ("attributes" == k ? val = val.split(",") : _.contains([ "tagFilters", "entityFilters" ], k) ? val = CommonViewFunction.attributeFilter.generateAPIObj(val) : _.contains([ "includeDE", "excludeST", "excludeSC" ], k) && (val = !val)), 
                _.contains([ "includeDE", "excludeST", "excludeSC" ], k) && (val = !!_.isUndefinedNull(val) || val), 
                obj[skey] || (obj[skey] = {}), obj[skey][v] = val;
            }) : obj[skey] = value[skey];
        }), obj;
    }, CommonViewFunction.generateUrlFromSaveSearchObject = function(options) {
        var value = options.value, classificationDefCollection = options.classificationDefCollection, entityDefCollection = options.entityDefCollection, obj = {};
        if (value) return _.each(Enums.extractFromUrlForSearch, function(svalue, skey) {
            _.isObject(svalue) ? _.each(svalue, function(v, k) {
                var val = value[skey][v];
                if (!_.isUndefinedNull(val)) if ("attributes" == k) val = val.join(","); else if ("tagFilters" == k) {
                    if (classificationDefCollection) {
                        var classificationDef = classificationDefCollection.fullCollection.findWhere({
                            name: value[skey].classification
                        });
                        attributeDefs = Utils.getNestedSuperTypeObj({
                            collection: classificationDefCollection,
                            attrMerge: !0,
                            data: classificationDef.toJSON()
                        });
                    }
                    val = CommonViewFunction.attributeFilter.generateUrl({
                        value: val,
                        attributeDefs: attributeDefs
                    });
                } else if ("entityFilters" == k) {
                    if (entityDefCollection) var entityDef = entityDefCollection.fullCollection.findWhere({
                        name: value[skey].typeName
                    }), attributeDefs = Utils.getNestedSuperTypeObj({
                        collection: entityDefCollection,
                        attrMerge: !0,
                        data: entityDef.toJSON()
                    });
                    val = CommonViewFunction.attributeFilter.generateUrl({
                        value: val,
                        attributeDefs: attributeDefs
                    });
                } else _.contains([ "includeDE", "excludeST", "excludeSC" ], k) && (val = !val);
                obj[k] = val;
            }) : obj[skey] = value[skey];
        }), obj;
    }, CommonViewFunction.attributeFilter = {
        generateUrl: function(options) {
            function conditionalURl(options, spliter) {
                return options ? _.map(options.rules || options.criterion, function(obj, key) {
                    if (_.has(obj, "condition")) return obj.condition + "(" + conditionalURl(obj, spliter + 1) + ")";
                    if (attributeDefs) {
                        var attributeDef = _.findWhere(attributeDefs, {
                            name: obj.attributeName
                        });
                        attributeDef && (obj.attributeValue = obj.attributeValue, obj.attributeType = attributeDef.typeName);
                    }
                    var type = obj.type || obj.attributeType, value = _.isString(obj.value) && _.contains([ "is_null", "not_null" ], obj.operator) && "date" === type || _.isObject(obj.value) ? "" : _.trim(obj.value || obj.attributeValue), url = [ obj.id || obj.attributeName, mapApiOperatorToUI(obj.operator), "date" === type && formatedDateToLong && value.length ? Date.parse(value) : value ];
                    return type && url.push(type), url.join("::");
                }).join("|" + spliter + "|") : null;
            }
            function mapApiOperatorToUI(oper) {
                return "eq" == oper ? "=" : "neq" == oper ? "!=" : "lt" == oper ? "<" : "lte" == oper ? "<=" : "gt" == oper ? ">" : "gte" == oper ? ">=" : "startsWith" == oper ? "begins_with" : "endsWith" == oper ? "ends_with" : "contains" == oper ? "contains" : "notNull" == oper ? "not_null" : "isNull" == oper ? "is_null" : oper;
            }
            var attrQuery = [], attrObj = options.value, formatedDateToLong = options.formatedDateToLong, attributeDefs = options.attributeDefs, spliter = 1;
            return attrQuery = conditionalURl(attrObj, spliter), attrQuery.length ? attrObj.condition + "(" + attrQuery + ")" : null;
        },
        extractUrl: function(options) {
            var attrObj = {}, urlObj = options.value, formatDate = options.formatDate, spliter = 1, apiObj = options.apiObj, mapUiOperatorToAPI = function(oper) {
                return "=" == oper ? "eq" : "!=" == oper ? "neq" : "<" == oper ? "lt" : "<=" == oper ? "lte" : ">" == oper ? "gt" : ">=" == oper ? "gte" : "begins_with" == oper ? "startsWith" : "ends_with" == oper ? "endsWith" : "contains" == oper ? "contains" : "not_null" == oper ? "notNull" : "is_null" == oper ? "isNull" : oper;
            }, createObject = function(urlObj) {
                var finalObj = {};
                return finalObj.condition = /^AND\(/.test(urlObj) ? "AND" : "OR", urlObj = "AND" === finalObj.condition ? urlObj.substr(4).slice(0, -1) : urlObj.substr(3).slice(0, -1), 
                finalObj[apiObj ? "criterion" : "rules"] = _.map(urlObj.split("|" + spliter + "|"), function(obj, key) {
                    var isStringNested = obj.split("|" + (spliter + 1) + "|").length > 1, isCondition = /^AND\(/.test(obj) || /^OR\(/.test(obj);
                    if (isStringNested && isCondition) return ++spliter, createObject(obj);
                    if (isCondition) return createObject(obj);
                    var temp = obj.split("::") || obj.split("|" + spliter + "|"), rule = {};
                    return apiObj ? (rule = {
                        attributeName: temp[0],
                        operator: mapUiOperatorToAPI(temp[1]),
                        attributeValue: _.trim(temp[2])
                    }, rule.attributeValue = "date" === rule.type && formatDate && rule.attributeValue.length ? moment(parseInt(rule.attributeValue)).format("MM/DD/YYYY h:mm A") : rule.attributeValue) : (rule = {
                        id: temp[0],
                        operator: temp[1],
                        value: _.trim(temp[2])
                    }, temp[3] && (rule.type = temp[3]), rule.value = "date" === rule.type && formatDate && rule.value.length ? moment(parseInt(rule.value)).format("MM/DD/YYYY h:mm A") : rule.value), 
                    rule;
                }), finalObj;
            };
            return urlObj && urlObj.length ? attrObj = createObject(urlObj) : null;
        },
        generateAPIObj: function(url) {
            return url && url.length ? this.extractUrl({
                value: url,
                apiObj: !0
            }) : null;
        }
    }, CommonViewFunction.createEditGlossaryCategoryTerm = function(options) {
        if (options) var model = options.model, isTermView = options.isTermView, isGlossaryView = options.isGlossaryView, collection = options.collection;
        require([ "views/glossary/CreateEditCategoryTermLayoutView", "views/glossary/CreateEditGlossaryLayoutView", "modules/Modal" ], function(CreateEditCategoryTermLayoutView, CreateEditGlossaryLayoutView, Modal) {
            var view = null, title = null;
            isGlossaryView ? (view = new CreateEditGlossaryLayoutView({
                glossaryCollection: collection,
                model: model
            }), title = "Glossary") : (view = new CreateEditCategoryTermLayoutView({
                glossaryCollection: collection,
                modelJSON: model
            }), title = isTermView ? "Term" : "Category");
            var modal = new Modal({
                title: (model ? "Update " : "Create ") + title,
                content: view,
                cancelText: "Cancel",
                okCloses: !1,
                okText: model ? "Update" : "Create",
                allowCancel: !0
            }).open();
            modal.$el.find("button.ok").attr("disabled", "true"), model ? view.$("input,textarea").on("keyup", function(e) {
                modal.$el.find("button.ok").attr("disabled", !1);
            }) : view.ui.name.on("keyup", function(e) {
                modal.$el.find("button.ok").attr("disabled", !1);
            }), view.ui.name.on("keyup", function(e) {
                8 != e.keyCode && 32 != e.keyCode && 46 != e.keyCode || "" != e.currentTarget.value.trim() || modal.$el.find("button.ok").attr("disabled", !0);
            }), modal.on("ok", function() {
                modal.$el.find("button.ok").attr("disabled", !0), CommonViewFunction.createEditGlossaryCategoryTermSubmit(_.extend({
                    ref: view,
                    modal: modal
                }, options));
            }), modal.on("closeModal", function() {
                modal.trigger("cancel"), options.onModalClose && options.onModalClose();
            });
        });
    }, CommonViewFunction.createEditGlossaryCategoryTermSubmit = function(options) {
        if (options) var ref = options.ref, modal = options.modal, model = options.model, node = options.node, isTermView = options.isTermView, isCategoryView = options.isCategoryView, collection = options.collection, isGlossaryView = options.isGlossaryView, data = ref.ui[isGlossaryView ? "glossaryForm" : "categoryTermForm"].serializeArray().reduce(function(obj, item) {
            return obj[item.name] = item.value, obj;
        }, {}), newModel = new options.collection.model(), messageType = "Glossary ";
        isTermView ? messageType = "Term " : isCategoryView && (messageType = "Category ");
        var ajaxOptions = {
            silent: !0,
            success: function(rModel, response) {
                Utils.notifySuccess({
                    content: messageType + ref.ui.name.val() + Messages[model ? "editSuccessMessage" : "addSuccessMessage"]
                }), options.callback && options.callback(rModel), modal.trigger("closeModal");
            },
            cust_error: function() {
                modal.$el.find("button.ok").attr("disabled", !1);
            }
        };
        if (model) isGlossaryView ? model.clone().set(data, {
            silent: !0
        }).save(null, ajaxOptions) : newModel[isTermView ? "createEditTerm" : "createEditCategory"](_.extend(ajaxOptions, {
            guid: model.guid,
            data: JSON.stringify(_.extend({}, model, data))
        })); else if (isGlossaryView) new collection.model().set(data).save(null, ajaxOptions); else {
            if (node) {
                data.anchor = {
                    glossaryGuid: node.glossaryId || node.guid,
                    displayText: node.glossaryName || node.text
                }, "GlossaryCategory" == node.type && (data.parentCategory = {
                    categoryGuid: node.guid
                });
            }
            newModel[isTermView ? "createEditTerm" : "createEditCategory"](_.extend(ajaxOptions, {
                data: JSON.stringify(data)
            }));
        }
    }, CommonViewFunction.removeCategoryTermAssociation = function(options) {
        if (options) {
            var selectedGuid = options.selectedGuid, termGuid = options.termGuid, isCategoryView = options.isCategoryView, isTermView = options.isTermView, isEntityView = options.isEntityView, model = (options.collection, 
            options.model), newModel = new options.collection.model(), ajaxOptions = {
                success: function(rModel, response) {
                    Utils.notifySuccess({
                        content: (isCategoryView || isEntityView ? "Term" : "Category") + " association is removed successfully"
                    }), options.callback && options.callback();
                },
                cust_error: function() {
                    options.hideLoader && options.hideLoader();
                }
            }, notifyObj = {
                modal: !0,
                text: options.msg,
                title: options.titleMessage,
                okText: options.buttonText,
                ok: function(argument) {
                    if (options.showLoader && options.showLoader(), isEntityView && model) {
                        var data = [ model ];
                        newModel.removeTermFromEntity(termGuid, _.extend(ajaxOptions, {
                            data: JSON.stringify(data)
                        }));
                    } else {
                        var data = _.extend({}, model);
                        isTermView ? data.categories = _.reject(data.categories, function(term) {
                            return term.categoryGuid == selectedGuid;
                        }) : data.terms = _.reject(data.terms, function(term) {
                            return term.termGuid == selectedGuid;
                        }), newModel[isTermView ? "createEditTerm" : "createEditCategory"](_.extend(ajaxOptions, {
                            guid: model.guid,
                            data: JSON.stringify(_.extend({}, model, data))
                        }));
                    }
                },
                cancel: function(argument) {}
            };
            Utils.notifyConfirm(notifyObj);
        }
    }, CommonViewFunction.addRestCsrfCustomHeader = function(xhr, settings) {
        if (null != settings.url) {
            var method = settings.type;
            null == CommonViewFunction.restCsrfCustomHeader || CommonViewFunction.restCsrfMethodsToIgnore[method] || xhr.setRequestHeader(CommonViewFunction.restCsrfCustomHeader, '""');
        }
    }, CommonViewFunction.restCsrfCustomHeader = null, CommonViewFunction.restCsrfMethodsToIgnore = null, 
    CommonViewFunction.userDataFetch = function(options) {
        function getTrimmedStringArrayValue(string) {
            var str = string, array = [];
            if (str) for (var splitStr = str.split(","), i = 0; i < splitStr.length; i++) array.push(splitStr[i].trim());
            return array;
        }
        var csrfEnabled = !1, header = null, methods = [];
        options.url && $.ajax({
            url: options.url,
            success: function(response) {
                if (response) {
                    if (response["atlas.rest-csrf.enabled"]) {
                        var str = "" + response["atlas.rest-csrf.enabled"];
                        csrfEnabled = "true" == str.toLowerCase();
                    }
                    response["atlas.rest-csrf.custom-header"] && (header = response["atlas.rest-csrf.custom-header"].trim()), 
                    response["atlas.rest-csrf.methods-to-ignore"] && (methods = getTrimmedStringArrayValue(response["atlas.rest-csrf.methods-to-ignore"])), 
                    csrfEnabled && (CommonViewFunction.restCsrfCustomHeader = header, CommonViewFunction.restCsrfMethodsToIgnore = {}, 
                    methods.map(function(method) {
                        CommonViewFunction.restCsrfMethodsToIgnore[method] = !0;
                    }), Backbone.$.ajaxSetup({
                        beforeSend: CommonViewFunction.addRestCsrfCustomHeader
                    }));
                }
            },
            complete: function(response) {
                options.callback && options.callback(response.responseJSON);
            }
        });
    }, CommonViewFunction;
});