/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchPredicateUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SearchPredicateUtil.class);
    private static Predicate ALWAYS_FALSE = new Predicate(){

        public boolean evaluate(Object object) {
            return false;
        }
    };

    public static VertexAttributePredicateGenerator getLTPredicateGenerator() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getLTPredicateGenerator");
        }
        VertexAttributePredicateGenerator ret = new VertexAttributePredicateGenerator(){

            @Override
            public Predicate generatePredicate(String attrName, Object attrVal, Class attrClass) {
                Object ret = attrName == null || attrClass == null || attrVal == null ? ALWAYS_FALSE : (Short.class.isAssignableFrom(attrClass) ? ShortPredicate.getLTPredicate(attrName, attrClass, (Short)attrVal) : (Integer.class.isAssignableFrom(attrClass) ? IntegerPredicate.getLTPredicate(attrName, attrClass, (Integer)attrVal) : (Long.class.isAssignableFrom(attrClass) ? LongPredicate.getLTPredicate(attrName, attrClass, (Long)attrVal) : (Float.class.isAssignableFrom(attrClass) ? FloatPredicate.getLTPredicate(attrName, attrClass, (Float)attrVal) : (Double.class.isAssignableFrom(attrClass) ? DoublePredicate.getLTPredicate(attrName, attrClass, (Double)attrVal) : (Byte.class.isAssignableFrom(attrClass) ? BytePredicate.getLTPredicate(attrName, attrClass, (Byte)attrVal) : (BigInteger.class.isAssignableFrom(attrClass) ? BigIntegerPredicate.getLTPredicate(attrName, attrClass, (BigInteger)attrVal) : (BigDecimal.class.isAssignableFrom(attrClass) ? BigDecimalPredicate.getLTPredicate(attrName, attrClass, (BigDecimal)attrVal) : (String.class.isAssignableFrom(attrClass) ? StringPredicate.getLTPredicate(attrName, attrClass, (String)attrVal) : ALWAYS_FALSE)))))))));
                return ret;
            }
        };
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getLTPredicateGenerator");
        }
        return ret;
    }

    public static VertexAttributePredicateGenerator getGTPredicateGenerator() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getGTPredicateGenerator");
        }
        VertexAttributePredicateGenerator ret = new VertexAttributePredicateGenerator(){

            @Override
            public Predicate generatePredicate(String attrName, Object attrVal, Class attrClass) {
                Object ret = attrName == null || attrClass == null || attrVal == null ? ALWAYS_FALSE : (Short.class.isAssignableFrom(attrClass) ? ShortPredicate.getGTPredicate(attrName, attrClass, (Short)attrVal) : (Integer.class.isAssignableFrom(attrClass) ? IntegerPredicate.getGTPredicate(attrName, attrClass, (Integer)attrVal) : (Long.class.isAssignableFrom(attrClass) ? LongPredicate.getGTPredicate(attrName, attrClass, (Long)attrVal) : (Float.class.isAssignableFrom(attrClass) ? FloatPredicate.getGTPredicate(attrName, attrClass, (Float)attrVal) : (Double.class.isAssignableFrom(attrClass) ? DoublePredicate.getGTPredicate(attrName, attrClass, (Double)attrVal) : (Byte.class.isAssignableFrom(attrClass) ? BytePredicate.getGTPredicate(attrName, attrClass, (Byte)attrVal) : (BigInteger.class.isAssignableFrom(attrClass) ? BigIntegerPredicate.getGTPredicate(attrName, attrClass, (BigInteger)attrVal) : (BigDecimal.class.isAssignableFrom(attrClass) ? BigDecimalPredicate.getGTPredicate(attrName, attrClass, (BigDecimal)attrVal) : (String.class.isAssignableFrom(attrClass) ? StringPredicate.getGTPredicate(attrName, attrClass, (String)attrVal) : ALWAYS_FALSE)))))))));
                return ret;
            }
        };
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getGTPredicateGenerator");
        }
        return ret;
    }

    public static VertexAttributePredicateGenerator getLTEPredicateGenerator() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getLTEPredicateGenerator");
        }
        VertexAttributePredicateGenerator ret = new VertexAttributePredicateGenerator(){

            @Override
            public Predicate generatePredicate(String attrName, Object attrVal, Class attrClass) {
                Object ret = attrName == null || attrClass == null || attrVal == null ? ALWAYS_FALSE : (Short.class.isAssignableFrom(attrClass) ? ShortPredicate.getLTEPredicate(attrName, attrClass, (Short)attrVal) : (Integer.class.isAssignableFrom(attrClass) ? IntegerPredicate.getLTEPredicate(attrName, attrClass, (Integer)attrVal) : (Long.class.isAssignableFrom(attrClass) ? LongPredicate.getLTEPredicate(attrName, attrClass, (Long)attrVal) : (Float.class.isAssignableFrom(attrClass) ? FloatPredicate.getLTEPredicate(attrName, attrClass, (Float)attrVal) : (Double.class.isAssignableFrom(attrClass) ? DoublePredicate.getLTEPredicate(attrName, attrClass, (Double)attrVal) : (Byte.class.isAssignableFrom(attrClass) ? BytePredicate.getLTEPredicate(attrName, attrClass, (Byte)attrVal) : (BigInteger.class.isAssignableFrom(attrClass) ? BigIntegerPredicate.getLTEPredicate(attrName, attrClass, (BigInteger)attrVal) : (BigDecimal.class.isAssignableFrom(attrClass) ? BigDecimalPredicate.getLTEPredicate(attrName, attrClass, (BigDecimal)attrVal) : (String.class.isAssignableFrom(attrClass) ? StringPredicate.getLTEPredicate(attrName, attrClass, (String)attrVal) : ALWAYS_FALSE)))))))));
                return ret;
            }
        };
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getLTEPredicateGenerator");
        }
        return ret;
    }

    public static VertexAttributePredicateGenerator getGTEPredicateGenerator() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getGTEPredicateGenerator");
        }
        VertexAttributePredicateGenerator ret = new VertexAttributePredicateGenerator(){

            @Override
            public Predicate generatePredicate(String attrName, Object attrVal, Class attrClass) {
                Object ret = attrName == null || attrClass == null || attrVal == null ? ALWAYS_FALSE : (Short.class.isAssignableFrom(attrClass) ? ShortPredicate.getGTEPredicate(attrName, attrClass, (Short)attrVal) : (Integer.class.isAssignableFrom(attrClass) ? IntegerPredicate.getGTEPredicate(attrName, attrClass, (Integer)attrVal) : (Long.class.isAssignableFrom(attrClass) ? LongPredicate.getGTEPredicate(attrName, attrClass, (Long)attrVal) : (Float.class.isAssignableFrom(attrClass) ? FloatPredicate.getGTEPredicate(attrName, attrClass, (Float)attrVal) : (Double.class.isAssignableFrom(attrClass) ? DoublePredicate.getGTEPredicate(attrName, attrClass, (Double)attrVal) : (Byte.class.isAssignableFrom(attrClass) ? BytePredicate.getGTEPredicate(attrName, attrClass, (Byte)attrVal) : (BigInteger.class.isAssignableFrom(attrClass) ? BigIntegerPredicate.getGTEPredicate(attrName, attrClass, (BigInteger)attrVal) : (BigDecimal.class.isAssignableFrom(attrClass) ? BigDecimalPredicate.getGTEPredicate(attrName, attrClass, (BigDecimal)attrVal) : (String.class.isAssignableFrom(attrClass) ? StringPredicate.getGTEPredicate(attrName, attrClass, (String)attrVal) : ALWAYS_FALSE)))))))));
                return ret;
            }
        };
        if (LOG.isDebugEnabled()) {
            LOG.debug("<- getGTEPredicateGenerator");
        }
        return ret;
    }

    public static VertexAttributePredicateGenerator getEQPredicateGenerator() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getEQPredicateGenerator");
        }
        VertexAttributePredicateGenerator ret = new VertexAttributePredicateGenerator(){

            @Override
            public Predicate generatePredicate(String attrName, Object attrVal, Class attrClass) {
                Object ret = attrName == null || attrClass == null || attrVal == null ? ALWAYS_FALSE : (Boolean.class.isAssignableFrom(attrClass) ? BooleanPredicate.getEQPredicate(attrName, attrClass, (Boolean)attrVal) : (Byte.class.isAssignableFrom(attrClass) ? BytePredicate.getEQPredicate(attrName, attrClass, (Byte)attrVal) : (Short.class.isAssignableFrom(attrClass) ? ShortPredicate.getEQPredicate(attrName, attrClass, (Short)attrVal) : (Integer.class.isAssignableFrom(attrClass) ? IntegerPredicate.getEQPredicate(attrName, attrClass, (Integer)attrVal) : (Long.class.isAssignableFrom(attrClass) ? LongPredicate.getEQPredicate(attrName, attrClass, (Long)attrVal) : (Float.class.isAssignableFrom(attrClass) ? FloatPredicate.getEQPredicate(attrName, attrClass, (Float)attrVal) : (Double.class.isAssignableFrom(attrClass) ? DoublePredicate.getEQPredicate(attrName, attrClass, (Double)attrVal) : (BigInteger.class.isAssignableFrom(attrClass) ? BigIntegerPredicate.getEQPredicate(attrName, attrClass, (BigInteger)attrVal) : (BigDecimal.class.isAssignableFrom(attrClass) ? BigDecimalPredicate.getEQPredicate(attrName, attrClass, (BigDecimal)attrVal) : (String.class.isAssignableFrom(attrClass) ? StringPredicate.getEQPredicate(attrName, attrClass, (String)attrVal) : ALWAYS_FALSE))))))))));
                return ret;
            }
        };
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getEQPredicateGenerator");
        }
        return ret;
    }

    public static VertexAttributePredicateGenerator getNEQPredicateGenerator() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getNEQPredicateGenerator");
        }
        VertexAttributePredicateGenerator ret = new VertexAttributePredicateGenerator(){

            @Override
            public Predicate generatePredicate(String attrName, Object attrVal, Class attrClass) {
                Object ret = attrName == null || attrClass == null || attrVal == null ? ALWAYS_FALSE : (Boolean.class.isAssignableFrom(attrClass) ? BooleanPredicate.getNEQPredicate(attrName, attrClass, (Boolean)attrVal) : (Byte.class.isAssignableFrom(attrClass) ? BytePredicate.getNEQPredicate(attrName, attrClass, (Byte)attrVal) : (Short.class.isAssignableFrom(attrClass) ? ShortPredicate.getNEQPredicate(attrName, attrClass, (Short)attrVal) : (Integer.class.isAssignableFrom(attrClass) ? IntegerPredicate.getNEQPredicate(attrName, attrClass, (Integer)attrVal) : (Long.class.isAssignableFrom(attrClass) ? LongPredicate.getNEQPredicate(attrName, attrClass, (Long)attrVal) : (Float.class.isAssignableFrom(attrClass) ? FloatPredicate.getNEQPredicate(attrName, attrClass, (Float)attrVal) : (Double.class.isAssignableFrom(attrClass) ? DoublePredicate.getNEQPredicate(attrName, attrClass, (Double)attrVal) : (BigInteger.class.isAssignableFrom(attrClass) ? BigIntegerPredicate.getNEQPredicate(attrName, attrClass, (BigInteger)attrVal) : (BigDecimal.class.isAssignableFrom(attrClass) ? BigDecimalPredicate.getNEQPredicate(attrName, attrClass, (BigDecimal)attrVal) : (String.class.isAssignableFrom(attrClass) ? StringPredicate.getNEQPredicate(attrName, attrClass, (String)attrVal) : ALWAYS_FALSE))))))))));
                return ret;
            }
        };
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getNEQPredicateGenerator");
        }
        return ret;
    }

    public static VertexAttributePredicateGenerator getContainsAnyPredicateGenerator() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getContainsAnyPredicateGenerator");
        }
        VertexAttributePredicateGenerator ret = new VertexAttributePredicateGenerator(){

            @Override
            public Predicate generatePredicate(String attrName, final Object attrVal, Class attrClass) {
                Object ret = attrName == null || attrClass == null || attrVal == null || !this.isValid(attrVal, attrClass) ? ALWAYS_FALSE : new VertexAttributePredicate(attrName, attrClass){

                    @Override
                    public boolean compareValue(Object vertexAttrVal) {
                        return CollectionUtils.containsAny((Collection)((Collection)attrVal), (Collection)((Collection)vertexAttrVal));
                    }
                };
                return ret;
            }

            private boolean isValid(Object attrVal, Class attrClass) {
                return attrVal instanceof Collection && Collection.class.isAssignableFrom(attrClass);
            }
        };
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getContainsAnyPredicateGenerator");
        }
        return ret;
    }

    public static VertexAttributePredicateGenerator getContainsAllPredicateGenerator() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getContainsAllPredicateGenerator");
        }
        VertexAttributePredicateGenerator ret = new VertexAttributePredicateGenerator(){

            @Override
            public Predicate generatePredicate(String attrName, final Object attrVal, Class attrClass) {
                Object ret = attrName == null || attrClass == null || attrVal == null || !this.isValid(attrVal, attrClass) ? ALWAYS_FALSE : new VertexAttributePredicate(attrName, attrClass){

                    @Override
                    public boolean compareValue(Object vertexAttrVal) {
                        return ((Collection)attrVal).containsAll((Collection)vertexAttrVal);
                    }
                };
                return ret;
            }

            private boolean isValid(Object attrVal, Class attrClass) {
                return attrVal instanceof Collection && Collection.class.isAssignableFrom(attrClass);
            }
        };
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getContainsAllPredicateGenerator");
        }
        return ret;
    }

    public static VertexAttributePredicateGenerator getINPredicateGenerator() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getINPredicateGenerator");
        }
        VertexAttributePredicateGenerator ret = new VertexAttributePredicateGenerator(){

            @Override
            public Predicate generatePredicate(String attrName, final Object attrVal, Class attrClass) {
                Object ret = attrName == null || attrClass == null || attrVal == null || !this.isValid(attrVal, attrClass) ? ALWAYS_FALSE : new VertexAttributePredicate(attrName, attrClass){

                    @Override
                    public boolean compareValue(Object vertexAttrVal) {
                        return ((Collection)attrVal).contains(vertexAttrVal);
                    }
                };
                return ret;
            }

            private boolean isValid(Object attrVal, Class attrClass) {
                return attrVal instanceof Collection;
            }
        };
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getINPredicateGenerator");
        }
        return ret;
    }

    public static VertexAttributePredicateGenerator getLIKEPredicateGenerator() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getLIKEPredicateGenerator");
        }
        VertexAttributePredicateGenerator ret = new VertexAttributePredicateGenerator(){

            @Override
            public Predicate generatePredicate(String attrName, Object attrVal, Class attrClass) {
                Object ret = attrName == null || attrClass == null || attrVal == null ? ALWAYS_FALSE : (String.class.isAssignableFrom(attrClass) ? StringPredicate.getContainsPredicate(attrName, attrClass, (String)attrVal) : ALWAYS_FALSE);
                return ret;
            }
        };
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getLIKEPredicateGenerator");
        }
        return ret;
    }

    public static VertexAttributePredicateGenerator getStartsWithPredicateGenerator() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getStartsWithPredicateGenerator");
        }
        VertexAttributePredicateGenerator ret = new VertexAttributePredicateGenerator(){

            @Override
            public Predicate generatePredicate(String attrName, Object attrVal, Class attrClass) {
                Object ret = attrName == null || attrClass == null || attrVal == null ? ALWAYS_FALSE : (String.class.isAssignableFrom(attrClass) ? StringPredicate.getStartsWithPredicate(attrName, attrClass, (String)attrVal) : ALWAYS_FALSE);
                return ret;
            }
        };
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getStartsWithPredicateGenerator");
        }
        return ret;
    }

    public static VertexAttributePredicateGenerator getEndsWithPredicateGenerator() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getEndsWithPredicateGenerator");
        }
        VertexAttributePredicateGenerator ret = new VertexAttributePredicateGenerator(){

            @Override
            public Predicate generatePredicate(String attrName, Object attrVal, Class attrClass) {
                Object ret = attrName == null || attrClass == null || attrVal == null ? ALWAYS_FALSE : (String.class.isAssignableFrom(attrClass) ? StringPredicate.getEndsWithPredicate(attrName, attrClass, (String)attrVal) : ALWAYS_FALSE);
                return ret;
            }
        };
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getEndsWithPredicateGenerator");
        }
        return ret;
    }

    public static VertexAttributePredicateGenerator getContainsPredicateGenerator() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getContainsPredicateGenerator");
        }
        VertexAttributePredicateGenerator ret = new VertexAttributePredicateGenerator(){

            @Override
            public Predicate generatePredicate(String attrName, final Object attrVal, Class attrClass) {
                Object ret = attrName == null || attrClass == null || attrVal == null ? ALWAYS_FALSE : (String.class.isAssignableFrom(attrClass) ? StringPredicate.getContainsPredicate(attrName, attrClass, (String)attrVal) : (Collection.class.isAssignableFrom(attrClass) ? new VertexAttributePredicate(attrName, attrClass){

                    @Override
                    protected boolean compareValue(Object vertexAttrVal) {
                        return ((Collection)vertexAttrVal).contains(attrVal);
                    }
                } : ALWAYS_FALSE));
                return ret;
            }
        };
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getContainsPredicateGenerator");
        }
        return ret;
    }

    public static VertexAttributePredicateGenerator getIsNullPredicateGenerator() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getIsNullPredicateGenerator");
        }
        VertexAttributePredicateGenerator ret = new VertexAttributePredicateGenerator(){

            @Override
            public Predicate generatePredicate(String attrName, Object attrVal, Class attrClass) {
                Object ret = attrName == null || attrClass == null ? ALWAYS_FALSE : new VertexAttributePredicate(attrName, attrClass, true){

                    @Override
                    protected boolean compareValue(Object vertexAttrVal) {
                        return vertexAttrVal == null;
                    }
                };
                return ret;
            }
        };
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getIsNullPredicateGenerator");
        }
        return ret;
    }

    public static VertexAttributePredicateGenerator getNotNullPredicateGenerator() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getNotNullPredicateGenerator");
        }
        VertexAttributePredicateGenerator ret = new VertexAttributePredicateGenerator(){

            @Override
            public Predicate generatePredicate(String attrName, Object attrVal, Class attrClass) {
                Object ret = attrName == null || attrClass == null ? ALWAYS_FALSE : new VertexAttributePredicate(attrName, attrClass, true){

                    @Override
                    protected boolean compareValue(Object vertexAttrVal) {
                        return vertexAttrVal != null;
                    }
                };
                return ret;
            }
        };
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getNotNullPredicateGenerator");
        }
        return ret;
    }

    public static VertexAttributePredicateGenerator getNotEmptyPredicateGenerator() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getNotEmptyPredicateGenerator");
        }
        VertexAttributePredicateGenerator ret = new VertexAttributePredicateGenerator(){

            @Override
            public Predicate generatePredicate(String attrName, Object attrVal, Class attrClass) {
                Object ret = attrName == null || attrClass == null ? ALWAYS_FALSE : new VertexAttributePredicate(attrName, attrClass, true){

                    @Override
                    protected boolean compareValue(Object vertexAttrVal) {
                        boolean ret = false;
                        if (vertexAttrVal != null) {
                            ret = vertexAttrVal instanceof Collection ? CollectionUtils.isNotEmpty((Collection)((Collection)vertexAttrVal)) : (vertexAttrVal instanceof String ? StringUtils.isNotEmpty((String)((String)vertexAttrVal)) : true);
                        }
                        return ret;
                    }
                };
                return ret;
            }
        };
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getNotEmptyPredicateGenerator");
        }
        return ret;
    }

    static abstract class StringPredicate
    extends VertexAttributePredicate {
        final String value;

        StringPredicate(String attrName, Class attrClass, String value) {
            super(attrName, attrClass);
            this.value = value;
        }

        static VertexAttributePredicate getEQPredicate(String attrName, Class attrClass, String value) {
            return new StringPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((String)vertexAttrVal).compareTo(this.value) == 0;
                }
            };
        }

        static VertexAttributePredicate getNEQPredicate(String attrName, Class attrClass, String value) {
            return new StringPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((String)vertexAttrVal).compareTo(this.value) != 0;
                }
            };
        }

        static VertexAttributePredicate getLTPredicate(String attrName, Class attrClass, String value) {
            return new StringPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((String)vertexAttrVal).compareTo(this.value) < 0;
                }
            };
        }

        static VertexAttributePredicate getLTEPredicate(String attrName, Class attrClass, String value) {
            return new StringPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((String)vertexAttrVal).compareTo(this.value) <= 0;
                }
            };
        }

        static VertexAttributePredicate getGTPredicate(String attrName, Class attrClass, String value) {
            return new StringPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((String)vertexAttrVal).compareTo(this.value) > 0;
                }
            };
        }

        static VertexAttributePredicate getGTEPredicate(String attrName, Class attrClass, String value) {
            return new StringPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((String)vertexAttrVal).compareTo(this.value) >= 0;
                }
            };
        }

        static VertexAttributePredicate getContainsPredicate(String attrName, Class attrClass, String value) {
            return new StringPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((String)vertexAttrVal).contains(this.value);
                }
            };
        }

        static VertexAttributePredicate getStartsWithPredicate(String attrName, Class attrClass, String value) {
            return new StringPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((String)vertexAttrVal).startsWith(this.value);
                }
            };
        }

        static VertexAttributePredicate getEndsWithPredicate(String attrName, Class attrClass, String value) {
            return new StringPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((String)vertexAttrVal).endsWith(this.value);
                }
            };
        }
    }

    static abstract class BigDecimalPredicate
    extends VertexAttributePredicate {
        final BigDecimal value;

        BigDecimalPredicate(String attrName, Class attrClass, BigDecimal value) {
            super(attrName, attrClass);
            this.value = value;
        }

        static VertexAttributePredicate getEQPredicate(String attrName, Class attrClass, BigDecimal value) {
            return new BigDecimalPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((BigDecimal)vertexAttrVal).compareTo(this.value) == 0;
                }
            };
        }

        static VertexAttributePredicate getNEQPredicate(String attrName, Class attrClass, BigDecimal value) {
            return new BigDecimalPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((BigDecimal)vertexAttrVal).compareTo(this.value) != 0;
                }
            };
        }

        static VertexAttributePredicate getLTPredicate(String attrName, Class attrClass, BigDecimal value) {
            return new BigDecimalPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((BigDecimal)vertexAttrVal).compareTo(this.value) < 0;
                }
            };
        }

        static VertexAttributePredicate getLTEPredicate(String attrName, Class attrClass, BigDecimal value) {
            return new BigDecimalPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((BigDecimal)vertexAttrVal).compareTo(this.value) <= 0;
                }
            };
        }

        static VertexAttributePredicate getGTPredicate(String attrName, Class attrClass, BigDecimal value) {
            return new BigDecimalPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((BigDecimal)vertexAttrVal).compareTo(this.value) > 0;
                }
            };
        }

        static VertexAttributePredicate getGTEPredicate(String attrName, Class attrClass, BigDecimal value) {
            return new BigDecimalPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((BigDecimal)vertexAttrVal).compareTo(this.value) >= 0;
                }
            };
        }
    }

    static abstract class BigIntegerPredicate
    extends VertexAttributePredicate {
        final BigInteger value;

        BigIntegerPredicate(String attrName, Class attrClass, BigInteger value) {
            super(attrName, attrClass);
            this.value = value;
        }

        static VertexAttributePredicate getEQPredicate(String attrName, Class attrClass, BigInteger value) {
            return new BigIntegerPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((BigInteger)vertexAttrVal).compareTo(this.value) == 0;
                }
            };
        }

        static VertexAttributePredicate getNEQPredicate(String attrName, Class attrClass, BigInteger value) {
            return new BigIntegerPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((BigInteger)vertexAttrVal).compareTo(this.value) != 0;
                }
            };
        }

        static VertexAttributePredicate getLTPredicate(String attrName, Class attrClass, BigInteger value) {
            return new BigIntegerPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((BigInteger)vertexAttrVal).compareTo(this.value) < 0;
                }
            };
        }

        static VertexAttributePredicate getLTEPredicate(String attrName, Class attrClass, BigInteger value) {
            return new BigIntegerPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((BigInteger)vertexAttrVal).compareTo(this.value) <= 0;
                }
            };
        }

        static VertexAttributePredicate getGTPredicate(String attrName, Class attrClass, BigInteger value) {
            return new BigIntegerPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((BigInteger)vertexAttrVal).compareTo(this.value) > 0;
                }
            };
        }

        static VertexAttributePredicate getGTEPredicate(String attrName, Class attrClass, BigInteger value) {
            return new BigIntegerPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((BigInteger)vertexAttrVal).compareTo(this.value) >= 0;
                }
            };
        }
    }

    static abstract class BytePredicate
    extends VertexAttributePredicate {
        final Byte value;

        BytePredicate(String attrName, Class attrClass, Byte value) {
            super(attrName, attrClass);
            this.value = value;
        }

        static VertexAttributePredicate getEQPredicate(String attrName, Class attrClass, Byte value) {
            return new BytePredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Byte)vertexAttrVal).compareTo(this.value) == 0;
                }
            };
        }

        static VertexAttributePredicate getNEQPredicate(String attrName, Class attrClass, Byte value) {
            return new BytePredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Byte)vertexAttrVal).compareTo(this.value) != 0;
                }
            };
        }

        static VertexAttributePredicate getLTPredicate(String attrName, Class attrClass, Byte value) {
            return new BytePredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Byte)vertexAttrVal).compareTo(this.value) < 0;
                }
            };
        }

        static VertexAttributePredicate getLTEPredicate(String attrName, Class attrClass, Byte value) {
            return new BytePredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Byte)vertexAttrVal).compareTo(this.value) <= 0;
                }
            };
        }

        static VertexAttributePredicate getGTPredicate(String attrName, Class attrClass, Byte value) {
            return new BytePredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Byte)vertexAttrVal).compareTo(this.value) > 0;
                }
            };
        }

        static VertexAttributePredicate getGTEPredicate(String attrName, Class attrClass, Byte value) {
            return new BytePredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Byte)vertexAttrVal).compareTo(this.value) >= 0;
                }
            };
        }
    }

    static abstract class DoublePredicate
    extends VertexAttributePredicate {
        final Double value;

        DoublePredicate(String attrName, Class attrClass, Double value) {
            super(attrName, attrClass);
            this.value = value;
        }

        static VertexAttributePredicate getEQPredicate(String attrName, Class attrClass, Double value) {
            return new DoublePredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Double)vertexAttrVal).compareTo(this.value) == 0;
                }
            };
        }

        static VertexAttributePredicate getNEQPredicate(String attrName, Class attrClass, Double value) {
            return new DoublePredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Double)vertexAttrVal).compareTo(this.value) != 0;
                }
            };
        }

        static VertexAttributePredicate getLTPredicate(String attrName, Class attrClass, Double value) {
            return new DoublePredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Double)vertexAttrVal).compareTo(this.value) < 0;
                }
            };
        }

        static VertexAttributePredicate getLTEPredicate(String attrName, Class attrClass, Double value) {
            return new DoublePredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Double)vertexAttrVal).compareTo(this.value) <= 0;
                }
            };
        }

        static VertexAttributePredicate getGTPredicate(String attrName, Class attrClass, Double value) {
            return new DoublePredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Double)vertexAttrVal).compareTo(this.value) > 0;
                }
            };
        }

        static VertexAttributePredicate getGTEPredicate(String attrName, Class attrClass, Double value) {
            return new DoublePredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Double)vertexAttrVal).compareTo(this.value) >= 0;
                }
            };
        }
    }

    static abstract class FloatPredicate
    extends VertexAttributePredicate {
        final Float value;

        FloatPredicate(String attrName, Class attrClass, Float value) {
            super(attrName, attrClass);
            this.value = value;
        }

        static VertexAttributePredicate getEQPredicate(String attrName, Class attrClass, Float value) {
            return new FloatPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Float)vertexAttrVal).compareTo(this.value) == 0;
                }
            };
        }

        static VertexAttributePredicate getNEQPredicate(String attrName, Class attrClass, Float value) {
            return new FloatPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Float)vertexAttrVal).compareTo(this.value) != 0;
                }
            };
        }

        static VertexAttributePredicate getLTPredicate(String attrName, Class attrClass, Float value) {
            return new FloatPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Float)vertexAttrVal).compareTo(this.value) < 0;
                }
            };
        }

        static VertexAttributePredicate getLTEPredicate(String attrName, Class attrClass, Float value) {
            return new FloatPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Float)vertexAttrVal).compareTo(this.value) <= 0;
                }
            };
        }

        static VertexAttributePredicate getGTPredicate(String attrName, Class attrClass, Float value) {
            return new FloatPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Float)vertexAttrVal).compareTo(this.value) > 0;
                }
            };
        }

        static VertexAttributePredicate getGTEPredicate(String attrName, Class attrClass, Float value) {
            return new FloatPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Float)vertexAttrVal).compareTo(this.value) >= 0;
                }
            };
        }
    }

    static abstract class LongPredicate
    extends VertexAttributePredicate {
        final Long value;

        LongPredicate(String attrName, Class attrClass, Long value) {
            super(attrName, attrClass);
            this.value = value;
        }

        static VertexAttributePredicate getEQPredicate(String attrName, Class attrClass, Long value) {
            return new LongPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Long)vertexAttrVal).compareTo(this.value) == 0;
                }
            };
        }

        static VertexAttributePredicate getNEQPredicate(String attrName, Class attrClass, Long value) {
            return new LongPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Long)vertexAttrVal).compareTo(this.value) != 0;
                }
            };
        }

        static VertexAttributePredicate getLTPredicate(String attrName, Class attrClass, Long value) {
            return new LongPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Long)vertexAttrVal).compareTo(this.value) < 0;
                }
            };
        }

        static VertexAttributePredicate getLTEPredicate(String attrName, Class attrClass, Long value) {
            return new LongPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Long)vertexAttrVal).compareTo(this.value) <= 0;
                }
            };
        }

        static VertexAttributePredicate getGTPredicate(String attrName, Class attrClass, Long value) {
            return new LongPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Long)vertexAttrVal).compareTo(this.value) > 0;
                }
            };
        }

        static VertexAttributePredicate getGTEPredicate(String attrName, Class attrClass, Long value) {
            return new LongPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Long)vertexAttrVal).compareTo(this.value) >= 0;
                }
            };
        }
    }

    static abstract class IntegerPredicate
    extends VertexAttributePredicate {
        final Integer value;

        IntegerPredicate(String attrName, Class attrClass, Integer value) {
            super(attrName, attrClass);
            this.value = value;
        }

        static VertexAttributePredicate getEQPredicate(String attrName, Class attrClass, Integer value) {
            return new IntegerPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Integer)vertexAttrVal).compareTo(this.value) == 0;
                }
            };
        }

        static VertexAttributePredicate getNEQPredicate(String attrName, Class attrClass, Integer value) {
            return new IntegerPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Integer)vertexAttrVal).compareTo(this.value) != 0;
                }
            };
        }

        static VertexAttributePredicate getLTPredicate(String attrName, Class attrClass, Integer value) {
            return new IntegerPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Integer)vertexAttrVal).compareTo(this.value) < 0;
                }
            };
        }

        static VertexAttributePredicate getLTEPredicate(String attrName, Class attrClass, Integer value) {
            return new IntegerPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Integer)vertexAttrVal).compareTo(this.value) <= 0;
                }
            };
        }

        static VertexAttributePredicate getGTPredicate(String attrName, Class attrClass, Integer value) {
            return new IntegerPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Integer)vertexAttrVal).compareTo(this.value) > 0;
                }
            };
        }

        static VertexAttributePredicate getGTEPredicate(String attrName, Class attrClass, Integer value) {
            return new IntegerPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Integer)vertexAttrVal).compareTo(this.value) >= 0;
                }
            };
        }
    }

    static abstract class ShortPredicate
    extends VertexAttributePredicate {
        final Short value;

        ShortPredicate(String attrName, Class attrClass, Short value) {
            super(attrName, attrClass);
            this.value = value;
        }

        static VertexAttributePredicate getEQPredicate(String attrName, Class attrClass, Short value) {
            return new ShortPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Short)vertexAttrVal).compareTo(this.value) == 0;
                }
            };
        }

        static VertexAttributePredicate getNEQPredicate(String attrName, Class attrClass, Short value) {
            return new ShortPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Short)vertexAttrVal).compareTo(this.value) != 0;
                }
            };
        }

        static VertexAttributePredicate getLTPredicate(String attrName, Class attrClass, Short value) {
            return new ShortPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Short)vertexAttrVal).compareTo(this.value) < 0;
                }
            };
        }

        static VertexAttributePredicate getLTEPredicate(String attrName, Class attrClass, Short value) {
            return new ShortPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Short)vertexAttrVal).compareTo(this.value) <= 0;
                }
            };
        }

        static VertexAttributePredicate getGTPredicate(String attrName, Class attrClass, Short value) {
            return new ShortPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Short)vertexAttrVal).compareTo(this.value) > 0;
                }
            };
        }

        static VertexAttributePredicate getGTEPredicate(String attrName, Class attrClass, Short value) {
            return new ShortPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Short)vertexAttrVal).compareTo(this.value) >= 0;
                }
            };
        }
    }

    static abstract class BooleanPredicate
    extends VertexAttributePredicate {
        final Boolean value;

        BooleanPredicate(String attrName, Class attrClass, Boolean value) {
            super(attrName, attrClass);
            this.value = value;
        }

        static VertexAttributePredicate getEQPredicate(String attrName, Class attrClass, Boolean value) {
            return new BooleanPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Boolean)vertexAttrVal).compareTo(this.value) == 0;
                }
            };
        }

        static VertexAttributePredicate getNEQPredicate(String attrName, Class attrClass, Boolean value) {
            return new BooleanPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Boolean)vertexAttrVal).compareTo(this.value) != 0;
                }
            };
        }
    }

    static abstract class VertexAttributePredicate
    implements Predicate {
        final String attrName;
        final Class attrClass;
        final boolean isNullValid;

        VertexAttributePredicate(String attrName, Class attrClass) {
            this(attrName, attrClass, false);
        }

        VertexAttributePredicate(String attrName, Class attrClass, boolean isNullValid) {
            this.attrName = attrName;
            this.attrClass = attrClass;
            this.isNullValid = isNullValid;
        }

        public boolean evaluate(Object object) {
            boolean ret;
            AtlasVertex vertex;
            AtlasVertex atlasVertex = vertex = object instanceof AtlasVertex ? (AtlasVertex)object : null;
            if (vertex != null) {
                Collection<Object> attrValue = Collection.class.isAssignableFrom(this.attrClass) ? vertex.getPropertyValues(this.attrName, this.attrClass) : AtlasGraphUtilsV2.getProperty(vertex, this.attrName, this.attrClass);
                ret = (this.isNullValid || attrValue != null) && this.compareValue(attrValue);
            } else {
                ret = false;
            }
            return ret;
        }

        protected abstract boolean compareValue(Object var1);
    }

    public static interface VertexAttributePredicateGenerator {
        public Predicate generatePredicate(String var1, Object var2, Class var3);
    }
}

