/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasException;
import org.apache.atlas.repository.audit.EntityAuditRepository;
import org.apache.atlas.repository.audit.HBaseBasedAuditRepository;
import org.apache.atlas.repository.graphdb.GraphDatabase;
import org.apache.atlas.repository.store.graph.v1.DeleteHandlerV1;
import org.apache.atlas.repository.store.graph.v1.SoftDeleteHandlerV1;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasRepositoryConfiguration {
    private static Logger LOG = LoggerFactory.getLogger(AtlasRepositoryConfiguration.class);
    public static final int DEFAULT_COMPILED_QUERY_CACHE_EVICTION_WARNING_THROTTLE = 0;
    public static final int DEFAULT_COMPILED_QUERY_CACHE_CAPACITY = 1000;
    public static final String TYPE_CACHE_IMPLEMENTATION_PROPERTY = "atlas.TypeCache.impl";
    public static final String AUDIT_EXCLUDED_OPERATIONS = "atlas.audit.excludes";
    private static List<String> skippedOperations = null;
    public static final String SEPARATOR = ":";
    private static final String CONFIG_TYPE_UPDATE_LOCK_MAX_WAIT_TIME_IN_SECONDS = "atlas.server.type.update.lock.max.wait.time.seconds";
    private static final Integer DEFAULT_TYPE_UPDATE_LOCK_MAX_WAIT_TIME_IN_SECONDS = 15;
    private static Integer typeUpdateLockMaxWaitTimeInSeconds = null;
    private static final String ENABLE_FULLTEXT_SEARCH_PROPERTY = "atlas.search.fulltext.enable";
    private static final String ENTITY_NOTIFICATION_VERSION_PROPERTY = "atlas.notification.entity.version";
    private static final String AUDIT_REPOSITORY_IMPLEMENTATION_PROPERTY = "atlas.EntityAuditRepository.impl";
    private static final String DELETE_HANDLER_V1_IMPLEMENTATION_PROPERTY = "atlas.DeleteHandlerV1.impl";
    public static final String COMPILED_QUERY_CACHE_CAPACITY = "atlas.CompiledQueryCache.capacity";
    public static final String COMPILED_QUERY_CACHE_EVICTION_WARNING_THROTTLE = "atlas.CompiledQueryCache.evictionWarningThrottle";
    private static final String GRAPH_DATABASE_IMPLEMENTATION_PROPERTY = "atlas.graphdb.backend";
    private static final String DEFAULT_GRAPH_DATABASE_IMPLEMENTATION_CLASS = "org.apache.atlas.repository.graphdb.janus.AtlasJanusGraphDatabase";
    public static final String GREMLIN_OPTIMIZER_ENABLED_PROPERTY = "atlas.query.gremlinOptimizerEnabled";
    private static final boolean DEFAULT_GREMLIN_OPTIMZER_ENABLED = true;

    public static boolean isFullTextSearchEnabled() throws AtlasException {
        return ApplicationProperties.get().getBoolean(ENABLE_FULLTEXT_SEARCH_PROPERTY, true);
    }

    public static boolean isV2EntityNotificationEnabled() {
        try {
            String notificationVersion = ApplicationProperties.get().getString(ENTITY_NOTIFICATION_VERSION_PROPERTY, "v2");
            return StringUtils.equalsIgnoreCase((CharSequence)notificationVersion, (CharSequence)"v2");
        }
        catch (AtlasException e) {
            boolean ret = true;
            return ret;
        }
    }

    public static Class<? extends EntityAuditRepository> getAuditRepositoryImpl() {
        try {
            Configuration config = ApplicationProperties.get();
            return ApplicationProperties.getClass((Configuration)config, (String)AUDIT_REPOSITORY_IMPLEMENTATION_PROPERTY, (String)HBaseBasedAuditRepository.class.getName(), EntityAuditRepository.class);
        }
        catch (AtlasException e) {
            throw new RuntimeException(e);
        }
    }

    public static Class<? extends DeleteHandlerV1> getDeleteHandlerV1Impl() {
        try {
            Configuration config = ApplicationProperties.get();
            return ApplicationProperties.getClass((Configuration)config, (String)DELETE_HANDLER_V1_IMPLEMENTATION_PROPERTY, (String)SoftDeleteHandlerV1.class.getName(), DeleteHandlerV1.class);
        }
        catch (AtlasException e) {
            throw new RuntimeException(e);
        }
    }

    public static int getCompiledQueryCacheCapacity() {
        try {
            return ApplicationProperties.get().getInt(COMPILED_QUERY_CACHE_CAPACITY, 1000);
        }
        catch (AtlasException e) {
            throw new RuntimeException(e);
        }
    }

    public static int getCompiledQueryCacheEvictionWarningThrottle() {
        try {
            return ApplicationProperties.get().getInt(COMPILED_QUERY_CACHE_EVICTION_WARNING_THROTTLE, 0);
        }
        catch (AtlasException e) {
            throw new RuntimeException(e);
        }
    }

    public static Class<? extends GraphDatabase> getGraphDatabaseImpl() {
        try {
            Configuration config = ApplicationProperties.get();
            return ApplicationProperties.getClass((Configuration)config, (String)GRAPH_DATABASE_IMPLEMENTATION_PROPERTY, (String)DEFAULT_GRAPH_DATABASE_IMPLEMENTATION_CLASS, GraphDatabase.class);
        }
        catch (AtlasException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isGremlinOptimizerEnabled() {
        try {
            return ApplicationProperties.get().getBoolean(GREMLIN_OPTIMIZER_ENABLED_PROPERTY, true);
        }
        catch (AtlasException e) {
            LOG.error("Could not determine value of atlas.query.gremlinOptimizerEnabled.  Defaulting to true", (Throwable)e);
            return true;
        }
    }

    public static List<String> getAuditExcludedOperations(Configuration config) throws AtlasException {
        if (skippedOperations == null) {
            if (config == null) {
                try {
                    config = ApplicationProperties.get();
                }
                catch (AtlasException e) {
                    LOG.error(" Error reading operations for auditing ", (Throwable)e);
                    throw e;
                }
            }
            skippedOperations = new ArrayList<String>();
            String[] skipAuditForOperations = config.getStringArray(AUDIT_EXCLUDED_OPERATIONS);
            if (skipAuditForOperations != null && skipAuditForOperations.length > 0) {
                for (String skippedOperation : skipAuditForOperations) {
                    String[] excludedOperations = skippedOperation.trim().toLowerCase().split(SEPARATOR);
                    if (excludedOperations != null && excludedOperations.length == 2) {
                        skippedOperations.add(skippedOperation.toLowerCase());
                        continue;
                    }
                    LOG.error("Invalid format for skipped operation {}. Valid format is HttpMethod:URL eg: GET:Version", (Object)skippedOperation);
                }
            }
        }
        return skippedOperations;
    }

    public static boolean isExcludedFromAudit(Configuration config, String httpMethod, String httpUrl) throws AtlasException {
        if (AtlasRepositoryConfiguration.getAuditExcludedOperations(config).size() > 0) {
            return AtlasRepositoryConfiguration.getAuditExcludedOperations(config).contains(httpMethod.toLowerCase() + SEPARATOR + httpUrl.toLowerCase());
        }
        return false;
    }

    public static void resetExcludedOperations() {
        skippedOperations = null;
    }

    public static int getTypeUpdateLockMaxWaitTimeInSeconds() {
        Integer ret = typeUpdateLockMaxWaitTimeInSeconds;
        if (ret == null) {
            try {
                Configuration config = ApplicationProperties.get();
                typeUpdateLockMaxWaitTimeInSeconds = ret = config.getInteger(CONFIG_TYPE_UPDATE_LOCK_MAX_WAIT_TIME_IN_SECONDS, DEFAULT_TYPE_UPDATE_LOCK_MAX_WAIT_TIME_IN_SECONDS);
            }
            catch (AtlasException atlasException) {
                // empty catch block
            }
        }
        return ret == null ? DEFAULT_TYPE_UPDATE_LOCK_MAX_WAIT_TIME_IN_SECONDS : ret;
    }
}

