/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.services;

import java.util.Collection;
import java.util.HashMap;
import javax.inject.Inject;
import org.apache.atlas.annotation.AtlasService;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.metrics.AtlasMetrics;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AtlasService
public class MetricsService {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsService.class);
    public static final String TYPE = "type";
    public static final String ENTITY = "entity";
    public static final String TAG = "tag";
    public static final String GENERAL = "general";
    protected static final String METRIC_TYPE_COUNT = "typeCount";
    protected static final String METRIC_TYPE_UNUSED_COUNT = "typeUnusedCount";
    protected static final String METRIC_ENTITY_COUNT = "entityCount";
    protected static final String METRIC_ENTITY_DELETED = "entityDeleted";
    protected static final String METRIC_ENTITY_ACTIVE = "entityActive";
    protected static final String METRIC_TAG_COUNT = "tagCount";
    protected static final String METRIC_ENTITIES_PER_TAG = "tagEntities";
    public static final String METRIC_COLLECTION_TIME = "collectionTime";
    private final AtlasGraph atlasGraph;
    private final AtlasTypeRegistry typeRegistry;
    private final String indexSearchPrefix = AtlasGraphUtilsV2.getIndexSearchPrefix();

    @Inject
    public MetricsService(AtlasGraph graph, AtlasTypeRegistry typeRegistry) {
        this.atlasGraph = graph;
        this.typeRegistry = typeRegistry;
    }

    public AtlasMetrics getMetrics() {
        Collection entityDefNames;
        AtlasMetrics metrics = new AtlasMetrics();
        metrics.addMetric(GENERAL, METRIC_TYPE_COUNT, (Object)this.getAllTypesCount());
        metrics.addMetric(GENERAL, METRIC_TAG_COUNT, (Object)this.getAllTagsCount());
        HashMap<Object, Long> activeCountMap = new HashMap<Object, Long>();
        HashMap<String, Long> deletedCountMap = new HashMap<String, Long>();
        Collection classificationDefNames = this.typeRegistry.getAllClassificationDefNames();
        if (classificationDefNames != null) {
            for (Object classificationDefName : classificationDefNames) {
                activeCountMap.put(classificationDefName, this.getTypeCount((String)classificationDefName, AtlasEntity.Status.ACTIVE));
            }
        }
        if ((entityDefNames = this.typeRegistry.getAllEntityDefNames()) != null) {
            for (String entityDefName : entityDefNames) {
                activeCountMap.put(entityDefName, this.getTypeCount(entityDefName, AtlasEntity.Status.ACTIVE));
                deletedCountMap.put(entityDefName, this.getTypeCount(entityDefName, AtlasEntity.Status.DELETED));
            }
        }
        HashMap<String, Long> activeEntityCount = new HashMap<String, Long>();
        HashMap<String, Long> deletedEntityCount = new HashMap<String, Long>();
        long unusedTypeCount = 0L;
        long totalEntities = 0L;
        for (Object entityDefName : this.typeRegistry.getAllEntityDefNames()) {
            Long activeCount = (Long)activeCountMap.get(entityDefName);
            Long deletedCount = (Long)deletedCountMap.get(entityDefName);
            if (activeCount > 0L) {
                activeEntityCount.put((String)entityDefName, activeCount);
                totalEntities += activeCount.longValue();
            }
            if (deletedCount > 0L) {
                deletedEntityCount.put((String)entityDefName, deletedCount);
                totalEntities += deletedCount.longValue();
            }
            if (activeCount != 0L || deletedCount != 0L) continue;
            ++unusedTypeCount;
        }
        metrics.addMetric(GENERAL, METRIC_TYPE_UNUSED_COUNT, (Object)unusedTypeCount);
        metrics.addMetric(GENERAL, METRIC_ENTITY_COUNT, (Object)totalEntities);
        metrics.addMetric(ENTITY, METRIC_ENTITY_ACTIVE, activeEntityCount);
        metrics.addMetric(ENTITY, METRIC_ENTITY_DELETED, deletedEntityCount);
        HashMap<String, Long> taggedEntityCount = new HashMap<String, Long>();
        for (String classificationName : this.typeRegistry.getAllClassificationDefNames()) {
            Long count = (Long)activeCountMap.get(classificationName);
            if (count <= 0L) continue;
            taggedEntityCount.put(classificationName, count);
        }
        metrics.addMetric(TAG, METRIC_ENTITIES_PER_TAG, taggedEntityCount);
        long collectionTime = System.currentTimeMillis();
        metrics.addMetric(GENERAL, METRIC_COLLECTION_TIME, (Object)collectionTime);
        return metrics;
    }

    private Long getTypeCount(String typeName, AtlasEntity.Status status) {
        String indexQuery = this.indexSearchPrefix + "\"" + Constants.ENTITY_TYPE_PROPERTY_KEY + "\" : (%s)" + " AND " + this.indexSearchPrefix + "\"" + Constants.STATE_PROPERTY_KEY + "\" : (%s)";
        indexQuery = String.format(indexQuery, typeName, status.name());
        return this.atlasGraph.indexQuery("vertex_index", indexQuery).vertexTotals();
    }

    private int getAllTypesCount() {
        Collection allTypeNames = this.typeRegistry.getAllTypeNames();
        return CollectionUtils.isNotEmpty((Collection)allTypeNames) ? allTypeNames.size() : 0;
    }

    private int getAllTagsCount() {
        Collection allTagNames = this.typeRegistry.getAllClassificationDefNames();
        return CollectionUtils.isNotEmpty((Collection)allTagNames) ? allTagNames.size() : 0;
    }
}

