/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class UniqueList<T> {
    private final List<T> list = new ArrayList<T>();
    private final Set<T> set = new HashSet<T>();

    public void add(T e) {
        if (this.set.contains(e)) {
            return;
        }
        this.list.add(e);
        this.set.add(e);
    }

    public void addAll(UniqueList<T> uniqueList) {
        for (T item : uniqueList.list) {
            if (this.set.contains(item)) continue;
            this.set.add(item);
            this.list.add(item);
        }
    }

    public void addAll(Collection<T> collection) {
        for (T item : collection) {
            this.add(item);
        }
    }

    public T remove(int index) {
        T e = this.list.remove(index);
        this.set.remove(e);
        return e;
    }

    public boolean contains(T e) {
        return this.set.contains(e);
    }

    public int size() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public void clear() {
        this.list.clear();
        this.set.clear();
    }

    public List<T> getList() {
        return this.list;
    }
}

