/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2;

import java.util.ArrayList;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.EntityGraphDiscoveryContext;
import org.apache.atlas.repository.store.graph.EntityResolver;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniqAttrBasedEntityResolver
implements EntityResolver {
    private static final Logger LOG = LoggerFactory.getLogger(UniqAttrBasedEntityResolver.class);
    private final AtlasTypeRegistry typeRegistry;

    public UniqAttrBasedEntityResolver(AtlasTypeRegistry typeRegistry) {
        this.typeRegistry = typeRegistry;
    }

    @Override
    public EntityGraphDiscoveryContext resolveEntityReferences(EntityGraphDiscoveryContext context) throws AtlasBaseException {
        if (context == null) {
            throw new AtlasBaseException(AtlasErrorCode.INTERNAL_ERROR, new String[]{"UniqAttrBasedEntityResolver.resolveEntityReferences(): context is null"});
        }
        ArrayList<AtlasObjectId> resolvedReferences = new ArrayList<AtlasObjectId>();
        for (AtlasObjectId objId : context.getReferencedByUniqAttribs()) {
            AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(objId.getTypeName());
            if (entityType == null) {
                throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_INVALID, new String[]{TypeCategory.ENTITY.name(), objId.getTypeName()});
            }
            AtlasVertex vertex = AtlasGraphUtilsV2.findByUniqueAttributes(entityType, objId.getUniqueAttributes());
            if (vertex != null) {
                context.addResolvedIdByUniqAttribs(objId, vertex);
                resolvedReferences.add(objId);
                continue;
            }
            throw new AtlasBaseException(AtlasErrorCode.REFERENCED_ENTITY_NOT_FOUND, new String[]{objId.toString()});
        }
        return context;
    }
}

