/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2;

import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.RequestContext;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.EntityGraphDiscoveryContext;
import org.apache.atlas.repository.store.graph.EntityResolver;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.repository.store.graph.v2.EntityStream;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.type.AtlasTypeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IDBasedEntityResolver
implements EntityResolver {
    private static final Logger LOG = LoggerFactory.getLogger(IDBasedEntityResolver.class);
    private final AtlasTypeRegistry typeRegistry;

    public IDBasedEntityResolver(AtlasTypeRegistry typeRegistry) {
        this.typeRegistry = typeRegistry;
    }

    @Override
    public EntityGraphDiscoveryContext resolveEntityReferences(EntityGraphDiscoveryContext context) throws AtlasBaseException {
        if (context == null) {
            throw new AtlasBaseException(AtlasErrorCode.INTERNAL_ERROR, new String[]{"IDBasedEntityResolver.resolveEntityReferences(): context is null"});
        }
        EntityStream entityStream = context.getEntityStream();
        for (String guid : context.getReferencedGuids()) {
            AtlasVertex vertex;
            boolean isAssignedGuid = AtlasTypeUtil.isAssignedGuid((String)guid);
            AtlasVertex atlasVertex = vertex = isAssignedGuid ? AtlasGraphUtilsV2.findByGuid(guid) : null;
            if (vertex == null && !RequestContext.get().isImportInProgress()) {
                AtlasEntity entity = entityStream.getByGuid(guid);
                if (entity != null) {
                    AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(entity.getTypeName());
                    if (entityType == null) {
                        throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_INVALID, new String[]{TypeCategory.ENTITY.name(), entity.getTypeName()});
                    }
                    vertex = AtlasGraphUtilsV2.findByUniqueAttributes(entityType, entity.getAttributes());
                } else if (!isAssignedGuid) {
                    throw new AtlasBaseException(AtlasErrorCode.REFERENCED_ENTITY_NOT_FOUND, new String[]{guid});
                }
            }
            if (vertex != null) {
                context.addResolvedGuid(guid, vertex);
                continue;
            }
            if (isAssignedGuid && !RequestContext.get().isImportInProgress()) {
                throw new AtlasBaseException(AtlasErrorCode.REFERENCED_ENTITY_NOT_FOUND, new String[]{guid});
            }
            context.addLocalGuidReference(guid);
        }
        return context;
    }
}

