/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2;

import com.fasterxml.jackson.core.type.TypeReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.TimeBoundary;
import org.apache.atlas.model.glossary.enums.AtlasTermAssignmentStatus;
import org.apache.atlas.model.glossary.relations.AtlasTermAssignmentHeader;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.instance.AtlasRelatedObjectId;
import org.apache.atlas.model.instance.AtlasRelationship;
import org.apache.atlas.model.instance.AtlasStruct;
import org.apache.atlas.model.typedef.AtlasRelationshipDef;
import org.apache.atlas.model.typedef.AtlasRelationshipEndDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graph.GraphHelper;
import org.apache.atlas.repository.graphdb.AtlasEdge;
import org.apache.atlas.repository.graphdb.AtlasEdgeDirection;
import org.apache.atlas.repository.graphdb.AtlasElement;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.type.AtlasArrayType;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasMapType;
import org.apache.atlas.type.AtlasRelationshipType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.type.AtlasTypeUtil;
import org.apache.atlas.utils.AtlasEntityUtil;
import org.apache.atlas.utils.AtlasJson;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EntityGraphRetriever {
    private static final Logger LOG = LoggerFactory.getLogger(EntityGraphRetriever.class);
    private static final String GLOSSARY_TERM_DISPLAY_NAME_ATTR = "AtlasGlossaryTerm.name";
    public static final String TERM_RELATION_NAME = "AtlasGlossarySemanticAssignment";
    public static final String NAME = "name";
    public static final String DISPLAY_NAME = "displayName";
    public static final String DESCRIPTION = "description";
    public static final String OWNER = "owner";
    public static final String CREATE_TIME = "createTime";
    public static final String QUALIFIED_NAME = "qualifiedName";
    private static final TypeReference<List<TimeBoundary>> TIME_BOUNDARIES_LIST_TYPE = new TypeReference<List<TimeBoundary>>(){};
    private static final GraphHelper graphHelper = GraphHelper.getInstance();
    private final AtlasTypeRegistry typeRegistry;
    private final boolean ignoreRelationshipAttr;

    @Inject
    public EntityGraphRetriever(AtlasTypeRegistry typeRegistry) {
        this(typeRegistry, false);
    }

    public EntityGraphRetriever(AtlasTypeRegistry typeRegistry, boolean ignoreRelationshipAttr) {
        this.typeRegistry = typeRegistry;
        this.ignoreRelationshipAttr = ignoreRelationshipAttr;
    }

    public AtlasEntity toAtlasEntity(String guid) throws AtlasBaseException {
        return this.toAtlasEntity(this.getEntityVertex(guid));
    }

    public AtlasEntity toAtlasEntity(AtlasObjectId objId) throws AtlasBaseException {
        return this.toAtlasEntity(this.getEntityVertex(objId));
    }

    public AtlasEntity toAtlasEntity(AtlasVertex entityVertex) throws AtlasBaseException {
        return this.mapVertexToAtlasEntity(entityVertex, null);
    }

    public AtlasEntity.AtlasEntityWithExtInfo toAtlasEntityWithExtInfo(String guid) throws AtlasBaseException {
        return this.toAtlasEntityWithExtInfo(this.getEntityVertex(guid));
    }

    public AtlasEntity.AtlasEntityWithExtInfo toAtlasEntityWithExtInfo(String guid, boolean isMinExtInfo) throws AtlasBaseException {
        return this.toAtlasEntityWithExtInfo(this.getEntityVertex(guid), isMinExtInfo);
    }

    public AtlasEntity.AtlasEntityWithExtInfo toAtlasEntityWithExtInfo(AtlasObjectId objId) throws AtlasBaseException {
        return this.toAtlasEntityWithExtInfo(this.getEntityVertex(objId));
    }

    public AtlasEntity.AtlasEntityWithExtInfo toAtlasEntityWithExtInfo(AtlasVertex entityVertex) throws AtlasBaseException {
        return this.toAtlasEntityWithExtInfo(entityVertex, false);
    }

    public AtlasEntity.AtlasEntityWithExtInfo toAtlasEntityWithExtInfo(AtlasVertex entityVertex, boolean isMinExtInfo) throws AtlasBaseException {
        AtlasEntity.AtlasEntityExtInfo entityExtInfo = new AtlasEntity.AtlasEntityExtInfo();
        AtlasEntity entity = this.mapVertexToAtlasEntity(entityVertex, entityExtInfo, isMinExtInfo);
        AtlasEntity.AtlasEntityWithExtInfo ret = new AtlasEntity.AtlasEntityWithExtInfo(entity, entityExtInfo);
        ret.compact();
        return ret;
    }

    public AtlasEntity.AtlasEntitiesWithExtInfo toAtlasEntitiesWithExtInfo(List<String> guids) throws AtlasBaseException {
        return this.toAtlasEntitiesWithExtInfo(guids, false);
    }

    public AtlasEntityHeader toAtlasEntityHeader(String guid) throws AtlasBaseException {
        return this.toAtlasEntityHeader(this.getEntityVertex(guid));
    }

    public AtlasEntityHeader toAtlasEntityHeader(AtlasVertex entityVertex) throws AtlasBaseException {
        return this.toAtlasEntityHeader(entityVertex, Collections.emptySet());
    }

    public AtlasEntityHeader toAtlasEntityHeader(AtlasVertex atlasVertex, Set<String> attributes) throws AtlasBaseException {
        return atlasVertex != null ? this.mapVertexToAtlasEntityHeader(atlasVertex, attributes) : null;
    }

    public AtlasEntityHeader toAtlasEntityHeaderWithClassifications(String guid) throws AtlasBaseException {
        return this.toAtlasEntityHeaderWithClassifications(this.getEntityVertex(guid), Collections.emptySet());
    }

    public AtlasEntityHeader toAtlasEntityHeaderWithClassifications(AtlasVertex entityVertex) throws AtlasBaseException {
        return this.toAtlasEntityHeaderWithClassifications(entityVertex, Collections.emptySet());
    }

    public AtlasEntityHeader toAtlasEntityHeaderWithClassifications(AtlasVertex entityVertex, Set<String> attributes) throws AtlasBaseException {
        AtlasEntityHeader ret = this.toAtlasEntityHeader(entityVertex, attributes);
        ret.setClassifications(this.getAllClassifications(entityVertex));
        return ret;
    }

    public Object getEntityAttribute(AtlasVertex entityVertex, AtlasStructType.AtlasAttribute attribute) {
        Object ret = null;
        try {
            ret = this.getVertexAttribute(entityVertex, attribute);
        }
        catch (AtlasBaseException atlasBaseException) {
            // empty catch block
        }
        return ret;
    }

    public AtlasObjectId toAtlasObjectId(AtlasVertex entityVertex) throws AtlasBaseException {
        AtlasObjectId ret = null;
        String typeName = (String)entityVertex.getProperty("__typeName", String.class);
        AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(typeName);
        if (entityType != null) {
            HashMap<String, Object> uniqueAttributes = new HashMap<String, Object>();
            for (AtlasStructType.AtlasAttribute attribute : entityType.getUniqAttributes().values()) {
                Object attrValue = this.getVertexAttribute(entityVertex, attribute);
                if (attrValue == null) continue;
                uniqueAttributes.put(attribute.getName(), attrValue);
            }
            ret = new AtlasObjectId((String)entityVertex.getProperty(Constants.GUID_PROPERTY_KEY, String.class), typeName, uniqueAttributes);
        }
        return ret;
    }

    public AtlasObjectId toAtlasObjectId(AtlasEntity entity) {
        AtlasObjectId ret = null;
        AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(entity.getTypeName());
        if (entityType != null) {
            HashMap<String, Object> uniqueAttributes = new HashMap<String, Object>();
            for (String attributeName : entityType.getUniqAttributes().keySet()) {
                Object attrValue = entity.getAttribute(attributeName);
                if (attrValue == null) continue;
                uniqueAttributes.put(attributeName, attrValue);
            }
            ret = new AtlasObjectId(entity.getGuid(), entity.getTypeName(), uniqueAttributes);
        }
        return ret;
    }

    public AtlasClassification toAtlasClassification(AtlasVertex classificationVertex) throws AtlasBaseException {
        AtlasClassification ret = new AtlasClassification(GraphHelper.getTypeName((AtlasElement)classificationVertex));
        ret.setEntityGuid(AtlasGraphUtilsV2.getEncodedProperty(classificationVertex, Constants.CLASSIFICATION_ENTITY_GUID, String.class));
        ret.setEntityStatus(GraphHelper.getClassificationEntityStatus((AtlasElement)classificationVertex));
        ret.setPropagate(Boolean.valueOf(GraphHelper.isPropagationEnabled(classificationVertex)));
        ret.setRemovePropagationsOnEntityDelete(Boolean.valueOf(GraphHelper.getRemovePropagations(classificationVertex)));
        String strValidityPeriods = AtlasGraphUtilsV2.getEncodedProperty(classificationVertex, Constants.CLASSIFICATION_VALIDITY_PERIODS_KEY, String.class);
        if (strValidityPeriods != null) {
            ret.setValidityPeriods((List)AtlasJson.fromJson((String)strValidityPeriods, TIME_BOUNDARIES_LIST_TYPE));
        }
        this.mapAttributes(classificationVertex, (AtlasStruct)ret, null);
        return ret;
    }

    public AtlasVertex getReferencedEntityVertex(AtlasEdge edge, AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection relationshipDirection, AtlasVertex parentVertex) throws AtlasBaseException {
        AtlasVertex entityVertex = null;
        if (relationshipDirection == AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection.OUT) {
            entityVertex = edge.getInVertex();
        } else if (relationshipDirection == AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection.IN) {
            entityVertex = edge.getOutVertex();
        } else if (relationshipDirection == AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection.BOTH) {
            entityVertex = StringUtils.equals((CharSequence)GraphHelper.getGuid((AtlasElement)parentVertex), (CharSequence)GraphHelper.getGuid((AtlasElement)edge.getOutVertex())) ? edge.getInVertex() : edge.getOutVertex();
        }
        return entityVertex;
    }

    public AtlasVertex getEntityVertex(String guid) throws AtlasBaseException {
        AtlasVertex ret = AtlasGraphUtilsV2.findByGuid(guid);
        if (ret == null) {
            throw new AtlasBaseException(AtlasErrorCode.INSTANCE_GUID_NOT_FOUND, new String[]{guid});
        }
        return ret;
    }

    public AtlasEntity.AtlasEntitiesWithExtInfo toAtlasEntitiesWithExtInfo(List<String> guids, boolean isMinExtInfo) throws AtlasBaseException {
        AtlasEntity.AtlasEntitiesWithExtInfo ret = new AtlasEntity.AtlasEntitiesWithExtInfo();
        for (String guid : guids) {
            AtlasVertex vertex = this.getEntityVertex(guid);
            AtlasEntity entity = this.mapVertexToAtlasEntity(vertex, (AtlasEntity.AtlasEntityExtInfo)ret, isMinExtInfo);
            ret.addEntity(entity);
        }
        ret.compact();
        return ret;
    }

    public Map<String, Object> getEntityUniqueAttribute(AtlasVertex entityVertex) throws AtlasBaseException {
        HashMap<String, Object> ret = null;
        String typeName = AtlasGraphUtilsV2.getTypeName((AtlasElement)entityVertex);
        AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(typeName);
        if (entityType != null && MapUtils.isNotEmpty((Map)entityType.getUniqAttributes())) {
            for (AtlasStructType.AtlasAttribute attribute : entityType.getUniqAttributes().values()) {
                Object val = this.mapVertexToAttribute(entityVertex, attribute, null, false);
                if (val == null) continue;
                if (ret == null) {
                    ret = new HashMap<String, Object>();
                }
                ret.put(attribute.getName(), val);
            }
        }
        return ret;
    }

    public AtlasEntity.AtlasEntitiesWithExtInfo getEntitiesByUniqueAttributes(String typeName, List<Map<String, Object>> uniqueAttributesList, boolean isMinExtInfo) throws AtlasBaseException {
        AtlasEntity.AtlasEntitiesWithExtInfo ret = new AtlasEntity.AtlasEntitiesWithExtInfo();
        AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(typeName);
        if (entityType != null) {
            for (Map<String, Object> uniqAttributes : uniqueAttributesList) {
                try {
                    AtlasVertex vertex = AtlasGraphUtilsV2.getVertexByUniqueAttributes(entityType, uniqAttributes);
                    if (vertex == null) continue;
                    AtlasEntity entity = this.mapVertexToAtlasEntity(vertex, (AtlasEntity.AtlasEntityExtInfo)ret, isMinExtInfo);
                    ret.addEntity(entity);
                }
                catch (AtlasBaseException e) {
                    if (e.getAtlasErrorCode() == AtlasErrorCode.INSTANCE_BY_UNIQUE_ATTRIBUTE_NOT_FOUND) continue;
                    throw e;
                }
            }
        }
        ret.compact();
        return ret;
    }

    private AtlasVertex getEntityVertex(AtlasObjectId objId) throws AtlasBaseException {
        AtlasVertex ret = null;
        if (!AtlasTypeUtil.isValid((AtlasObjectId)objId)) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_OBJECT_ID, new String[]{objId.toString()});
        }
        if (AtlasTypeUtil.isAssignedGuid((AtlasObjectId)objId)) {
            ret = AtlasGraphUtilsV2.findByGuid(objId.getGuid());
        } else {
            AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(objId.getTypeName());
            Map uniqAttributes = objId.getUniqueAttributes();
            ret = AtlasGraphUtilsV2.getVertexByUniqueAttributes(entityType, uniqAttributes);
        }
        if (ret == null) {
            throw new AtlasBaseException(AtlasErrorCode.INSTANCE_GUID_NOT_FOUND, new String[]{objId.toString()});
        }
        return ret;
    }

    private AtlasEntity mapVertexToAtlasEntity(AtlasVertex entityVertex, AtlasEntity.AtlasEntityExtInfo entityExtInfo) throws AtlasBaseException {
        return this.mapVertexToAtlasEntity(entityVertex, entityExtInfo, false);
    }

    private AtlasEntity mapVertexToAtlasEntity(AtlasVertex entityVertex, AtlasEntity.AtlasEntityExtInfo entityExtInfo, boolean isMinExtInfo) throws AtlasBaseException {
        AtlasEntity entity;
        String guid = GraphHelper.getGuid((AtlasElement)entityVertex);
        AtlasEntity atlasEntity = entity = entityExtInfo != null ? entityExtInfo.getEntity(guid) : null;
        if (entity == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Mapping graph vertex to atlas entity for guid {}", (Object)guid);
            }
            entity = new AtlasEntity();
            if (entityExtInfo != null) {
                entityExtInfo.addReferredEntity(guid, entity);
            }
            this.mapSystemAttributes(entityVertex, entity);
            this.mapAttributes(entityVertex, (AtlasStruct)entity, entityExtInfo, isMinExtInfo);
            if (!this.ignoreRelationshipAttr) {
                this.mapRelationshipAttributes(entityVertex, entity, entityExtInfo, isMinExtInfo);
            }
            this.mapClassifications(entityVertex, entity);
        }
        return entity;
    }

    private AtlasEntity mapVertexToAtlasEntityMin(AtlasVertex entityVertex, AtlasEntity.AtlasEntityExtInfo entityExtInfo) throws AtlasBaseException {
        return this.mapVertexToAtlasEntityMin(entityVertex, entityExtInfo, null);
    }

    private AtlasEntity mapVertexToAtlasEntityMin(AtlasVertex entityVertex, AtlasEntity.AtlasEntityExtInfo entityExtInfo, Set<String> attributes) throws AtlasBaseException {
        AtlasEntity entity;
        String guid = GraphHelper.getGuid((AtlasElement)entityVertex);
        AtlasEntity atlasEntity = entity = entityExtInfo != null ? entityExtInfo.getEntity(guid) : null;
        if (entity == null) {
            entity = new AtlasEntity();
            if (entityExtInfo != null) {
                entityExtInfo.addReferredEntity(guid, entity);
            }
            this.mapSystemAttributes(entityVertex, entity);
            this.mapClassifications(entityVertex, entity);
            AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(entity.getTypeName());
            if (entityType != null) {
                for (AtlasStructType.AtlasAttribute attribute : entityType.getMinInfoAttributes().values()) {
                    Object attrValue = this.getVertexAttribute(entityVertex, attribute);
                    if (attrValue == null) continue;
                    entity.setAttribute(attribute.getName(), attrValue);
                }
            }
        }
        return entity;
    }

    private AtlasEntityHeader mapVertexToAtlasEntityHeader(AtlasVertex entityVertex) throws AtlasBaseException {
        return this.mapVertexToAtlasEntityHeader(entityVertex, Collections.emptySet());
    }

    private AtlasEntityHeader mapVertexToAtlasEntityHeader(AtlasVertex entityVertex, Set<String> attributes) throws AtlasBaseException {
        AtlasEntityHeader ret = new AtlasEntityHeader();
        String typeName = (String)entityVertex.getProperty("__typeName", String.class);
        String guid = (String)entityVertex.getProperty(Constants.GUID_PROPERTY_KEY, String.class);
        ret.setTypeName(typeName);
        ret.setGuid(guid);
        ret.setStatus(GraphHelper.getStatus((AtlasElement)entityVertex));
        ret.setClassificationNames(GraphHelper.getAllTraitNames(entityVertex));
        List<AtlasTermAssignmentHeader> termAssignmentHeaders = this.mapAssignedTerms(entityVertex);
        ret.setMeanings(termAssignmentHeaders);
        ret.setMeaningNames(termAssignmentHeaders.stream().map(AtlasTermAssignmentHeader::getDisplayText).collect(Collectors.toList()));
        AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(typeName);
        if (entityType != null) {
            Object displayText;
            for (AtlasStructType.AtlasAttribute headerAttribute : entityType.getHeaderAttributes().values()) {
                Object attrValue = this.getVertexAttribute(entityVertex, headerAttribute);
                if (attrValue == null) continue;
                ret.setAttribute(headerAttribute.getName(), attrValue);
            }
            Object name = ret.getAttribute(NAME);
            Object object = displayText = name != null ? name : ret.getAttribute(QUALIFIED_NAME);
            if (displayText != null) {
                ret.setDisplayText(displayText.toString());
            }
            if (CollectionUtils.isNotEmpty(attributes)) {
                for (String attrName : attributes) {
                    Object attrValue;
                    String nonQualifiedAttrName = this.toNonQualifiedName(attrName);
                    if (ret.hasAttribute(attrName)) continue;
                    AtlasStructType.AtlasAttribute attribute = entityType.getAttribute(nonQualifiedAttrName);
                    if (attribute == null) {
                        attribute = entityType.getRelationshipAttribute(nonQualifiedAttrName, null);
                    }
                    if ((attrValue = this.getVertexAttribute(entityVertex, attribute)) == null) continue;
                    ret.setAttribute(nonQualifiedAttrName, attrValue);
                }
            }
        }
        return ret;
    }

    private String toNonQualifiedName(String attrName) {
        String ret;
        if (attrName.contains(".")) {
            String[] attributeParts = attrName.split("\\.");
            ret = attributeParts[attributeParts.length - 1];
        } else {
            ret = attrName;
        }
        return ret;
    }

    private AtlasEntity mapSystemAttributes(AtlasVertex entityVertex, AtlasEntity entity) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Mapping system attributes for type {}", (Object)entity.getTypeName());
        }
        entity.setGuid(GraphHelper.getGuid((AtlasElement)entityVertex));
        entity.setTypeName(GraphHelper.getTypeName((AtlasElement)entityVertex));
        entity.setStatus(GraphHelper.getStatus((AtlasElement)entityVertex));
        entity.setVersion(GraphHelper.getVersion((AtlasElement)entityVertex));
        entity.setCreatedBy(GraphHelper.getCreatedByAsString((AtlasElement)entityVertex));
        entity.setUpdatedBy(GraphHelper.getModifiedByAsString((AtlasElement)entityVertex));
        entity.setCreateTime(new Date(GraphHelper.getCreatedTime((AtlasElement)entityVertex)));
        entity.setUpdateTime(new Date(GraphHelper.getModifiedTime((AtlasElement)entityVertex)));
        entity.setHomeId(GraphHelper.getHomeId((AtlasElement)entityVertex));
        entity.setIsProxy(GraphHelper.isProxy((AtlasElement)entityVertex));
        entity.setProvenanceType(GraphHelper.getProvenanceType((AtlasElement)entityVertex));
        return entity;
    }

    private void mapAttributes(AtlasVertex entityVertex, AtlasStruct struct, AtlasEntity.AtlasEntityExtInfo entityExtInfo) throws AtlasBaseException {
        this.mapAttributes(entityVertex, struct, entityExtInfo, false);
    }

    private void mapAttributes(AtlasVertex entityVertex, AtlasStruct struct, AtlasEntity.AtlasEntityExtInfo entityExtInfo, boolean isMinExtInfo) throws AtlasBaseException {
        AtlasType objType = this.typeRegistry.getType(struct.getTypeName());
        if (!(objType instanceof AtlasStructType)) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_INVALID, new String[]{struct.getTypeName()});
        }
        AtlasStructType structType = (AtlasStructType)objType;
        for (AtlasStructType.AtlasAttribute attribute : structType.getAllAttributes().values()) {
            Object attrValue = this.mapVertexToAttribute(entityVertex, attribute, entityExtInfo, isMinExtInfo);
            struct.setAttribute(attribute.getName(), attrValue);
        }
    }

    public List<AtlasClassification> getAllClassifications(AtlasVertex entityVertex) throws AtlasBaseException {
        ArrayList<AtlasClassification> ret = new ArrayList<AtlasClassification>();
        Iterable edges = entityVertex.query().direction(AtlasEdgeDirection.OUT).label("classifiedAs").edges();
        if (edges != null) {
            for (AtlasEdge edge : edges) {
                if (edge == null) continue;
                ret.add(this.toAtlasClassification(edge.getInVertex()));
            }
        }
        return ret;
    }

    public List<AtlasTermAssignmentHeader> mapAssignedTerms(AtlasVertex entityVertex) throws AtlasBaseException {
        ArrayList<AtlasTermAssignmentHeader> ret = new ArrayList<AtlasTermAssignmentHeader>();
        Iterable edges = entityVertex.query().direction(AtlasEdgeDirection.IN).label("r:AtlasGlossarySemanticAssignment").edges();
        if (edges != null) {
            for (AtlasEdge edge : edges) {
                if (edge == null || GraphHelper.getStatus((AtlasElement)edge) == AtlasEntity.Status.DELETED) continue;
                ret.add(this.toTermAssignmentHeader(edge));
            }
        }
        return ret;
    }

    private AtlasTermAssignmentHeader toTermAssignmentHeader(AtlasEdge edge) {
        String source;
        String steward;
        String createdBy;
        Integer confidence;
        String status;
        String expression;
        String description;
        Object displayName;
        String relationGuid;
        AtlasTermAssignmentHeader ret = new AtlasTermAssignmentHeader();
        AtlasVertex termVertex = edge.getOutVertex();
        String guid = GraphHelper.getGuid((AtlasElement)termVertex);
        if (guid != null) {
            ret.setTermGuid(guid);
        }
        if ((relationGuid = (String)edge.getProperty(Constants.RELATIONSHIP_GUID_PROPERTY_KEY, String.class)) != null) {
            ret.setRelationGuid(relationGuid);
        }
        if ((displayName = AtlasGraphUtilsV2.getEncodedProperty(termVertex, GLOSSARY_TERM_DISPLAY_NAME_ATTR, Object.class)) instanceof String) {
            ret.setDisplayText((String)displayName);
        }
        if ((description = (String)edge.getProperty(DESCRIPTION, String.class)) != null) {
            ret.setDescription(description);
        }
        if ((expression = (String)edge.getProperty("expression", String.class)) != null) {
            ret.setExpression(expression);
        }
        if ((status = (String)edge.getProperty("status", String.class)) != null) {
            AtlasTermAssignmentStatus assignmentStatus = AtlasTermAssignmentStatus.valueOf((String)status);
            ret.setStatus(assignmentStatus);
        }
        if ((confidence = (Integer)edge.getProperty("confidence", Integer.class)) != null) {
            ret.setConfidence(confidence.intValue());
        }
        if ((createdBy = (String)edge.getProperty("createdBy", String.class)) != null) {
            ret.setCreatedBy(createdBy);
        }
        if ((steward = (String)edge.getProperty("steward", String.class)) != null) {
            ret.setSteward(steward);
        }
        if ((source = (String)edge.getProperty("source", String.class)) != null) {
            ret.setSource(source);
        }
        return ret;
    }

    private void mapClassifications(AtlasVertex entityVertex, AtlasEntity entity) throws AtlasBaseException {
        List<AtlasEdge> edges = GraphHelper.getAllClassificationEdges(entityVertex);
        if (CollectionUtils.isNotEmpty(edges)) {
            ArrayList<AtlasClassification> allClassifications = new ArrayList<AtlasClassification>();
            for (AtlasEdge edge : edges) {
                AtlasVertex classificationVertex = edge.getInVertex();
                allClassifications.add(this.toAtlasClassification(classificationVertex));
            }
            entity.setClassifications(allClassifications);
        }
    }

    private Object mapVertexToAttribute(AtlasVertex entityVertex, AtlasStructType.AtlasAttribute attribute, AtlasEntity.AtlasEntityExtInfo entityExtInfo, boolean isMinExtInfo) throws AtlasBaseException {
        Object ret = null;
        AtlasType attrType = attribute.getAttributeType();
        String edgeLabel = attribute.getRelationshipEdgeLabel();
        boolean isOwnedAttribute = attribute.isOwnedRef();
        AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection edgeDirection = attribute.getRelationshipEdgeDirection();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Mapping vertex {} to atlas entity {}.{}", new Object[]{entityVertex, attribute.getDefinedInDef().getName(), attribute.getName()});
        }
        switch (attrType.getTypeCategory()) {
            case PRIMITIVE: {
                ret = this.mapVertexToPrimitive((AtlasElement)entityVertex, attribute.getVertexPropertyName(), attribute.getAttributeDef());
                break;
            }
            case ENUM: {
                ret = AtlasGraphUtilsV2.getEncodedProperty(entityVertex, attribute.getVertexPropertyName(), Object.class);
                break;
            }
            case STRUCT: {
                ret = this.mapVertexToStruct(entityVertex, edgeLabel, null, entityExtInfo, isMinExtInfo);
                break;
            }
            case OBJECT_ID_TYPE: {
                if (attribute.getAttributeDef().isSoftReferenced()) {
                    ret = this.mapVertexToObjectIdForSoftRef(entityVertex, attribute, entityExtInfo, isMinExtInfo);
                    break;
                }
                ret = this.mapVertexToObjectId(entityVertex, edgeLabel, null, entityExtInfo, isOwnedAttribute, edgeDirection, isMinExtInfo);
                break;
            }
            case ARRAY: {
                if (attribute.getAttributeDef().isSoftReferenced()) {
                    ret = this.mapVertexToArrayForSoftRef(entityVertex, attribute, entityExtInfo, isMinExtInfo);
                    break;
                }
                ret = this.mapVertexToArray(entityVertex, entityExtInfo, isOwnedAttribute, attribute, isMinExtInfo);
                break;
            }
            case MAP: {
                if (attribute.getAttributeDef().isSoftReferenced()) {
                    ret = this.mapVertexToMapForSoftRef(entityVertex, attribute, entityExtInfo, isMinExtInfo);
                    break;
                }
                ret = this.mapVertexToMap(entityVertex, entityExtInfo, isOwnedAttribute, attribute, isMinExtInfo);
                break;
            }
        }
        return ret;
    }

    private Map<String, AtlasObjectId> mapVertexToMapForSoftRef(AtlasVertex entityVertex, AtlasStructType.AtlasAttribute attribute, AtlasEntity.AtlasEntityExtInfo entityExtInfo, boolean isMinExtInfo) {
        HashMap<String, AtlasObjectId> ret = null;
        Map softRefVal = (Map)entityVertex.getProperty(attribute.getVertexPropertyName(), Map.class);
        if (MapUtils.isNotEmpty((Map)softRefVal)) {
            ret = new HashMap<String, AtlasObjectId>();
            for (Object mapKey : softRefVal.keySet()) {
                AtlasObjectId objectId = this.getAtlasObjectIdFromSoftRefFormat(Objects.toString(softRefVal.get(mapKey)), attribute, entityExtInfo, isMinExtInfo);
                if (objectId == null) continue;
                ret.put(Objects.toString(mapKey), objectId);
            }
        }
        return ret;
    }

    private List<AtlasObjectId> mapVertexToArrayForSoftRef(AtlasVertex entityVertex, AtlasStructType.AtlasAttribute attribute, AtlasEntity.AtlasEntityExtInfo entityExtInfo, boolean isMinExtInfo) {
        ArrayList<AtlasObjectId> ret = null;
        List softRefVal = entityVertex.getListProperty(attribute.getVertexPropertyName(), List.class);
        if (CollectionUtils.isNotEmpty((Collection)softRefVal)) {
            ret = new ArrayList<AtlasObjectId>();
            for (Object o : softRefVal) {
                AtlasObjectId objectId = this.getAtlasObjectIdFromSoftRefFormat(Objects.toString(o), attribute, entityExtInfo, isMinExtInfo);
                if (objectId == null) continue;
                ret.add(objectId);
            }
        }
        return ret;
    }

    private AtlasObjectId mapVertexToObjectIdForSoftRef(AtlasVertex entityVertex, AtlasStructType.AtlasAttribute attribute, AtlasEntity.AtlasEntityExtInfo entityExtInfo, boolean isMinExtInfo) {
        String softRefVal = AtlasGraphUtilsV2.getEncodedProperty(entityVertex, attribute.getVertexPropertyName(), String.class);
        return StringUtils.isNotEmpty((CharSequence)softRefVal) ? this.getAtlasObjectIdFromSoftRefFormat(softRefVal, attribute, entityExtInfo, isMinExtInfo) : null;
    }

    private AtlasObjectId getAtlasObjectIdFromSoftRefFormat(String softRefVal, AtlasStructType.AtlasAttribute attribute, AtlasEntity.AtlasEntityExtInfo entityExtInfo, boolean isMinExtInfo) {
        AtlasObjectId ret = AtlasEntityUtil.parseSoftRefValue((String)softRefVal);
        if (ret != null && entityExtInfo != null && attribute.isOwnedRef()) {
            try {
                AtlasEntity entity;
                AtlasVertex referenceVertex = this.getEntityVertex(ret.getGuid());
                if (referenceVertex != null && (entity = isMinExtInfo ? this.mapVertexToAtlasEntityMin(referenceVertex, entityExtInfo) : this.mapVertexToAtlasEntity(referenceVertex, entityExtInfo)) != null) {
                    ret = this.toAtlasObjectId(entity);
                }
            }
            catch (AtlasBaseException excp) {
                LOG.info("failed to retrieve soft-referenced entity(typeName={}, guid={}); errorCode={}. Ignoring", new Object[]{ret.getTypeName(), ret.getGuid(), excp.getAtlasErrorCode()});
            }
        }
        return ret;
    }

    private Map<String, Object> mapVertexToMap(AtlasVertex entityVertex, AtlasEntity.AtlasEntityExtInfo entityExtInfo, boolean isOwnedAttribute, AtlasStructType.AtlasAttribute attribute, boolean isMinExtInfo) throws AtlasBaseException {
        Map<String, Object> ret = null;
        AtlasMapType mapType = (AtlasMapType)attribute.getAttributeType();
        AtlasType mapValueType = mapType.getValueType();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Mapping map attribute {} for vertex {}", (Object)mapType.getTypeName(), (Object)entityVertex);
        }
        if (AtlasGraphUtilsV2.isReference(mapValueType)) {
            Map<String, Object> currentMap = GraphHelper.getReferenceMap(entityVertex, attribute);
            if (MapUtils.isNotEmpty(currentMap)) {
                ret = new HashMap<String, Object>();
                for (Map.Entry<String, Object> entry : currentMap.entrySet()) {
                    String mapKey = entry.getKey();
                    Object keyValue = entry.getValue();
                    Object mapValue = this.mapVertexToCollectionEntry(entityVertex, mapValueType, keyValue, attribute.getRelationshipEdgeLabel(), entityExtInfo, isOwnedAttribute, attribute.getRelationshipEdgeDirection(), isMinExtInfo);
                    if (mapValue == null) continue;
                    ret.put(mapKey, mapValue);
                }
            }
        } else {
            ret = GraphHelper.getPrimitiveMap(entityVertex, attribute.getVertexPropertyName());
        }
        if (MapUtils.isEmpty(ret)) {
            ret = null;
        }
        return ret;
    }

    private List<Object> mapVertexToArray(AtlasVertex entityVertex, AtlasEntity.AtlasEntityExtInfo entityExtInfo, boolean isOwnedAttribute, AtlasStructType.AtlasAttribute attribute, boolean isMinExtInfo) throws AtlasBaseException {
        AtlasArrayType arrayType = (AtlasArrayType)attribute.getAttributeType();
        AtlasType arrayElementType = arrayType.getElementType();
        List<Object> arrayElements = GraphHelper.getArrayElementsProperty(arrayElementType, entityVertex, attribute);
        if (CollectionUtils.isEmpty(arrayElements)) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Mapping array attribute {} for vertex {}", (Object)arrayElementType.getTypeName(), (Object)entityVertex);
        }
        ArrayList<Object> arrValues = new ArrayList<Object>(arrayElements.size());
        String edgeLabel = attribute.getRelationshipEdgeLabel();
        AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection edgeDirection = attribute.getRelationshipEdgeDirection();
        for (Object element : arrayElements) {
            if (element == null) {
                LOG.debug("Skipping null arrayElement");
                continue;
            }
            Object arrValue = this.mapVertexToCollectionEntry(entityVertex, arrayElementType, element, edgeLabel, entityExtInfo, isOwnedAttribute, edgeDirection, isMinExtInfo);
            if (arrValue == null) continue;
            arrValues.add(arrValue);
        }
        return arrValues;
    }

    private Object mapVertexToCollectionEntry(AtlasVertex entityVertex, AtlasType arrayElement, Object value, String edgeLabel, AtlasEntity.AtlasEntityExtInfo entityExtInfo, boolean isOwnedAttribute, AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection edgeDirection, boolean isMinExtInfo) throws AtlasBaseException {
        Object ret = null;
        switch (arrayElement.getTypeCategory()) {
            case PRIMITIVE: 
            case ENUM: 
            case ARRAY: 
            case MAP: {
                ret = value;
                break;
            }
            case CLASSIFICATION: {
                break;
            }
            case STRUCT: {
                ret = this.mapVertexToStruct(entityVertex, edgeLabel, (AtlasEdge)value, entityExtInfo, isMinExtInfo);
                break;
            }
            case OBJECT_ID_TYPE: {
                ret = this.mapVertexToObjectId(entityVertex, edgeLabel, (AtlasEdge)value, entityExtInfo, isOwnedAttribute, edgeDirection, isMinExtInfo);
                break;
            }
        }
        return ret;
    }

    public Object mapVertexToPrimitive(AtlasElement entityVertex, String vertexPropertyName, AtlasStructDef.AtlasAttributeDef attrDef) {
        Object ret = null;
        if (AtlasGraphUtilsV2.getEncodedProperty(entityVertex, vertexPropertyName, Object.class) == null) {
            return null;
        }
        switch (attrDef.getTypeName().toLowerCase()) {
            case "string": {
                ret = AtlasGraphUtilsV2.getEncodedProperty(entityVertex, vertexPropertyName, String.class);
                break;
            }
            case "short": {
                ret = AtlasGraphUtilsV2.getEncodedProperty(entityVertex, vertexPropertyName, Short.class);
                break;
            }
            case "int": {
                ret = AtlasGraphUtilsV2.getEncodedProperty(entityVertex, vertexPropertyName, Integer.class);
                break;
            }
            case "biginteger": {
                ret = AtlasGraphUtilsV2.getEncodedProperty(entityVertex, vertexPropertyName, BigInteger.class);
                break;
            }
            case "boolean": {
                ret = AtlasGraphUtilsV2.getEncodedProperty(entityVertex, vertexPropertyName, Boolean.class);
                break;
            }
            case "byte": {
                ret = AtlasGraphUtilsV2.getEncodedProperty(entityVertex, vertexPropertyName, Byte.class);
                break;
            }
            case "long": {
                ret = AtlasGraphUtilsV2.getEncodedProperty(entityVertex, vertexPropertyName, Long.class);
                break;
            }
            case "float": {
                ret = AtlasGraphUtilsV2.getEncodedProperty(entityVertex, vertexPropertyName, Float.class);
                break;
            }
            case "double": {
                ret = AtlasGraphUtilsV2.getEncodedProperty(entityVertex, vertexPropertyName, Double.class);
                break;
            }
            case "bigdecimal": {
                ret = AtlasGraphUtilsV2.getEncodedProperty(entityVertex, vertexPropertyName, BigDecimal.class);
                break;
            }
            case "date": {
                ret = new Date(AtlasGraphUtilsV2.getEncodedProperty(entityVertex, vertexPropertyName, Long.class));
                break;
            }
        }
        return ret;
    }

    private AtlasObjectId mapVertexToObjectId(AtlasVertex entityVertex, String edgeLabel, AtlasEdge edge, AtlasEntity.AtlasEntityExtInfo entityExtInfo, boolean isOwnedAttribute, AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection edgeDirection, boolean isMinExtInfo) throws AtlasBaseException {
        AtlasObjectId ret = null;
        if (edge == null) {
            edge = graphHelper.getEdgeForLabel(entityVertex, edgeLabel, edgeDirection);
        }
        if (GraphHelper.elementExists((AtlasElement)edge)) {
            AtlasVertex referenceVertex = edge.getInVertex();
            if (StringUtils.equals((CharSequence)AtlasGraphUtilsV2.getIdFromVertex(referenceVertex), (CharSequence)AtlasGraphUtilsV2.getIdFromVertex(entityVertex))) {
                referenceVertex = edge.getOutVertex();
            }
            if (referenceVertex != null) {
                if (entityExtInfo != null && isOwnedAttribute) {
                    AtlasEntity entity = isMinExtInfo ? this.mapVertexToAtlasEntityMin(referenceVertex, entityExtInfo) : this.mapVertexToAtlasEntity(referenceVertex, entityExtInfo);
                    if (entity != null) {
                        ret = AtlasTypeUtil.getAtlasObjectId((AtlasEntity)entity);
                    }
                } else {
                    ret = this.toAtlasObjectId(referenceVertex);
                }
            }
        }
        return ret;
    }

    private AtlasStruct mapVertexToStruct(AtlasVertex entityVertex, String edgeLabel, AtlasEdge edge, AtlasEntity.AtlasEntityExtInfo entityExtInfo, boolean isMinExtInfo) throws AtlasBaseException {
        AtlasStruct ret = null;
        if (edge == null) {
            edge = graphHelper.getEdgeForLabel(entityVertex, edgeLabel);
        }
        if (GraphHelper.elementExists((AtlasElement)edge)) {
            AtlasVertex referenceVertex = edge.getInVertex();
            ret = new AtlasStruct(GraphHelper.getTypeName((AtlasElement)referenceVertex));
            this.mapAttributes(referenceVertex, ret, entityExtInfo, isMinExtInfo);
        }
        return ret;
    }

    private Object getVertexAttribute(AtlasVertex vertex, AtlasStructType.AtlasAttribute attribute) throws AtlasBaseException {
        return vertex != null && attribute != null ? this.mapVertexToAttribute(vertex, attribute, null, false) : null;
    }

    private void mapRelationshipAttributes(AtlasVertex entityVertex, AtlasEntity entity, AtlasEntity.AtlasEntityExtInfo entityExtInfo, boolean isMinExtInfo) throws AtlasBaseException {
        AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(entity.getTypeName());
        if (entityType == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_INVALID, new String[]{entity.getTypeName()});
        }
        for (String attributeName : entityType.getRelationshipAttributes().keySet()) {
            this.mapVertexToRelationshipAttribute(entityVertex, entityType, attributeName, entity, entityExtInfo, isMinExtInfo);
        }
    }

    private Object mapVertexToRelationshipAttribute(AtlasVertex entityVertex, AtlasEntityType entityType, String attributeName, AtlasEntity entity, AtlasEntity.AtlasEntityExtInfo entityExtInfo, boolean isMinExtInfo) throws AtlasBaseException {
        AtlasRelationshipType relationshipType;
        Object ret = null;
        String relationshipTypeName = graphHelper.getRelationshipTypeName(entityVertex, entityType, attributeName);
        AtlasRelationshipType atlasRelationshipType = relationshipType = relationshipTypeName != null ? this.typeRegistry.getRelationshipTypeByName(relationshipTypeName) : null;
        if (relationshipType == null) {
            throw new AtlasBaseException(AtlasErrorCode.RELATIONSHIPDEF_INVALID, new String[]{"relationshipDef is null"});
        }
        AtlasStructType.AtlasAttribute attribute = entityType.getRelationshipAttribute(attributeName, relationshipTypeName);
        AtlasRelationshipDef relationshipDef = relationshipType.getRelationshipDef();
        AtlasRelationshipEndDef endDef1 = relationshipDef.getEndDef1();
        AtlasRelationshipEndDef endDef2 = relationshipDef.getEndDef2();
        AtlasEntityType endDef1Type = this.typeRegistry.getEntityTypeByName(endDef1.getType());
        AtlasEntityType endDef2Type = this.typeRegistry.getEntityTypeByName(endDef2.getType());
        AtlasRelationshipEndDef attributeEndDef = null;
        if (endDef1Type.isTypeOrSuperTypeOf(entityType.getTypeName()) && StringUtils.equals((CharSequence)endDef1.getName(), (CharSequence)attributeName)) {
            attributeEndDef = endDef1;
        } else if (endDef2Type.isTypeOrSuperTypeOf(entityType.getTypeName()) && StringUtils.equals((CharSequence)endDef2.getName(), (CharSequence)attributeName)) {
            attributeEndDef = endDef2;
        }
        if (attributeEndDef == null) {
            throw new AtlasBaseException(AtlasErrorCode.RELATIONSHIPDEF_INVALID, new String[]{relationshipDef.toString()});
        }
        switch (attributeEndDef.getCardinality()) {
            case SINGLE: {
                ret = this.mapRelatedVertexToObjectId(entityVertex, attribute, entityExtInfo, isMinExtInfo);
                break;
            }
            case LIST: 
            case SET: {
                ret = this.mapRelationshipArrayAttribute(entityVertex, attribute, entityExtInfo, isMinExtInfo);
            }
        }
        if (ret != null) {
            entity.setRelationshipAttribute(attributeName, ret);
            if (attributeEndDef.getIsLegacyAttribute() && !entity.hasAttribute(attributeName)) {
                entity.setAttribute(attributeName, this.toAtlasObjectId(ret));
            }
        }
        return ret;
    }

    private Object toAtlasObjectId(Object obj) {
        Object ret;
        if (obj instanceof AtlasObjectId) {
            ret = new AtlasObjectId((AtlasObjectId)obj);
        } else if (obj instanceof Collection) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object elem : (Collection)obj) {
                list.add(this.toAtlasObjectId(elem));
            }
            ret = list;
        } else if (obj instanceof Map) {
            HashMap map = new HashMap();
            for (Object key : ((Map)obj).keySet()) {
                map.put(key, this.toAtlasObjectId(((Map)obj).get(key)));
            }
            ret = map;
        } else {
            ret = obj;
        }
        return ret;
    }

    private AtlasObjectId mapRelatedVertexToObjectId(AtlasVertex entityVertex, AtlasStructType.AtlasAttribute attribute, AtlasEntity.AtlasEntityExtInfo entityExtInfo, boolean isMinExtInfo) throws AtlasBaseException {
        AtlasEdge edge = graphHelper.getEdgeForLabel(entityVertex, attribute.getRelationshipEdgeLabel(), attribute.getRelationshipEdgeDirection());
        return this.mapVertexToRelatedObjectId(entityVertex, edge, attribute.isOwnedRef(), entityExtInfo, isMinExtInfo);
    }

    private List<AtlasRelatedObjectId> mapRelationshipArrayAttribute(AtlasVertex entityVertex, AtlasStructType.AtlasAttribute attribute, AtlasEntity.AtlasEntityExtInfo entityExtInfo, boolean isMinExtInfo) throws AtlasBaseException {
        ArrayList<AtlasRelatedObjectId> ret = new ArrayList<AtlasRelatedObjectId>();
        Iterator<AtlasEdge> edges = null;
        if (attribute.getRelationshipEdgeDirection() == AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection.IN) {
            edges = GraphHelper.getIncomingEdgesByLabel(entityVertex, attribute.getRelationshipEdgeLabel());
        } else if (attribute.getRelationshipEdgeDirection() == AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection.OUT) {
            edges = GraphHelper.getOutGoingEdgesByLabel(entityVertex, attribute.getRelationshipEdgeLabel());
        } else if (attribute.getRelationshipEdgeDirection() == AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection.BOTH) {
            edges = GraphHelper.getAdjacentEdgesByLabel(entityVertex, AtlasEdgeDirection.BOTH, attribute.getRelationshipEdgeLabel());
        }
        if (edges != null) {
            while (edges.hasNext()) {
                AtlasEdge relationshipEdge = edges.next();
                AtlasRelatedObjectId relatedObjectId = this.mapVertexToRelatedObjectId(entityVertex, relationshipEdge, attribute.isOwnedRef(), entityExtInfo, isMinExtInfo);
                ret.add(relatedObjectId);
            }
        }
        return ret;
    }

    private AtlasRelatedObjectId mapVertexToRelatedObjectId(AtlasVertex entityVertex, AtlasEdge edge, boolean isOwnedRef, AtlasEntity.AtlasEntityExtInfo entityExtInfo, boolean isMinExtInfo) throws AtlasBaseException {
        AtlasRelatedObjectId ret = null;
        if (GraphHelper.elementExists((AtlasElement)edge)) {
            AtlasVertex referenceVertex = edge.getInVertex();
            if (StringUtils.equals((CharSequence)AtlasGraphUtilsV2.getIdFromVertex(referenceVertex), (CharSequence)AtlasGraphUtilsV2.getIdFromVertex(entityVertex))) {
                referenceVertex = edge.getOutVertex();
            }
            if (referenceVertex != null) {
                String entityTypeName = GraphHelper.getTypeName((AtlasElement)referenceVertex);
                String entityGuid = GraphHelper.getGuid((AtlasElement)referenceVertex);
                AtlasEntity.Status entityStatus = GraphHelper.getStatus((AtlasElement)referenceVertex);
                AtlasRelationship relationship = this.mapEdgeToAtlasRelationship(edge);
                ret = new AtlasRelatedObjectId(entityGuid, entityTypeName, entityStatus, relationship.getGuid(), relationship.getStatus(), new AtlasStruct(relationship.getTypeName(), relationship.getAttributes()));
                Object displayText = this.getDisplayText(referenceVertex, entityTypeName);
                if (displayText != null) {
                    ret.setDisplayText(displayText.toString());
                }
                if (isOwnedRef && entityExtInfo != null) {
                    if (isMinExtInfo) {
                        this.mapVertexToAtlasEntityMin(referenceVertex, entityExtInfo);
                    } else {
                        this.mapVertexToAtlasEntity(referenceVertex, entityExtInfo);
                    }
                }
            }
        }
        return ret;
    }

    private Object getDisplayText(AtlasVertex entityVertex, String entityTypeName) throws AtlasBaseException {
        AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(entityTypeName);
        Object ret = null;
        if (entityType != null) {
            ret = this.getVertexAttribute(entityVertex, entityType.getAttribute(NAME));
            if (ret == null) {
                ret = this.getVertexAttribute(entityVertex, entityType.getAttribute(DISPLAY_NAME));
            }
            if (ret == null) {
                ret = this.getVertexAttribute(entityVertex, entityType.getAttribute(QUALIFIED_NAME));
            }
        }
        return ret;
    }

    public AtlasRelationship mapEdgeToAtlasRelationship(AtlasEdge edge) throws AtlasBaseException {
        return this.mapEdgeToAtlasRelationship(edge, false).getRelationship();
    }

    public AtlasRelationship.AtlasRelationshipWithExtInfo mapEdgeToAtlasRelationshipWithExtInfo(AtlasEdge edge) throws AtlasBaseException {
        return this.mapEdgeToAtlasRelationship(edge, true);
    }

    public AtlasRelationship.AtlasRelationshipWithExtInfo mapEdgeToAtlasRelationship(AtlasEdge edge, boolean extendedInfo) throws AtlasBaseException {
        AtlasRelationship.AtlasRelationshipWithExtInfo ret = new AtlasRelationship.AtlasRelationshipWithExtInfo();
        this.mapSystemAttributes(edge, ret, extendedInfo);
        this.mapAttributes(edge, ret);
        return ret;
    }

    private AtlasRelationship.AtlasRelationshipWithExtInfo mapSystemAttributes(AtlasEdge edge, AtlasRelationship.AtlasRelationshipWithExtInfo relationshipWithExtInfo, boolean extendedInfo) throws AtlasBaseException {
        AtlasRelationship relationship;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Mapping system attributes for relationship");
        }
        if ((relationship = relationshipWithExtInfo.getRelationship()) == null) {
            relationship = new AtlasRelationship();
            relationshipWithExtInfo.setRelationship(relationship);
        }
        relationship.setGuid(GraphHelper.getRelationshipGuid((AtlasElement)edge));
        relationship.setTypeName(GraphHelper.getTypeName((AtlasElement)edge));
        relationship.setCreatedBy(GraphHelper.getCreatedByAsString((AtlasElement)edge));
        relationship.setUpdatedBy(GraphHelper.getModifiedByAsString((AtlasElement)edge));
        relationship.setCreateTime(new Date(GraphHelper.getCreatedTime((AtlasElement)edge)));
        relationship.setUpdateTime(new Date(GraphHelper.getModifiedTime((AtlasElement)edge)));
        Long version = GraphHelper.getVersion((AtlasElement)edge);
        if (version == null) {
            version = 1L;
        }
        relationship.setVersion(version);
        Integer provenanceType = GraphHelper.getProvenanceType((AtlasElement)edge);
        if (provenanceType == null) {
            provenanceType = 0;
        }
        relationship.setProvenanceType(provenanceType);
        relationship.setStatus(GraphHelper.getEdgeStatus((AtlasElement)edge));
        AtlasVertex end1Vertex = edge.getOutVertex();
        AtlasVertex end2Vertex = edge.getInVertex();
        relationship.setEnd1(new AtlasObjectId(GraphHelper.getGuid((AtlasElement)end1Vertex), GraphHelper.getTypeName((AtlasElement)end1Vertex)));
        relationship.setEnd2(new AtlasObjectId(GraphHelper.getGuid((AtlasElement)end2Vertex), GraphHelper.getTypeName((AtlasElement)end2Vertex)));
        relationship.setLabel(edge.getLabel());
        relationship.setPropagateTags(GraphHelper.getPropagateTags((AtlasElement)edge));
        if (extendedInfo) {
            this.addToReferredEntities(relationshipWithExtInfo, end1Vertex);
            this.addToReferredEntities(relationshipWithExtInfo, end2Vertex);
        }
        this.readClassificationsFromEdge(edge, relationshipWithExtInfo, extendedInfo);
        return relationshipWithExtInfo;
    }

    private void readClassificationsFromEdge(AtlasEdge edge, AtlasRelationship.AtlasRelationshipWithExtInfo relationshipWithExtInfo, boolean extendedInfo) throws AtlasBaseException {
        List<AtlasVertex> classificationVertices = GraphHelper.getClassificationVertices(edge);
        List<String> blockedClassificationIds = GraphHelper.getBlockedClassificationIds(edge);
        AtlasRelationship relationship = relationshipWithExtInfo.getRelationship();
        HashSet<AtlasClassification> propagatedClassifications = new HashSet<AtlasClassification>();
        HashSet<AtlasClassification> blockedClassifications = new HashSet<AtlasClassification>();
        for (AtlasVertex classificationVertex : classificationVertices) {
            String classificationId = classificationVertex.getIdForDisplay();
            AtlasClassification classification = this.toAtlasClassification(classificationVertex);
            String entityGuid = classification.getEntityGuid();
            if (blockedClassificationIds.contains(classificationId)) {
                blockedClassifications.add(classification);
            } else {
                propagatedClassifications.add(classification);
            }
            if (!extendedInfo) continue;
            this.addToReferredEntities(relationshipWithExtInfo, entityGuid);
        }
        relationship.setPropagatedClassifications(propagatedClassifications);
        relationship.setBlockedPropagatedClassifications(blockedClassifications);
    }

    private void addToReferredEntities(AtlasRelationship.AtlasRelationshipWithExtInfo relationshipWithExtInfo, String guid) throws AtlasBaseException {
        if (!relationshipWithExtInfo.referredEntitiesContains(guid)) {
            this.addToReferredEntities(relationshipWithExtInfo, this.getEntityVertex(guid));
        }
    }

    private void addToReferredEntities(AtlasRelationship.AtlasRelationshipWithExtInfo relationshipWithExtInfo, AtlasVertex entityVertex) throws AtlasBaseException {
        String entityGuid = GraphHelper.getGuid((AtlasElement)entityVertex);
        if (!relationshipWithExtInfo.referredEntitiesContains(entityGuid)) {
            relationshipWithExtInfo.addReferredEntity(entityGuid, this.toAtlasEntityHeader(entityVertex));
        }
    }

    private void mapAttributes(AtlasEdge edge, AtlasRelationship.AtlasRelationshipWithExtInfo relationshipWithExtInfo) throws AtlasBaseException {
        AtlasRelationship relationship = relationshipWithExtInfo.getRelationship();
        AtlasType objType = this.typeRegistry.getType(relationship.getTypeName());
        if (!(objType instanceof AtlasRelationshipType)) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_INVALID, new String[]{relationship.getTypeName()});
        }
        AtlasRelationshipType relationshipType = (AtlasRelationshipType)objType;
        for (AtlasStructType.AtlasAttribute attribute : relationshipType.getAllAttributes().values()) {
            Object attrValue = this.mapVertexToPrimitive((AtlasElement)edge, attribute.getVertexPropertyName(), attribute.getAttributeDef());
            relationship.setAttribute(attribute.getName(), attrValue);
        }
    }
}

