/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.atlas.AtlasConfiguration;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.GraphTransactionInterceptor;
import org.apache.atlas.RequestContext;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.instance.AtlasRelatedObjectId;
import org.apache.atlas.model.instance.AtlasRelationship;
import org.apache.atlas.model.instance.AtlasStruct;
import org.apache.atlas.model.instance.EntityMutationResponse;
import org.apache.atlas.model.instance.EntityMutations;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.RepositoryException;
import org.apache.atlas.repository.converters.AtlasInstanceConverter;
import org.apache.atlas.repository.graph.GraphHelper;
import org.apache.atlas.repository.graphdb.AtlasEdge;
import org.apache.atlas.repository.graphdb.AtlasElement;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.AtlasRelationshipStore;
import org.apache.atlas.repository.store.graph.v1.DeleteHandlerDelegate;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityChangeNotifier;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.repository.store.graph.v2.AttributeMutationContext;
import org.apache.atlas.repository.store.graph.v2.EntityGraphRetriever;
import org.apache.atlas.repository.store.graph.v2.EntityMutationContext;
import org.apache.atlas.type.AtlasArrayType;
import org.apache.atlas.type.AtlasBuiltInTypes;
import org.apache.atlas.type.AtlasClassificationType;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasMapType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.type.AtlasTypeUtil;
import org.apache.atlas.utils.AtlasEntityUtil;
import org.apache.atlas.utils.AtlasJson;
import org.apache.atlas.utils.AtlasPerfMetrics;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EntityGraphMapper {
    private static final Logger LOG = LoggerFactory.getLogger(EntityGraphMapper.class);
    private static final String SOFT_REF_FORMAT = "%s:%s";
    private static final int INDEXED_STR_SAFE_LEN = AtlasConfiguration.GRAPHSTORE_INDEXED_STRING_SAFE_LENGTH.getInt();
    private final GraphHelper graphHelper = GraphHelper.getInstance();
    private final AtlasGraph graph;
    private final DeleteHandlerDelegate deleteDelegate;
    private final AtlasTypeRegistry typeRegistry;
    private final AtlasRelationshipStore relationshipStore;
    private final AtlasEntityChangeNotifier entityChangeNotifier;
    private final AtlasInstanceConverter instanceConverter;
    private final EntityGraphRetriever entityRetriever;

    @Inject
    public EntityGraphMapper(DeleteHandlerDelegate deleteDelegate, AtlasTypeRegistry typeRegistry, AtlasGraph atlasGraph, AtlasRelationshipStore relationshipStore, AtlasEntityChangeNotifier entityChangeNotifier, AtlasInstanceConverter instanceConverter) {
        this.deleteDelegate = deleteDelegate;
        this.typeRegistry = typeRegistry;
        this.graph = atlasGraph;
        this.relationshipStore = relationshipStore;
        this.entityChangeNotifier = entityChangeNotifier;
        this.instanceConverter = instanceConverter;
        this.entityRetriever = new EntityGraphRetriever(typeRegistry);
    }

    public AtlasVertex createVertex(AtlasEntity entity) {
        String guid = UUID.randomUUID().toString();
        return this.createVertexWithGuid(entity, guid);
    }

    public AtlasVertex createVertexWithGuid(AtlasEntity entity, String guid) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> createVertex({})", (Object)entity.getTypeName());
        }
        AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(entity.getTypeName());
        AtlasVertex ret = this.createStructVertex((AtlasStruct)entity);
        for (String superTypeName : entityType.getAllSuperTypes()) {
            AtlasGraphUtilsV2.addEncodedProperty(ret, Constants.SUPER_TYPES_PROPERTY_KEY, superTypeName);
        }
        AtlasGraphUtilsV2.setEncodedProperty(ret, Constants.GUID_PROPERTY_KEY, guid);
        AtlasGraphUtilsV2.setEncodedProperty(ret, Constants.VERSION_PROPERTY_KEY, this.getEntityVersion(entity));
        GraphTransactionInterceptor.addToVertexCache(guid, ret);
        return ret;
    }

    public void updateSystemAttributes(AtlasVertex vertex, AtlasEntity entity) {
        if (entity.getVersion() != null) {
            AtlasGraphUtilsV2.setEncodedProperty(vertex, Constants.VERSION_PROPERTY_KEY, entity.getVersion());
        }
        if (entity.getCreateTime() != null) {
            AtlasGraphUtilsV2.setEncodedProperty(vertex, Constants.TIMESTAMP_PROPERTY_KEY, entity.getCreateTime().getTime());
        }
        if (entity.getUpdateTime() != null) {
            AtlasGraphUtilsV2.setEncodedProperty(vertex, Constants.MODIFICATION_TIMESTAMP_PROPERTY_KEY, entity.getUpdateTime().getTime());
        }
        if (StringUtils.isNotEmpty((CharSequence)entity.getCreatedBy())) {
            AtlasGraphUtilsV2.setEncodedProperty(vertex, Constants.CREATED_BY_KEY, entity.getCreatedBy());
        }
        if (StringUtils.isNotEmpty((CharSequence)entity.getUpdatedBy())) {
            AtlasGraphUtilsV2.setEncodedProperty(vertex, Constants.MODIFIED_BY_KEY, entity.getUpdatedBy());
        }
        if (StringUtils.isNotEmpty((CharSequence)entity.getHomeId())) {
            AtlasGraphUtilsV2.setEncodedProperty(vertex, Constants.HOME_ID_KEY, entity.getHomeId());
        }
        if (entity.isProxy() != null) {
            AtlasGraphUtilsV2.setEncodedProperty(vertex, Constants.IS_PROXY_KEY, entity.isProxy());
        }
        if (entity.getProvenanceType() != null) {
            AtlasGraphUtilsV2.setEncodedProperty(vertex, Constants.PROVENANCE_TYPE_KEY, entity.getProvenanceType());
        }
    }

    public EntityMutationResponse mapAttributesAndClassifications(EntityMutationContext context, boolean isPartialUpdate, boolean replaceClassifications) throws AtlasBaseException {
        AtlasEntityType entityType;
        AtlasVertex vertex;
        String guid;
        AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("mapAttributesAndClassifications");
        EntityMutationResponse resp = new EntityMutationResponse();
        Collection<AtlasEntity> createdEntities = context.getCreatedEntities();
        Collection<AtlasEntity> updatedEntities = context.getUpdatedEntities();
        if (CollectionUtils.isNotEmpty(createdEntities)) {
            for (AtlasEntity createdEntity : createdEntities) {
                guid = createdEntity.getGuid();
                vertex = context.getVertex(guid);
                entityType = context.getType(guid);
                this.mapRelationshipAttributes(createdEntity, entityType, vertex, EntityMutations.EntityOperation.CREATE, context);
                this.mapAttributes((AtlasStruct)createdEntity, (AtlasStructType)entityType, vertex, EntityMutations.EntityOperation.CREATE, context);
                resp.addEntity(EntityMutations.EntityOperation.CREATE, this.constructHeader(createdEntity, entityType, vertex));
                this.addClassifications(context, guid, createdEntity.getClassifications());
            }
        }
        if (CollectionUtils.isNotEmpty(updatedEntities)) {
            for (AtlasEntity updatedEntity : updatedEntities) {
                guid = updatedEntity.getGuid();
                vertex = context.getVertex(guid);
                entityType = context.getType(guid);
                this.mapRelationshipAttributes(updatedEntity, entityType, vertex, EntityMutations.EntityOperation.UPDATE, context);
                this.mapAttributes((AtlasStruct)updatedEntity, (AtlasStructType)entityType, vertex, EntityMutations.EntityOperation.UPDATE, context);
                if (isPartialUpdate) {
                    resp.addEntity(EntityMutations.EntityOperation.PARTIAL_UPDATE, this.constructHeader(updatedEntity, entityType, vertex));
                } else {
                    resp.addEntity(EntityMutations.EntityOperation.UPDATE, this.constructHeader(updatedEntity, entityType, vertex));
                }
                if (!replaceClassifications) continue;
                this.deleteClassifications(guid);
                this.addClassifications(context, guid, updatedEntity.getClassifications());
            }
        }
        if (CollectionUtils.isNotEmpty(context.getEntitiesToDelete())) {
            this.deleteDelegate.getHandler().deleteEntities(context.getEntitiesToDelete());
        }
        RequestContext req = RequestContext.get();
        for (AtlasEntityHeader entity : req.getDeletedEntities()) {
            resp.addEntity(EntityMutations.EntityOperation.DELETE, entity);
        }
        for (AtlasEntityHeader entity : req.getUpdatedEntities()) {
            if (isPartialUpdate) {
                resp.addEntity(EntityMutations.EntityOperation.PARTIAL_UPDATE, entity);
                continue;
            }
            resp.addEntity(EntityMutations.EntityOperation.UPDATE, entity);
        }
        RequestContext.get().endMetricRecord(metric);
        return resp;
    }

    private AtlasVertex createStructVertex(AtlasStruct struct) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> createStructVertex({})", (Object)struct.getTypeName());
        }
        AtlasVertex ret = this.graph.addVertex();
        AtlasGraphUtilsV2.setEncodedProperty(ret, Constants.ENTITY_TYPE_PROPERTY_KEY, struct.getTypeName());
        AtlasGraphUtilsV2.setEncodedProperty(ret, Constants.STATE_PROPERTY_KEY, AtlasEntity.Status.ACTIVE.name());
        AtlasGraphUtilsV2.setEncodedProperty(ret, Constants.TIMESTAMP_PROPERTY_KEY, RequestContext.get().getRequestTime());
        AtlasGraphUtilsV2.setEncodedProperty(ret, Constants.MODIFICATION_TIMESTAMP_PROPERTY_KEY, RequestContext.get().getRequestTime());
        AtlasGraphUtilsV2.setEncodedProperty(ret, Constants.CREATED_BY_KEY, RequestContext.get().getUser());
        AtlasGraphUtilsV2.setEncodedProperty(ret, Constants.MODIFIED_BY_KEY, RequestContext.get().getUser());
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== createStructVertex({})", (Object)struct.getTypeName());
        }
        return ret;
    }

    private AtlasVertex createClassificationVertex(AtlasClassification classification) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> createVertex({})", (Object)classification.getTypeName());
        }
        AtlasClassificationType classificationType = this.typeRegistry.getClassificationTypeByName(classification.getTypeName());
        AtlasVertex ret = this.createStructVertex((AtlasStruct)classification);
        AtlasGraphUtilsV2.addEncodedProperty(ret, Constants.SUPER_TYPES_PROPERTY_KEY, classificationType.getAllSuperTypes());
        AtlasGraphUtilsV2.setEncodedProperty(ret, Constants.CLASSIFICATION_ENTITY_GUID, classification.getEntityGuid());
        AtlasGraphUtilsV2.setEncodedProperty(ret, Constants.CLASSIFICATION_ENTITY_STATUS, classification.getEntityStatus().name());
        return ret;
    }

    private void mapAttributes(AtlasStruct struct, AtlasVertex vertex, EntityMutations.EntityOperation op, EntityMutationContext context) throws AtlasBaseException {
        this.mapAttributes(struct, this.getStructType(struct.getTypeName()), vertex, op, context);
    }

    private void mapAttributes(AtlasStruct struct, AtlasStructType structType, AtlasVertex vertex, EntityMutations.EntityOperation op, EntityMutationContext context) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> mapAttributes({}, {})", (Object)op, (Object)struct.getTypeName());
        }
        if (MapUtils.isNotEmpty((Map)struct.getAttributes())) {
            AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("mapAttributes");
            if (op.equals((Object)EntityMutations.EntityOperation.CREATE)) {
                for (AtlasStructType.AtlasAttribute attribute : structType.getAllAttributes().values()) {
                    Object attrValue = struct.getAttribute(attribute.getName());
                    this.mapAttribute(attribute, attrValue, vertex, op, context);
                }
            } else if (op.equals((Object)EntityMutations.EntityOperation.UPDATE)) {
                for (String attrName : struct.getAttributes().keySet()) {
                    AtlasStructType.AtlasAttribute attribute = structType.getAttribute(attrName);
                    if (attribute != null) {
                        Object attrValue = struct.getAttribute(attrName);
                        this.mapAttribute(attribute, attrValue, vertex, op, context);
                        continue;
                    }
                    LOG.warn("mapAttributes(): invalid attribute {}.{}. Ignored..", (Object)struct.getTypeName(), (Object)attrName);
                }
            }
            GraphHelper.updateModificationMetadata(vertex);
            RequestContext.get().endMetricRecord(metric);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== mapAttributes({}, {})", (Object)op, (Object)struct.getTypeName());
        }
    }

    private void mapRelationshipAttributes(AtlasEntity entity, AtlasEntityType entityType, AtlasVertex vertex, EntityMutations.EntityOperation op, EntityMutationContext context) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> mapRelationshipAttributes({}, {})", (Object)op, (Object)entity.getTypeName());
        }
        if (MapUtils.isNotEmpty((Map)entity.getRelationshipAttributes())) {
            AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("mapRelationshipAttributes");
            if (op.equals((Object)EntityMutations.EntityOperation.CREATE)) {
                for (String attrName : entityType.getRelationshipAttributes().keySet()) {
                    Object attrValue = entity.getRelationshipAttribute(attrName);
                    String relationType = AtlasEntityUtil.getRelationshipType((Object)attrValue);
                    AtlasStructType.AtlasAttribute attribute = entityType.getRelationshipAttribute(attrName, relationType);
                    this.mapAttribute(attribute, attrValue, vertex, op, context);
                }
            } else if (op.equals((Object)EntityMutations.EntityOperation.UPDATE)) {
                for (String attrName : entityType.getRelationshipAttributes().keySet()) {
                    if (!entity.hasRelationshipAttribute(attrName)) continue;
                    Object attrValue = entity.getRelationshipAttribute(attrName);
                    String relationType = AtlasEntityUtil.getRelationshipType((Object)attrValue);
                    AtlasStructType.AtlasAttribute attribute = entityType.getRelationshipAttribute(attrName, relationType);
                    this.mapAttribute(attribute, attrValue, vertex, op, context);
                }
            }
            GraphHelper.updateModificationMetadata(vertex);
            RequestContext.get().endMetricRecord(metric);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== mapRelationshipAttributes({}, {})", (Object)op, (Object)entity.getTypeName());
        }
    }

    private void mapAttribute(AtlasStructType.AtlasAttribute attribute, Object attrValue, AtlasVertex vertex, EntityMutations.EntityOperation op, EntityMutationContext context) throws AtlasBaseException {
        if (attrValue == null) {
            AtlasStructDef.AtlasAttributeDef attributeDef = attribute.getAttributeDef();
            AtlasType attrType = attribute.getAttributeType();
            if (attrType.getTypeCategory() == TypeCategory.PRIMITIVE) {
                attrValue = attributeDef.getDefaultValue() != null ? attrType.createDefaultValue((Object)attributeDef.getDefaultValue()) : (attribute.getAttributeDef().getIsOptional() ? attrType.createOptionalDefaultValue() : attrType.createDefaultValue());
            }
        }
        AttributeMutationContext ctx = new AttributeMutationContext(op, vertex, attribute, attrValue);
        this.mapToVertexByTypeCategory(ctx, context);
    }

    private Object mapToVertexByTypeCategory(AttributeMutationContext ctx, EntityMutationContext context) throws AtlasBaseException {
        if (ctx.getOp() == EntityMutations.EntityOperation.CREATE && ctx.getValue() == null) {
            return null;
        }
        switch (ctx.getAttrType().getTypeCategory()) {
            case PRIMITIVE: 
            case ENUM: {
                return this.mapPrimitiveValue(ctx, context);
            }
            case STRUCT: {
                String edgeLabel = AtlasGraphUtilsV2.getEdgeLabel(ctx.getVertexProperty());
                AtlasEdge currentEdge = this.graphHelper.getEdgeForLabel(ctx.getReferringVertex(), edgeLabel);
                AtlasEdge edge = currentEdge != null ? currentEdge : null;
                ctx.setExistingEdge(edge);
                AtlasEdge newEdge = this.mapStructValue(ctx, context);
                if (currentEdge != null && !currentEdge.equals(newEdge)) {
                    this.deleteDelegate.getHandler().deleteEdgeReference(currentEdge, ctx.getAttrType().getTypeCategory(), false, true, ctx.getReferringVertex());
                }
                return newEdge;
            }
            case OBJECT_ID_TYPE: {
                String relationshipGuid;
                if (ctx.getAttributeDef().isSoftReferenced()) {
                    return this.mapSoftRefValueWithUpdate(ctx, context);
                }
                AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection edgeDirection = ctx.getAttribute().getRelationshipEdgeDirection();
                String edgeLabel = ctx.getAttribute().getRelationshipEdgeLabel();
                if (StringUtils.isEmpty((CharSequence)edgeLabel)) {
                    edgeLabel = AtlasGraphUtilsV2.getEdgeLabel(ctx.getVertexProperty());
                }
                AtlasEdge currentEdge = StringUtils.isNotEmpty((CharSequence)(relationshipGuid = EntityGraphMapper.getRelationshipGuid(ctx.getValue()))) && !RequestContext.get().isImportInProgress() ? this.graphHelper.getEdgeForGUID(relationshipGuid) : this.graphHelper.getEdgeForLabel(ctx.getReferringVertex(), edgeLabel, edgeDirection);
                AtlasEdge newEdge = null;
                if (ctx.getValue() != null) {
                    AtlasEntityType instanceType = this.getInstanceType(ctx.getValue(), context);
                    AtlasEdge edge = currentEdge != null ? currentEdge : null;
                    ctx.setElementType((AtlasType)instanceType);
                    ctx.setExistingEdge(edge);
                    newEdge = this.mapObjectIdValueUsingRelationship(ctx, context);
                    if (ctx.getAttribute().getInverseRefAttribute() != null) {
                        this.addInverseReference(context, ctx.getAttribute().getInverseRefAttribute(), newEdge, EntityGraphMapper.getRelationshipAttributes(ctx.getValue()));
                    }
                }
                if (currentEdge == null && newEdge != null) {
                    if (edgeDirection == AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection.IN) {
                        this.recordEntityUpdate(newEdge.getOutVertex());
                    } else {
                        this.recordEntityUpdate(newEdge.getInVertex());
                    }
                }
                if (currentEdge != null && !currentEdge.equals(newEdge)) {
                    if (GraphHelper.isRelationshipEdge(newEdge)) {
                        AtlasVertex attrVertex = context.getDiscoveryContext().getResolvedEntityVertex(EntityGraphMapper.getGuid(ctx.getValue()));
                        this.recordEntityUpdate(attrVertex);
                    }
                    this.deleteDelegate.getHandler().deleteEdgeReference(currentEdge, ctx.getAttrType().getTypeCategory(), ctx.getAttribute().isOwnedRef(), true, ctx.getAttribute().getRelationshipEdgeDirection(), ctx.getReferringVertex());
                }
                return newEdge;
            }
            case MAP: {
                return this.mapMapValue(ctx, context);
            }
            case ARRAY: {
                return this.mapArrayValue(ctx, context);
            }
        }
        throw new AtlasBaseException(AtlasErrorCode.TYPE_CATEGORY_INVALID, new String[]{ctx.getAttrType().getTypeCategory().name()});
    }

    private String mapSoftRefValue(AttributeMutationContext ctx, EntityMutationContext context) {
        String ret = null;
        if (ctx.getValue() instanceof AtlasObjectId) {
            AtlasObjectId objectId = (AtlasObjectId)ctx.getValue();
            String typeName = objectId.getTypeName();
            String guid = AtlasTypeUtil.isUnAssignedGuid((String)objectId.getGuid()) ? context.getGuidAssignments().get(objectId.getGuid()) : objectId.getGuid();
            ret = AtlasEntityUtil.formatSoftRefValue((String)typeName, (String)guid);
        } else if (ctx.getValue() != null) {
            LOG.warn("mapSoftRefValue: Was expecting AtlasObjectId, but found: {}", ctx.getValue().getClass());
        }
        return ret;
    }

    private Object mapSoftRefValueWithUpdate(AttributeMutationContext ctx, EntityMutationContext context) {
        String softRefValue = this.mapSoftRefValue(ctx, context);
        AtlasGraphUtilsV2.setProperty(ctx.getReferringVertex(), ctx.getVertexProperty(), softRefValue);
        return softRefValue;
    }

    private void addInverseReference(EntityMutationContext context, AtlasStructType.AtlasAttribute inverseAttribute, AtlasEdge edge, Map<String, Object> relationshipAttributes) throws AtlasBaseException {
        RequestContext requestContext;
        AtlasStructType inverseType = inverseAttribute.getDefinedInType();
        AtlasVertex inverseVertex = edge.getInVertex();
        String inverseEdgeLabel = inverseAttribute.getRelationshipEdgeLabel();
        AtlasEdge inverseEdge = this.graphHelper.getEdgeForLabel(inverseVertex, inverseEdgeLabel);
        String propertyName = AtlasGraphUtilsV2.getQualifiedAttributePropertyKey(inverseType, inverseAttribute.getName());
        AtlasEdge newEdge = this.createInverseReferenceUsingRelationship(context, inverseAttribute, edge, relationshipAttributes);
        boolean inverseUpdated = true;
        switch (inverseAttribute.getAttributeType().getTypeCategory()) {
            case OBJECT_ID_TYPE: {
                if (inverseEdge == null) break;
                if (!inverseEdge.equals(newEdge)) {
                    this.deleteDelegate.getHandler().deleteEdgeReference(inverseEdge, inverseAttribute.getAttributeType().getTypeCategory(), inverseAttribute.isOwnedRef(), true, inverseVertex);
                    break;
                }
                inverseUpdated = false;
                break;
            }
            case ARRAY: {
                ArrayList<String> elements = (ArrayList<String>)inverseVertex.getProperty(propertyName, List.class);
                if (newEdge != null && elements == null) {
                    elements = new ArrayList<String>();
                    elements.add(newEdge.getId().toString());
                    inverseVertex.setProperty(propertyName, elements);
                    break;
                }
                if (newEdge != null && !elements.contains(newEdge.getId().toString())) {
                    elements.add(newEdge.getId().toString());
                    inverseVertex.setProperty(propertyName, elements);
                    break;
                }
                inverseUpdated = false;
                break;
            }
        }
        if (inverseUpdated && !(requestContext = RequestContext.get()).isDeletedEntity(GraphHelper.getGuid((AtlasElement)inverseVertex))) {
            GraphHelper.updateModificationMetadata(inverseVertex);
            requestContext.recordEntityUpdate(this.entityRetriever.toAtlasEntityHeader(inverseVertex));
        }
    }

    private AtlasEdge createInverseReferenceUsingRelationship(EntityMutationContext context, AtlasStructType.AtlasAttribute inverseAttribute, AtlasEdge edge, Map<String, Object> relationshipAttributes) throws AtlasBaseException {
        AtlasEdge ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> createInverseReferenceUsingRelationship()");
        }
        String inverseAttributeName = inverseAttribute.getName();
        AtlasStructType inverseAttributeType = inverseAttribute.getDefinedInType();
        AtlasVertex inverseVertex = edge.getInVertex();
        AtlasVertex vertex = edge.getOutVertex();
        if (inverseAttributeType instanceof AtlasEntityType) {
            AtlasEntityType entityType = (AtlasEntityType)inverseAttributeType;
            if (entityType.hasRelationshipAttribute(inverseAttributeName)) {
                String relationshipName = this.graphHelper.getRelationshipTypeName(inverseVertex, entityType, inverseAttributeName);
                ret = this.getOrCreateRelationship(inverseVertex, vertex, relationshipName, relationshipAttributes);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No RelationshipDef defined between {} and {} on attribute: {}", new Object[]{inverseAttributeType, AtlasGraphUtilsV2.getTypeName((AtlasElement)vertex), inverseAttributeName});
                }
                ret = this.createInverseReference(inverseAttribute, inverseAttributeType, inverseVertex, vertex);
            }
        } else {
            ret = this.createInverseReference(inverseAttribute, inverseAttributeType, inverseVertex, vertex);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== createInverseReferenceUsingRelationship()");
        }
        this.updateRelationshipGuidForImport(context, inverseAttributeName, inverseVertex, ret);
        return ret;
    }

    private void updateRelationshipGuidForImport(EntityMutationContext context, String inverseAttributeName, AtlasVertex inverseVertex, AtlasEdge edge) throws AtlasBaseException {
        if (!RequestContext.get().isImportInProgress()) {
            return;
        }
        String parentGuid = GraphHelper.getGuid((AtlasElement)inverseVertex);
        if (StringUtils.isEmpty((CharSequence)parentGuid)) {
            return;
        }
        AtlasEntity entity = context.getCreatedOrUpdatedEntity(parentGuid);
        if (entity == null) {
            return;
        }
        String parentRelationshipGuid = EntityGraphMapper.getRelationshipGuid(entity.getRelationshipAttribute(inverseAttributeName));
        if (StringUtils.isEmpty((CharSequence)parentRelationshipGuid)) {
            return;
        }
        AtlasGraphUtilsV2.setEncodedProperty(edge, Constants.RELATIONSHIP_GUID_PROPERTY_KEY, parentRelationshipGuid);
    }

    private AtlasEdge createInverseReference(AtlasStructType.AtlasAttribute inverseAttribute, AtlasStructType inverseAttributeType, AtlasVertex inverseVertex, AtlasVertex vertex) throws AtlasBaseException {
        AtlasEdge ret;
        String propertyName = AtlasGraphUtilsV2.getQualifiedAttributePropertyKey(inverseAttributeType, inverseAttribute.getName());
        String inverseEdgeLabel = AtlasGraphUtilsV2.getEdgeLabel(propertyName);
        try {
            ret = this.graphHelper.getOrCreateEdge(inverseVertex, vertex, inverseEdgeLabel);
        }
        catch (RepositoryException e) {
            throw new AtlasBaseException(AtlasErrorCode.INTERNAL_ERROR, (Throwable)((Object)e), new String[0]);
        }
        return ret;
    }

    private Object mapPrimitiveValue(AttributeMutationContext ctx, EntityMutationContext context) {
        String uniqPropName;
        String value;
        boolean isIndexableStrAttr = ctx.getAttributeDef().getIsIndexable() && ctx.getAttrType() instanceof AtlasBuiltInTypes.AtlasStringType;
        Object ret = ctx.getValue();
        if (ret != null && isIndexableStrAttr && (value = ret.toString()).length() > INDEXED_STR_SAFE_LEN) {
            RequestContext requestContext = RequestContext.get();
            int trimmedLength = requestContext.getAttemptCount() <= 1 ? value.length() : (requestContext.getAttemptCount() >= requestContext.getMaxAttempts() ? INDEXED_STR_SAFE_LEN : (requestContext.getAttemptCount() == 2 ? Math.min(4 * INDEXED_STR_SAFE_LEN, value.length()) : (requestContext.getAttemptCount() == 3 ? Math.min(2 * INDEXED_STR_SAFE_LEN, value.length()) : INDEXED_STR_SAFE_LEN)));
            if (trimmedLength < value.length()) {
                LOG.warn("Length of indexed attribute {} is {} characters, longer than safe-limit {}; trimming to {} - attempt #{}", new Object[]{ctx.getAttribute().getQualifiedName(), value.length(), INDEXED_STR_SAFE_LEN, trimmedLength, requestContext.getAttemptCount()});
                String checksumSuffix = ":" + DigestUtils.shaHex((String)value);
                ret = value.substring(0, trimmedLength - checksumSuffix.length()) + checksumSuffix;
            } else {
                LOG.warn("Length of indexed attribute {} is {} characters, longer than safe-limit {}", new Object[]{ctx.getAttribute().getQualifiedName(), value.length(), INDEXED_STR_SAFE_LEN});
            }
        }
        AtlasGraphUtilsV2.setEncodedProperty(ctx.getReferringVertex(), ctx.getVertexProperty(), ret);
        String string = uniqPropName = ctx.getAttribute() != null ? ctx.getAttribute().getVertexUniquePropertyName() : null;
        if (uniqPropName != null) {
            if (context.isDeletedEntity(ctx.getReferringVertex()) || AtlasGraphUtilsV2.getState((AtlasElement)ctx.getReferringVertex()) == AtlasEntity.Status.DELETED) {
                ctx.getReferringVertex().removeProperty(uniqPropName);
            } else {
                AtlasGraphUtilsV2.setEncodedProperty(ctx.getReferringVertex(), uniqPropName, ret);
            }
        }
        return ret;
    }

    private AtlasEdge mapStructValue(AttributeMutationContext ctx, EntityMutationContext context) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> mapStructValue({})", (Object)ctx);
        }
        AtlasEdge ret = null;
        if (ctx.getCurrentEdge() != null) {
            AtlasStruct structVal = null;
            if (ctx.getValue() instanceof AtlasStruct) {
                structVal = (AtlasStruct)ctx.getValue();
            } else if (ctx.getValue() instanceof Map) {
                structVal = new AtlasStruct(ctx.getAttrType().getTypeName(), AtlasTypeUtil.toStructAttributes((Map)((Map)ctx.getValue())));
            }
            if (structVal != null) {
                this.updateVertex(structVal, ctx.getCurrentEdge().getInVertex(), context);
            }
            ret = ctx.getCurrentEdge();
        } else if (ctx.getValue() != null) {
            String edgeLabel = AtlasGraphUtilsV2.getEdgeLabel(ctx.getVertexProperty());
            AtlasStruct structVal = null;
            if (ctx.getValue() instanceof AtlasStruct) {
                structVal = (AtlasStruct)ctx.getValue();
            } else if (ctx.getValue() instanceof Map) {
                structVal = new AtlasStruct(ctx.getAttrType().getTypeName(), AtlasTypeUtil.toStructAttributes((Map)((Map)ctx.getValue())));
            }
            if (structVal != null) {
                ret = this.createVertex(structVal, ctx.getReferringVertex(), edgeLabel, context);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== mapStructValue({})", (Object)ctx);
        }
        return ret;
    }

    private AtlasEdge mapObjectIdValue(AttributeMutationContext ctx, EntityMutationContext context) throws AtlasBaseException {
        AtlasObjectId objId;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> mapObjectIdValue({})", (Object)ctx);
        }
        AtlasEdge ret = null;
        String guid = EntityGraphMapper.getGuid(ctx.getValue());
        AtlasVertex entityVertex = context.getDiscoveryContext().getResolvedEntityVertex(guid);
        if (entityVertex == null && (objId = EntityGraphMapper.getObjectId(ctx.getValue())) != null) {
            entityVertex = context.getDiscoveryContext().getResolvedEntityVertex(objId);
        }
        if (entityVertex == null) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_OBJECT_ID, new String[]{ctx.getValue() == null ? null : ctx.getValue().toString()});
        }
        if (ctx.getCurrentEdge() != null) {
            ret = this.updateEdge(ctx.getAttributeDef(), ctx.getValue(), ctx.getCurrentEdge(), entityVertex);
        } else if (ctx.getValue() != null) {
            String edgeLabel = AtlasGraphUtilsV2.getEdgeLabel(ctx.getVertexProperty());
            try {
                ret = this.graphHelper.getOrCreateEdge(ctx.getReferringVertex(), entityVertex, edgeLabel);
            }
            catch (RepositoryException e) {
                throw new AtlasBaseException(AtlasErrorCode.INTERNAL_ERROR, (Throwable)((Object)e), new String[0]);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== mapObjectIdValue({})", (Object)ctx);
        }
        return ret;
    }

    private AtlasEdge mapObjectIdValueUsingRelationship(AttributeMutationContext ctx, EntityMutationContext context) throws AtlasBaseException {
        AtlasEdge ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> mapObjectIdValueUsingRelationship({})", (Object)ctx);
        }
        AtlasVertex attributeVertex = context.getDiscoveryContext().getResolvedEntityVertex(EntityGraphMapper.getGuid(ctx.getValue()));
        AtlasVertex entityVertex = ctx.getReferringVertex();
        if (attributeVertex == null) {
            AtlasObjectId objectId = EntityGraphMapper.getObjectId(ctx.getValue());
            AtlasVertex atlasVertex = attributeVertex = objectId != null ? context.getDiscoveryContext().getResolvedEntityVertex(objectId) : null;
        }
        if (attributeVertex == null) {
            if (RequestContext.get().isImportInProgress()) {
                return null;
            }
            throw new AtlasBaseException(AtlasErrorCode.INVALID_OBJECT_ID, new String[]{ctx.getValue() == null ? null : ctx.getValue().toString()});
        }
        AtlasType type = this.typeRegistry.getType(AtlasGraphUtilsV2.getTypeName((AtlasElement)entityVertex));
        if (type instanceof AtlasEntityType) {
            AtlasEntityType entityType = (AtlasEntityType)type;
            AtlasStructType.AtlasAttribute attribute = ctx.getAttribute();
            String attributeName = attribute.getName();
            if (entityType.hasRelationshipAttribute(attributeName)) {
                Map<String, Object> relationshipAttributes = EntityGraphMapper.getRelationshipAttributes(ctx.getValue());
                if (ctx.getCurrentEdge() != null) {
                    ret = this.updateRelationship(ctx.getCurrentEdge(), entityVertex, attributeVertex, attribute.getRelationshipEdgeDirection(), relationshipAttributes);
                } else {
                    String relationshipGuid;
                    boolean isCreated;
                    AtlasVertex toVertex;
                    AtlasVertex fromVertex;
                    String relationshipName = attribute.getRelationshipName();
                    if (StringUtils.isEmpty((CharSequence)relationshipName)) {
                        relationshipName = this.graphHelper.getRelationshipTypeName(entityVertex, entityType, attributeName);
                    }
                    if (attribute.getRelationshipEdgeDirection() == AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection.IN) {
                        fromVertex = attributeVertex;
                        toVertex = entityVertex;
                    } else {
                        fromVertex = entityVertex;
                        toVertex = attributeVertex;
                    }
                    ret = this.getOrCreateRelationship(fromVertex, toVertex, relationshipName, relationshipAttributes);
                    boolean bl = isCreated = GraphHelper.getCreatedTime((AtlasElement)ret) == RequestContext.get().getRequestTime();
                    if (isCreated) {
                        this.recordEntityUpdate(attributeVertex);
                    }
                    if (RequestContext.get().isImportInProgress() && !StringUtils.isEmpty((CharSequence)(relationshipGuid = EntityGraphMapper.getRelationshipGuid(ctx.getValue())))) {
                        AtlasGraphUtilsV2.setEncodedProperty(ret, Constants.RELATIONSHIP_GUID_PROPERTY_KEY, relationshipGuid);
                    }
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No RelationshipDef defined between {} and {} on attribute: {}", new Object[]{GraphHelper.getTypeName((AtlasElement)entityVertex), GraphHelper.getTypeName((AtlasElement)attributeVertex), attributeName});
                }
                ret = this.mapObjectIdValue(ctx, context);
            }
        } else {
            ret = this.mapObjectIdValue(ctx, context);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== mapObjectIdValueUsingRelationship({})", (Object)ctx);
        }
        return ret;
    }

    private Map<String, Object> mapMapValue(AttributeMutationContext ctx, EntityMutationContext context) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> mapMapValue({})", (Object)ctx);
        }
        Map newVal = (Map)ctx.getValue();
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        AtlasMapType mapType = (AtlasMapType)ctx.getAttrType();
        AtlasStructType.AtlasAttribute attribute = ctx.getAttribute();
        Map<String, Object> currentMap = GraphHelper.getMapElementsProperty(mapType, ctx.getReferringVertex(), ctx.getVertexProperty(), attribute);
        boolean isReference = AtlasGraphUtilsV2.isReference(mapType.getValueType());
        boolean isSoftReference = ctx.getAttribute().getAttributeDef().isSoftReferenced();
        if (MapUtils.isNotEmpty((Map)newVal)) {
            String propertyName = ctx.getVertexProperty();
            if (isReference) {
                for (Map.Entry entry : newVal.entrySet()) {
                    String key2 = entry.getKey().toString();
                    AtlasEdge existingEdge = isSoftReference ? null : EntityGraphMapper.getEdgeIfExists(mapType, currentMap, key2);
                    AttributeMutationContext mapCtx = new AttributeMutationContext(ctx.getOp(), ctx.getReferringVertex(), attribute, entry.getValue(), propertyName, mapType.getValueType(), existingEdge);
                    Object newEntry = this.mapCollectionElementsToVertex(mapCtx, context);
                    if (!isSoftReference && newEntry instanceof AtlasEdge) {
                        AtlasEdge edge = (AtlasEdge)newEntry;
                        edge.setProperty(Constants.ATTRIBUTE_KEY_PROPERTY_KEY, (Object)key2);
                        AtlasStructType.AtlasAttribute inverseRefAttribute = attribute.getInverseRefAttribute();
                        if (inverseRefAttribute != null) {
                            this.addInverseReference(context, inverseRefAttribute, edge, EntityGraphMapper.getRelationshipAttributes(ctx.getValue()));
                        }
                        this.updateInConsistentOwnedMapVertices(ctx, mapType, newEntry);
                        newMap.put(key2, newEntry);
                    }
                    if (!isSoftReference) continue;
                    newMap.put(key2, newEntry);
                }
                Map<String, Object> finalMap = this.removeUnusedMapEntries(attribute, ctx.getReferringVertex(), currentMap, newMap);
                newMap.putAll(finalMap);
            } else {
                ctx.getReferringVertex().setProperty(propertyName, new HashMap(newVal));
                newVal.forEach((key, value) -> newMap.put(key.toString(), value));
            }
            if (isSoftReference) {
                ctx.getReferringVertex().setProperty(propertyName, new HashMap<String, Object>(newMap));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== mapMapValue({})", (Object)ctx);
        }
        return newMap;
    }

    public List mapArrayValue(AttributeMutationContext ctx, EntityMutationContext context) throws AtlasBaseException {
        int index;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> mapArrayValue({})", (Object)ctx);
        }
        AtlasStructType.AtlasAttribute attribute = ctx.getAttribute();
        List newElements = (List)ctx.getValue();
        AtlasArrayType arrType = (AtlasArrayType)attribute.getAttributeType();
        AtlasType elementType = arrType.getElementType();
        boolean isReference = AtlasGraphUtilsV2.isReference(elementType);
        boolean isSoftReference = ctx.getAttribute().getAttributeDef().isSoftReferenced();
        AtlasStructType.AtlasAttribute inverseRefAttribute = attribute.getInverseRefAttribute();
        AtlasStructDef.AtlasAttributeDef.Cardinality cardinality = attribute.getAttributeDef().getCardinality();
        ArrayList<AtlasEdge> newElementsCreated = new ArrayList<AtlasEdge>();
        List<Object> currentElements = isReference && !isSoftReference ? GraphHelper.getCollectionElementsUsingRelationship(ctx.getReferringVertex(), attribute) : EntityGraphMapper.getArrayElementsProperty(elementType, isSoftReference, ctx.getReferringVertex(), ctx.getVertexProperty());
        if (CollectionUtils.isNotEmpty((Collection)newElements)) {
            if (cardinality == AtlasStructDef.AtlasAttributeDef.Cardinality.SET) {
                newElements = newElements.stream().distinct().collect(Collectors.toList());
            }
            for (index = 0; index < newElements.size(); ++index) {
                AtlasEdge existingEdge = isSoftReference ? null : this.getEdgeAt(currentElements, index, elementType);
                AttributeMutationContext arrCtx = new AttributeMutationContext(ctx.getOp(), ctx.getReferringVertex(), ctx.getAttribute(), newElements.get(index), ctx.getVertexProperty(), elementType, existingEdge);
                Object newEntry = this.mapCollectionElementsToVertex(arrCtx, context);
                if (isReference && newEntry != null && newEntry instanceof AtlasEdge && inverseRefAttribute != null) {
                    AtlasEdge newEdge = (AtlasEdge)newEntry;
                    this.addInverseReference(context, inverseRefAttribute, newEdge, EntityGraphMapper.getRelationshipAttributes(ctx.getValue()));
                }
                if (newEntry == null) continue;
                newElementsCreated.add((AtlasEdge)newEntry);
            }
        }
        if (isReference && !isSoftReference) {
            List<AtlasEdge> additionalEdges = this.removeUnusedArrayEntries(attribute, currentElements, newElementsCreated, ctx.getReferringVertex());
            newElementsCreated.addAll(additionalEdges);
        }
        for (index = 0; index < newElementsCreated.size(); ++index) {
            Object element = newElementsCreated.get(index);
            if (!(element instanceof AtlasEdge)) continue;
            AtlasGraphUtilsV2.setEncodedProperty((AtlasEdge)element, Constants.ATTRIBUTE_INDEX_PROPERTY_KEY, index);
        }
        this.setArrayElementsProperty(elementType, isSoftReference, ctx.getReferringVertex(), ctx.getVertexProperty(), newElementsCreated);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== mapArrayValue({})", (Object)ctx);
        }
        return newElementsCreated;
    }

    private AtlasEdge createVertex(AtlasStruct struct, AtlasVertex referringVertex, String edgeLabel, EntityMutationContext context) throws AtlasBaseException {
        AtlasVertex vertex = this.createStructVertex(struct);
        this.mapAttributes(struct, vertex, EntityMutations.EntityOperation.CREATE, context);
        try {
            return this.graphHelper.getOrCreateEdge(referringVertex, vertex, edgeLabel);
        }
        catch (RepositoryException e) {
            throw new AtlasBaseException(AtlasErrorCode.INTERNAL_ERROR, (Throwable)((Object)e), new String[0]);
        }
    }

    private void updateVertex(AtlasStruct struct, AtlasVertex vertex, EntityMutationContext context) throws AtlasBaseException {
        this.mapAttributes(struct, vertex, EntityMutations.EntityOperation.UPDATE, context);
    }

    private Long getEntityVersion(AtlasEntity entity) {
        Long ret = entity != null ? entity.getVersion() : null;
        return ret != null ? ret : 0L;
    }

    private AtlasStructType getStructType(String typeName) throws AtlasBaseException {
        AtlasType objType = this.typeRegistry.getType(typeName);
        if (!(objType instanceof AtlasStructType)) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_INVALID, new String[]{typeName});
        }
        return (AtlasStructType)objType;
    }

    private AtlasEntityType getEntityType(String typeName) throws AtlasBaseException {
        AtlasType objType = this.typeRegistry.getType(typeName);
        if (!(objType instanceof AtlasEntityType)) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_INVALID, new String[]{typeName});
        }
        return (AtlasEntityType)objType;
    }

    private Object mapCollectionElementsToVertex(AttributeMutationContext ctx, EntityMutationContext context) throws AtlasBaseException {
        switch (ctx.getAttrType().getTypeCategory()) {
            case PRIMITIVE: 
            case ENUM: 
            case MAP: 
            case ARRAY: {
                return ctx.getValue();
            }
            case STRUCT: {
                return this.mapStructValue(ctx, context);
            }
            case OBJECT_ID_TYPE: {
                AtlasEntityType instanceType = this.getInstanceType(ctx.getValue(), context);
                ctx.setElementType((AtlasType)instanceType);
                if (ctx.getAttributeDef().isSoftReferenced()) {
                    return this.mapSoftRefValue(ctx, context);
                }
                return this.mapObjectIdValueUsingRelationship(ctx, context);
            }
        }
        throw new AtlasBaseException(AtlasErrorCode.TYPE_CATEGORY_INVALID, new String[]{ctx.getAttrType().getTypeCategory().name()});
    }

    private static AtlasObjectId getObjectId(Object val) throws AtlasBaseException {
        Object ret = null;
        if (val != null) {
            if (val instanceof AtlasObjectId) {
                ret = (AtlasObjectId)val;
            } else if (val instanceof Map) {
                Map map = (Map)val;
                ret = map.containsKey("relationshipType") ? new AtlasRelatedObjectId(map) : new AtlasObjectId((Map)val);
                if (!AtlasTypeUtil.isValid((AtlasObjectId)ret)) {
                    throw new AtlasBaseException(AtlasErrorCode.INVALID_OBJECT_ID, new String[]{val.toString()});
                }
            } else {
                throw new AtlasBaseException(AtlasErrorCode.INVALID_OBJECT_ID, new String[]{val.toString()});
            }
        }
        return ret;
    }

    private static String getGuid(Object val) throws AtlasBaseException {
        if (val != null) {
            if (val instanceof AtlasObjectId) {
                return ((AtlasObjectId)val).getGuid();
            }
            if (val instanceof Map) {
                Object guidVal = ((Map)val).get("guid");
                return guidVal != null ? guidVal.toString() : null;
            }
        }
        return null;
    }

    private static Map<String, Object> getRelationshipAttributes(Object val) throws AtlasBaseException {
        Object relationshipStruct;
        if (val instanceof AtlasRelatedObjectId) {
            AtlasStruct relationshipStruct2 = ((AtlasRelatedObjectId)val).getRelationshipAttributes();
            return relationshipStruct2 != null ? relationshipStruct2.getAttributes() : null;
        }
        if (val instanceof Map && (relationshipStruct = ((Map)val).get("relationshipAttributes")) instanceof Map) {
            return AtlasTypeUtil.toStructAttributes((Map)((Map)relationshipStruct));
        }
        return null;
    }

    private static String getRelationshipGuid(Object val) throws AtlasBaseException {
        if (val instanceof AtlasRelatedObjectId) {
            return ((AtlasRelatedObjectId)val).getRelationshipGuid();
        }
        if (val instanceof Map) {
            Object relationshipGuidVal = ((Map)val).get("relationshipGuid");
            return relationshipGuidVal != null ? relationshipGuidVal.toString() : null;
        }
        return null;
    }

    private AtlasEntityType getInstanceType(Object val, EntityMutationContext context) throws AtlasBaseException {
        AtlasEntityType ret = null;
        if (val != null) {
            AtlasVertex vertex;
            String typeName = null;
            String guid = null;
            if (val instanceof AtlasObjectId) {
                AtlasObjectId objId = (AtlasObjectId)val;
                typeName = objId.getTypeName();
                guid = objId.getGuid();
            } else if (val instanceof Map) {
                Map map = (Map)val;
                Object typeNameVal = map.get("typeName");
                Object guidVal = map.get("guid");
                if (typeNameVal != null) {
                    typeName = typeNameVal.toString();
                }
                if (guidVal != null) {
                    guid = guidVal.toString();
                }
            }
            if (typeName == null && guid != null && (ret = context.getType(guid)) == null && (vertex = context.getDiscoveryContext().getResolvedEntityVertex(guid)) != null) {
                typeName = AtlasGraphUtilsV2.getTypeName((AtlasElement)vertex);
            }
            if (ret == null && typeName != null) {
                ret = this.typeRegistry.getEntityTypeByName(typeName);
            }
            if (ret == null) {
                throw new AtlasBaseException(AtlasErrorCode.INVALID_OBJECT_ID, new String[]{val.toString()});
            }
        }
        return ret;
    }

    private Map<String, Object> removeUnusedMapEntries(AtlasStructType.AtlasAttribute attribute, AtlasVertex vertex, Map<String, Object> currentMap, Map<String, Object> newMap) throws AtlasBaseException {
        HashMap<String, Object> additionalMap = new HashMap<String, Object>();
        AtlasMapType mapType = (AtlasMapType)attribute.getAttributeType();
        for (String currentKey : currentMap.keySet()) {
            boolean deleted;
            AtlasEdge currentEdge = (AtlasEdge)currentMap.get(currentKey);
            if (newMap.values().contains(currentEdge) || (deleted = this.deleteDelegate.getHandler().deleteEdgeReference(currentEdge, mapType.getValueType().getTypeCategory(), attribute.isOwnedRef(), true, vertex))) continue;
            additionalMap.put(currentKey, currentEdge);
        }
        return additionalMap;
    }

    private static AtlasEdge getEdgeIfExists(AtlasMapType mapType, Map<String, Object> currentMap, String keyStr) {
        Object val;
        AtlasEdge ret = null;
        if (AtlasGraphUtilsV2.isReference(mapType.getValueType()) && (val = currentMap.get(keyStr)) != null) {
            ret = (AtlasEdge)val;
        }
        return ret;
    }

    private AtlasEdge updateEdge(AtlasStructDef.AtlasAttributeDef attributeDef, Object value, AtlasEdge currentEdge, AtlasVertex entityVertex) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Updating entity reference {} for reference attribute {}", (Object)attributeDef.getName());
        }
        AtlasVertex currentVertex = currentEdge.getInVertex();
        String currentEntityId = AtlasGraphUtilsV2.getIdFromVertex(currentVertex);
        String newEntityId = AtlasGraphUtilsV2.getIdFromVertex(entityVertex);
        AtlasEdge newEdge = currentEdge;
        if (!currentEntityId.equals(newEntityId) && entityVertex != null) {
            try {
                newEdge = this.graphHelper.getOrCreateEdge(currentEdge.getOutVertex(), entityVertex, currentEdge.getLabel());
            }
            catch (RepositoryException e) {
                throw new AtlasBaseException(AtlasErrorCode.INTERNAL_ERROR, (Throwable)((Object)e), new String[0]);
            }
        }
        return newEdge;
    }

    private AtlasEdge updateRelationship(AtlasEdge currentEdge, AtlasVertex parentEntityVertex, AtlasVertex newEntityVertex, AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection edgeDirection, Map<String, Object> relationshipAttributes) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Updating entity reference using relationship {} for reference attribute {}", (Object)GraphHelper.getTypeName((AtlasElement)newEntityVertex));
        }
        String currentEntityId = edgeDirection == AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection.IN ? this.getIdFromOutVertex(currentEdge) : (edgeDirection == AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection.OUT ? this.getIdFromInVertex(currentEdge) : this.getIdFromBothVertex(currentEdge, parentEntityVertex));
        String newEntityId = AtlasGraphUtilsV2.getIdFromVertex(newEntityVertex);
        AtlasEdge ret = currentEdge;
        if (!currentEntityId.equals(newEntityId)) {
            String relationshipName = AtlasGraphUtilsV2.getTypeName((AtlasElement)currentEdge);
            if (relationshipName == null) {
                relationshipName = currentEdge.getLabel();
            }
            ret = edgeDirection == AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection.IN ? this.getOrCreateRelationship(newEntityVertex, currentEdge.getInVertex(), relationshipName, relationshipAttributes) : (edgeDirection == AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection.OUT ? this.getOrCreateRelationship(currentEdge.getOutVertex(), newEntityVertex, relationshipName, relationshipAttributes) : this.getOrCreateRelationship(newEntityVertex, parentEntityVertex, relationshipName, relationshipAttributes));
            this.recordEntityUpdate(newEntityVertex);
        }
        return ret;
    }

    public static List<Object> getArrayElementsProperty(AtlasType elementType, boolean isSoftReference, AtlasVertex vertex, String vertexPropertyName) {
        if (!isSoftReference && AtlasGraphUtilsV2.isReference(elementType)) {
            return vertex.getListProperty(vertexPropertyName, AtlasEdge.class);
        }
        return vertex.getListProperty(vertexPropertyName);
    }

    private AtlasEdge getEdgeAt(List<Object> currentElements, int index, AtlasType elemType) {
        AtlasEdge ret = null;
        if (AtlasGraphUtilsV2.isReference(elemType) && currentElements != null && index < currentElements.size()) {
            ret = (AtlasEdge)currentElements.get(index);
        }
        return ret;
    }

    private List<AtlasEdge> removeUnusedArrayEntries(AtlasStructType.AtlasAttribute attribute, List<AtlasEdge> currentEntries, List<AtlasEdge> newEntries, AtlasVertex entityVertex) throws AtlasBaseException {
        Collection edgesToRemove;
        AtlasType entryType;
        if (CollectionUtils.isNotEmpty(currentEntries) && AtlasGraphUtilsV2.isReference(entryType = ((AtlasArrayType)attribute.getAttributeType()).getElementType()) && CollectionUtils.isNotEmpty((Collection)(edgesToRemove = CollectionUtils.subtract(currentEntries, newEntries)))) {
            ArrayList<AtlasEdge> additionalElements = new ArrayList<AtlasEdge>();
            for (AtlasEdge edge : edgesToRemove) {
                boolean deleted = this.deleteDelegate.getHandler().deleteEdgeReference(edge, entryType.getTypeCategory(), attribute.isOwnedRef(), true, attribute.getRelationshipEdgeDirection(), entityVertex);
                if (deleted) continue;
                additionalElements.add(edge);
            }
            return additionalElements;
        }
        return Collections.emptyList();
    }

    private void setArrayElementsProperty(AtlasType elementType, boolean isSoftReference, AtlasVertex vertex, String vertexPropertyName, List<Object> values) {
        if (!AtlasGraphUtilsV2.isReference(elementType) || isSoftReference) {
            AtlasGraphUtilsV2.setEncodedProperty(vertex, vertexPropertyName, values);
        }
    }

    private AtlasEntityHeader constructHeader(AtlasEntity entity, AtlasEntityType type, AtlasVertex vertex) {
        AtlasEntityHeader header = new AtlasEntityHeader(entity.getTypeName());
        header.setGuid(AtlasGraphUtilsV2.getIdFromVertex(vertex));
        header.setStatus(entity.getStatus());
        for (AtlasStructType.AtlasAttribute attribute : type.getUniqAttributes().values()) {
            header.setAttribute(attribute.getName(), entity.getAttribute(attribute.getName()));
        }
        return header;
    }

    private void updateInConsistentOwnedMapVertices(AttributeMutationContext ctx, AtlasMapType mapType, Object val) {
        if (mapType.getValueType().getTypeCategory() == TypeCategory.OBJECT_ID_TYPE && !ctx.getAttributeDef().isSoftReferenced()) {
            AtlasEdge edge = (AtlasEdge)val;
            if (ctx.getAttribute().isOwnedRef() && GraphHelper.getStatus((AtlasElement)edge) == AtlasEntity.Status.DELETED && GraphHelper.getStatus((AtlasElement)edge.getInVertex()) == AtlasEntity.Status.DELETED) {
                AtlasGraphUtilsV2.setEncodedProperty(edge, Constants.STATE_PROPERTY_KEY, AtlasEntity.Status.ACTIVE.name());
                AtlasGraphUtilsV2.setEncodedProperty(edge.getInVertex(), Constants.STATE_PROPERTY_KEY, AtlasEntity.Status.ACTIVE.name());
            }
        }
    }

    public void addClassifications(EntityMutationContext context, String guid, List<AtlasClassification> classifications) throws AtlasBaseException {
        if (CollectionUtils.isNotEmpty(classifications)) {
            AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("addClassifications");
            final AtlasVertex entityVertex = context.getVertex(guid);
            AtlasEntityType entityType = context.getType(guid);
            List<AtlasVertex> entitiesToPropagateTo = null;
            HashMap propagations = null;
            ArrayList<AtlasClassification> addClassifications = new ArrayList<AtlasClassification>(classifications.size());
            for (AtlasClassification c : classifications) {
                AtlasClassification classification = new AtlasClassification(c);
                String classificationName = classification.getTypeName();
                Boolean propagateTags = classification.isPropagate();
                Boolean removePropagations = classification.getRemovePropagationsOnEntityDelete();
                if (propagateTags != null && propagateTags.booleanValue() && classification.getEntityGuid() != null && !StringUtils.equals((CharSequence)classification.getEntityGuid(), (CharSequence)guid)) continue;
                if (propagateTags == null) {
                    RequestContext reqContext = RequestContext.get();
                    if (reqContext.isImportInProgress() || reqContext.isInNotificationProcessing()) {
                        propagateTags = false;
                        classification.setPropagate(propagateTags);
                    } else {
                        propagateTags = true;
                    }
                }
                if (removePropagations == null) {
                    removePropagations = GraphHelper.getDefaultRemovePropagations();
                    classification.setRemovePropagationsOnEntityDelete(removePropagations);
                }
                if (classification.getEntityGuid() == null) {
                    classification.setEntityGuid(guid);
                }
                if (classification.getEntityStatus() == null) {
                    classification.setEntityStatus(AtlasEntity.Status.ACTIVE);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding classification [{}] to [{}] using edge label: [{}]", new Object[]{classificationName, entityType.getTypeName(), GraphHelper.getTraitLabel(classificationName)});
                }
                AtlasGraphUtilsV2.addEncodedProperty(entityVertex, Constants.TRAIT_NAMES_PROPERTY_KEY, classificationName);
                AtlasVertex classificationVertex = this.createClassificationVertex(classification);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("created vertex {} for trait {}", (Object)GraphHelper.string(classificationVertex), (Object)classificationName);
                }
                this.mapClassification(EntityMutations.EntityOperation.CREATE, context, classification, entityType, entityVertex, classificationVertex);
                GraphHelper.updateModificationMetadata(entityVertex);
                if (propagateTags.booleanValue()) {
                    if (entitiesToPropagateTo == null) {
                        entitiesToPropagateTo = this.graphHelper.getImpactedVertices(guid);
                    }
                    if (CollectionUtils.isNotEmpty(entitiesToPropagateTo)) {
                        List<AtlasVertex> entitiesPropagatedTo;
                        if (propagations == null) {
                            propagations = new HashMap(entitiesToPropagateTo.size());
                            for (AtlasVertex entityToPropagateTo : entitiesToPropagateTo) {
                                propagations.put(entityToPropagateTo, new ArrayList());
                            }
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Propagating tag: [{}][{}] to {}", new Object[]{classificationName, entityType.getTypeName(), GraphHelper.getTypeNames(entitiesToPropagateTo)});
                        }
                        if ((entitiesPropagatedTo = this.deleteDelegate.getHandler().addTagPropagation(classificationVertex, entitiesToPropagateTo)) != null) {
                            for (AtlasVertex entityPropagatedTo : entitiesPropagatedTo) {
                                ((List)propagations.get(entityPropagatedTo)).add(classification);
                            }
                        }
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug(" --> Not propagating classification: [{}][{}] - no entities found to propagate to.", (Object)GraphHelper.getTypeName((AtlasElement)classificationVertex), (Object)entityType.getTypeName());
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug(" --> Not propagating classification: [{}][{}] - propagation is disabled.", (Object)GraphHelper.getTypeName((AtlasElement)classificationVertex), (Object)entityType.getTypeName());
                }
                addClassifications.add(classification);
            }
            ArrayList<AtlasVertex> notificationVertices = new ArrayList<AtlasVertex>(){
                {
                    this.add(entityVertex);
                }
            };
            if (CollectionUtils.isNotEmpty(entitiesToPropagateTo)) {
                notificationVertices.addAll(entitiesToPropagateTo);
            }
            for (AtlasVertex vertex : notificationVertices) {
                String entityGuid = GraphHelper.getGuid((AtlasElement)vertex);
                AtlasEntity entity = this.instanceConverter.getAndCacheEntity(entityGuid);
                List<Object> addedClassifications = StringUtils.equals((CharSequence)entityGuid, (CharSequence)guid) ? addClassifications : (List)propagations.get(vertex);
                if (!CollectionUtils.isNotEmpty(addedClassifications)) continue;
                this.entityChangeNotifier.onClassificationAddedToEntity(entity, addedClassifications);
            }
            RequestContext.get().endMetricRecord(metric);
        }
    }

    public void deleteClassification(String entityGuid, String classificationName, String associatedEntityGuid) throws AtlasBaseException {
        if (StringUtils.isEmpty((CharSequence)associatedEntityGuid) || associatedEntityGuid.equals(entityGuid)) {
            this.deleteClassification(entityGuid, classificationName);
        } else {
            this.deletePropagatedClassification(entityGuid, classificationName, associatedEntityGuid);
        }
    }

    private void deletePropagatedClassification(String entityGuid, String classificationName, String associatedEntityGuid) throws AtlasBaseException {
        if (StringUtils.isEmpty((CharSequence)classificationName)) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_CLASSIFICATION_PARAMS, new String[]{"delete", entityGuid});
        }
        AtlasVertex entityVertex = AtlasGraphUtilsV2.findByGuid(entityGuid);
        if (entityVertex == null) {
            throw new AtlasBaseException(AtlasErrorCode.INSTANCE_GUID_NOT_FOUND, new String[]{entityGuid});
        }
        this.deleteDelegate.getHandler().deletePropagatedClassification(entityVertex, classificationName, associatedEntityGuid);
    }

    public void deleteClassification(String entityGuid, String classificationName) throws AtlasBaseException {
        ArrayList<AtlasClassification> classifications;
        List<AtlasVertex> propagatedEntityVertices;
        if (StringUtils.isEmpty((CharSequence)classificationName)) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_CLASSIFICATION_PARAMS, new String[]{"delete", entityGuid});
        }
        AtlasVertex entityVertex = AtlasGraphUtilsV2.findByGuid(entityGuid);
        if (entityVertex == null) {
            throw new AtlasBaseException(AtlasErrorCode.INSTANCE_GUID_NOT_FOUND, new String[]{entityGuid});
        }
        List<String> traitNames = GraphHelper.getTraitNames(entityVertex);
        if (CollectionUtils.isEmpty(traitNames)) {
            throw new AtlasBaseException(AtlasErrorCode.NO_CLASSIFICATIONS_FOUND_FOR_ENTITY, new String[]{entityGuid});
        }
        this.validateClassificationExists(traitNames, classificationName);
        HashMap<AtlasVertex, ArrayList<AtlasClassification>> removedClassifications = new HashMap<AtlasVertex, ArrayList<AtlasClassification>>();
        AtlasVertex classificationVertex = GraphHelper.getClassificationVertex(entityVertex, classificationName);
        AtlasClassification classification = this.entityRetriever.toAtlasClassification(classificationVertex);
        if (GraphHelper.isPropagationEnabled(classificationVertex) && CollectionUtils.isNotEmpty(propagatedEntityVertices = this.deleteDelegate.getHandler().removeTagPropagation(classificationVertex))) {
            for (AtlasVertex propagatedEntityVertex : propagatedEntityVertices) {
                ArrayList<AtlasClassification> classifications2 = (ArrayList<AtlasClassification>)removedClassifications.get(propagatedEntityVertex);
                if (classifications2 == null) {
                    classifications2 = new ArrayList<AtlasClassification>();
                    removedClassifications.put(propagatedEntityVertex, classifications2);
                }
                classifications2.add(classification);
            }
        }
        if ((classifications = (ArrayList<AtlasClassification>)removedClassifications.get(entityVertex)) == null) {
            classifications = new ArrayList<AtlasClassification>();
            removedClassifications.put(entityVertex, classifications);
        }
        classifications.add(classification);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing classification: [{}] from: [{}][{}] with edge label: [{}]", new Object[]{classificationName, GraphHelper.getTypeName((AtlasElement)entityVertex), entityGuid, "classifiedAs"});
        }
        AtlasEdge edge = GraphHelper.getClassificationEdge(entityVertex, classificationVertex);
        this.deleteDelegate.getHandler().deleteEdgeReference(edge, TypeCategory.CLASSIFICATION, false, true, entityVertex);
        traitNames.remove(classificationName);
        this.updateTraitNamesProperty(entityVertex, traitNames);
        GraphHelper.updateModificationMetadata(entityVertex);
        for (Map.Entry entry : removedClassifications.entrySet()) {
            String guid = GraphHelper.getGuid((AtlasElement)entry.getKey());
            List deletedClassificationNames = (List)entry.getValue();
            AtlasEntity entity = this.instanceConverter.getAndCacheEntity(guid);
            this.entityChangeNotifier.onClassificationDeletedFromEntity(entity, deletedClassificationNames);
        }
    }

    public void updateClassifications(EntityMutationContext context, String guid, List<AtlasClassification> classifications) throws AtlasBaseException {
        if (CollectionUtils.isEmpty(classifications)) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_CLASSIFICATION_PARAMS, new String[]{"update", guid});
        }
        final AtlasVertex entityVertex = AtlasGraphUtilsV2.findByGuid(guid);
        if (entityVertex == null) {
            throw new AtlasBaseException(AtlasErrorCode.INSTANCE_GUID_NOT_FOUND, new String[]{guid});
        }
        String entityTypeName = AtlasGraphUtilsV2.getTypeName((AtlasElement)entityVertex);
        AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(entityTypeName);
        ArrayList<AtlasClassification> updatedClassifications = new ArrayList<AtlasClassification>();
        List<Object> entitiesToPropagateTo = new ArrayList();
        HashSet<AtlasVertex> notificationVertices = new HashSet<AtlasVertex>(){
            {
                this.add(entityVertex);
            }
        };
        HashMap addedPropagations = null;
        HashMap<AtlasVertex, ArrayList<AtlasClassification>> removedPropagations = null;
        for (AtlasClassification atlasClassification : classifications) {
            List updatedValidityPeriods;
            List currentValidityPeriods;
            String classificationName = atlasClassification.getTypeName();
            String classificationEntityGuid = atlasClassification.getEntityGuid();
            if (StringUtils.isEmpty((CharSequence)classificationEntityGuid)) {
                atlasClassification.setEntityGuid(guid);
            }
            if (StringUtils.isNotEmpty((CharSequence)classificationEntityGuid) && !StringUtils.equalsIgnoreCase((CharSequence)guid, (CharSequence)classificationEntityGuid)) {
                throw new AtlasBaseException(AtlasErrorCode.CLASSIFICATION_UPDATE_FROM_PROPAGATED_ENTITY, new String[]{classificationName});
            }
            AtlasVertex classificationVertex = GraphHelper.getClassificationVertex(entityVertex, classificationName);
            if (classificationVertex == null) {
                throw new AtlasBaseException(AtlasErrorCode.CLASSIFICATION_NOT_ASSOCIATED_WITH_ENTITY, new String[]{classificationName});
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Updating classification {} for entity {}", (Object)atlasClassification, (Object)guid);
            }
            AtlasClassification currentClassification = this.entityRetriever.toAtlasClassification(classificationVertex);
            this.validateAndNormalizeForUpdate(atlasClassification);
            boolean isClassificationUpdated = false;
            Map updatedAttributes = atlasClassification.getAttributes();
            if (MapUtils.isNotEmpty((Map)updatedAttributes)) {
                for (String attributeName : updatedAttributes.keySet()) {
                    currentClassification.setAttribute(attributeName, updatedAttributes.get(attributeName));
                }
                isClassificationUpdated = true;
            }
            if (!Objects.equals(currentValidityPeriods = currentClassification.getValidityPeriods(), updatedValidityPeriods = atlasClassification.getValidityPeriods())) {
                currentClassification.setValidityPeriods(updatedValidityPeriods);
                isClassificationUpdated = true;
            }
            Boolean currentRemovePropagations = currentClassification.getRemovePropagationsOnEntityDelete();
            Boolean updatedRemovePropagations = atlasClassification.getRemovePropagationsOnEntityDelete();
            if (updatedRemovePropagations != null && updatedRemovePropagations != currentRemovePropagations) {
                AtlasGraphUtilsV2.setEncodedProperty(classificationVertex, Constants.CLASSIFICATION_VERTEX_REMOVE_PROPAGATIONS_KEY, updatedRemovePropagations);
                isClassificationUpdated = true;
            }
            if (isClassificationUpdated) {
                List<AtlasVertex> propagatedEntityVertices = GraphHelper.getAllPropagatedEntityVertices(classificationVertex);
                notificationVertices.addAll(propagatedEntityVertices);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("updating vertex {} for trait {}", (Object)GraphHelper.string(classificationVertex), (Object)classificationName);
            }
            this.mapClassification(EntityMutations.EntityOperation.UPDATE, context, atlasClassification, entityType, entityVertex, classificationVertex);
            GraphHelper.updateModificationMetadata(entityVertex);
            Boolean currentTagPropagation = currentClassification.isPropagate();
            Boolean updatedTagPropagation = atlasClassification.isPropagate();
            if (updatedTagPropagation != null && currentTagPropagation != updatedTagPropagation) {
                if (updatedTagPropagation.booleanValue()) {
                    if (CollectionUtils.isEmpty(entitiesToPropagateTo)) {
                        entitiesToPropagateTo = this.graphHelper.getImpactedVerticesWithRestrictions(guid, classificationVertex.getIdForDisplay());
                    }
                    if (CollectionUtils.isNotEmpty(entitiesToPropagateTo)) {
                        List<AtlasVertex> entitiesPropagatedTo;
                        if (addedPropagations == null) {
                            addedPropagations = new HashMap(entitiesToPropagateTo.size());
                            for (AtlasVertex atlasVertex : entitiesToPropagateTo) {
                                addedPropagations.put(atlasVertex, new ArrayList());
                            }
                        }
                        if ((entitiesPropagatedTo = this.deleteDelegate.getHandler().addTagPropagation(classificationVertex, entitiesToPropagateTo)) != null) {
                            for (AtlasVertex entityPropagatedTo : entitiesPropagatedTo) {
                                ((List)addedPropagations.get(entityPropagatedTo)).add(atlasClassification);
                            }
                        }
                    }
                } else {
                    List<AtlasVertex> impactedVertices = this.deleteDelegate.getHandler().removeTagPropagation(classificationVertex);
                    if (CollectionUtils.isNotEmpty(impactedVertices) && removedPropagations == null) {
                        removedPropagations = new HashMap<AtlasVertex, ArrayList<AtlasClassification>>();
                        for (AtlasVertex impactedVertex : impactedVertices) {
                            ArrayList<AtlasClassification> removedClassifications = (ArrayList<AtlasClassification>)removedPropagations.get(impactedVertex);
                            if (removedClassifications == null) {
                                removedClassifications = new ArrayList<AtlasClassification>();
                                removedPropagations.put(impactedVertex, removedClassifications);
                            }
                            removedClassifications.add(atlasClassification);
                        }
                    }
                }
            }
            updatedClassifications.add(currentClassification);
        }
        if (CollectionUtils.isNotEmpty(entitiesToPropagateTo)) {
            notificationVertices.addAll(entitiesToPropagateTo);
        }
        for (AtlasVertex atlasVertex : notificationVertices) {
            String entityGuid = GraphHelper.getGuid((AtlasElement)atlasVertex);
            AtlasEntity entity = this.instanceConverter.getAndCacheEntity(entityGuid);
            if (!GraphHelper.isActive(entity)) continue;
            this.entityChangeNotifier.onClassificationUpdatedToEntity(entity, updatedClassifications);
        }
        if (removedPropagations != null) {
            for (Map.Entry entry : removedPropagations.entrySet()) {
                AtlasVertex vertex = (AtlasVertex)entry.getKey();
                List removedClassifications = (List)entry.getValue();
                String entityGuid = GraphHelper.getGuid((AtlasElement)vertex);
                AtlasEntity entity = this.instanceConverter.getAndCacheEntity(entityGuid);
                if (!GraphHelper.isActive(entity)) continue;
                this.entityChangeNotifier.onClassificationDeletedFromEntity(entity, removedClassifications);
            }
        }
    }

    private AtlasEdge mapClassification(EntityMutations.EntityOperation operation, EntityMutationContext context, AtlasClassification classification, AtlasEntityType entityType, AtlasVertex parentInstanceVertex, AtlasVertex traitInstanceVertex) throws AtlasBaseException {
        if (classification.getValidityPeriods() != null) {
            String strValidityPeriods = AtlasJson.toJson((Object)classification.getValidityPeriods());
            AtlasGraphUtilsV2.setEncodedProperty(traitInstanceVertex, Constants.CLASSIFICATION_VALIDITY_PERIODS_KEY, strValidityPeriods);
        }
        if (classification.isPropagate() != null) {
            AtlasGraphUtilsV2.setEncodedProperty(traitInstanceVertex, Constants.CLASSIFICATION_VERTEX_PROPAGATE_KEY, classification.isPropagate());
        }
        if (classification.getRemovePropagationsOnEntityDelete() != null) {
            AtlasGraphUtilsV2.setEncodedProperty(traitInstanceVertex, Constants.CLASSIFICATION_VERTEX_REMOVE_PROPAGATIONS_KEY, classification.getRemovePropagationsOnEntityDelete());
        }
        this.mapAttributes((AtlasStruct)classification, traitInstanceVertex, operation, context);
        AtlasEdge ret = GraphHelper.getClassificationEdge(parentInstanceVertex, traitInstanceVertex);
        if (ret == null) {
            ret = this.graphHelper.addClassificationEdge(parentInstanceVertex, traitInstanceVertex, false);
        }
        return ret;
    }

    public void deleteClassifications(String guid) throws AtlasBaseException {
        AtlasVertex instanceVertex = AtlasGraphUtilsV2.findByGuid(guid);
        if (instanceVertex == null) {
            throw new AtlasBaseException(AtlasErrorCode.INSTANCE_GUID_NOT_FOUND, new String[]{guid});
        }
        List<String> traitNames = GraphHelper.getTraitNames(instanceVertex);
        if (CollectionUtils.isNotEmpty(traitNames)) {
            for (String traitName : traitNames) {
                this.deleteClassification(guid, traitName);
            }
        }
    }

    private void updateTraitNamesProperty(AtlasVertex entityVertex, List<String> traitNames) {
        if (entityVertex != null) {
            entityVertex.removeProperty(Constants.TRAIT_NAMES_PROPERTY_KEY);
            for (String traitName : traitNames) {
                AtlasGraphUtilsV2.addEncodedProperty(entityVertex, Constants.TRAIT_NAMES_PROPERTY_KEY, traitName);
            }
        }
    }

    private void validateClassificationExists(List<String> existingClassifications, List<String> suppliedClassifications) throws AtlasBaseException {
        HashSet<String> existingNames = new HashSet<String>(existingClassifications);
        for (String classificationName : suppliedClassifications) {
            if (existingNames.contains(classificationName)) continue;
            throw new AtlasBaseException(AtlasErrorCode.CLASSIFICATION_NOT_ASSOCIATED_WITH_ENTITY, new String[]{classificationName});
        }
    }

    private void validateClassificationExists(List<String> existingClassifications, String suppliedClassificationName) throws AtlasBaseException {
        if (!existingClassifications.contains(suppliedClassificationName)) {
            throw new AtlasBaseException(AtlasErrorCode.CLASSIFICATION_NOT_ASSOCIATED_WITH_ENTITY, new String[]{suppliedClassificationName});
        }
    }

    private AtlasEdge getOrCreateRelationship(AtlasVertex end1Vertex, AtlasVertex end2Vertex, String relationshipName, Map<String, Object> relationshipAttributes) throws AtlasBaseException {
        return this.relationshipStore.getOrCreate(end1Vertex, end2Vertex, new AtlasRelationship(relationshipName, relationshipAttributes));
    }

    private void recordEntityUpdate(AtlasVertex vertex) throws AtlasBaseException {
        RequestContext req = RequestContext.get();
        if (!req.isUpdatedEntity(GraphHelper.getGuid((AtlasElement)vertex))) {
            GraphHelper.updateModificationMetadata(vertex);
            req.recordEntityUpdate(this.entityRetriever.toAtlasEntityHeader(vertex));
        }
    }

    private String getIdFromInVertex(AtlasEdge edge) {
        return AtlasGraphUtilsV2.getIdFromVertex(edge.getInVertex());
    }

    private String getIdFromOutVertex(AtlasEdge edge) {
        return AtlasGraphUtilsV2.getIdFromVertex(edge.getOutVertex());
    }

    private String getIdFromBothVertex(AtlasEdge currentEdge, AtlasVertex parentEntityVertex) {
        String parentEntityId = AtlasGraphUtilsV2.getIdFromVertex(parentEntityVertex);
        String currentEntityId = AtlasGraphUtilsV2.getIdFromVertex(currentEdge.getInVertex());
        if (StringUtils.equals((CharSequence)currentEntityId, (CharSequence)parentEntityId)) {
            currentEntityId = this.getIdFromOutVertex(currentEdge);
        }
        return currentEntityId;
    }

    public void validateAndNormalizeForUpdate(AtlasClassification classification) throws AtlasBaseException {
        AtlasClassificationType type = this.typeRegistry.getClassificationTypeByName(classification.getTypeName());
        if (type == null) {
            throw new AtlasBaseException(AtlasErrorCode.CLASSIFICATION_NOT_FOUND, new String[]{classification.getTypeName()});
        }
        ArrayList messages = new ArrayList();
        type.validateValueForUpdate((Object)classification, classification.getTypeName(), messages);
        if (!messages.isEmpty()) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, messages);
        }
        type.getNormalizedValueForUpdate((Object)classification);
    }

    public static String getSoftRefFormattedValue(AtlasObjectId objectId) {
        return EntityGraphMapper.getSoftRefFormattedString(objectId.getTypeName(), objectId.getGuid());
    }

    private static String getSoftRefFormattedString(String typeName, String resolvedGuid) {
        return String.format(SOFT_REF_FORMAT, typeName, resolvedGuid);
    }
}

