/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.RequestContext;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.impexp.AtlasImportResult;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.EntityMutationResponse;
import org.apache.atlas.repository.store.graph.AtlasEntityStore;
import org.apache.atlas.repository.store.graph.BulkImporter;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityStoreV2;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityStreamForImport;
import org.apache.atlas.repository.store.graph.v2.EntityImportStream;
import org.apache.atlas.repository.store.graph.v2.EntityStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BulkImporterImpl
implements BulkImporter {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasEntityStoreV2.class);
    private final AtlasEntityStore entityStore;

    @Inject
    public BulkImporterImpl(AtlasEntityStore entityStore) {
        this.entityStore = entityStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EntityMutationResponse bulkImport(EntityImportStream entityStream, AtlasImportResult importResult) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> bulkImport()");
        }
        if (entityStream == null || !entityStream.hasNext()) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"no entities to create/update."});
        }
        EntityMutationResponse ret = new EntityMutationResponse();
        ret.setGuidAssignments(new HashMap());
        HashSet<String> processedGuids = new HashSet<String>();
        float currentPercent = 0.0f;
        ArrayList<String> residualList = new ArrayList<String>();
        EntityImportStreamWithResidualList entityImportStreamWithResidualList = new EntityImportStreamWithResidualList(entityStream, residualList);
        while (entityImportStreamWithResidualList.hasNext()) {
            AtlasEntity entity;
            AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = entityImportStreamWithResidualList.getNextEntityWithExtInfo();
            AtlasEntity atlasEntity = entity = entityWithExtInfo != null ? entityWithExtInfo.getEntity() : null;
            if (entity == null) continue;
            AtlasEntityStreamForImport oneEntityStream = new AtlasEntityStreamForImport(entityWithExtInfo, (EntityStream)entityStream);
            try {
                EntityMutationResponse resp = this.entityStore.createOrUpdateForImport(oneEntityStream);
                if (resp.getGuidAssignments() != null) {
                    ret.getGuidAssignments().putAll(resp.getGuidAssignments());
                }
                currentPercent = this.updateImportMetrics(entityWithExtInfo, resp, importResult, processedGuids, entityStream.getPosition(), entityImportStreamWithResidualList.getStreamSize(), currentPercent);
                entityStream.onImportComplete(entity.getGuid());
            }
            catch (AtlasBaseException e) {
                if (this.updateResidualList(e, residualList, entityWithExtInfo.getEntity().getGuid())) continue;
                throw e;
            }
            catch (Throwable e) {
                AtlasBaseException abe = new AtlasBaseException(e);
                if (this.updateResidualList(abe, residualList, entityWithExtInfo.getEntity().getGuid())) continue;
                throw abe;
            }
            finally {
                RequestContext.get().clearCache();
            }
        }
        importResult.getProcessedEntities().addAll(processedGuids);
        LOG.info("bulkImport(): done. Total number of entities (including referred entities) imported: {}", (Object)processedGuids.size());
        return ret;
    }

    private boolean updateResidualList(AtlasBaseException e, List<String> lineageList, String guid) {
        if (!e.getAtlasErrorCode().getErrorCode().equals(AtlasErrorCode.INVALID_OBJECT_ID.getErrorCode())) {
            return false;
        }
        lineageList.add(guid);
        return true;
    }

    private float updateImportMetrics(AtlasEntity.AtlasEntityWithExtInfo currentEntity, EntityMutationResponse resp, AtlasImportResult importResult, Set<String> processedGuids, int currentIndex, int streamSize, float currentPercent) {
        BulkImporterImpl.updateImportMetrics("entity:%s:created", resp.getCreatedEntities(), processedGuids, importResult);
        BulkImporterImpl.updateImportMetrics("entity:%s:updated", resp.getUpdatedEntities(), processedGuids, importResult);
        BulkImporterImpl.updateImportMetrics("entity:%s:deleted", resp.getDeletedEntities(), processedGuids, importResult);
        String lastEntityImported = String.format("entity:last-imported:%s:[%s]:(%s)", currentEntity.getEntity().getTypeName(), currentIndex, currentEntity.getEntity().getGuid());
        return BulkImporterImpl.updateImportProgress(LOG, currentIndex, streamSize, currentPercent, lastEntityImported);
    }

    @VisibleForTesting
    static float updateImportProgress(Logger log, int currentIndex, int streamSize, float currentPercent, String additionalInfo) {
        float updatedPercent;
        boolean updateLog;
        double tolerance = 1.0E-6;
        int MAX_PERCENT = 100;
        int maxSize = currentIndex <= streamSize ? streamSize : currentIndex;
        float percent = currentIndex * 100 / maxSize;
        boolean bl = updateLog = (double)Double.compare(percent, currentPercent) > 1.0E-6;
        float f = 100 < maxSize ? percent : (updatedPercent = updateLog ? (currentPercent = currentPercent + 1.0f) : currentPercent);
        if (updateLog) {
            log.info("bulkImport(): progress: {}% (of {}) - {}", new Object[]{(int)Math.ceil(percent), maxSize, additionalInfo});
        }
        return updatedPercent;
    }

    private static void updateImportMetrics(String prefix, List<AtlasEntityHeader> list, Set<String> processedGuids, AtlasImportResult importResult) {
        if (list == null) {
            return;
        }
        for (AtlasEntityHeader h : list) {
            if (processedGuids.contains(h.getGuid())) continue;
            processedGuids.add(h.getGuid());
            importResult.incrementMeticsCounter(String.format(prefix, h.getTypeName()));
        }
    }

    private static class EntityImportStreamWithResidualList {
        private final EntityImportStream stream;
        private final List<String> residualList;
        private boolean navigateResidualList;
        private int currentResidualListIndex;

        public EntityImportStreamWithResidualList(EntityImportStream stream, List<String> residualList) {
            this.stream = stream;
            this.residualList = residualList;
            this.navigateResidualList = false;
            this.currentResidualListIndex = 0;
        }

        public AtlasEntity.AtlasEntityWithExtInfo getNextEntityWithExtInfo() {
            if (!this.navigateResidualList) {
                return this.stream.getNextEntityWithExtInfo();
            }
            this.stream.setPositionUsingEntityGuid(this.residualList.get(this.currentResidualListIndex++));
            return this.stream.getNextEntityWithExtInfo();
        }

        public boolean hasNext() {
            if (!this.navigateResidualList) {
                boolean streamHasNext = this.stream.hasNext();
                boolean bl = this.navigateResidualList = !streamHasNext;
                return streamHasNext ? streamHasNext : this.currentResidualListIndex < this.residualList.size();
            }
            return this.currentResidualListIndex < this.residualList.size();
        }

        public int getStreamSize() {
            return this.stream.size() + this.residualList.size();
        }
    }
}

