/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2;

import java.util.Objects;
import org.apache.atlas.model.instance.EntityMutations;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.repository.graphdb.AtlasEdge;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;

public class AttributeMutationContext {
    private EntityMutations.EntityOperation op;
    private AtlasStructType.AtlasAttribute attribute;
    private AtlasType currentElementType;
    private Object value;
    private String vertexProperty;
    AtlasVertex referringVertex;
    AtlasEdge existingEdge;

    public AttributeMutationContext(EntityMutations.EntityOperation op, AtlasVertex referringVertex, AtlasStructType.AtlasAttribute attribute, Object value) {
        this(op, referringVertex, attribute, value, attribute.getVertexPropertyName(), null, null);
    }

    public AttributeMutationContext(EntityMutations.EntityOperation op, AtlasVertex referringVertex, AtlasStructType.AtlasAttribute attribute, Object value, String vertexProperty, AtlasType currentElementType, AtlasEdge currentEdge) {
        this.op = op;
        this.referringVertex = referringVertex;
        this.attribute = attribute;
        this.value = value;
        this.vertexProperty = vertexProperty;
        this.currentElementType = currentElementType;
        this.existingEdge = currentEdge;
    }

    public int hashCode() {
        return Objects.hash(this.op, this.referringVertex, this.attribute, this.value, this.vertexProperty, this.currentElementType, this.existingEdge);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AttributeMutationContext rhs = (AttributeMutationContext)obj;
        return Objects.equals(this.op, rhs.op) && Objects.equals(this.referringVertex, rhs.referringVertex) && Objects.equals(this.attribute, rhs.attribute) && Objects.equals(this.value, rhs.value) && Objects.equals(this.vertexProperty, rhs.vertexProperty) && Objects.equals(this.currentElementType, rhs.currentElementType) && Objects.equals(this.existingEdge, rhs.existingEdge);
    }

    public AtlasStructType getParentType() {
        return this.attribute.getDefinedInType();
    }

    public AtlasStructDef getStructDef() {
        return this.attribute.getDefinedInDef();
    }

    public AtlasStructDef.AtlasAttributeDef getAttributeDef() {
        return this.attribute.getAttributeDef();
    }

    public AtlasType getAttrType() {
        return this.currentElementType == null ? this.attribute.getAttributeType() : this.currentElementType;
    }

    public AtlasType getCurrentElementType() {
        return this.currentElementType;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getVertexProperty() {
        return this.vertexProperty;
    }

    public AtlasVertex getReferringVertex() {
        return this.referringVertex;
    }

    public AtlasEdge getCurrentEdge() {
        return this.existingEdge;
    }

    public void setElementType(AtlasType attrType) {
        this.currentElementType = attrType;
    }

    public AtlasStructType.AtlasAttribute getAttribute() {
        return this.attribute;
    }

    public EntityMutations.EntityOperation getOp() {
        return this.op;
    }

    public void setExistingEdge(AtlasEdge existingEdge) {
        this.existingEdge = existingEdge;
    }
}

