/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.inject.Inject;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.annotation.GraphTransaction;
import org.apache.atlas.authorize.AtlasAuthorizationUtils;
import org.apache.atlas.authorize.AtlasPrivilege;
import org.apache.atlas.authorize.AtlasRelationshipAccessRequest;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.instance.AtlasRelationship;
import org.apache.atlas.model.typedef.AtlasRelationshipDef;
import org.apache.atlas.model.typedef.AtlasRelationshipEndDef;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.RepositoryException;
import org.apache.atlas.repository.graph.GraphHelper;
import org.apache.atlas.repository.graphdb.AtlasEdge;
import org.apache.atlas.repository.graphdb.AtlasEdgeDirection;
import org.apache.atlas.repository.graphdb.AtlasElement;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.AtlasRelationshipStore;
import org.apache.atlas.repository.store.graph.v1.DeleteHandlerDelegate;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityChangeNotifier;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.repository.store.graph.v2.EntityGraphRetriever;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasRelationshipType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.type.AtlasTypeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AtlasRelationshipStoreV2
implements AtlasRelationshipStore {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasRelationshipStoreV2.class);
    private static final Long DEFAULT_RELATIONSHIP_VERSION = 0L;
    private final AtlasTypeRegistry typeRegistry;
    private final EntityGraphRetriever entityRetriever;
    private final DeleteHandlerDelegate deleteDelegate;
    private final GraphHelper graphHelper = GraphHelper.getInstance();
    private final AtlasEntityChangeNotifier entityChangeNotifier;

    @Inject
    public AtlasRelationshipStoreV2(AtlasTypeRegistry typeRegistry, DeleteHandlerDelegate deleteDelegate, AtlasEntityChangeNotifier entityChangeNotifier) {
        this.typeRegistry = typeRegistry;
        this.entityRetriever = new EntityGraphRetriever(typeRegistry);
        this.deleteDelegate = deleteDelegate;
        this.entityChangeNotifier = entityChangeNotifier;
    }

    @Override
    @GraphTransaction
    public AtlasRelationship create(AtlasRelationship relationship) throws AtlasBaseException {
        AtlasVertex end2Vertex;
        AtlasVertex end1Vertex;
        AtlasEdge edge;
        AtlasRelationship ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> create({})", (Object)relationship);
        }
        AtlasRelationship atlasRelationship = ret = (edge = this.createRelationship(end1Vertex = this.getVertexFromEndPoint(relationship.getEnd1()), end2Vertex = this.getVertexFromEndPoint(relationship.getEnd2()), relationship)) != null ? this.entityRetriever.mapEdgeToAtlasRelationship(edge) : null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== create({}): {}", (Object)relationship, (Object)ret);
        }
        this.entityChangeNotifier.notifyPropagatedEntities();
        return ret;
    }

    @Override
    @GraphTransaction
    public AtlasRelationship update(AtlasRelationship relationship) throws AtlasBaseException {
        String guid;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> update({})", (Object)relationship);
        }
        if (StringUtils.isEmpty((String)(guid = relationship.getGuid()))) {
            throw new AtlasBaseException(AtlasErrorCode.RELATIONSHIP_GUID_NOT_FOUND, new String[]{guid});
        }
        AtlasEdge edge = this.graphHelper.getEdgeForGUID(guid);
        String edgeType = AtlasGraphUtilsV2.getTypeName((AtlasElement)edge);
        AtlasVertex end1Vertex = edge.getOutVertex();
        AtlasVertex end2Vertex = edge.getInVertex();
        if (StringUtils.isNotEmpty((String)relationship.getTypeName()) && !StringUtils.equalsIgnoreCase((String)edgeType, (String)relationship.getTypeName())) {
            throw new AtlasBaseException(AtlasErrorCode.RELATIONSHIP_UPDATE_TYPE_CHANGE_NOT_ALLOWED, new String[]{guid, edgeType, relationship.getTypeName()});
        }
        if (relationship.getEnd1() != null) {
            String updatedEnd1Guid = relationship.getEnd1().getGuid();
            if (updatedEnd1Guid == null) {
                AtlasVertex updatedEnd1Vertex = this.getVertexFromEndPoint(relationship.getEnd1());
                String string = updatedEnd1Guid = updatedEnd1Vertex == null ? null : AtlasGraphUtilsV2.getIdFromVertex(updatedEnd1Vertex);
            }
            if (updatedEnd1Guid != null) {
                String end1Guid = AtlasGraphUtilsV2.getIdFromVertex(end1Vertex);
                if (!StringUtils.equalsIgnoreCase((String)relationship.getEnd1().getGuid(), (String)end1Guid)) {
                    throw new AtlasBaseException(AtlasErrorCode.RELATIONSHIP_UPDATE_END_CHANGE_NOT_ALLOWED, new String[]{edgeType, guid, end1Guid, relationship.getEnd1().getGuid()});
                }
            }
        }
        if (relationship.getEnd2() != null) {
            String updatedEnd2Guid = relationship.getEnd2().getGuid();
            if (updatedEnd2Guid == null) {
                AtlasVertex updatedEnd2Vertex = this.getVertexFromEndPoint(relationship.getEnd2());
                String string = updatedEnd2Guid = updatedEnd2Vertex == null ? null : AtlasGraphUtilsV2.getIdFromVertex(updatedEnd2Vertex);
            }
            if (updatedEnd2Guid != null) {
                String end2Guid = AtlasGraphUtilsV2.getIdFromVertex(end2Vertex);
                if (!StringUtils.equalsIgnoreCase((String)relationship.getEnd2().getGuid(), (String)end2Guid)) {
                    throw new AtlasBaseException(AtlasErrorCode.RELATIONSHIP_UPDATE_END_CHANGE_NOT_ALLOWED, new String[]{AtlasGraphUtilsV2.getTypeName((AtlasElement)edge), guid, end2Guid, relationship.getEnd2().getGuid()});
                }
            }
        }
        this.validateRelationship(end1Vertex, end2Vertex, edgeType, relationship.getAttributes());
        AtlasRelationship ret = this.updateRelationship(edge, relationship);
        this.entityChangeNotifier.notifyPropagatedEntities();
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== update({}): {}", (Object)relationship, (Object)ret);
        }
        return ret;
    }

    @Override
    @GraphTransaction
    public AtlasRelationship getById(String guid) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getById({})", (Object)guid);
        }
        AtlasEdge edge = this.graphHelper.getEdgeForGUID(guid);
        AtlasRelationship ret = this.entityRetriever.mapEdgeToAtlasRelationship(edge);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getById({}): {}", (Object)guid, (Object)ret);
        }
        return ret;
    }

    @Override
    @GraphTransaction
    public AtlasRelationship.AtlasRelationshipWithExtInfo getExtInfoById(String guid) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getExtInfoById({})", (Object)guid);
        }
        AtlasEdge edge = this.graphHelper.getEdgeForGUID(guid);
        AtlasRelationship.AtlasRelationshipWithExtInfo ret = this.entityRetriever.mapEdgeToAtlasRelationshipWithExtInfo(edge);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getExtInfoById({}): {}", (Object)guid, (Object)ret);
        }
        return ret;
    }

    @Override
    @GraphTransaction
    public void deleteById(String guid) throws AtlasBaseException {
        this.deleteById(guid, false);
    }

    @Override
    @GraphTransaction
    public void deleteById(String guid, boolean forceDelete) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> deleteById({}, {})", (Object)guid, (Object)forceDelete);
        }
        if (StringUtils.isEmpty((String)guid)) {
            throw new AtlasBaseException(AtlasErrorCode.RELATIONSHIP_CRUD_INVALID_PARAMS, new String[]{" empty/null guid"});
        }
        AtlasEdge edge = this.graphHelper.getEdgeForGUID(guid);
        if (edge == null) {
            throw new AtlasBaseException(AtlasErrorCode.RELATIONSHIP_GUID_NOT_FOUND, new String[]{guid});
        }
        if (AtlasGraphUtilsV2.getState((AtlasElement)edge) == AtlasEntity.Status.DELETED) {
            throw new AtlasBaseException(AtlasErrorCode.RELATIONSHIP_ALREADY_DELETED, new String[]{guid});
        }
        String relationShipType = GraphHelper.getTypeName((AtlasElement)edge);
        AtlasEntityHeader end1Entity = this.entityRetriever.toAtlasEntityHeaderWithClassifications(edge.getOutVertex());
        AtlasEntityHeader end2Entity = this.entityRetriever.toAtlasEntityHeaderWithClassifications(edge.getInVertex());
        AtlasAuthorizationUtils.verifyAccess((AtlasRelationshipAccessRequest)new AtlasRelationshipAccessRequest(this.typeRegistry, AtlasPrivilege.RELATIONSHIP_REMOVE, relationShipType, end1Entity, end2Entity), (Object[])new Object[0]);
        this.deleteDelegate.getHandler().deleteRelationships(Collections.singleton(edge), forceDelete);
        this.entityChangeNotifier.notifyPropagatedEntities();
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== deleteById({}): {}", (Object)guid);
        }
    }

    @Override
    public AtlasEdge getOrCreate(AtlasVertex end1Vertex, AtlasVertex end2Vertex, AtlasRelationship relationship) throws AtlasBaseException {
        AtlasEdge ret = this.getRelationship(end1Vertex, end2Vertex, relationship);
        if (ret == null) {
            ret = this.createRelationship(end1Vertex, end2Vertex, relationship, false);
        }
        return ret;
    }

    @Override
    public AtlasEdge getRelationship(AtlasVertex fromVertex, AtlasVertex toVertex, AtlasRelationship relationship) throws AtlasBaseException {
        String relationshipLabel = this.getRelationshipEdgeLabel(fromVertex, toVertex, relationship.getTypeName());
        return this.getRelationshipEdge(fromVertex, toVertex, relationshipLabel);
    }

    @Override
    public AtlasRelationship getOrCreate(AtlasRelationship relationship) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getOrCreate({})", (Object)relationship);
        }
        AtlasVertex end1Vertex = this.getVertexFromEndPoint(relationship.getEnd1());
        AtlasVertex end2Vertex = this.getVertexFromEndPoint(relationship.getEnd2());
        AtlasRelationship ret = null;
        AtlasEdge relationshipEdge = this.getRelationship(end1Vertex, end2Vertex, relationship);
        if (relationshipEdge == null) {
            relationshipEdge = this.createRelationship(end1Vertex, end2Vertex, relationship, false);
        }
        if (relationshipEdge != null) {
            ret = this.entityRetriever.mapEdgeToAtlasRelationship(relationshipEdge);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getOrCreate({}): {}", (Object)relationship, (Object)ret);
        }
        return ret;
    }

    @Override
    public AtlasEdge createRelationship(AtlasVertex end1Vertex, AtlasVertex end2Vertex, AtlasRelationship relationship) throws AtlasBaseException {
        return this.createRelationship(end1Vertex, end2Vertex, relationship, true);
    }

    public AtlasEdge createRelationship(AtlasVertex end1Vertex, AtlasVertex end2Vertex, AtlasRelationship relationship, boolean existingRelationshipCheck) throws AtlasBaseException {
        AtlasEdge ret;
        try {
            this.validateRelationship(end1Vertex, end2Vertex, relationship.getTypeName(), relationship.getAttributes());
            String relationshipLabel = this.getRelationshipEdgeLabel(end1Vertex, end2Vertex, relationship.getTypeName());
            if (existingRelationshipCheck && (ret = this.getRelationshipEdge(end1Vertex, end2Vertex, relationshipLabel)) != null) {
                throw new AtlasBaseException(AtlasErrorCode.RELATIONSHIP_ALREADY_EXISTS, new String[]{relationship.getTypeName(), AtlasGraphUtilsV2.getIdFromVertex(end1Vertex), AtlasGraphUtilsV2.getIdFromVertex(end2Vertex)});
            }
            AtlasRelationshipType relationType = this.typeRegistry.getRelationshipTypeByName(relationship.getTypeName());
            if (!relationType.hasLegacyAttributeEnd()) {
                AtlasEntityHeader end1Entity = this.entityRetriever.toAtlasEntityHeaderWithClassifications(end1Vertex);
                AtlasEntityHeader end2Entity = this.entityRetriever.toAtlasEntityHeaderWithClassifications(end2Vertex);
                AtlasAuthorizationUtils.verifyAccess((AtlasRelationshipAccessRequest)new AtlasRelationshipAccessRequest(this.typeRegistry, AtlasPrivilege.RELATIONSHIP_ADD, relationship.getTypeName(), end1Entity, end2Entity), (Object[])new Object[0]);
            }
            if (existingRelationshipCheck) {
                ret = this.graphHelper.getOrCreateEdge(end1Vertex, end2Vertex, relationshipLabel);
            } else {
                ret = this.graphHelper.addEdge(end1Vertex, end2Vertex, relationshipLabel);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Created relationship edge from [{}] --> [{}] using edge label: [{}]", new Object[]{AtlasGraphUtilsV2.getTypeName((AtlasElement)end1Vertex), AtlasGraphUtilsV2.getTypeName((AtlasElement)end2Vertex), relationshipLabel});
                }
            }
            if (ret != null) {
                String relationshipGuid = relationship.getGuid();
                AtlasRelationshipDef.PropagateTags tagPropagation = this.getRelationshipTagPropagation(end1Vertex, end2Vertex, relationship);
                String guid = AtlasTypeUtil.isAssignedGuid((String)relationshipGuid) ? relationshipGuid : UUID.randomUUID().toString();
                AtlasGraphUtilsV2.setEncodedProperty(ret, Constants.ENTITY_TYPE_PROPERTY_KEY, relationship.getTypeName());
                AtlasGraphUtilsV2.setEncodedProperty(ret, Constants.RELATIONSHIP_GUID_PROPERTY_KEY, guid);
                AtlasGraphUtilsV2.setEncodedProperty(ret, Constants.VERSION_PROPERTY_KEY, this.getRelationshipVersion(relationship));
                AtlasGraphUtilsV2.setEncodedProperty(ret, Constants.PROVENANCE_TYPE_KEY, relationship.getProvenanceType());
                AtlasGraphUtilsV2.setEncodedProperty(ret, Constants.RELATIONSHIPTYPE_TAG_PROPAGATION_KEY, tagPropagation.name());
                this.handleBlockedClassifications(ret, relationship.getBlockedPropagatedClassifications());
                this.deleteDelegate.getHandler().addTagPropagation(ret, tagPropagation);
            }
            if (MapUtils.isNotEmpty((Map)relationType.getAllAttributes())) {
                for (AtlasStructType.AtlasAttribute attr : relationType.getAllAttributes().values()) {
                    String attrName = attr.getName();
                    String attrVertexProperty = attr.getVertexPropertyName();
                    Object attrValue = relationship.getAttribute(attrName);
                    AtlasGraphUtilsV2.setEncodedProperty(ret, attrVertexProperty, attrValue);
                }
            }
        }
        catch (RepositoryException e) {
            throw new AtlasBaseException(AtlasErrorCode.INTERNAL_ERROR, (Throwable)((Object)e), new String[0]);
        }
        return ret;
    }

    private AtlasRelationship updateRelationship(AtlasEdge relationshipEdge, AtlasRelationship relationship) throws AtlasBaseException {
        AtlasRelationshipType relationType = this.typeRegistry.getRelationshipTypeByName(relationship.getTypeName());
        AtlasVertex end1Vertex = relationshipEdge.getOutVertex();
        AtlasVertex end2Vertex = relationshipEdge.getInVertex();
        AtlasEntityHeader end1Entity = this.entityRetriever.toAtlasEntityHeaderWithClassifications(end1Vertex);
        AtlasEntityHeader end2Entity = this.entityRetriever.toAtlasEntityHeaderWithClassifications(end2Vertex);
        AtlasAuthorizationUtils.verifyAccess((AtlasRelationshipAccessRequest)new AtlasRelationshipAccessRequest(this.typeRegistry, AtlasPrivilege.RELATIONSHIP_UPDATE, relationship.getTypeName(), end1Entity, end2Entity), (Object[])new Object[0]);
        this.updateTagPropagations(relationshipEdge, relationship);
        if (MapUtils.isNotEmpty((Map)relationType.getAllAttributes())) {
            for (AtlasStructType.AtlasAttribute attr : relationType.getAllAttributes().values()) {
                Object attrValue;
                String attrName = attr.getName();
                String attrVertexProperty = attr.getVertexPropertyName();
                if (relationship.hasAttribute(attrName)) {
                    AtlasGraphUtilsV2.setEncodedProperty(relationshipEdge, attrVertexProperty, relationship.getAttribute(attrName));
                    continue;
                }
                String defaultValue = attr.getAttributeDef().getDefaultValue();
                if (!StringUtils.isNotEmpty((String)defaultValue) || (attrValue = attr.getAttributeType().createDefaultValue((Object)defaultValue)) == null) continue;
                AtlasGraphUtilsV2.setEncodedProperty(relationshipEdge, attrVertexProperty, attrValue);
            }
        }
        return this.entityRetriever.mapEdgeToAtlasRelationship(relationshipEdge);
    }

    private void handleBlockedClassifications(AtlasEdge edge, Set<AtlasClassification> blockedPropagatedClassifications) throws AtlasBaseException {
        if (blockedPropagatedClassifications != null) {
            List<AtlasVertex> propagatedClassificationVertices = GraphHelper.getClassificationVertices(edge);
            List<String> currentClassificationIds = GraphHelper.getBlockedClassificationIds(edge);
            List<AtlasVertex> currentBlockedPropagatedClassificationVertices = this.getBlockedClassificationVertices(propagatedClassificationVertices, currentClassificationIds);
            ArrayList<AtlasVertex> updatedBlockedPropagatedClassificationVertices = new ArrayList<AtlasVertex>();
            ArrayList<String> updatedClassificationIds = new ArrayList<String>();
            for (AtlasClassification atlasClassification : blockedPropagatedClassifications) {
                AtlasVertex classificationVertex = this.validateBlockedPropagatedClassification(propagatedClassificationVertices, atlasClassification);
                if (classificationVertex == null) continue;
                updatedBlockedPropagatedClassificationVertices.add(classificationVertex);
                String classificationId = classificationVertex.getIdForDisplay();
                updatedClassificationIds.add(classificationId);
            }
            this.addToBlockedClassificationIds(edge, updatedClassificationIds);
            List addedBlockedClassifications = (List)CollectionUtils.subtract(updatedBlockedPropagatedClassificationVertices, currentBlockedPropagatedClassificationVertices);
            for (AtlasVertex classificationVertex : addedBlockedClassifications) {
                List<AtlasVertex> removePropagationFromVertices = this.graphHelper.getPropagatedEntityVertices(classificationVertex);
                this.deleteDelegate.getHandler().removeTagPropagation(classificationVertex, removePropagationFromVertices);
            }
            List list = (List)CollectionUtils.subtract(currentBlockedPropagatedClassificationVertices, updatedBlockedPropagatedClassificationVertices);
            for (AtlasVertex classificationVertex : list) {
                List<AtlasVertex> addPropagationToVertices = this.graphHelper.getPropagatedEntityVertices(classificationVertex);
                this.deleteDelegate.getHandler().addTagPropagation(classificationVertex, addPropagationToVertices);
            }
        }
    }

    private List<AtlasVertex> getBlockedClassificationVertices(List<AtlasVertex> classificationVertices, List<String> blockedClassificationIds) {
        ArrayList<AtlasVertex> ret = new ArrayList<AtlasVertex>();
        if (CollectionUtils.isNotEmpty(blockedClassificationIds)) {
            for (AtlasVertex classificationVertex : classificationVertices) {
                String classificationId = classificationVertex.getIdForDisplay();
                if (!blockedClassificationIds.contains(classificationId)) continue;
                ret.add(classificationVertex);
            }
        }
        return ret;
    }

    private AtlasVertex validateBlockedPropagatedClassification(List<AtlasVertex> classificationVertices, AtlasClassification classification) {
        AtlasVertex ret = null;
        for (AtlasVertex vertex : classificationVertices) {
            String classificationName = GraphHelper.getClassificationName(vertex);
            String entityGuid = GraphHelper.getClassificationEntityGuid(vertex);
            if (!classificationName.equals(classification.getTypeName()) || !entityGuid.equals(classification.getEntityGuid())) continue;
            ret = vertex;
            break;
        }
        return ret;
    }

    private void addToBlockedClassificationIds(AtlasEdge edge, List<String> classificationIds) {
        if (edge != null) {
            if (classificationIds.isEmpty()) {
                edge.removeProperty(Constants.RELATIONSHIPTYPE_BLOCKED_PROPAGATED_CLASSIFICATIONS_KEY);
            } else {
                edge.setListProperty(Constants.RELATIONSHIPTYPE_BLOCKED_PROPAGATED_CLASSIFICATIONS_KEY, classificationIds);
            }
        }
    }

    private void updateTagPropagations(AtlasEdge edge, AtlasRelationship relationship) throws AtlasBaseException {
        AtlasRelationshipDef.PropagateTags oldTagPropagation = GraphHelper.getPropagateTags((AtlasElement)edge);
        AtlasRelationshipDef.PropagateTags newTagPropagation = relationship.getPropagateTags();
        if (newTagPropagation != oldTagPropagation) {
            List<AtlasVertex> currentClassificationVertices = GraphHelper.getClassificationVertices(edge);
            Map<AtlasVertex, List<AtlasVertex>> currentClassificationsMap = this.graphHelper.getClassificationPropagatedEntitiesMapping(currentClassificationVertices);
            AtlasGraphUtilsV2.setEncodedProperty(edge, Constants.RELATIONSHIPTYPE_TAG_PROPAGATION_KEY, newTagPropagation.name());
            List<AtlasVertex> updatedClassificationVertices = GraphHelper.getClassificationVertices(edge);
            List classificationVerticesUnion = (List)CollectionUtils.union(currentClassificationVertices, updatedClassificationVertices);
            Map<AtlasVertex, List<AtlasVertex>> updatedClassificationsMap = this.graphHelper.getClassificationPropagatedEntitiesMapping(classificationVerticesUnion);
            HashMap<AtlasVertex, List> addPropagationsMap = new HashMap<AtlasVertex, List>();
            HashMap<AtlasVertex, List> removePropagationsMap = new HashMap<AtlasVertex, List>();
            if (MapUtils.isEmpty(currentClassificationsMap) && MapUtils.isNotEmpty(updatedClassificationsMap)) {
                addPropagationsMap.putAll(updatedClassificationsMap);
            } else if (MapUtils.isNotEmpty(currentClassificationsMap) && MapUtils.isEmpty(updatedClassificationsMap)) {
                removePropagationsMap.putAll(currentClassificationsMap);
            } else {
                for (AtlasVertex classificationVertex : updatedClassificationsMap.keySet()) {
                    List currentPropagatingEntities = currentClassificationsMap.containsKey(classificationVertex) ? currentClassificationsMap.get(classificationVertex) : Collections.emptyList();
                    List updatedPropagatingEntities = updatedClassificationsMap.containsKey(classificationVertex) ? updatedClassificationsMap.get(classificationVertex) : Collections.emptyList();
                    List entitiesAdded = (List)CollectionUtils.subtract(updatedPropagatingEntities, currentPropagatingEntities);
                    List entitiesRemoved = (List)CollectionUtils.subtract(currentPropagatingEntities, updatedPropagatingEntities);
                    if (CollectionUtils.isNotEmpty((Collection)entitiesAdded)) {
                        addPropagationsMap.put(classificationVertex, entitiesAdded);
                    }
                    if (!CollectionUtils.isNotEmpty((Collection)entitiesRemoved)) continue;
                    removePropagationsMap.put(classificationVertex, entitiesRemoved);
                }
            }
            for (AtlasVertex classificationVertex : addPropagationsMap.keySet()) {
                this.deleteDelegate.getHandler().addTagPropagation(classificationVertex, (List)addPropagationsMap.get(classificationVertex));
            }
            for (AtlasVertex classificationVertex : removePropagationsMap.keySet()) {
                this.deleteDelegate.getHandler().removeTagPropagation(classificationVertex, (List)removePropagationsMap.get(classificationVertex));
            }
        } else {
            this.handleBlockedClassifications(edge, relationship.getBlockedPropagatedClassifications());
        }
    }

    private void validateRelationship(AtlasRelationship relationship) throws AtlasBaseException {
        if (relationship == null) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"AtlasRelationship is null"});
        }
        String relationshipName = relationship.getTypeName();
        String end1TypeName = this.getTypeNameFromObjectId(relationship.getEnd1());
        String end2TypeName = this.getTypeNameFromObjectId(relationship.getEnd2());
        AtlasRelationshipType relationshipType = this.typeRegistry.getRelationshipTypeByName(relationshipName);
        if (relationshipType == null) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_VALUE, new String[]{"unknown relationship type'" + relationshipName + "'"});
        }
        if (relationship.getEnd1() == null || relationship.getEnd2() == null) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"end1/end2 is null"});
        }
        boolean validEndTypes = false;
        if (relationshipType.getEnd1Type().isTypeOrSuperTypeOf(end1TypeName)) {
            validEndTypes = relationshipType.getEnd2Type().isTypeOrSuperTypeOf(end2TypeName);
        } else if (relationshipType.getEnd2Type().isTypeOrSuperTypeOf(end1TypeName)) {
            validEndTypes = relationshipType.getEnd1Type().isTypeOrSuperTypeOf(end2TypeName);
        }
        if (!validEndTypes) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_RELATIONSHIP_END_TYPE, new String[]{relationshipName, relationshipType.getEnd2Type().getTypeName(), end1TypeName});
        }
        this.validateEnds(relationship);
        this.validateAndNormalize(relationship);
    }

    private void validateRelationship(AtlasVertex end1Vertex, AtlasVertex end2Vertex, String relationshipName, Map<String, Object> attributes) throws AtlasBaseException {
        AtlasRelationshipType relationshipType = this.typeRegistry.getRelationshipTypeByName(relationshipName);
        if (relationshipType == null) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_VALUE, new String[]{"unknown relationship type'" + relationshipName + "'"});
        }
        if (end1Vertex == null) {
            throw new AtlasBaseException(AtlasErrorCode.RELATIONSHIP_END_IS_NULL, new String[]{relationshipType.getEnd1Type().getTypeName()});
        }
        if (end2Vertex == null) {
            throw new AtlasBaseException(AtlasErrorCode.RELATIONSHIP_END_IS_NULL, new String[]{relationshipType.getEnd2Type().getTypeName()});
        }
        String end1TypeName = AtlasGraphUtilsV2.getTypeName((AtlasElement)end1Vertex);
        String end2TypeName = AtlasGraphUtilsV2.getTypeName((AtlasElement)end2Vertex);
        boolean validEndTypes = false;
        if (relationshipType.getEnd1Type().isTypeOrSuperTypeOf(end1TypeName)) {
            validEndTypes = relationshipType.getEnd2Type().isTypeOrSuperTypeOf(end2TypeName);
        } else if (relationshipType.getEnd2Type().isTypeOrSuperTypeOf(end1TypeName)) {
            validEndTypes = relationshipType.getEnd1Type().isTypeOrSuperTypeOf(end2TypeName);
        }
        if (!validEndTypes) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_RELATIONSHIP_END_TYPE, new String[]{relationshipName, relationshipType.getEnd2Type().getTypeName(), end1TypeName});
        }
        ArrayList messages = new ArrayList();
        AtlasRelationship relationship = new AtlasRelationship(relationshipName, attributes);
        relationshipType.validateValue((Object)relationship, relationshipName, messages);
        if (!messages.isEmpty()) {
            throw new AtlasBaseException(AtlasErrorCode.RELATIONSHIP_CRUD_INVALID_PARAMS, messages);
        }
        relationshipType.getNormalizedValue((Object)relationship);
    }

    private void validateEnds(AtlasRelationship relationship) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("validateEnds entry relationship:" + relationship);
        }
        ArrayList<AtlasObjectId> ends = new ArrayList<AtlasObjectId>();
        ArrayList<AtlasRelationshipEndDef> endDefs = new ArrayList<AtlasRelationshipEndDef>();
        String relationshipTypeName = relationship.getTypeName();
        AtlasRelationshipDef relationshipDef = this.typeRegistry.getRelationshipDefByName(relationshipTypeName);
        ends.add(relationship.getEnd1());
        ends.add(relationship.getEnd2());
        endDefs.add(relationshipDef.getEndDef1());
        endDefs.add(relationshipDef.getEndDef2());
        for (int i = 0; i < ends.size(); ++i) {
            AtlasObjectId end = (AtlasObjectId)ends.get(i);
            String guid = end.getGuid();
            String typeName = end.getTypeName();
            Map uniqueAttributes = end.getUniqueAttributes();
            AtlasVertex endVertex = AtlasGraphUtilsV2.findByGuid(guid);
            if (!AtlasTypeUtil.isValidGuid((String)guid) || endVertex == null) {
                throw new AtlasBaseException(AtlasErrorCode.INSTANCE_GUID_NOT_FOUND, new String[]{guid});
            }
            if (MapUtils.isNotEmpty((Map)uniqueAttributes)) {
                AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(typeName);
                if (AtlasGraphUtilsV2.findByUniqueAttributes(entityType, uniqueAttributes) != null) continue;
                throw new AtlasBaseException(AtlasErrorCode.INSTANCE_BY_UNIQUE_ATTRIBUTE_NOT_FOUND, new String[]{typeName, uniqueAttributes.toString()});
            }
            String vertexTypeName = (String)endVertex.getProperty("__typeName", String.class);
            if (Objects.equals(vertexTypeName, typeName)) continue;
            String attrName = ((AtlasRelationshipEndDef)endDefs.get(i)).getName();
            throw new AtlasBaseException(AtlasErrorCode.RELATIONSHIP_INVALID_ENDTYPE, new String[]{attrName, guid, vertexTypeName, typeName});
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("validateEnds exit successfully validated relationship:" + relationship);
        }
    }

    private void validateAndNormalize(AtlasRelationship relationship) throws AtlasBaseException {
        ArrayList messages = new ArrayList();
        if (!AtlasTypeUtil.isValidGuid((String)relationship.getGuid())) {
            throw new AtlasBaseException(AtlasErrorCode.RELATIONSHIP_GUID_NOT_FOUND, new String[]{relationship.getGuid()});
        }
        AtlasRelationshipType type = this.typeRegistry.getRelationshipTypeByName(relationship.getTypeName());
        if (type == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_INVALID, new String[]{TypeCategory.RELATIONSHIP.name(), relationship.getTypeName()});
        }
        type.validateValue((Object)relationship, relationship.getTypeName(), messages);
        if (!messages.isEmpty()) {
            throw new AtlasBaseException(AtlasErrorCode.RELATIONSHIP_CRUD_INVALID_PARAMS, messages);
        }
        type.getNormalizedValue((Object)relationship);
    }

    public AtlasEdge getRelationshipEdge(AtlasVertex fromVertex, AtlasVertex toVertex, String relationshipLabel) {
        AtlasEdge ret = null;
        Iterator<AtlasEdge> edgesIterator = GraphHelper.getIncomingEdgesByLabel(toVertex, relationshipLabel);
        while (edgesIterator != null && edgesIterator.hasNext()) {
            AtlasEdge edge = edgesIterator.next();
            if (edge == null) continue;
            AtlasEntity.Status status = GraphHelper.getStatus((AtlasElement)edge);
            if (status != null && status != AtlasEntity.Status.ACTIVE || !edge.getOutVertex().equals(fromVertex)) continue;
            ret = edge;
            break;
        }
        return ret;
    }

    private Long getRelationshipVersion(AtlasRelationship relationship) {
        Long ret = relationship != null ? relationship.getVersion() : null;
        return ret != null ? ret : DEFAULT_RELATIONSHIP_VERSION;
    }

    private AtlasVertex getVertexFromEndPoint(AtlasObjectId endPoint) {
        AtlasVertex ret = null;
        if (StringUtils.isNotEmpty((String)endPoint.getGuid())) {
            ret = AtlasGraphUtilsV2.findByGuid(endPoint.getGuid());
        } else if (StringUtils.isNotEmpty((String)endPoint.getTypeName()) && MapUtils.isNotEmpty((Map)endPoint.getUniqueAttributes())) {
            AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(endPoint.getTypeName());
            ret = AtlasGraphUtilsV2.findByUniqueAttributes(entityType, endPoint.getUniqueAttributes());
        }
        return ret;
    }

    private AtlasRelationshipDef.PropagateTags getRelationshipTagPropagation(AtlasVertex fromVertex, AtlasVertex toVertex, AtlasRelationship relationship) {
        AtlasRelationshipType relationshipType = this.typeRegistry.getRelationshipTypeByName(relationship.getTypeName());
        AtlasRelationshipEndDef endDef1 = relationshipType.getRelationshipDef().getEndDef1();
        AtlasRelationshipEndDef endDef2 = relationshipType.getRelationshipDef().getEndDef2();
        Set<String> fromVertexTypes = this.getTypeAndAllSuperTypes(AtlasGraphUtilsV2.getTypeName((AtlasElement)fromVertex));
        Set<String> toVertexTypes = this.getTypeAndAllSuperTypes(AtlasGraphUtilsV2.getTypeName((AtlasElement)toVertex));
        AtlasRelationshipDef.PropagateTags ret = relationshipType.getRelationshipDef().getPropagateTags();
        if (fromVertexTypes.contains(endDef2.getType()) && toVertexTypes.contains(endDef1.getType())) {
            if (ret == AtlasRelationshipDef.PropagateTags.ONE_TO_TWO) {
                ret = AtlasRelationshipDef.PropagateTags.TWO_TO_ONE;
            } else if (ret == AtlasRelationshipDef.PropagateTags.TWO_TO_ONE) {
                ret = AtlasRelationshipDef.PropagateTags.ONE_TO_TWO;
            }
        }
        return ret;
    }

    private String getRelationshipEdgeLabel(AtlasVertex fromVertex, AtlasVertex toVertex, String relationshipTypeName) throws AtlasBaseException {
        AtlasRelationshipType relationshipType;
        if (LOG.isDebugEnabled()) {
            LOG.debug("getRelationshipEdgeLabel({})", (Object)relationshipTypeName);
        }
        if ((relationshipType = this.typeRegistry.getRelationshipTypeByName(relationshipTypeName)) == null) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_VALUE, new String[]{"unknown relationship type'" + relationshipTypeName + "'"});
        }
        if (fromVertex == null) {
            throw new AtlasBaseException(AtlasErrorCode.RELATIONSHIP_END_IS_NULL, new String[]{relationshipType.getEnd1Type().getTypeName()});
        }
        if (toVertex == null) {
            throw new AtlasBaseException(AtlasErrorCode.RELATIONSHIP_END_IS_NULL, new String[]{relationshipType.getEnd2Type().getTypeName()});
        }
        String ret = relationshipType.getRelationshipLabel();
        AtlasRelationshipEndDef endDef1 = relationshipType.getRelationshipDef().getEndDef1();
        AtlasRelationshipEndDef endDef2 = relationshipType.getRelationshipDef().getEndDef2();
        Set<String> fromVertexTypes = this.getTypeAndAllSuperTypes(AtlasGraphUtilsV2.getTypeName((AtlasElement)fromVertex));
        Set<String> toVertexTypes = this.getTypeAndAllSuperTypes(AtlasGraphUtilsV2.getTypeName((AtlasElement)toVertex));
        AtlasStructType.AtlasAttribute attribute = null;
        if (fromVertexTypes.contains(endDef1.getType()) && toVertexTypes.contains(endDef2.getType())) {
            String attributeName = endDef1.getName();
            attribute = relationshipType.getEnd1Type().getRelationshipAttribute(attributeName, relationshipTypeName);
        } else if (fromVertexTypes.contains(endDef2.getType()) && toVertexTypes.contains(endDef1.getType())) {
            String attributeName = endDef2.getName();
            attribute = relationshipType.getEnd2Type().getRelationshipAttribute(attributeName, relationshipTypeName);
        }
        if (attribute != null) {
            ret = attribute.getRelationshipEdgeLabel();
        }
        return ret;
    }

    public Set<String> getTypeAndAllSuperTypes(String entityTypeName) {
        AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(entityTypeName);
        return entityType != null ? entityType.getTypeAndAllSuperTypes() : new HashSet();
    }

    private String getTypeNameFromObjectId(AtlasObjectId objectId) {
        String typeName = objectId.getTypeName();
        if (StringUtils.isBlank((String)typeName)) {
            typeName = AtlasGraphUtilsV2.getTypeNameFromGuid(objectId.getGuid());
        }
        return typeName;
    }

    private boolean vertexHasRelationshipWithType(AtlasVertex vertex, String relationshipTypeName) {
        String relationshipEdgeLabel = this.getRelationshipEdgeLabel(AtlasGraphUtilsV2.getTypeName((AtlasElement)vertex), relationshipTypeName);
        Iterator<AtlasEdge> iter = GraphHelper.getAdjacentEdgesByLabel(vertex, AtlasEdgeDirection.BOTH, relationshipEdgeLabel);
        return iter != null ? iter.hasNext() : false;
    }

    private String getRelationshipEdgeLabel(String typeName, String relationshipTypeName) {
        AtlasRelationshipType relationshipType = this.typeRegistry.getRelationshipTypeByName(relationshipTypeName);
        AtlasRelationshipDef relationshipDef = relationshipType.getRelationshipDef();
        AtlasEntityType end1Type = relationshipType.getEnd1Type();
        AtlasEntityType end2Type = relationshipType.getEnd2Type();
        Set<String> vertexTypes = this.getTypeAndAllSuperTypes(typeName);
        AtlasStructType.AtlasAttribute attribute = null;
        if (vertexTypes.contains(end1Type.getTypeName())) {
            String attributeName = relationshipDef.getEndDef1().getName();
            attribute = attributeName != null ? end1Type.getAttribute(attributeName) : null;
        } else if (vertexTypes.contains(end2Type.getTypeName())) {
            String attributeName = relationshipDef.getEndDef2().getName();
            attribute = attributeName != null ? end2Type.getAttribute(attributeName) : null;
        }
        return attribute != null ? attribute.getRelationshipEdgeLabel() : null;
    }
}

