/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.GraphTransactionInterceptor;
import org.apache.atlas.RequestContext;
import org.apache.atlas.SortOrder;
import org.apache.atlas.discovery.SearchProcessor;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graph.AtlasGraphProvider;
import org.apache.atlas.repository.graphdb.AtlasEdge;
import org.apache.atlas.repository.graphdb.AtlasElement;
import org.apache.atlas.repository.graphdb.AtlasGraphQuery;
import org.apache.atlas.repository.graphdb.AtlasIndexQuery;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.utils.AtlasPerfMetrics;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasGraphUtilsV2 {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasGraphUtilsV2.class);
    public static final String PROPERTY_PREFIX = "__type.";
    public static final String SUPERTYPE_EDGE_LABEL = "__type..supertype";
    public static final String ENTITYTYPE_EDGE_LABEL = "__type..entitytype";
    public static final String RELATIONSHIPTYPE_EDGE_LABEL = "__type..relationshipType";
    public static final String VERTEX_TYPE = "typeSystem";
    private static boolean USE_INDEX_QUERY_TO_FIND_ENTITY_BY_UNIQUE_ATTRIBUTES = false;
    private static boolean USE_UNIQUE_INDEX_PROPERTY_TO_FIND_ENTITY = false;
    private static String INDEX_SEARCH_PREFIX;

    public static String getTypeDefPropertyKey(AtlasBaseTypeDef typeDef) {
        return AtlasGraphUtilsV2.getTypeDefPropertyKey(typeDef.getName());
    }

    public static String getTypeDefPropertyKey(AtlasBaseTypeDef typeDef, String child) {
        return AtlasGraphUtilsV2.getTypeDefPropertyKey(typeDef.getName(), child);
    }

    public static String getTypeDefPropertyKey(String typeName) {
        return PROPERTY_PREFIX + typeName;
    }

    public static String getTypeDefPropertyKey(String typeName, String child) {
        return PROPERTY_PREFIX + typeName + "." + child;
    }

    public static String getIdFromVertex(AtlasVertex vertex) {
        return (String)vertex.getProperty(Constants.GUID_PROPERTY_KEY, String.class);
    }

    public static String getIdFromEdge(AtlasEdge edge) {
        return (String)edge.getProperty(Constants.GUID_PROPERTY_KEY, String.class);
    }

    public static String getTypeName(AtlasElement element) {
        return (String)element.getProperty(Constants.ENTITY_TYPE_PROPERTY_KEY, String.class);
    }

    public static String getEdgeLabel(String fromNode, String toNode) {
        return "__type.edge." + fromNode + "." + toNode;
    }

    public static String getEdgeLabel(String property) {
        return "__" + property;
    }

    public static String getQualifiedAttributePropertyKey(AtlasStructType fromType, String attributeName) throws AtlasBaseException {
        switch (fromType.getTypeCategory()) {
            case ENTITY: 
            case STRUCT: 
            case CLASSIFICATION: {
                return fromType.getQualifiedAttributePropertyKey(attributeName);
            }
        }
        throw new AtlasBaseException(AtlasErrorCode.UNKNOWN_TYPE, new String[]{fromType.getTypeCategory().name()});
    }

    public static boolean isEntityVertex(AtlasVertex vertex) {
        return StringUtils.isNotEmpty((String)AtlasGraphUtilsV2.getIdFromVertex(vertex)) && StringUtils.isNotEmpty((String)AtlasGraphUtilsV2.getTypeName((AtlasElement)vertex));
    }

    public static boolean isReference(AtlasType type) {
        return AtlasGraphUtilsV2.isReference(type.getTypeCategory());
    }

    public static boolean isReference(TypeCategory typeCategory) {
        return typeCategory == TypeCategory.STRUCT || typeCategory == TypeCategory.ENTITY || typeCategory == TypeCategory.OBJECT_ID_TYPE;
    }

    public static String encodePropertyKey(String key) {
        return AtlasStructType.AtlasAttribute.encodePropertyKey((String)key);
    }

    public static String decodePropertyKey(String key) {
        return AtlasStructType.AtlasAttribute.decodePropertyKey((String)key);
    }

    public static AtlasVertex addProperty(AtlasVertex vertex, String propertyName, Object value) {
        return AtlasGraphUtilsV2.addProperty(vertex, propertyName, value, false);
    }

    public static AtlasVertex addEncodedProperty(AtlasVertex vertex, String propertyName, Object value) {
        return AtlasGraphUtilsV2.addProperty(vertex, propertyName, value, true);
    }

    public static AtlasVertex addProperty(AtlasVertex vertex, String propertyName, Object value, boolean isEncoded) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> addProperty({}, {}, {})", new Object[]{AtlasGraphUtilsV2.toString(vertex), propertyName, value});
        }
        if (!isEncoded) {
            propertyName = AtlasGraphUtilsV2.encodePropertyKey(propertyName);
        }
        vertex.addProperty(propertyName, value);
        return vertex;
    }

    public static <T extends AtlasElement> void setProperty(T element, String propertyName, Object value) {
        AtlasGraphUtilsV2.setProperty(element, propertyName, value, false);
    }

    public static <T extends AtlasElement> void setEncodedProperty(T element, String propertyName, Object value) {
        AtlasGraphUtilsV2.setProperty(element, propertyName, value, true);
    }

    public static <T extends AtlasElement> void setProperty(T element, String propertyName, Object value, boolean isEncoded) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> setProperty({}, {}, {})", new Object[]{AtlasGraphUtilsV2.toString(element), propertyName, value});
        }
        if (!isEncoded) {
            propertyName = AtlasGraphUtilsV2.encodePropertyKey(propertyName);
        }
        Object existingValue = element.getProperty(propertyName, Object.class);
        if (value == null || value instanceof Collection && ((Collection)value).isEmpty()) {
            if (existingValue != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Removing property {} from {}", (Object)propertyName, (Object)AtlasGraphUtilsV2.toString(element));
                }
                element.removeProperty(propertyName);
            }
        } else if (!value.equals(existingValue)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting property {} in {}", (Object)propertyName, (Object)AtlasGraphUtilsV2.toString(element));
            }
            if (value instanceof Date) {
                Long encodedValue = ((Date)value).getTime();
                element.setProperty(propertyName, (Object)encodedValue);
            } else {
                element.setProperty(propertyName, value);
            }
        }
    }

    public static <T extends AtlasElement, O> O getProperty(T element, String propertyName, Class<O> returnType) {
        return AtlasGraphUtilsV2.getProperty(element, propertyName, returnType, false);
    }

    public static <T extends AtlasElement, O> O getEncodedProperty(T element, String propertyName, Class<O> returnType) {
        return AtlasGraphUtilsV2.getProperty(element, propertyName, returnType, true);
    }

    public static <T extends AtlasElement, O> O getProperty(T element, String propertyName, Class<O> returnType, boolean isEncoded) {
        if (!isEncoded) {
            propertyName = AtlasGraphUtilsV2.encodePropertyKey(propertyName);
        }
        Object property = element.getProperty(propertyName, returnType);
        if (LOG.isDebugEnabled()) {
            LOG.debug("getProperty({}, {}) ==> {}", new Object[]{AtlasGraphUtilsV2.toString(element), propertyName, returnType.cast(property)});
        }
        return returnType.cast(property);
    }

    public static AtlasVertex getVertexByUniqueAttributes(AtlasEntityType entityType, Map<String, Object> attrValues) throws AtlasBaseException {
        AtlasVertex vertex = AtlasGraphUtilsV2.findByUniqueAttributes(entityType, attrValues);
        if (vertex == null) {
            throw new AtlasBaseException(AtlasErrorCode.INSTANCE_BY_UNIQUE_ATTRIBUTE_NOT_FOUND, new String[]{entityType.getTypeName(), attrValues.toString()});
        }
        return vertex;
    }

    public static String getGuidByUniqueAttributes(AtlasEntityType entityType, Map<String, Object> attrValues) throws AtlasBaseException {
        AtlasVertex vertexByUniqueAttributes = AtlasGraphUtilsV2.getVertexByUniqueAttributes(entityType, attrValues);
        return AtlasGraphUtilsV2.getIdFromVertex(vertexByUniqueAttributes);
    }

    public static AtlasVertex findByUniqueAttributes(AtlasEntityType entityType, Map<String, Object> attrValues) {
        AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("findByUniqueAttributes");
        AtlasVertex vertex = null;
        Map uniqueAttributes = entityType.getUniqAttributes();
        if (MapUtils.isNotEmpty((Map)uniqueAttributes) && MapUtils.isNotEmpty(attrValues)) {
            for (AtlasStructType.AtlasAttribute attribute : uniqueAttributes.values()) {
                Object attrValue = attrValues.get(attribute.getName());
                if (attrValue == null) continue;
                if (AtlasGraphUtilsV2.canUseIndexQuery(entityType, attribute.getName())) {
                    vertex = AtlasGraphUtilsV2.getAtlasVertexFromIndexQuery(entityType, attribute, attrValue);
                } else if (USE_UNIQUE_INDEX_PROPERTY_TO_FIND_ENTITY && attribute.getVertexUniquePropertyName() != null) {
                    vertex = AtlasGraphUtilsV2.findByTypeAndUniquePropertyName(entityType.getTypeName(), attribute.getVertexUniquePropertyName(), attrValue);
                    if (vertex == null && !entityType.getAllSubTypes().isEmpty()) {
                        vertex = AtlasGraphUtilsV2.findBySuperTypeAndUniquePropertyName(entityType.getTypeName(), attribute.getVertexUniquePropertyName(), attrValue);
                    }
                } else {
                    vertex = AtlasGraphUtilsV2.findByTypeAndPropertyName(entityType.getTypeName(), attribute.getVertexPropertyName(), attrValue);
                    if (vertex == null && !entityType.getAllSubTypes().isEmpty()) {
                        vertex = AtlasGraphUtilsV2.findBySuperTypeAndPropertyName(entityType.getTypeName(), attribute.getVertexPropertyName(), attrValue);
                    }
                }
                if (vertex == null) continue;
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("findByUniqueAttributes(type={}, attrName={}, attrValue={}: found vertex {}", new Object[]{entityType.getTypeName(), attribute.getName(), attrValue, vertex});
                break;
            }
        }
        RequestContext.get().endMetricRecord(metric);
        return vertex;
    }

    public static AtlasVertex findByGuid(String guid) {
        AtlasVertex ret = GraphTransactionInterceptor.getVertexFromCache(guid);
        if (ret == null) {
            AtlasGraphQuery query = AtlasGraphProvider.getGraphInstance().query().has(Constants.GUID_PROPERTY_KEY, (Object)guid);
            Iterator results = query.vertices().iterator();
            AtlasVertex atlasVertex = ret = results.hasNext() ? (AtlasVertex)results.next() : null;
            if (ret != null) {
                GraphTransactionInterceptor.addToVertexCache(guid, ret);
            }
        }
        return ret;
    }

    public static String getTypeNameFromGuid(String guid) {
        String ret = null;
        if (StringUtils.isNotEmpty((String)guid)) {
            AtlasVertex vertex = AtlasGraphUtilsV2.findByGuid(guid);
            ret = vertex != null ? AtlasGraphUtilsV2.getTypeName((AtlasElement)vertex) : null;
        }
        return ret;
    }

    public static boolean typeHasInstanceVertex(String typeName) throws AtlasBaseException {
        boolean hasInstanceVertex;
        AtlasGraphQuery query = AtlasGraphProvider.getGraphInstance().query().has("__typeName", (AtlasGraphQuery.QueryOperator)AtlasGraphQuery.ComparisionOperator.EQUAL, (Object)typeName);
        Iterator results = query.vertices().iterator();
        boolean bl = hasInstanceVertex = results != null && results.hasNext();
        if (LOG.isDebugEnabled()) {
            LOG.debug("typeName {} has instance vertex {}", (Object)typeName, (Object)hasInstanceVertex);
        }
        return hasInstanceVertex;
    }

    public static AtlasVertex findByTypeAndUniquePropertyName(String typeName, String propertyName, Object attrVal) {
        AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("findByTypeAndUniquePropertyName");
        AtlasGraphQuery query = AtlasGraphProvider.getGraphInstance().query().has(Constants.ENTITY_TYPE_PROPERTY_KEY, (Object)typeName).has(propertyName, attrVal);
        Iterator results = query.vertices().iterator();
        AtlasVertex vertex = results.hasNext() ? (AtlasVertex)results.next() : null;
        RequestContext.get().endMetricRecord(metric);
        return vertex;
    }

    public static AtlasVertex findBySuperTypeAndUniquePropertyName(String typeName, String propertyName, Object attrVal) {
        AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("findBySuperTypeAndUniquePropertyName");
        AtlasGraphQuery query = AtlasGraphProvider.getGraphInstance().query().has(Constants.SUPER_TYPES_PROPERTY_KEY, (Object)typeName).has(propertyName, attrVal);
        Iterator results = query.vertices().iterator();
        AtlasVertex vertex = results.hasNext() ? (AtlasVertex)results.next() : null;
        RequestContext.get().endMetricRecord(metric);
        return vertex;
    }

    public static AtlasVertex findByTypeAndPropertyName(String typeName, String propertyName, Object attrVal) {
        AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("findByTypeAndPropertyName");
        AtlasGraphQuery query = AtlasGraphProvider.getGraphInstance().query().has(Constants.ENTITY_TYPE_PROPERTY_KEY, (Object)typeName).has(propertyName, attrVal).has(Constants.STATE_PROPERTY_KEY, (Object)AtlasEntity.Status.ACTIVE.name());
        Iterator results = query.vertices().iterator();
        AtlasVertex vertex = results.hasNext() ? (AtlasVertex)results.next() : null;
        RequestContext.get().endMetricRecord(metric);
        return vertex;
    }

    public static AtlasVertex findBySuperTypeAndPropertyName(String typeName, String propertyName, Object attrVal) {
        AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("findBySuperTypeAndPropertyName");
        AtlasGraphQuery query = AtlasGraphProvider.getGraphInstance().query().has(Constants.SUPER_TYPES_PROPERTY_KEY, (Object)typeName).has(propertyName, attrVal).has(Constants.STATE_PROPERTY_KEY, (Object)AtlasEntity.Status.ACTIVE.name());
        Iterator results = query.vertices().iterator();
        AtlasVertex vertex = results.hasNext() ? (AtlasVertex)results.next() : null;
        RequestContext.get().endMetricRecord(metric);
        return vertex;
    }

    public static List<String> findEntityGUIDsByType(String typename, SortOrder sortOrder) {
        AtlasGraphQuery query = AtlasGraphProvider.getGraphInstance().query().has(Constants.ENTITY_TYPE_PROPERTY_KEY, (Object)typename);
        if (sortOrder != null) {
            AtlasGraphQuery.SortOrder qrySortOrder = sortOrder == SortOrder.ASCENDING ? AtlasGraphQuery.SortOrder.ASC : AtlasGraphQuery.SortOrder.DESC;
            query.orderBy("Referenceable.qualifiedName", qrySortOrder);
        }
        Iterator results = query.vertices().iterator();
        ArrayList<String> ret = new ArrayList<String>();
        if (!results.hasNext()) {
            return Collections.emptyList();
        }
        while (results.hasNext()) {
            ret.add(AtlasGraphUtilsV2.getIdFromVertex((AtlasVertex)results.next()));
        }
        return ret;
    }

    public static List<String> findEntityGUIDsByType(String typename) {
        return AtlasGraphUtilsV2.findEntityGUIDsByType(typename, null);
    }

    public static boolean relationshipTypeHasInstanceEdges(String typeName) throws AtlasBaseException {
        boolean hasInstanceEdges;
        AtlasGraphQuery query = AtlasGraphProvider.getGraphInstance().query().has("__typeName", (AtlasGraphQuery.QueryOperator)AtlasGraphQuery.ComparisionOperator.EQUAL, (Object)typeName);
        Iterator results = query.edges().iterator();
        boolean bl = hasInstanceEdges = results != null && results.hasNext();
        if (LOG.isDebugEnabled()) {
            LOG.debug("relationshipType {} has instance edges {}", (Object)typeName, (Object)hasInstanceEdges);
        }
        return hasInstanceEdges;
    }

    private static String toString(AtlasElement element) {
        if (element instanceof AtlasVertex) {
            return AtlasGraphUtilsV2.toString((AtlasVertex)element);
        }
        if (element instanceof AtlasEdge) {
            return AtlasGraphUtilsV2.toString((AtlasEdge)element);
        }
        return element.toString();
    }

    public static String toString(AtlasVertex vertex) {
        if (vertex == null) {
            return "vertex[null]";
        }
        if (LOG.isDebugEnabled()) {
            return AtlasGraphUtilsV2.getVertexDetails(vertex);
        }
        return String.format("vertex[id=%s]", vertex.getId().toString());
    }

    public static String toString(AtlasEdge edge) {
        if (edge == null) {
            return "edge[null]";
        }
        if (LOG.isDebugEnabled()) {
            return AtlasGraphUtilsV2.getEdgeDetails(edge);
        }
        return String.format("edge[id=%s]", edge.getId().toString());
    }

    public static String getVertexDetails(AtlasVertex vertex) {
        return String.format("vertex[id=%s type=%s guid=%s]", vertex.getId().toString(), AtlasGraphUtilsV2.getTypeName((AtlasElement)vertex), AtlasGraphUtilsV2.getIdFromVertex(vertex));
    }

    public static String getEdgeDetails(AtlasEdge edge) {
        return String.format("edge[id=%s label=%s from %s -> to %s]", edge.getId(), edge.getLabel(), AtlasGraphUtilsV2.toString(edge.getOutVertex()), AtlasGraphUtilsV2.toString(edge.getInVertex()));
    }

    public static AtlasEntity.Status getState(AtlasElement element) {
        String state = AtlasGraphUtilsV2.getStateAsString(element);
        return state == null ? null : AtlasEntity.Status.valueOf((String)state);
    }

    public static String getStateAsString(AtlasElement element) {
        return (String)element.getProperty(Constants.STATE_PROPERTY_KEY, String.class);
    }

    private static boolean canUseIndexQuery(AtlasEntityType entityType, String attributeName) {
        boolean ret = false;
        if (USE_INDEX_QUERY_TO_FIND_ENTITY_BY_UNIQUE_ATTRIBUTES) {
            String typeAndSubTypesQryStr = entityType.getTypeAndAllSubTypesQryStr();
            boolean bl = ret = typeAndSubTypesQryStr.length() <= SearchProcessor.MAX_QUERY_STR_LENGTH_TYPES;
            if (ret) {
                Set indexSet = AtlasGraphProvider.getGraphInstance().getVertexIndexKeys();
                try {
                    ret = indexSet.contains(entityType.getQualifiedAttributeName(attributeName));
                }
                catch (AtlasBaseException ex) {
                    ret = false;
                }
            }
        }
        return ret;
    }

    private static AtlasVertex getAtlasVertexFromIndexQuery(AtlasEntityType entityType, AtlasStructType.AtlasAttribute attribute, Object attrVal) {
        String propertyName = attribute.getVertexPropertyName();
        AtlasIndexQuery query = AtlasGraphUtilsV2.getIndexQuery(entityType, propertyName, attrVal.toString());
        Iterator iter = query.vertices();
        while (iter.hasNext()) {
            String vertexVal;
            String s;
            AtlasIndexQuery.Result result = (AtlasIndexQuery.Result)iter.next();
            AtlasVertex vertex = result.getVertex();
            if (vertex == null || !vertex.getPropertyKeys().contains(Constants.GUID_PROPERTY_KEY)) continue;
            String typeNameInVertex = AtlasGraphUtilsV2.getTypeName((AtlasElement)vertex);
            if (!entityType.getTypeAndAllSubTypes().contains(typeNameInVertex)) {
                LOG.warn("incorrect vertex type from index-query: expected='{}'; found='{}'", (Object)entityType.getTypeName(), (Object)typeNameInVertex);
                continue;
            }
            if (attrVal.getClass() == String.class && !(s = (String)attrVal).equalsIgnoreCase(vertexVal = (String)vertex.getProperty(propertyName, String.class))) {
                LOG.warn("incorrect match from index-query for property {}: expected='{}'; found='{}'", new Object[]{propertyName, s, vertexVal});
                continue;
            }
            return vertex;
        }
        return null;
    }

    private static AtlasIndexQuery getIndexQuery(AtlasEntityType entityType, String propertyName, String value) {
        StringBuilder sb = new StringBuilder();
        sb.append(INDEX_SEARCH_PREFIX + "\"").append("__typeName").append("\":").append(entityType.getTypeAndAllSubTypesQryStr()).append(" AND ").append(INDEX_SEARCH_PREFIX + "\"").append(propertyName).append("\":").append(AtlasStructType.AtlasAttribute.escapeIndexQueryValue((String)value)).append(" AND ").append(INDEX_SEARCH_PREFIX + "\"").append(Constants.STATE_PROPERTY_KEY).append("\":ACTIVE");
        return AtlasGraphProvider.getGraphInstance().indexQuery("vertex_index", sb.toString());
    }

    public static String getIndexSearchPrefix() {
        return INDEX_SEARCH_PREFIX;
    }

    static {
        try {
            Configuration conf = ApplicationProperties.get();
            USE_INDEX_QUERY_TO_FIND_ENTITY_BY_UNIQUE_ATTRIBUTES = conf.getBoolean("atlas.use.index.query.to.find.entity.by.unique.attributes", USE_INDEX_QUERY_TO_FIND_ENTITY_BY_UNIQUE_ATTRIBUTES);
            USE_UNIQUE_INDEX_PROPERTY_TO_FIND_ENTITY = conf.getBoolean("atlas.unique.index.property.to.find.entity", USE_UNIQUE_INDEX_PROPERTY_TO_FIND_ENTITY);
            INDEX_SEARCH_PREFIX = conf.getString("atlas.graph.index.search.vertex.prefix", "$v$");
        }
        catch (Exception excp) {
            LOG.error("Error reading configuration", (Throwable)excp);
        }
        finally {
            LOG.info("atlas.use.index.query.to.find.entity.by.unique.attributes=" + USE_INDEX_QUERY_TO_FIND_ENTITY_BY_UNIQUE_ATTRIBUTES);
        }
    }
}

