/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.authorize.AtlasAuthorizationUtils;
import org.apache.atlas.authorize.AtlasPrivilege;
import org.apache.atlas.authorize.AtlasTypeAccessRequest;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.model.typedef.AtlasEnumDef;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.v2.AtlasAbstractDefStoreV2;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.repository.store.graph.v2.AtlasTypeDefGraphStoreV2;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.typesystem.types.DataTypes;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AtlasEnumDefStoreV2
extends AtlasAbstractDefStoreV2<AtlasEnumDef> {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasEnumDefStoreV2.class);

    public AtlasEnumDefStoreV2(AtlasTypeDefGraphStoreV2 typeDefStore, AtlasTypeRegistry typeRegistry) {
        super(typeDefStore, typeRegistry);
    }

    @Override
    public AtlasVertex preCreate(AtlasEnumDef enumDef) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasEnumDefStoreV2.preCreate({})", (Object)enumDef);
        }
        this.validateType((AtlasBaseTypeDef)enumDef);
        AtlasVertex vertex = this.typeDefStore.findTypeVertexByName(enumDef.getName());
        if (vertex != null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_ALREADY_EXISTS, new String[]{enumDef.getName()});
        }
        vertex = this.typeDefStore.createTypeVertex((AtlasBaseTypeDef)enumDef);
        this.toVertex(enumDef, vertex);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasEnumDefStoreV2.preCreate({}): {}", (Object)enumDef, (Object)vertex);
        }
        return vertex;
    }

    @Override
    public AtlasEnumDef create(AtlasEnumDef enumDef, AtlasVertex preCreateResult) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasEnumDefStoreV2.create({}, {})", (Object)enumDef, (Object)preCreateResult);
        }
        AtlasAuthorizationUtils.verifyAccess((AtlasTypeAccessRequest)new AtlasTypeAccessRequest(AtlasPrivilege.TYPE_CREATE, (AtlasBaseTypeDef)enumDef), (Object[])new Object[]{"create enum-def ", enumDef.getName()});
        AtlasVertex vertex = preCreateResult == null ? this.preCreate(enumDef) : preCreateResult;
        AtlasEnumDef ret = this.toEnumDef(vertex);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasEntityDefStoreV2.create({}, {}): {}", new Object[]{enumDef, preCreateResult, ret});
        }
        return ret;
    }

    @Override
    public List<AtlasEnumDef> getAll() throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasEnumDefStoreV2.getAll()");
        }
        ArrayList<AtlasEnumDef> ret = new ArrayList<AtlasEnumDef>();
        Iterator<AtlasVertex> vertices = this.typeDefStore.findTypeVerticesByCategory(DataTypes.TypeCategory.ENUM);
        while (vertices.hasNext()) {
            ret.add(this.toEnumDef(vertices.next()));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasEnumDefStoreV2.getAll(): count={}", (Object)ret.size());
        }
        return ret;
    }

    @Override
    public AtlasEnumDef getByName(String name) throws AtlasBaseException {
        AtlasVertex vertex;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasEnumDefStoreV2.getByName({})", (Object)name);
        }
        if ((vertex = this.typeDefStore.findTypeVertexByNameAndCategory(name, DataTypes.TypeCategory.ENUM)) == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_NOT_FOUND, new String[]{name});
        }
        vertex.getProperty(Constants.TYPE_CATEGORY_PROPERTY_KEY, DataTypes.TypeCategory.class);
        AtlasEnumDef ret = this.toEnumDef(vertex);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasEnumDefStoreV2.getByName({}): {}", (Object)name, (Object)ret);
        }
        return ret;
    }

    @Override
    public AtlasEnumDef getByGuid(String guid) throws AtlasBaseException {
        AtlasVertex vertex;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasEnumDefStoreV2.getByGuid({})", (Object)guid);
        }
        if ((vertex = this.typeDefStore.findTypeVertexByGuidAndCategory(guid, DataTypes.TypeCategory.ENUM)) == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_GUID_NOT_FOUND, new String[]{guid});
        }
        AtlasEnumDef ret = this.toEnumDef(vertex);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasEnumDefStoreV2.getByGuid({}): {}", (Object)guid, (Object)ret);
        }
        return ret;
    }

    @Override
    public AtlasEnumDef update(AtlasEnumDef enumDef) throws AtlasBaseException {
        AtlasEnumDef ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasEnumDefStoreV2.update({})", (Object)enumDef);
        }
        this.validateType((AtlasBaseTypeDef)enumDef);
        AtlasEnumDef atlasEnumDef = ret = StringUtils.isNotBlank((CharSequence)enumDef.getGuid()) ? this.updateByGuid(enumDef.getGuid(), enumDef) : this.updateByName(enumDef.getName(), enumDef);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasEnumDefStoreV2.update({}): {}", (Object)enumDef, (Object)ret);
        }
        return ret;
    }

    @Override
    public AtlasEnumDef updateByName(String name, AtlasEnumDef enumDef) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasEnumDefStoreV2.updateByName({}, {})", (Object)name, (Object)enumDef);
        }
        AtlasEnumDef existingDef = this.typeRegistry.getEnumDefByName(name);
        AtlasAuthorizationUtils.verifyAccess((AtlasTypeAccessRequest)new AtlasTypeAccessRequest(AtlasPrivilege.TYPE_UPDATE, (AtlasBaseTypeDef)existingDef), (Object[])new Object[]{"update enum-def ", name});
        this.validateType((AtlasBaseTypeDef)enumDef);
        AtlasVertex vertex = this.typeDefStore.findTypeVertexByNameAndCategory(name, DataTypes.TypeCategory.ENUM);
        if (vertex == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_NOT_FOUND, new String[]{name});
        }
        this.typeDefStore.updateTypeVertex((AtlasBaseTypeDef)enumDef, vertex);
        this.toVertex(enumDef, vertex);
        AtlasEnumDef ret = this.toEnumDef(vertex);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasEnumDefStoreV2.updateByName({}, {}): {}", new Object[]{name, enumDef, ret});
        }
        return ret;
    }

    @Override
    public AtlasEnumDef updateByGuid(String guid, AtlasEnumDef enumDef) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasEnumDefStoreV2.updateByGuid({})", (Object)guid);
        }
        AtlasEnumDef existingDef = this.typeRegistry.getEnumDefByGuid(guid);
        AtlasAuthorizationUtils.verifyAccess((AtlasTypeAccessRequest)new AtlasTypeAccessRequest(AtlasPrivilege.TYPE_UPDATE, (AtlasBaseTypeDef)existingDef), (Object[])new Object[]{"update enum-def ", existingDef != null ? existingDef.getName() : guid});
        this.validateType((AtlasBaseTypeDef)enumDef);
        AtlasVertex vertex = this.typeDefStore.findTypeVertexByGuidAndCategory(guid, DataTypes.TypeCategory.ENUM);
        if (vertex == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_GUID_NOT_FOUND, new String[]{guid});
        }
        this.typeDefStore.updateTypeVertex((AtlasBaseTypeDef)enumDef, vertex);
        this.toVertex(enumDef, vertex);
        AtlasEnumDef ret = this.toEnumDef(vertex);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasEnumDefStoreV2.updateByGuid({}): {}", (Object)guid, (Object)ret);
        }
        return ret;
    }

    @Override
    public AtlasVertex preDeleteByName(String name) throws AtlasBaseException {
        AtlasVertex vertex = this.typeDefStore.findTypeVertexByNameAndCategory(name, DataTypes.TypeCategory.ENUM);
        if (vertex == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_NOT_FOUND, new String[]{name});
        }
        AtlasEnumDef existingDef = this.typeRegistry.getEnumDefByName(name);
        AtlasAuthorizationUtils.verifyAccess((AtlasTypeAccessRequest)new AtlasTypeAccessRequest(AtlasPrivilege.TYPE_DELETE, (AtlasBaseTypeDef)existingDef), (Object[])new Object[]{"delete enum-def ", existingDef != null ? existingDef.getName() : name});
        return vertex;
    }

    @Override
    public AtlasVertex preDeleteByGuid(String guid) throws AtlasBaseException {
        AtlasVertex vertex = this.typeDefStore.findTypeVertexByGuidAndCategory(guid, DataTypes.TypeCategory.ENUM);
        if (vertex == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_GUID_NOT_FOUND, new String[]{guid});
        }
        AtlasEnumDef existingDef = this.typeRegistry.getEnumDefByGuid(guid);
        AtlasAuthorizationUtils.verifyAccess((AtlasTypeAccessRequest)new AtlasTypeAccessRequest(AtlasPrivilege.TYPE_DELETE, (AtlasBaseTypeDef)existingDef), (Object[])new Object[]{"delete enum-def ", existingDef != null ? existingDef.getName() : guid});
        return vertex;
    }

    private void toVertex(AtlasEnumDef enumDef, AtlasVertex vertex) throws AtlasBaseException {
        if (CollectionUtils.isEmpty((Collection)enumDef.getElementDefs())) {
            throw new AtlasBaseException(AtlasErrorCode.MISSING_MANDATORY_ATTRIBUTE, new String[]{enumDef.getName(), "values"});
        }
        ArrayList<String> values = new ArrayList<String>(enumDef.getElementDefs().size());
        for (AtlasEnumDef.AtlasEnumElementDef element : enumDef.getElementDefs()) {
            if (StringUtils.isEmpty((CharSequence)element.getValue()) || null == element.getOrdinal()) {
                throw new AtlasBaseException(AtlasErrorCode.MISSING_MANDATORY_ATTRIBUTE, new String[]{enumDef.getName(), "elementValue"});
            }
            String elemKey = AtlasGraphUtilsV2.getTypeDefPropertyKey((AtlasBaseTypeDef)enumDef, element.getValue());
            AtlasGraphUtilsV2.setProperty(vertex, elemKey, element.getOrdinal());
            if (StringUtils.isNotBlank((CharSequence)element.getDescription())) {
                String descKey = AtlasGraphUtilsV2.getTypeDefPropertyKey(elemKey, "description");
                AtlasGraphUtilsV2.setProperty(vertex, descKey, element.getDescription());
            }
            values.add(element.getValue());
        }
        AtlasGraphUtilsV2.setProperty(vertex, AtlasGraphUtilsV2.getTypeDefPropertyKey((AtlasBaseTypeDef)enumDef), values);
        String defaultValueKey = AtlasGraphUtilsV2.getTypeDefPropertyKey((AtlasBaseTypeDef)enumDef, "defaultValue");
        AtlasGraphUtilsV2.setProperty(vertex, defaultValueKey, enumDef.getDefaultValue());
    }

    private AtlasEnumDef toEnumDef(AtlasVertex vertex) {
        AtlasEnumDef ret = null;
        if (vertex != null && this.typeDefStore.isTypeVertex(vertex, DataTypes.TypeCategory.ENUM)) {
            ret = AtlasEnumDefStoreV2.toEnumDef(vertex, new AtlasEnumDef(), this.typeDefStore);
        }
        return ret;
    }

    private static AtlasEnumDef toEnumDef(AtlasVertex vertex, AtlasEnumDef enumDef, AtlasTypeDefGraphStoreV2 typeDefStore) {
        AtlasEnumDef ret = enumDef != null ? enumDef : new AtlasEnumDef();
        typeDefStore.vertexToTypeDef(vertex, (AtlasBaseTypeDef)ret);
        ArrayList<AtlasEnumDef.AtlasEnumElementDef> elements = new ArrayList<AtlasEnumDef.AtlasEnumElementDef>();
        List elemValues = (List)vertex.getProperty(AtlasGraphUtilsV2.getTypeDefPropertyKey((AtlasBaseTypeDef)ret), List.class);
        for (String elemValue : elemValues) {
            String elemKey = AtlasGraphUtilsV2.getTypeDefPropertyKey((AtlasBaseTypeDef)ret, elemValue);
            String descKey = AtlasGraphUtilsV2.getTypeDefPropertyKey(elemKey, "description");
            Integer ordinal = AtlasGraphUtilsV2.getProperty(vertex, elemKey, Integer.class);
            String desc = AtlasGraphUtilsV2.getProperty(vertex, descKey, String.class);
            elements.add(new AtlasEnumDef.AtlasEnumElementDef(elemValue, desc, ordinal));
        }
        ret.setElementDefs(elements);
        String defaultValueKey = AtlasGraphUtilsV2.getTypeDefPropertyKey((AtlasBaseTypeDef)ret, "defaultValue");
        String defaultValue = AtlasGraphUtilsV2.getProperty(vertex, defaultValueKey, String.class);
        ret.setDefaultValue(defaultValue);
        return ret;
    }
}

