/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.GraphTransactionInterceptor;
import org.apache.atlas.RequestContext;
import org.apache.atlas.annotation.GraphTransaction;
import org.apache.atlas.authorize.AtlasAuthorizationUtils;
import org.apache.atlas.authorize.AtlasEntityAccessRequest;
import org.apache.atlas.authorize.AtlasPrivilege;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.instance.AtlasCheckStateRequest;
import org.apache.atlas.model.instance.AtlasCheckStateResult;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.AtlasEntityHeaders;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.instance.EntityMutationResponse;
import org.apache.atlas.model.instance.EntityMutations;
import org.apache.atlas.repository.graphdb.AtlasElement;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.AtlasEntityStore;
import org.apache.atlas.repository.store.graph.EntityGraphDiscoveryContext;
import org.apache.atlas.repository.store.graph.v1.DeleteHandlerDelegate;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityChangeNotifier;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityGraphDiscoveryV2;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityStream;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.repository.store.graph.v2.ClassificationAssociator;
import org.apache.atlas.repository.store.graph.v2.EntityGraphMapper;
import org.apache.atlas.repository.store.graph.v2.EntityGraphRetriever;
import org.apache.atlas.repository.store.graph.v2.EntityMutationContext;
import org.apache.atlas.repository.store.graph.v2.EntityStateChecker;
import org.apache.atlas.repository.store.graph.v2.EntityStream;
import org.apache.atlas.type.AtlasClassificationType;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.type.AtlasTypeUtil;
import org.apache.atlas.utils.AtlasEntityUtil;
import org.apache.atlas.utils.AtlasPerfMetrics;
import org.apache.atlas.utils.AtlasPerfTracer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AtlasEntityStoreV2
implements AtlasEntityStore {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasEntityStoreV2.class);
    private static final Logger PERF_LOG = AtlasPerfTracer.getPerfLogger((String)"store.EntityStore");
    private final DeleteHandlerDelegate deleteDelegate;
    private final AtlasTypeRegistry typeRegistry;
    private final AtlasEntityChangeNotifier entityChangeNotifier;
    private final EntityGraphMapper entityGraphMapper;
    private final EntityGraphRetriever entityRetriever;

    @Inject
    public AtlasEntityStoreV2(DeleteHandlerDelegate deleteDelegate, AtlasTypeRegistry typeRegistry, AtlasEntityChangeNotifier entityChangeNotifier, EntityGraphMapper entityGraphMapper) {
        this.deleteDelegate = deleteDelegate;
        this.typeRegistry = typeRegistry;
        this.entityChangeNotifier = entityChangeNotifier;
        this.entityGraphMapper = entityGraphMapper;
        this.entityRetriever = new EntityGraphRetriever(typeRegistry);
    }

    @Override
    @GraphTransaction
    public List<String> getEntityGUIDS(String typename) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getEntityGUIDS({})", (Object)typename);
        }
        if (StringUtils.isEmpty((CharSequence)typename) || !this.typeRegistry.isRegisteredType(typename)) {
            throw new AtlasBaseException(AtlasErrorCode.UNKNOWN_TYPENAME, new String[0]);
        }
        List<String> ret = AtlasGraphUtilsV2.findEntityGUIDsByType(typename);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getEntityGUIDS({})", (Object)typename);
        }
        return ret;
    }

    @Override
    @GraphTransaction
    public AtlasEntity.AtlasEntityWithExtInfo getById(String guid) throws AtlasBaseException {
        return this.getById(guid, false, false);
    }

    @Override
    @GraphTransaction
    public AtlasEntity.AtlasEntityWithExtInfo getById(String guid, boolean isMinExtInfo, boolean ignoreRelationships) throws AtlasBaseException {
        EntityGraphRetriever entityRetriever;
        AtlasEntity.AtlasEntityWithExtInfo ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getById({}, {})", (Object)guid, (Object)isMinExtInfo);
        }
        if ((ret = (entityRetriever = new EntityGraphRetriever(this.typeRegistry, ignoreRelationships)).toAtlasEntityWithExtInfo(guid, isMinExtInfo)) == null) {
            throw new AtlasBaseException(AtlasErrorCode.INSTANCE_GUID_NOT_FOUND, new String[]{guid});
        }
        AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)new AtlasEntityAccessRequest(this.typeRegistry, AtlasPrivilege.ENTITY_READ, new AtlasEntityHeader(ret.getEntity())), (Object[])new Object[]{"read entity: guid=", guid});
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getById({}, {}): {}", new Object[]{guid, isMinExtInfo, ret});
        }
        return ret;
    }

    @Override
    @GraphTransaction
    public AtlasEntityHeader getHeaderById(String guid) throws AtlasBaseException {
        EntityGraphRetriever entityRetriever;
        AtlasEntityHeader ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getHeaderById({})", (Object)guid);
        }
        if ((ret = (entityRetriever = new EntityGraphRetriever(this.typeRegistry)).toAtlasEntityHeader(guid)) == null) {
            throw new AtlasBaseException(AtlasErrorCode.INSTANCE_GUID_NOT_FOUND, new String[]{guid});
        }
        AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)new AtlasEntityAccessRequest(this.typeRegistry, AtlasPrivilege.ENTITY_READ, ret), (Object[])new Object[]{"read entity: guid=", guid});
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getHeaderById({}): {}", (Object)guid, (Object)ret);
        }
        return ret;
    }

    @Override
    @GraphTransaction
    public AtlasEntity.AtlasEntitiesWithExtInfo getByIds(List<String> guids) throws AtlasBaseException {
        return this.getByIds(guids, false, false);
    }

    @Override
    @GraphTransaction
    public AtlasEntity.AtlasEntitiesWithExtInfo getByIds(List<String> guids, boolean isMinExtInfo, boolean ignoreRelationships) throws AtlasBaseException {
        EntityGraphRetriever entityRetriever;
        AtlasEntity.AtlasEntitiesWithExtInfo ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getByIds({}, {})", guids, (Object)isMinExtInfo);
        }
        if ((ret = (entityRetriever = new EntityGraphRetriever(this.typeRegistry, ignoreRelationships)).toAtlasEntitiesWithExtInfo(guids, isMinExtInfo)) != null) {
            for (String guid : guids) {
                AtlasEntity entity = ret.getEntity(guid);
                AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)new AtlasEntityAccessRequest(this.typeRegistry, AtlasPrivilege.ENTITY_READ, new AtlasEntityHeader(entity)), (Object[])new Object[]{"read entity: guid=", guid});
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getByIds({}, {}): {}", new Object[]{guids, isMinExtInfo, ret});
        }
        return ret;
    }

    @Override
    @GraphTransaction
    public AtlasEntity.AtlasEntitiesWithExtInfo getEntitiesByUniqueAttributes(AtlasEntityType entityType, List<Map<String, Object>> uniqueAttributes, boolean isMinExtInfo, boolean ignoreRelationships) throws AtlasBaseException {
        EntityGraphRetriever entityRetriever;
        AtlasEntity.AtlasEntitiesWithExtInfo ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getEntitiesByUniqueAttributes({}, {})", (Object)entityType.getTypeName(), uniqueAttributes);
        }
        if ((ret = (entityRetriever = new EntityGraphRetriever(this.typeRegistry, ignoreRelationships)).getEntitiesByUniqueAttributes(entityType.getTypeName(), uniqueAttributes, isMinExtInfo)) != null && ret.getEntities() != null) {
            for (AtlasEntity entity : ret.getEntities()) {
                AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)new AtlasEntityAccessRequest(this.typeRegistry, AtlasPrivilege.ENTITY_READ, new AtlasEntityHeader(entity)), (Object[])new Object[]{"read entity: typeName=", entityType.getTypeName(), ", guid=", entity.getGuid()});
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getEntitiesByUniqueAttributes({}, {}): {}", new Object[]{entityType.getTypeName(), uniqueAttributes, ret});
        }
        return ret;
    }

    @Override
    @GraphTransaction
    public AtlasEntity.AtlasEntityWithExtInfo getByUniqueAttributes(AtlasEntityType entityType, Map<String, Object> uniqAttributes) throws AtlasBaseException {
        return this.getByUniqueAttributes(entityType, uniqAttributes, false, false);
    }

    @Override
    @GraphTransaction
    public AtlasEntity.AtlasEntityWithExtInfo getByUniqueAttributes(AtlasEntityType entityType, Map<String, Object> uniqAttributes, boolean isMinExtInfo, boolean ignoreRelationships) throws AtlasBaseException {
        AtlasVertex entityVertex;
        EntityGraphRetriever entityRetriever;
        AtlasEntity.AtlasEntityWithExtInfo ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getByUniqueAttribute({}, {})", (Object)entityType.getTypeName(), uniqAttributes);
        }
        if ((ret = (entityRetriever = new EntityGraphRetriever(this.typeRegistry, ignoreRelationships)).toAtlasEntityWithExtInfo(entityVertex = AtlasGraphUtilsV2.getVertexByUniqueAttributes(entityType, uniqAttributes), isMinExtInfo)) == null) {
            throw new AtlasBaseException(AtlasErrorCode.INSTANCE_BY_UNIQUE_ATTRIBUTE_NOT_FOUND, new String[]{entityType.getTypeName(), uniqAttributes.toString()});
        }
        AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)new AtlasEntityAccessRequest(this.typeRegistry, AtlasPrivilege.ENTITY_READ, new AtlasEntityHeader(ret.getEntity())), (Object[])new Object[]{"read entity: typeName=", entityType.getTypeName(), ", uniqueAttributes=", uniqAttributes});
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getByUniqueAttribute({}, {}): {}", new Object[]{entityType.getTypeName(), uniqAttributes, ret});
        }
        return ret;
    }

    @Override
    @GraphTransaction
    public AtlasCheckStateResult checkState(AtlasCheckStateRequest request) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> checkState({})", (Object)request);
        }
        EntityStateChecker entityStateChecker = new EntityStateChecker(this.typeRegistry);
        AtlasCheckStateResult ret = entityStateChecker.checkState(request);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== checkState({}, {})", (Object)request, (Object)ret);
        }
        return ret;
    }

    @Override
    @GraphTransaction
    public EntityMutationResponse createOrUpdate(EntityStream entityStream, boolean isPartialUpdate) throws AtlasBaseException {
        return this.createOrUpdate(entityStream, isPartialUpdate, false);
    }

    @Override
    @GraphTransaction
    public EntityMutationResponse createOrUpdateForImport(EntityStream entityStream) throws AtlasBaseException {
        return this.createOrUpdate(entityStream, false, true);
    }

    @Override
    @GraphTransaction
    public EntityMutationResponse updateEntity(AtlasObjectId objectId, AtlasEntity.AtlasEntityWithExtInfo updatedEntityInfo, boolean isPartialUpdate) throws AtlasBaseException {
        String guid;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> updateEntity({}, {}, {})", new Object[]{objectId, updatedEntityInfo, isPartialUpdate});
        }
        if (objectId == null || updatedEntityInfo == null || updatedEntityInfo.getEntity() == null) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"null entity-id/entity"});
        }
        if (AtlasTypeUtil.isAssignedGuid((String)objectId.getGuid())) {
            guid = objectId.getGuid();
        } else {
            AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(objectId.getTypeName());
            if (entityType == null) {
                throw new AtlasBaseException(AtlasErrorCode.UNKNOWN_TYPENAME, new String[]{objectId.getTypeName()});
            }
            guid = AtlasGraphUtilsV2.getGuidByUniqueAttributes(this.typeRegistry.getEntityTypeByName(objectId.getTypeName()), objectId.getUniqueAttributes());
        }
        AtlasEntity entity = updatedEntityInfo.getEntity();
        entity.setGuid(guid);
        return this.createOrUpdate(new AtlasEntityStream(updatedEntityInfo), isPartialUpdate, false);
    }

    @Override
    @GraphTransaction
    public EntityMutationResponse updateByUniqueAttributes(AtlasEntityType entityType, Map<String, Object> uniqAttributes, AtlasEntity.AtlasEntityWithExtInfo updatedEntityInfo) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> updateByUniqueAttributes({}, {})", (Object)entityType.getTypeName(), uniqAttributes);
        }
        if (updatedEntityInfo == null || updatedEntityInfo.getEntity() == null) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"no entity to update."});
        }
        String guid = AtlasGraphUtilsV2.getGuidByUniqueAttributes(entityType, uniqAttributes);
        AtlasEntity entity = updatedEntityInfo.getEntity();
        entity.setGuid(guid);
        return this.createOrUpdate(new AtlasEntityStream(updatedEntityInfo), true, false);
    }

    @Override
    @GraphTransaction
    public EntityMutationResponse updateEntityAttributeByGuid(String guid, String attrName, Object attrValue) throws AtlasBaseException {
        AtlasEntityHeader entity;
        AtlasEntityType entityType;
        AtlasStructType.AtlasAttribute attr;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> updateEntityAttributeByGuid({}, {}, {})", new Object[]{guid, attrName, attrValue});
        }
        if ((attr = (entityType = (AtlasEntityType)this.typeRegistry.getType((entity = this.entityRetriever.toAtlasEntityHeaderWithClassifications(guid)).getTypeName())).getAttribute(attrName)) == null && (attr = entityType.getRelationshipAttribute(attrName, AtlasEntityUtil.getRelationshipType((Object)attrValue))) == null) {
            throw new AtlasBaseException(AtlasErrorCode.UNKNOWN_ATTRIBUTE, new String[]{attrName, entity.getTypeName()});
        }
        AtlasType attrType = attr.getAttributeType();
        AtlasEntity updateEntity = new AtlasEntity();
        updateEntity.setGuid(guid);
        updateEntity.setTypeName(entity.getTypeName());
        switch (attrType.getTypeCategory()) {
            case PRIMITIVE: {
                updateEntity.setAttribute(attrName, attrValue);
                break;
            }
            case OBJECT_ID_TYPE: {
                AtlasObjectId objId = attrValue instanceof String ? new AtlasObjectId((String)attrValue, attr.getAttributeDef().getTypeName()) : (AtlasObjectId)attrType.getNormalizedValue(attrValue);
                updateEntity.setAttribute(attrName, (Object)objId);
                break;
            }
            default: {
                throw new AtlasBaseException(AtlasErrorCode.ATTRIBUTE_UPDATE_NOT_SUPPORTED, new String[]{attrName, attrType.getTypeName()});
            }
        }
        return this.createOrUpdate(new AtlasEntityStream(updateEntity), true, false);
    }

    @Override
    @GraphTransaction
    public EntityMutationResponse deleteById(String guid) throws AtlasBaseException {
        if (StringUtils.isEmpty((CharSequence)guid)) {
            throw new AtlasBaseException(AtlasErrorCode.INSTANCE_GUID_NOT_FOUND, new String[]{guid});
        }
        ArrayList<AtlasVertex> deletionCandidates = new ArrayList<AtlasVertex>();
        AtlasVertex vertex = AtlasGraphUtilsV2.findByGuid(guid);
        if (vertex != null) {
            AtlasEntityHeader entityHeader = this.entityRetriever.toAtlasEntityHeaderWithClassifications(vertex);
            AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)new AtlasEntityAccessRequest(this.typeRegistry, AtlasPrivilege.ENTITY_DELETE, entityHeader), (Object[])new Object[]{"delete entity: guid=", guid});
            deletionCandidates.add(vertex);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Deletion request ignored for non-existent entity with guid " + guid);
        }
        EntityMutationResponse ret = this.deleteVertices(deletionCandidates);
        this.entityChangeNotifier.onEntitiesMutated(ret, false);
        return ret;
    }

    @Override
    @GraphTransaction
    public EntityMutationResponse deleteByIds(List<String> guids) throws AtlasBaseException {
        if (CollectionUtils.isEmpty(guids)) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"Guid(s) not specified"});
        }
        ArrayList<AtlasVertex> deletionCandidates = new ArrayList<AtlasVertex>();
        for (String guid : guids) {
            AtlasVertex vertex = AtlasGraphUtilsV2.findByGuid(guid);
            if (vertex == null) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Deletion request ignored for non-existent entity with guid " + guid);
                continue;
            }
            AtlasEntityHeader entityHeader = this.entityRetriever.toAtlasEntityHeaderWithClassifications(vertex);
            AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)new AtlasEntityAccessRequest(this.typeRegistry, AtlasPrivilege.ENTITY_DELETE, entityHeader), (Object[])new Object[]{"delete entity: guid=", guid});
            deletionCandidates.add(vertex);
        }
        if (deletionCandidates.isEmpty()) {
            LOG.info("No deletion candidate entities were found for guids %s", guids);
        }
        EntityMutationResponse ret = this.deleteVertices(deletionCandidates);
        this.entityChangeNotifier.onEntitiesMutated(ret, false);
        return ret;
    }

    @Override
    @GraphTransaction
    public EntityMutationResponse deleteByUniqueAttributes(AtlasEntityType entityType, Map<String, Object> uniqAttributes) throws AtlasBaseException {
        if (MapUtils.isEmpty(uniqAttributes)) {
            throw new AtlasBaseException(AtlasErrorCode.INSTANCE_BY_UNIQUE_ATTRIBUTE_NOT_FOUND, new String[]{uniqAttributes.toString()});
        }
        ArrayList<AtlasVertex> deletionCandidates = new ArrayList<AtlasVertex>();
        AtlasVertex vertex = AtlasGraphUtilsV2.findByUniqueAttributes(entityType, uniqAttributes);
        if (vertex != null) {
            AtlasEntityHeader entityHeader = this.entityRetriever.toAtlasEntityHeaderWithClassifications(vertex);
            AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)new AtlasEntityAccessRequest(this.typeRegistry, AtlasPrivilege.ENTITY_DELETE, entityHeader), (Object[])new Object[]{"delete entity: typeName=", entityType.getTypeName(), ", uniqueAttributes=", uniqAttributes});
            deletionCandidates.add(vertex);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Deletion request ignored for non-existent entity with uniqueAttributes " + uniqAttributes);
        }
        EntityMutationResponse ret = this.deleteVertices(deletionCandidates);
        this.entityChangeNotifier.onEntitiesMutated(ret, false);
        return ret;
    }

    @Override
    @GraphTransaction
    public String getGuidByUniqueAttributes(AtlasEntityType entityType, Map<String, Object> uniqAttributes) throws AtlasBaseException {
        return AtlasGraphUtilsV2.getGuidByUniqueAttributes(entityType, uniqAttributes);
    }

    @Override
    @GraphTransaction
    public void addClassifications(String guid, List<AtlasClassification> classifications) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding classifications={} to entity={}", classifications, (Object)guid);
        }
        if (StringUtils.isEmpty((CharSequence)guid)) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"Guid(s) not specified"});
        }
        if (CollectionUtils.isEmpty(classifications)) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"classifications(s) not specified"});
        }
        AtlasVertex entityVertex = AtlasGraphUtilsV2.findByGuid(guid);
        if (entityVertex == null) {
            throw new AtlasBaseException(AtlasErrorCode.INSTANCE_GUID_NOT_FOUND, new String[]{guid});
        }
        AtlasEntityHeader entityHeader = this.entityRetriever.toAtlasEntityHeaderWithClassifications(entityVertex);
        for (AtlasClassification classification : classifications) {
            AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)new AtlasEntityAccessRequest(this.typeRegistry, AtlasPrivilege.ENTITY_ADD_CLASSIFICATION, entityHeader, classification), (Object[])new Object[]{"add classification: guid=", guid, ", classification=", classification.getTypeName()});
        }
        EntityMutationContext context = new EntityMutationContext();
        context.cacheEntity(guid, entityVertex, this.typeRegistry.getEntityTypeByName(entityHeader.getTypeName()));
        GraphTransactionInterceptor.lockObjectAndReleasePostCommit(guid);
        for (AtlasClassification classification : classifications) {
            this.validateAndNormalize(classification);
        }
        this.validateEntityAssociations(guid, classifications);
        this.entityGraphMapper.addClassifications(context, guid, classifications);
    }

    @Override
    @GraphTransaction
    public void updateClassifications(String guid, List<AtlasClassification> classifications) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Updating classifications={} for entity={}", classifications, (Object)guid);
        }
        if (StringUtils.isEmpty((CharSequence)guid)) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"Guid not specified"});
        }
        if (CollectionUtils.isEmpty(classifications)) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"classifications(s) not specified"});
        }
        AtlasVertex entityVertex = AtlasGraphUtilsV2.findByGuid(guid);
        if (entityVertex == null) {
            throw new AtlasBaseException(AtlasErrorCode.INSTANCE_GUID_NOT_FOUND, new String[]{guid});
        }
        AtlasEntityHeader entityHeader = this.entityRetriever.toAtlasEntityHeaderWithClassifications(entityVertex);
        for (AtlasClassification classification : classifications) {
            AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)new AtlasEntityAccessRequest(this.typeRegistry, AtlasPrivilege.ENTITY_UPDATE_CLASSIFICATION, entityHeader, classification), (Object[])new Object[]{"update classification: guid=", guid, ", classification=", classification.getTypeName()});
        }
        EntityMutationContext context = new EntityMutationContext();
        context.cacheEntity(guid, entityVertex, this.typeRegistry.getEntityTypeByName(entityHeader.getTypeName()));
        GraphTransactionInterceptor.lockObjectAndReleasePostCommit(guid);
        for (AtlasClassification classification : classifications) {
            this.validateAndNormalize(classification);
        }
        this.entityGraphMapper.updateClassifications(context, guid, classifications);
    }

    @Override
    @GraphTransaction
    public void addClassification(List<String> guids, AtlasClassification classification) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding classification={} to entities={}", (Object)classification, guids);
        }
        if (CollectionUtils.isEmpty(guids)) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"Guid(s) not specified"});
        }
        if (classification == null) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"classification not specified"});
        }
        EntityMutationContext context = new EntityMutationContext();
        for (String guid : guids) {
            AtlasVertex entityVertex = AtlasGraphUtilsV2.findByGuid(guid);
            if (entityVertex == null) {
                throw new AtlasBaseException(AtlasErrorCode.INSTANCE_GUID_NOT_FOUND, new String[]{guid});
            }
            AtlasEntityHeader entityHeader = this.entityRetriever.toAtlasEntityHeaderWithClassifications(entityVertex);
            AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)new AtlasEntityAccessRequest(this.typeRegistry, AtlasPrivilege.ENTITY_ADD_CLASSIFICATION, entityHeader, classification), (Object[])new Object[]{"add classification: guid=", guid, ", classification=", classification.getTypeName()});
            context.cacheEntity(guid, entityVertex, this.typeRegistry.getEntityTypeByName(entityHeader.getTypeName()));
        }
        GraphTransactionInterceptor.lockObjectAndReleasePostCommit(guids);
        this.validateAndNormalize(classification);
        List<AtlasClassification> classifications = Collections.singletonList(classification);
        for (String guid : guids) {
            this.validateEntityAssociations(guid, classifications);
            this.entityGraphMapper.addClassifications(context, guid, classifications);
        }
    }

    @Override
    @GraphTransaction
    public void deleteClassification(String guid, String classificationName) throws AtlasBaseException {
        this.deleteClassification(guid, classificationName, null);
    }

    @Override
    @GraphTransaction
    public void deleteClassification(String guid, String classificationName, String associatedEntityGuid) throws AtlasBaseException {
        if (StringUtils.isEmpty((CharSequence)guid)) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"Guid(s) not specified"});
        }
        if (StringUtils.isEmpty((CharSequence)classificationName)) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"classifications not specified"});
        }
        AtlasEntityHeader entityHeader = this.entityRetriever.toAtlasEntityHeaderWithClassifications(guid);
        if (StringUtils.isEmpty((CharSequence)associatedEntityGuid) || guid.equals(associatedEntityGuid)) {
            AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)new AtlasEntityAccessRequest(this.typeRegistry, AtlasPrivilege.ENTITY_REMOVE_CLASSIFICATION, entityHeader, new AtlasClassification(classificationName)), (Object[])new Object[]{"remove classification: guid=", guid, ", classification=", classificationName});
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Deleting classification={} from entity={}", (Object)classificationName, (Object)guid);
        }
        GraphTransactionInterceptor.lockObjectAndReleasePostCommit(guid);
        this.entityGraphMapper.deleteClassification(guid, classificationName, associatedEntityGuid);
    }

    @GraphTransaction
    public List<AtlasClassification> retrieveClassifications(String guid) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Retriving classifications for entity={}", (Object)guid);
        }
        AtlasEntityHeader entityHeader = this.entityRetriever.toAtlasEntityHeaderWithClassifications(guid);
        return entityHeader.getClassifications();
    }

    @Override
    @GraphTransaction
    public List<AtlasClassification> getClassifications(String guid) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Getting classifications for entity={}", (Object)guid);
        }
        AtlasEntityHeader entityHeader = this.entityRetriever.toAtlasEntityHeaderWithClassifications(guid);
        AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)new AtlasEntityAccessRequest(this.typeRegistry, AtlasPrivilege.ENTITY_READ, entityHeader), (Object[])new Object[]{"get classifications: guid=", guid});
        return entityHeader.getClassifications();
    }

    @Override
    @GraphTransaction
    public AtlasClassification getClassification(String guid, String classificationName) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Getting classifications for entities={}", (Object)guid);
        }
        AtlasClassification ret = null;
        AtlasEntityHeader entityHeader = this.entityRetriever.toAtlasEntityHeaderWithClassifications(guid);
        if (CollectionUtils.isNotEmpty((Collection)entityHeader.getClassifications())) {
            AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)new AtlasEntityAccessRequest(this.typeRegistry, AtlasPrivilege.ENTITY_READ, entityHeader), (Object[])new Object[]{"get classification: guid=", guid, ", classification=", classificationName});
            for (AtlasClassification classification : entityHeader.getClassifications()) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)classification.getTypeName(), (CharSequence)classificationName)) continue;
                if (StringUtils.isEmpty((CharSequence)classification.getEntityGuid()) || StringUtils.equalsIgnoreCase((CharSequence)classification.getEntityGuid(), (CharSequence)guid)) {
                    ret = classification;
                    break;
                }
                if (ret != null) continue;
                ret = classification;
            }
        }
        if (ret == null) {
            throw new AtlasBaseException(AtlasErrorCode.CLASSIFICATION_NOT_FOUND, new String[]{classificationName});
        }
        return ret;
    }

    @Override
    @GraphTransaction
    public String setClassifications(AtlasEntityHeaders entityHeaders) {
        ClassificationAssociator.Updater associator = new ClassificationAssociator.Updater(this.typeRegistry, this);
        return associator.setClassifications(entityHeaders.getGuidHeaderMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EntityMutationResponse createOrUpdate(EntityStream entityStream, boolean isPartialUpdate, boolean replaceClassifications) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> createOrUpdate()");
        }
        if (entityStream == null || !entityStream.hasNext()) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"no entities to create/update."});
        }
        AtlasPerfTracer perf = null;
        if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
            perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)"createOrUpdate()");
        }
        AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("createOrUpdate");
        try {
            EntityMutationContext context = this.preCreateOrUpdate(entityStream, this.entityGraphMapper, isPartialUpdate);
            if (!RequestContext.get().isImportInProgress()) {
                for (AtlasEntity entity : context.getCreatedEntities()) {
                    AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)new AtlasEntityAccessRequest(this.typeRegistry, AtlasPrivilege.ENTITY_CREATE, new AtlasEntityHeader(entity)), (Object[])new Object[]{"create entity: type=", entity.getTypeName()});
                }
            }
            if (CollectionUtils.isNotEmpty(context.getUpdatedEntities())) {
                AtlasPerfMetrics.MetricRecorder checkForUnchangedEntities = RequestContext.get().startMetricRecord("checkForUnchangedEntities");
                ArrayList<AtlasEntity> entitiesToSkipUpdate = null;
                for (AtlasEntity entity : context.getUpdatedEntities()) {
                    Object newVal;
                    String guid = entity.getGuid();
                    AtlasVertex vertex = context.getVertex(guid);
                    AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(entity.getTypeName());
                    boolean hasUpdates = false;
                    if (!hasUpdates) {
                        boolean bl = hasUpdates = entity.getStatus() == AtlasEntity.Status.DELETED;
                    }
                    if (!hasUpdates && MapUtils.isNotEmpty((Map)entity.getAttributes())) {
                        for (AtlasStructType.AtlasAttribute attribute : entityType.getAllAttributes().values()) {
                            if (!entity.getAttributes().containsKey(attribute.getName())) continue;
                            newVal = entity.getAttribute(attribute.getName());
                            Object currVal = this.entityRetriever.getEntityAttribute(vertex, attribute);
                            if (attribute.getAttributeType().areEqualValues(currVal, newVal, context.getGuidAssignments())) continue;
                            hasUpdates = true;
                            if (!LOG.isDebugEnabled()) break;
                            LOG.debug("found attribute update: entity(guid={}, typeName={}), attrName={}, currValue={}, newValue={}", new Object[]{guid, entity.getTypeName(), attribute.getName(), currVal, newVal});
                            break;
                        }
                    }
                    if (!hasUpdates && MapUtils.isNotEmpty((Map)entity.getRelationshipAttributes())) {
                        for (String attributeName : entityType.getRelationshipAttributes().keySet()) {
                            if (!entity.getRelationshipAttributes().containsKey(attributeName)) continue;
                            newVal = entity.getRelationshipAttribute(attributeName);
                            String relationshipType = AtlasEntityUtil.getRelationshipType((Object)newVal);
                            AtlasStructType.AtlasAttribute attribute = entityType.getRelationshipAttribute(attributeName, relationshipType);
                            Object currVal = this.entityRetriever.getEntityAttribute(vertex, attribute);
                            if (attribute.getAttributeType().areEqualValues(currVal, newVal, context.getGuidAssignments())) continue;
                            hasUpdates = true;
                            if (!LOG.isDebugEnabled()) break;
                            LOG.debug("found relationship attribute update: entity(guid={}, typeName={}), attrName={}, currValue={}, newValue={}", new Object[]{guid, entity.getTypeName(), attribute.getName(), currVal, newVal});
                            break;
                        }
                    }
                    if (!hasUpdates && replaceClassifications) {
                        List newVal2 = entity.getClassifications();
                        List<AtlasClassification> currVal = this.entityRetriever.getAllClassifications(vertex);
                        if (!Objects.equals(currVal, newVal2)) {
                            hasUpdates = true;
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("found classifications update: entity(guid={}, typeName={}), currValue={}, newValue={}", new Object[]{guid, entity.getTypeName(), currVal, newVal2});
                            }
                        }
                    }
                    if (hasUpdates) continue;
                    if (entitiesToSkipUpdate == null) {
                        entitiesToSkipUpdate = new ArrayList<AtlasEntity>();
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("skipping unchanged entity: {}", (Object)entity);
                    }
                    entitiesToSkipUpdate.add(entity);
                }
                if (entitiesToSkipUpdate != null) {
                    context.getUpdatedEntities().removeAll(entitiesToSkipUpdate);
                }
                if (!RequestContext.get().isImportInProgress()) {
                    for (AtlasEntity entity : context.getUpdatedEntities()) {
                        AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)new AtlasEntityAccessRequest(this.typeRegistry, AtlasPrivilege.ENTITY_UPDATE, new AtlasEntityHeader(entity)), (Object[])new Object[]{"update entity: type=", entity.getTypeName()});
                    }
                }
                RequestContext.get().endMetricRecord(checkForUnchangedEntities);
            }
            EntityMutationResponse ret = this.entityGraphMapper.mapAttributesAndClassifications(context, isPartialUpdate, replaceClassifications);
            ret.setGuidAssignments(context.getGuidAssignments());
            this.entityChangeNotifier.onEntitiesMutated(ret, RequestContext.get().isImportInProgress());
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== createOrUpdate()");
            }
            EntityMutationResponse entityMutationResponse = ret;
            return entityMutationResponse;
        }
        finally {
            RequestContext.get().endMetricRecord(metric);
            AtlasPerfTracer.log((AtlasPerfTracer)perf);
        }
    }

    private EntityMutationContext preCreateOrUpdate(EntityStream entityStream, EntityGraphMapper entityGraphMapper, boolean isPartialUpdate) throws AtlasBaseException {
        AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("preCreateOrUpdate");
        AtlasEntityGraphDiscoveryV2 graphDiscoverer = new AtlasEntityGraphDiscoveryV2(this.typeRegistry, entityStream);
        EntityGraphDiscoveryContext discoveryContext = graphDiscoverer.discoverEntities();
        EntityMutationContext context = new EntityMutationContext(discoveryContext);
        RequestContext requestContext = RequestContext.get();
        for (String guid : discoveryContext.getReferencedGuids()) {
            AtlasEntity entity = entityStream.getByGuid(guid);
            if (entity == null) continue;
            AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(entity.getTypeName());
            if (entityType == null) {
                throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_INVALID, new String[]{TypeCategory.ENTITY.name(), entity.getTypeName()});
            }
            this.compactAttributes(entity, entityType);
            AtlasVertex vertex = this.getResolvedEntityVertex(discoveryContext, entity);
            if (vertex != null) {
                if (!isPartialUpdate) {
                    graphDiscoverer.validateAndNormalize(entity);
                } else {
                    graphDiscoverer.validateAndNormalizeForUpdate(entity);
                }
                String guidVertex = AtlasGraphUtilsV2.getIdFromVertex(vertex);
                if (!StringUtils.equals((CharSequence)guidVertex, (CharSequence)guid)) {
                    entity.setGuid(guidVertex);
                    requestContext.recordEntityGuidUpdate(entity, guid);
                }
                context.addUpdated(guid, entity, entityType, vertex);
            } else {
                graphDiscoverer.validateAndNormalize(entity);
                vertex = RequestContext.get().isImportInProgress() && AtlasTypeUtil.isAssignedGuid((String)entity.getGuid()) ? entityGraphMapper.createVertexWithGuid(entity, entity.getGuid()) : entityGraphMapper.createVertex(entity);
                discoveryContext.addResolvedGuid(guid, vertex);
                discoveryContext.addResolvedIdByUniqAttribs(this.getAtlasObjectId(entity), vertex);
                String generatedGuid = AtlasGraphUtilsV2.getIdFromVertex(vertex);
                entity.setGuid(generatedGuid);
                requestContext.recordEntityGuidUpdate(entity, guid);
                context.addCreated(guid, entity, entityType, vertex);
            }
            if (!RequestContext.get().isImportInProgress()) continue;
            AtlasEntity.Status newStatus = entity.getStatus();
            if (newStatus != null) {
                AtlasEntity.Status currStatus = AtlasGraphUtilsV2.getState((AtlasElement)vertex);
                if (currStatus == AtlasEntity.Status.ACTIVE && newStatus == AtlasEntity.Status.DELETED) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("entity-delete via import - guid={}", (Object)guid);
                    }
                    context.addEntityToDelete(vertex);
                } else if (currStatus == AtlasEntity.Status.DELETED && newStatus == AtlasEntity.Status.ACTIVE) {
                    LOG.warn("attempt to activate deleted entity (guid={}). Ignored", (Object)guid);
                    entity.setStatus(currStatus);
                }
            }
            entityGraphMapper.updateSystemAttributes(vertex, entity);
        }
        RequestContext.get().endMetricRecord(metric);
        return context;
    }

    private AtlasVertex getResolvedEntityVertex(EntityGraphDiscoveryContext context, AtlasEntity entity) throws AtlasBaseException {
        AtlasObjectId objectId = this.getAtlasObjectId(entity);
        AtlasVertex ret = context.getResolvedEntityVertex(entity.getGuid());
        if (ret != null) {
            context.addResolvedIdByUniqAttribs(objectId, ret);
        } else {
            ret = context.getResolvedEntityVertex(objectId);
            if (ret != null) {
                context.addResolvedGuid(entity.getGuid(), ret);
            }
        }
        return ret;
    }

    private AtlasObjectId getAtlasObjectId(AtlasEntity entity) {
        AtlasObjectId ret = this.entityRetriever.toAtlasObjectId(entity);
        if (ret != null && MapUtils.isNotEmpty((Map)ret.getUniqueAttributes())) {
            ret.setGuid(null);
        }
        return ret;
    }

    private EntityMutationResponse deleteVertices(Collection<AtlasVertex> deletionCandidates) throws AtlasBaseException {
        EntityMutationResponse response = new EntityMutationResponse();
        RequestContext req = RequestContext.get();
        this.deleteDelegate.getHandler().deleteEntities(deletionCandidates);
        for (AtlasEntityHeader entity : req.getDeletedEntities()) {
            response.addEntity(EntityMutations.EntityOperation.DELETE, entity);
        }
        for (AtlasEntityHeader entity : req.getUpdatedEntities()) {
            response.addEntity(EntityMutations.EntityOperation.UPDATE, entity);
        }
        return response;
    }

    private void validateAndNormalize(AtlasClassification classification) throws AtlasBaseException {
        AtlasClassificationType type = this.typeRegistry.getClassificationTypeByName(classification.getTypeName());
        if (type == null) {
            throw new AtlasBaseException(AtlasErrorCode.CLASSIFICATION_NOT_FOUND, new String[]{classification.getTypeName()});
        }
        ArrayList messages = new ArrayList();
        type.validateValue((Object)classification, classification.getTypeName(), messages);
        if (!messages.isEmpty()) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, messages);
        }
        type.getNormalizedValue((Object)classification);
    }

    private void validateEntityAssociations(String guid, List<AtlasClassification> classifications) throws AtlasBaseException {
        List<String> entityClassifications = this.getClassificationNames(guid);
        String entityTypeName = AtlasGraphUtilsV2.getTypeNameFromGuid(guid);
        AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(entityTypeName);
        for (AtlasClassification classification : classifications) {
            String newClassification = classification.getTypeName();
            if (CollectionUtils.isNotEmpty(entityClassifications) && entityClassifications.contains(newClassification)) {
                throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"entity: " + guid + ", already associated with classification: " + newClassification});
            }
            AtlasClassificationType classificationType = this.typeRegistry.getClassificationTypeByName(newClassification);
            if (classificationType.canApplyToEntityType(entityType)) continue;
            throw new AtlasBaseException(AtlasErrorCode.INVALID_ENTITY_FOR_CLASSIFICATION, new String[]{guid, entityTypeName, newClassification});
        }
    }

    private List<String> getClassificationNames(String guid) throws AtlasBaseException {
        ArrayList<String> ret = null;
        List<AtlasClassification> classifications = this.retrieveClassifications(guid);
        if (CollectionUtils.isNotEmpty(classifications)) {
            ret = new ArrayList<String>();
            for (AtlasClassification classification : classifications) {
                String entityGuid = classification.getEntityGuid();
                if (!StringUtils.isEmpty((CharSequence)entityGuid) && !StringUtils.equalsIgnoreCase((CharSequence)guid, (CharSequence)entityGuid)) continue;
                ret.add(classification.getTypeName());
            }
        }
        return ret;
    }

    private void compactAttributes(AtlasEntity entity, AtlasEntityType entityType) {
        if (entity != null) {
            for (String attrName : entityType.getRelationshipAttributes().keySet()) {
                Object attrValue;
                if (!entity.hasAttribute(attrName) || (attrValue = entity.removeAttribute(attrName)) == null) continue;
                Object relationshipAttrValue = entity.getRelationshipAttribute(attrName);
                if (relationshipAttrValue == null) {
                    entity.setRelationshipAttribute(attrName, attrValue);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("moved attribute {}.{} from attributes to relationshipAttributes", (Object)entityType.getTypeName(), (Object)attrName);
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("attribute {}.{} is present in attributes and relationshipAttributes. Removed from attributes", (Object)entityType.getTypeName(), (Object)attrName);
            }
        }
    }
}

