/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.RequestContext;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.instance.AtlasStruct;
import org.apache.atlas.repository.store.graph.EntityGraphDiscovery;
import org.apache.atlas.repository.store.graph.EntityGraphDiscoveryContext;
import org.apache.atlas.repository.store.graph.EntityResolver;
import org.apache.atlas.repository.store.graph.v2.EntityStream;
import org.apache.atlas.repository.store.graph.v2.IDBasedEntityResolver;
import org.apache.atlas.repository.store.graph.v2.UniqAttrBasedEntityResolver;
import org.apache.atlas.type.AtlasArrayType;
import org.apache.atlas.type.AtlasBuiltInTypes;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasMapType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.type.AtlasTypeUtil;
import org.apache.atlas.utils.AtlasEntityUtil;
import org.apache.atlas.utils.AtlasPerfMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasEntityGraphDiscoveryV2
implements EntityGraphDiscovery {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasEntityGraphDiscoveryV2.class);
    private final AtlasTypeRegistry typeRegistry;
    private final EntityGraphDiscoveryContext discoveryContext;

    public AtlasEntityGraphDiscoveryV2(AtlasTypeRegistry typeRegistry, EntityStream entityStream) {
        this.typeRegistry = typeRegistry;
        this.discoveryContext = new EntityGraphDiscoveryContext(typeRegistry, entityStream);
    }

    @Override
    public void init() throws AtlasBaseException {
    }

    @Override
    public EntityGraphDiscoveryContext discoverEntities() throws AtlasBaseException {
        this.discover();
        this.resolveReferences();
        return this.discoveryContext;
    }

    @Override
    public void validateAndNormalize(AtlasEntity entity) throws AtlasBaseException {
        ArrayList messages = new ArrayList();
        if (!AtlasTypeUtil.isValidGuid((String)entity.getGuid())) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_OBJECT_ID, new String[]{"invalid guid " + entity.getGuid()});
        }
        AtlasEntityType type = this.typeRegistry.getEntityTypeByName(entity.getTypeName());
        if (type == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_INVALID, new String[]{TypeCategory.ENTITY.name(), entity.getTypeName()});
        }
        type.validateValue((Object)entity, entity.getTypeName(), messages);
        if (!messages.isEmpty()) {
            throw new AtlasBaseException(AtlasErrorCode.INSTANCE_CRUD_INVALID_PARAMS, messages);
        }
        type.getNormalizedValue((Object)entity);
    }

    @Override
    public void validateAndNormalizeForUpdate(AtlasEntity entity) throws AtlasBaseException {
        ArrayList messages = new ArrayList();
        if (!AtlasTypeUtil.isValidGuid((String)entity.getGuid())) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_OBJECT_ID, new String[]{"invalid guid " + entity.getGuid()});
        }
        AtlasEntityType type = this.typeRegistry.getEntityTypeByName(entity.getTypeName());
        if (type == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_INVALID, new String[]{TypeCategory.ENTITY.name(), entity.getTypeName()});
        }
        type.validateValueForUpdate((Object)entity, entity.getTypeName(), messages);
        if (!messages.isEmpty()) {
            throw new AtlasBaseException(AtlasErrorCode.INSTANCE_CRUD_INVALID_PARAMS, messages);
        }
        type.getNormalizedValueForUpdate((Object)entity);
    }

    @Override
    public void cleanUp() throws AtlasBaseException {
        this.discoveryContext.cleanUp();
    }

    protected void discover() throws AtlasBaseException {
        AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("walkEntityGraph");
        EntityStream entityStream = this.discoveryContext.getEntityStream();
        HashSet<String> walkedEntities = new HashSet<String>();
        while (entityStream.hasNext()) {
            AtlasEntity entity = entityStream.next();
            if (entity == null) {
                throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"found null entity"});
            }
            this.walkEntityGraph(entity);
            walkedEntities.add(entity.getGuid());
        }
        List<String> referencedGuids = this.discoveryContext.getReferencedGuids();
        for (int i = 0; i < referencedGuids.size(); ++i) {
            AtlasEntity entity;
            String guid = referencedGuids.get(i);
            if (walkedEntities.contains(guid) || (entity = entityStream.getByGuid(guid)) == null) continue;
            this.walkEntityGraph(entity);
            walkedEntities.add(entity.getGuid());
        }
        RequestContext.get().endMetricRecord(metric);
    }

    protected void resolveReferences() throws AtlasBaseException {
        EntityResolver[] entityResolvers;
        AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("resolveReferences");
        for (EntityResolver resolver : entityResolvers = new EntityResolver[]{new IDBasedEntityResolver(this.typeRegistry), new UniqAttrBasedEntityResolver(this.typeRegistry)}) {
            resolver.resolveEntityReferences(this.discoveryContext);
        }
        RequestContext.get().endMetricRecord(metric);
    }

    private void visitReference(AtlasBuiltInTypes.AtlasObjectIdType type, Object val) throws AtlasBaseException {
        if (type == null || val == null) {
            return;
        }
        if (val instanceof AtlasObjectId) {
            AtlasObjectId objId = (AtlasObjectId)val;
            if (!AtlasTypeUtil.isValid((AtlasObjectId)objId)) {
                throw new AtlasBaseException(AtlasErrorCode.INVALID_OBJECT_ID, new String[]{objId.toString()});
            }
            this.recordObjectReference(objId);
        } else if (val instanceof Map) {
            AtlasObjectId objId = new AtlasObjectId((Map)val);
            if (!AtlasTypeUtil.isValid((AtlasObjectId)objId)) {
                throw new AtlasBaseException(AtlasErrorCode.INVALID_OBJECT_ID, new String[]{objId.toString()});
            }
            this.recordObjectReference(objId);
        } else {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_OBJECT_ID, new String[]{val.toString()});
        }
    }

    void visitAttribute(AtlasType attrType, Object val) throws AtlasBaseException {
        if (attrType == null || val == null) {
            return;
        }
        switch (attrType.getTypeCategory()) {
            case PRIMITIVE: 
            case ENUM: {
                return;
            }
            case ARRAY: {
                AtlasArrayType arrayType = (AtlasArrayType)attrType;
                AtlasType elemType = arrayType.getElementType();
                this.visitCollectionReferences(elemType, val);
                break;
            }
            case MAP: {
                AtlasType keyType = ((AtlasMapType)attrType).getKeyType();
                AtlasType valueType = ((AtlasMapType)attrType).getValueType();
                this.visitMapReferences(keyType, valueType, val);
                break;
            }
            case STRUCT: {
                this.visitStruct((AtlasStructType)attrType, val);
                break;
            }
            case OBJECT_ID_TYPE: {
                this.visitReference((AtlasBuiltInTypes.AtlasObjectIdType)attrType, val);
                break;
            }
            default: {
                throw new AtlasBaseException(AtlasErrorCode.TYPE_CATEGORY_INVALID, new String[]{attrType.getTypeCategory().name()});
            }
        }
    }

    void visitMapReferences(AtlasType keyType, AtlasType valueType, Object val) throws AtlasBaseException {
        if (keyType == null || valueType == null || val == null) {
            return;
        }
        if (this.isPrimitive(keyType.getTypeCategory()) && this.isPrimitive(valueType.getTypeCategory())) {
            return;
        }
        if (Map.class.isAssignableFrom(val.getClass())) {
            for (Map.Entry e : ((Map)val).entrySet()) {
                this.visitAttribute(keyType, e.getKey());
                this.visitAttribute(valueType, e.getValue());
            }
        }
    }

    void visitCollectionReferences(AtlasType elemType, Object val) throws AtlasBaseException {
        if (elemType == null || val == null || this.isPrimitive(elemType.getTypeCategory())) {
            return;
        }
        Iterator<Object> it = null;
        if (val instanceof Collection) {
            it = ((Collection)val).iterator();
        } else if (val instanceof Iterable) {
            it = ((Iterable)val).iterator();
        } else if (val instanceof Iterator) {
            it = (Iterator)val;
        }
        if (it != null) {
            while (it.hasNext()) {
                Object elem = it.next();
                this.visitAttribute(elemType, elem);
            }
        }
    }

    void visitStruct(AtlasStructType structType, Object val) throws AtlasBaseException {
        AtlasStruct struct;
        if (structType == null || val == null) {
            return;
        }
        if (val instanceof AtlasStruct) {
            struct = (AtlasStruct)val;
        } else if (val instanceof Map) {
            Map attributes = AtlasTypeUtil.toStructAttributes((Map)((Map)val));
            struct = new AtlasStruct(structType.getTypeName(), attributes);
        } else {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_STRUCT_VALUE, new String[]{val.toString()});
        }
        this.visitStruct(structType, struct);
    }

    void visitEntity(AtlasEntityType entityType, AtlasEntity entity) throws AtlasBaseException {
        ArrayList<String> visitedAttributes = new ArrayList<String>();
        this.visitRelationships(entityType, entity, visitedAttributes);
        for (AtlasStructType.AtlasAttribute attribute : entityType.getAllAttributes().values()) {
            AtlasType attrType = attribute.getAttributeType();
            String attrName = attribute.getName();
            Object attrVal = entity.getAttribute(attrName);
            if (!entity.hasAttribute(attrName) || visitedAttributes.contains(attrName)) continue;
            this.visitAttribute(attrType, attrVal);
        }
    }

    private void visitRelationships(AtlasEntityType entityType, AtlasEntity entity, List<String> visitedAttributes) throws AtlasBaseException {
        for (String attrName : entityType.getRelationshipAttributes().keySet()) {
            AtlasStructType.AtlasAttribute attribute;
            String relationshipType;
            Object attrVal;
            if (entity.hasRelationshipAttribute(attrName)) {
                attrVal = entity.getRelationshipAttribute(attrName);
                relationshipType = AtlasEntityUtil.getRelationshipType((Object)attrVal);
                attribute = entityType.getRelationshipAttribute(attrName, relationshipType);
                this.visitAttribute(attribute.getAttributeType(), attrVal);
                visitedAttributes.add(attrName);
                continue;
            }
            if (!entity.hasAttribute(attrName)) continue;
            attrVal = entity.getAttribute(attrName);
            relationshipType = AtlasEntityUtil.getRelationshipType((Object)attrVal);
            attribute = entityType.getRelationshipAttribute(attrName, relationshipType);
            this.visitAttribute(attribute.getAttributeType(), attrVal);
            visitedAttributes.add(attrName);
        }
    }

    void visitStruct(AtlasStructType structType, AtlasStruct struct) throws AtlasBaseException {
        for (AtlasStructType.AtlasAttribute attribute : structType.getAllAttributes().values()) {
            AtlasType attrType = attribute.getAttributeType();
            Object attrVal = struct.getAttribute(attribute.getName());
            this.visitAttribute(attrType, attrVal);
        }
    }

    void walkEntityGraph(AtlasEntity entity) throws AtlasBaseException {
        if (entity == null) {
            return;
        }
        AtlasEntityType type = this.typeRegistry.getEntityTypeByName(entity.getTypeName());
        if (type == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_INVALID, new String[]{TypeCategory.ENTITY.name(), entity.getTypeName()});
        }
        this.recordObjectReference(entity.getGuid());
        this.visitEntity(type, entity);
    }

    boolean isPrimitive(TypeCategory typeCategory) {
        return typeCategory == TypeCategory.PRIMITIVE || typeCategory == TypeCategory.ENUM;
    }

    private void recordObjectReference(String guid) {
        this.discoveryContext.addReferencedGuid(guid);
    }

    private void recordObjectReference(AtlasObjectId objId) {
        if (AtlasTypeUtil.isValidGuid((AtlasObjectId)objId)) {
            this.discoveryContext.addReferencedGuid(objId.getGuid());
        } else {
            this.discoveryContext.addReferencedByUniqAttribs(objId);
        }
    }
}

