/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2;

import java.util.List;
import java.util.regex.Pattern;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.AtlasException;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.query.AtlasDSL;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.AtlasDefStore;
import org.apache.atlas.repository.store.graph.v2.AtlasTypeDefGraphStoreV2;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AtlasAbstractDefStoreV2<T extends AtlasBaseTypeDef>
implements AtlasDefStore<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasAbstractDefStoreV2.class);
    protected final AtlasTypeDefGraphStoreV2 typeDefStore;
    protected final AtlasTypeRegistry typeRegistry;
    private static final String NAME_REGEX = "[a-zA-Z][a-zA-Z0-9_ ]*";
    private static final String INTERNAL_NAME_REGEX = "__[a-zA-Z][a-zA-Z0-9_ ]*";
    private static final Pattern NAME_PATTERN = Pattern.compile("[a-zA-Z][a-zA-Z0-9_ ]*");
    private static final Pattern INTERNAL_NAME_PATTERN = Pattern.compile("__[a-zA-Z][a-zA-Z0-9_ ]*");
    public static final String ALLOW_RESERVED_KEYWORDS = "atlas.types.allowReservedKeywords";

    public AtlasAbstractDefStoreV2(AtlasTypeDefGraphStoreV2 typeDefStore, AtlasTypeRegistry typeRegistry) {
        this.typeDefStore = typeDefStore;
        this.typeRegistry = typeRegistry;
    }

    public void validateType(AtlasBaseTypeDef typeDef) throws AtlasBaseException {
        if (!this.isValidName(typeDef.getName())) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_INVALID_FORMAT, new String[]{typeDef.getName(), typeDef.getCategory().name()});
        }
        try {
            boolean allowReservedKeywords = ApplicationProperties.get().getBoolean(ALLOW_RESERVED_KEYWORDS, true);
            if (!allowReservedKeywords && typeDef instanceof AtlasStructDef) {
                List attributeDefs = ((AtlasStructDef)typeDef).getAttributeDefs();
                for (AtlasStructDef.AtlasAttributeDef attrDef : attributeDefs) {
                    if (!AtlasDSL.Parser.isKeyword(attrDef.getName())) continue;
                    throw new AtlasBaseException(AtlasErrorCode.ATTRIBUTE_NAME_INVALID, new String[]{attrDef.getName(), typeDef.getCategory().name()});
                }
            }
        }
        catch (AtlasException e) {
            LOG.error("Exception while loading configuration ", (Throwable)e);
            throw new AtlasBaseException(AtlasErrorCode.INTERNAL_ERROR, new String[]{"Could not load configuration"});
        }
    }

    public boolean isValidName(String typeName) {
        return NAME_PATTERN.matcher(typeName).matches() || INTERNAL_NAME_PATTERN.matcher(typeName).matches();
    }

    @Override
    public void deleteByName(String name, AtlasVertex preDeleteResult) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasAbstractDefStoreV1.deleteByName({}, {})", (Object)name, (Object)preDeleteResult);
        }
        AtlasVertex vertex = preDeleteResult == null ? this.preDeleteByName(name) : preDeleteResult;
        this.typeDefStore.deleteTypeVertex(vertex);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasAbstractDefStoreV1.deleteByName({}, {})", (Object)name, (Object)preDeleteResult);
        }
    }

    @Override
    public void deleteByGuid(String guid, AtlasVertex preDeleteResult) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasAbstractDefStoreV1.deleteByGuid({}, {})", (Object)guid, (Object)preDeleteResult);
        }
        AtlasVertex vertex = preDeleteResult == null ? this.preDeleteByGuid(guid) : preDeleteResult;
        this.typeDefStore.deleteTypeVertex(vertex);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasAbstractDefStoreV1.deleteByGuid({}, {})", (Object)guid, (Object)preDeleteResult);
        }
    }
}

