/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v1;

import javax.inject.Inject;
import org.apache.atlas.RequestContext;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graph.GraphHelper;
import org.apache.atlas.repository.graphdb.AtlasEdge;
import org.apache.atlas.repository.graphdb.AtlasElement;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.v1.DeleteHandlerV1;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.type.AtlasTypeRegistry;

public class SoftDeleteHandlerV1
extends DeleteHandlerV1 {
    @Inject
    public SoftDeleteHandlerV1(AtlasTypeRegistry typeRegistry) {
        super(typeRegistry, false, true);
    }

    @Override
    protected void _deleteVertex(AtlasVertex instanceVertex, boolean force) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> SoftDeleteHandlerV1._deleteVertex({}, {})", (Object)GraphHelper.string(instanceVertex), (Object)force);
        }
        if (force) {
            graphHelper.removeVertex(instanceVertex);
        } else {
            AtlasEntity.Status state = AtlasGraphUtilsV2.getState((AtlasElement)instanceVertex);
            if (state != AtlasEntity.Status.DELETED) {
                AtlasGraphUtilsV2.setEncodedProperty(instanceVertex, Constants.STATE_PROPERTY_KEY, AtlasEntity.Status.DELETED.name());
                AtlasGraphUtilsV2.setEncodedProperty(instanceVertex, Constants.MODIFICATION_TIMESTAMP_PROPERTY_KEY, RequestContext.get().getRequestTime());
                AtlasGraphUtilsV2.setEncodedProperty(instanceVertex, Constants.MODIFIED_BY_KEY, RequestContext.get().getUser());
            }
        }
    }

    @Override
    protected void deleteEdge(AtlasEdge edge, boolean force) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> SoftDeleteHandlerV1.deleteEdge({}, {})", (Object)GraphHelper.string(edge), (Object)force);
        }
        if (force) {
            graphHelper.removeEdge(edge);
        } else {
            AtlasEntity.Status state = AtlasGraphUtilsV2.getState((AtlasElement)edge);
            if (state != AtlasEntity.Status.DELETED) {
                AtlasGraphUtilsV2.setEncodedProperty(edge, Constants.STATE_PROPERTY_KEY, AtlasEntity.Status.DELETED.name());
                AtlasGraphUtilsV2.setEncodedProperty(edge, Constants.MODIFICATION_TIMESTAMP_PROPERTY_KEY, RequestContext.get().getRequestTime());
                AtlasGraphUtilsV2.setEncodedProperty(edge, Constants.MODIFIED_BY_KEY, RequestContext.get().getUser());
            }
        }
    }
}

