/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v1;

import javax.inject.Inject;
import org.apache.atlas.annotation.ConditionalOnAtlasProperty;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.repository.graph.GraphHelper;
import org.apache.atlas.repository.graphdb.AtlasEdge;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.v1.DeleteHandlerV1;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnAtlasProperty(property="atlas.DeleteHandlerV1.impl")
public class HardDeleteHandlerV1
extends DeleteHandlerV1 {
    @Inject
    public HardDeleteHandlerV1(AtlasTypeRegistry typeRegistry) {
        super(typeRegistry, true, false);
    }

    @Override
    protected void _deleteVertex(AtlasVertex instanceVertex, boolean force) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> SoftDeleteHandlerV1._deleteVertex({}, {})", (Object)GraphHelper.string(instanceVertex), (Object)force);
        }
        graphHelper.removeVertex(instanceVertex);
    }

    @Override
    protected void deleteEdge(AtlasEdge edge, boolean force) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> HardDeleteHandlerV1.deleteEdge({}, {})", (Object)GraphHelper.string(edge), (Object)force);
        }
        graphHelper.removeEdge(edge);
    }
}

