/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v1;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.RequestContext;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.typedef.AtlasRelationshipDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graph.AtlasEdgeLabel;
import org.apache.atlas.repository.graph.GraphHelper;
import org.apache.atlas.repository.graphdb.AtlasEdge;
import org.apache.atlas.repository.graphdb.AtlasEdgeDirection;
import org.apache.atlas.repository.graphdb.AtlasElement;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.repository.store.graph.v2.EntityGraphRetriever;
import org.apache.atlas.type.AtlasArrayType;
import org.apache.atlas.type.AtlasClassificationType;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasMapType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.utils.AtlasEntityUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DeleteHandlerV1 {
    public static final Logger LOG = LoggerFactory.getLogger(DeleteHandlerV1.class);
    protected static final GraphHelper graphHelper = GraphHelper.getInstance();
    private final AtlasTypeRegistry typeRegistry;
    private final EntityGraphRetriever entityRetriever;
    private final boolean shouldUpdateInverseReferences;
    private final boolean softDelete;

    public DeleteHandlerV1(AtlasTypeRegistry typeRegistry, boolean shouldUpdateInverseReference, boolean softDelete) {
        this.typeRegistry = typeRegistry;
        this.entityRetriever = new EntityGraphRetriever(typeRegistry);
        this.shouldUpdateInverseReferences = shouldUpdateInverseReference;
        this.softDelete = softDelete;
    }

    public void deleteEntities(Collection<AtlasVertex> instanceVertices) throws AtlasBaseException {
        RequestContext requestContext = RequestContext.get();
        HashSet<AtlasVertex> deletionCandidateVertices = new HashSet<AtlasVertex>();
        for (AtlasVertex instanceVertex : instanceVertices) {
            String guid = AtlasGraphUtilsV2.getIdFromVertex(instanceVertex);
            AtlasEntity.Status state = AtlasGraphUtilsV2.getState((AtlasElement)instanceVertex);
            if (state == AtlasEntity.Status.DELETED || requestContext.isDeletedEntity(guid)) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Skipping deletion of {} as it is already deleted", (Object)guid);
                continue;
            }
            for (GraphHelper.VertexInfo vertexInfo : this.getOwnedVertices(instanceVertex)) {
                requestContext.recordEntityDelete(vertexInfo.getEntity());
                deletionCandidateVertices.add(vertexInfo.getVertex());
            }
        }
        for (AtlasVertex deletionCandidateVertex : deletionCandidateVertices) {
            this.deleteAllClassifications(deletionCandidateVertex);
            this.deleteTypeVertex(deletionCandidateVertex, this.isInternalType(deletionCandidateVertex));
        }
    }

    public void deleteRelationship(AtlasEdge edge) throws AtlasBaseException {
        this.deleteRelationships(Collections.singleton(edge), false);
    }

    public void deleteRelationships(Collection<AtlasEdge> edges, boolean forceDelete) throws AtlasBaseException {
        for (AtlasEdge edge : edges) {
            boolean isInternal;
            boolean bl = isInternal = this.isInternalType(edge.getInVertex()) && this.isInternalType(edge.getOutVertex());
            if (!isInternal && AtlasGraphUtilsV2.getState((AtlasElement)edge) == AtlasEntity.Status.DELETED) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Skipping deletion of {} as it is already deleted", (Object)AtlasGraphUtilsV2.getIdFromEdge(edge));
                continue;
            }
            this.removeTagPropagation(edge);
            this.deleteEdge(edge, isInternal || forceDelete);
        }
    }

    public Collection<GraphHelper.VertexInfo> getOwnedVertices(AtlasVertex entityVertex) throws AtlasBaseException {
        HashMap<String, GraphHelper.VertexInfo> vertexInfoMap = new HashMap<String, GraphHelper.VertexInfo>();
        Stack<AtlasVertex> vertices = new Stack<AtlasVertex>();
        vertices.push(entityVertex);
        while (vertices.size() > 0) {
            String guid;
            AtlasVertex vertex = (AtlasVertex)vertices.pop();
            AtlasEntity.Status state = AtlasGraphUtilsV2.getState((AtlasElement)vertex);
            if (state == AtlasEntity.Status.DELETED || vertexInfoMap.containsKey(guid = GraphHelper.getGuid((AtlasElement)vertex))) continue;
            AtlasEntityHeader entity = this.entityRetriever.toAtlasEntityHeader(vertex);
            String typeName = entity.getTypeName();
            AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(typeName);
            if (entityType == null) {
                throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_INVALID, new String[]{TypeCategory.ENTITY.name(), typeName});
            }
            vertexInfoMap.put(guid, new GraphHelper.VertexInfo(entity, vertex));
            for (AtlasStructType.AtlasAttribute attributeInfo : entityType.getOwnedRefAttributes()) {
                String edgeLabel = attributeInfo.getRelationshipEdgeLabel();
                AtlasType attrType = attributeInfo.getAttributeType();
                TypeCategory typeCategory = attrType.getTypeCategory();
                if (typeCategory == TypeCategory.OBJECT_ID_TYPE) {
                    if (attributeInfo.getAttributeDef().isSoftReferenced()) {
                        String softRefVal = (String)vertex.getProperty(attributeInfo.getVertexPropertyName(), String.class);
                        AtlasObjectId refObjId = AtlasEntityUtil.parseSoftRefValue((String)softRefVal);
                        AtlasVertex refVertex = refObjId != null ? AtlasGraphUtilsV2.findByGuid(refObjId.getGuid()) : null;
                        if (refVertex == null) continue;
                        vertices.push(refVertex);
                        continue;
                    }
                    AtlasEdge edge = graphHelper.getEdgeForLabel(vertex, edgeLabel);
                    if (edge == null || AtlasGraphUtilsV2.getState((AtlasElement)edge) == AtlasEntity.Status.DELETED) continue;
                    vertices.push(edge.getInVertex());
                    continue;
                }
                if (typeCategory != TypeCategory.ARRAY && typeCategory != TypeCategory.MAP) continue;
                TypeCategory elementType = null;
                if (typeCategory == TypeCategory.ARRAY) {
                    elementType = ((AtlasArrayType)attrType).getElementType().getTypeCategory();
                } else if (typeCategory == TypeCategory.MAP) {
                    elementType = ((AtlasMapType)attrType).getValueType().getTypeCategory();
                }
                if (elementType != TypeCategory.OBJECT_ID_TYPE) continue;
                if (attributeInfo.getAttributeDef().isSoftReferenced()) {
                    AtlasVertex refVertex;
                    Object refObjIds;
                    Object softRefVal;
                    if (typeCategory == TypeCategory.ARRAY) {
                        softRefVal = vertex.getListProperty(attributeInfo.getVertexPropertyName(), List.class);
                        refObjIds = AtlasEntityUtil.parseSoftRefValue((List)softRefVal);
                        if (!CollectionUtils.isNotEmpty((Collection)refObjIds)) continue;
                        Iterator<Object> iterator = refObjIds.iterator();
                        while (iterator.hasNext()) {
                            AtlasObjectId refObjId = (AtlasObjectId)iterator.next();
                            refVertex = AtlasGraphUtilsV2.findByGuid(refObjId.getGuid());
                            if (refVertex == null) continue;
                            vertices.push(refVertex);
                        }
                        continue;
                    }
                    if (typeCategory != TypeCategory.MAP || !MapUtils.isNotEmpty((Map)(refObjIds = AtlasEntityUtil.parseSoftRefValue((Map)(softRefVal = (Map)vertex.getProperty(attributeInfo.getVertexPropertyName(), Map.class)))))) continue;
                    for (AtlasObjectId refObjId : refObjIds.values()) {
                        refVertex = AtlasGraphUtilsV2.findByGuid(refObjId.getGuid());
                        if (refVertex == null) continue;
                        vertices.push(refVertex);
                    }
                    continue;
                }
                List<AtlasEdge> edges = GraphHelper.getCollectionElementsUsingRelationship(vertex, attributeInfo);
                if (!CollectionUtils.isNotEmpty(edges)) continue;
                for (AtlasEdge edge : edges) {
                    if (edge == null || AtlasGraphUtilsV2.getState((AtlasElement)edge) == AtlasEntity.Status.DELETED) continue;
                    vertices.push(edge.getInVertex());
                }
            }
        }
        return vertexInfoMap.values();
    }

    public boolean deleteEdgeReference(AtlasEdge edge, TypeCategory typeCategory, boolean isOwned, boolean forceDeleteStructTrait, AtlasVertex vertex) throws AtlasBaseException {
        return this.deleteEdgeReference(edge, typeCategory, isOwned, forceDeleteStructTrait, AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection.OUT, vertex);
    }

    public boolean deleteEdgeReference(AtlasEdge edge, TypeCategory typeCategory, boolean isOwned, boolean forceDeleteStructTrait, AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection relationshipDirection, AtlasVertex entityVertex) throws AtlasBaseException {
        boolean forceDelete;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Deleting {}, force = {}", (Object)GraphHelper.string(edge), (Object)forceDeleteStructTrait);
        }
        boolean isInternalType = this.isInternalType(entityVertex);
        boolean bl = forceDelete = !(typeCategory != TypeCategory.STRUCT && typeCategory != TypeCategory.CLASSIFICATION || !forceDeleteStructTrait && !isInternalType);
        if (LOG.isDebugEnabled()) {
            LOG.debug("isInternal = {}, forceDelete = {}", (Object)isInternalType, (Object)forceDelete);
        }
        if (typeCategory == TypeCategory.STRUCT || typeCategory == TypeCategory.CLASSIFICATION || typeCategory == TypeCategory.OBJECT_ID_TYPE && isOwned) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing delete for typeCategory={}, isOwned={}", (Object)typeCategory, (Object)isOwned);
            }
            AtlasVertex vertexForDelete = edge.getInVertex();
            this.deleteEdge(edge, false, forceDelete);
            this.deleteTypeVertex(vertexForDelete, typeCategory, forceDelete);
        } else if (GraphHelper.isRelationshipEdge(edge)) {
            RequestContext requestContext;
            this.deleteEdge(edge, isInternalType);
            AtlasVertex referencedVertex = this.entityRetriever.getReferencedEntityVertex(edge, relationshipDirection, entityVertex);
            if (referencedVertex != null && !(requestContext = RequestContext.get()).isUpdatedEntity(GraphHelper.getGuid((AtlasElement)referencedVertex))) {
                AtlasGraphUtilsV2.setEncodedProperty(referencedVertex, Constants.MODIFICATION_TIMESTAMP_PROPERTY_KEY, requestContext.getRequestTime());
                AtlasGraphUtilsV2.setEncodedProperty(referencedVertex, Constants.MODIFIED_BY_KEY, requestContext.getUser());
                requestContext.recordEntityUpdate(this.entityRetriever.toAtlasEntityHeader(referencedVertex));
            }
        } else {
            this.deleteEdge(edge, true, isInternalType);
        }
        return !this.softDelete || forceDelete;
    }

    public void addTagPropagation(AtlasEdge edge, AtlasRelationshipDef.PropagateTags propagateTags) throws AtlasBaseException {
        if (edge == null) {
            return;
        }
        AtlasVertex outVertex = edge.getOutVertex();
        AtlasVertex inVertex = edge.getInVertex();
        if (propagateTags == AtlasRelationshipDef.PropagateTags.ONE_TO_TWO || propagateTags == AtlasRelationshipDef.PropagateTags.BOTH) {
            this.addTagPropagation(outVertex, inVertex, edge);
        }
        if (propagateTags == AtlasRelationshipDef.PropagateTags.TWO_TO_ONE || propagateTags == AtlasRelationshipDef.PropagateTags.BOTH) {
            this.addTagPropagation(inVertex, outVertex, edge);
        }
    }

    private void addTagPropagation(AtlasVertex fromVertex, AtlasVertex toVertex, AtlasEdge edge) throws AtlasBaseException {
        List<AtlasVertex> propagatedEntityVertices;
        List<AtlasVertex> classificationVertices = GraphHelper.getPropagationEnabledClassificationVertices(fromVertex);
        List<AtlasVertex> list = propagatedEntityVertices = CollectionUtils.isNotEmpty(classificationVertices) ? graphHelper.getIncludedImpactedVerticesWithReferences(toVertex, GraphHelper.getRelationshipGuid((AtlasElement)edge)) : null;
        if (CollectionUtils.isNotEmpty(propagatedEntityVertices)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Propagate {} tags: from {} entity to {} entities", new Object[]{classificationVertices.size(), GraphHelper.getTypeName((AtlasElement)fromVertex), propagatedEntityVertices.size()});
            }
            for (AtlasVertex classificationVertex : classificationVertices) {
                this.addTagPropagation(classificationVertex, propagatedEntityVertices);
            }
        }
    }

    public List<AtlasVertex> addTagPropagation(AtlasVertex classificationVertex, List<AtlasVertex> propagatedEntityVertices) throws AtlasBaseException {
        ArrayList<AtlasVertex> ret = null;
        if (CollectionUtils.isNotEmpty(propagatedEntityVertices) && classificationVertex != null) {
            String classificationName = GraphHelper.getTypeName((AtlasElement)classificationVertex);
            AtlasClassificationType classificationType = this.typeRegistry.getClassificationTypeByName(classificationName);
            AtlasVertex associatedEntityVertex = GraphHelper.getAssociatedEntityVertex(classificationVertex);
            for (AtlasVertex propagatedEntityVertex : propagatedEntityVertices) {
                if (GraphHelper.getClassificationEdge(propagatedEntityVertex, classificationVertex) != null) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug(" --> Classification edge already exists from [{}] --> [{}][{}] using edge label: [{}]", new Object[]{GraphHelper.getTypeName((AtlasElement)propagatedEntityVertex), GraphHelper.getTypeName((AtlasElement)classificationVertex), GraphHelper.getTypeName((AtlasElement)associatedEntityVertex), classificationName});
                    continue;
                }
                if (GraphHelper.getPropagatedClassificationEdge(propagatedEntityVertex, classificationVertex) != null) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug(" --> Propagated classification edge already exists from [{}] --> [{}][{}] using edge label: [{}]", new Object[]{GraphHelper.getTypeName((AtlasElement)propagatedEntityVertex), GraphHelper.getTypeName((AtlasElement)classificationVertex), GraphHelper.getTypeName((AtlasElement)associatedEntityVertex), "classifiedAs"});
                    continue;
                }
                String entityTypeName = GraphHelper.getTypeName((AtlasElement)propagatedEntityVertex);
                AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(entityTypeName);
                String entityGuid = GraphHelper.getGuid((AtlasElement)propagatedEntityVertex);
                if (!classificationType.canApplyToEntityType(entityType)) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug(" --> Not creating propagated classification edge from [{}] --> [{}][{}], classification is not applicable for entity type", new Object[]{GraphHelper.getTypeName((AtlasElement)propagatedEntityVertex), GraphHelper.getTypeName((AtlasElement)classificationVertex), GraphHelper.getTypeName((AtlasElement)associatedEntityVertex)});
                    continue;
                }
                AtlasEdge existingEdge = GraphHelper.getPropagatedClassificationEdge(propagatedEntityVertex, classificationVertex);
                if (existingEdge != null) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug(" --> Adding propagated classification: [{}] to {} ({}) using edge label: [{}]", new Object[]{classificationName, GraphHelper.getTypeName((AtlasElement)propagatedEntityVertex), GraphHelper.getGuid((AtlasElement)propagatedEntityVertex), "classifiedAs"});
                }
                if (ret == null) {
                    ret = new ArrayList<AtlasVertex>();
                }
                ret.add(propagatedEntityVertex);
                graphHelper.addClassificationEdge(propagatedEntityVertex, classificationVertex, true);
                GraphHelper.addToPropagatedTraitNames(propagatedEntityVertex, classificationName);
                RequestContext context = RequestContext.get();
                AtlasClassification classification = this.entityRetriever.toAtlasClassification(classificationVertex);
                context.recordAddedPropagation(entityGuid, classification);
            }
        }
        return ret;
    }

    public void removeTagPropagation(AtlasEdge edge) throws AtlasBaseException {
        if (edge == null || !this.isRelationshipEdge(edge)) {
            return;
        }
        List<AtlasVertex> currentClassificationVertices = GraphHelper.getClassificationVertices(edge);
        Map<AtlasVertex, List<AtlasVertex>> currentClassificationsMap = graphHelper.getClassificationPropagatedEntitiesMapping(currentClassificationVertices);
        Map<AtlasVertex, List<AtlasVertex>> updatedClassificationsMap = graphHelper.getClassificationPropagatedEntitiesMapping(currentClassificationVertices, GraphHelper.getRelationshipGuid((AtlasElement)edge));
        HashMap<AtlasVertex, List> removePropagationsMap = new HashMap<AtlasVertex, List>();
        if (MapUtils.isNotEmpty(currentClassificationsMap) && MapUtils.isEmpty(updatedClassificationsMap)) {
            removePropagationsMap.putAll(currentClassificationsMap);
        } else {
            for (AtlasVertex classificationVertex : updatedClassificationsMap.keySet()) {
                List updatedPropagatingEntities;
                List<Object> currentPropagatingEntities = currentClassificationsMap.containsKey(classificationVertex) ? currentClassificationsMap.get(classificationVertex) : Collections.emptyList();
                List entitiesRemoved = (List)CollectionUtils.subtract(currentPropagatingEntities, updatedPropagatingEntities = updatedClassificationsMap.containsKey(classificationVertex) ? updatedClassificationsMap.get(classificationVertex) : Collections.emptyList());
                if (!CollectionUtils.isNotEmpty((Collection)entitiesRemoved)) continue;
                removePropagationsMap.put(classificationVertex, entitiesRemoved);
            }
        }
        boolean isTermEntityEdge = GraphHelper.isTermEntityEdge(edge);
        for (AtlasVertex classificationVertex : removePropagationsMap.keySet()) {
            boolean removePropagations = GraphHelper.getRemovePropagations(classificationVertex);
            if (!isTermEntityEdge && !removePropagations) continue;
            this.removeTagPropagation(classificationVertex, (List)removePropagationsMap.get(classificationVertex));
        }
    }

    public boolean isRelationshipEdge(AtlasEdge edge) {
        boolean ret = false;
        if (edge != null) {
            String outVertexType = GraphHelper.getTypeName((AtlasElement)edge.getOutVertex());
            String inVertexType = GraphHelper.getTypeName((AtlasElement)edge.getInVertex());
            ret = GraphHelper.isRelationshipEdge(edge) || edge.getPropertyKeys().contains(Constants.RELATIONSHIP_GUID_PROPERTY_KEY) || this.typeRegistry.getEntityTypeByName(outVertexType) != null && this.typeRegistry.getEntityTypeByName(inVertexType) != null;
        }
        return ret;
    }

    public List<AtlasVertex> removeTagPropagation(AtlasVertex classificationVertex) throws AtlasBaseException {
        List<AtlasEdge> propagatedEdges;
        ArrayList<AtlasVertex> ret = new ArrayList<AtlasVertex>();
        if (classificationVertex != null && CollectionUtils.isNotEmpty(propagatedEdges = GraphHelper.getPropagatedEdges(classificationVertex))) {
            AtlasClassification classification = this.entityRetriever.toAtlasClassification(classificationVertex);
            for (AtlasEdge propagatedEdge : propagatedEdges) {
                AtlasVertex entityVertex = propagatedEdge.getOutVertex();
                ret.add(entityVertex);
                RequestContext.get().recordRemovedPropagation(GraphHelper.getGuid((AtlasElement)entityVertex), classification);
                this.deletePropagatedEdge(propagatedEdge);
            }
        }
        return ret;
    }

    public void removeTagPropagation(AtlasVertex classificationVertex, List<AtlasVertex> entityVertices) throws AtlasBaseException {
        if (classificationVertex != null && CollectionUtils.isNotEmpty(entityVertices)) {
            String classificationName = GraphHelper.getClassificationName(classificationVertex);
            AtlasClassification classification = this.entityRetriever.toAtlasClassification(classificationVertex);
            String entityGuid = GraphHelper.getClassificationEntityGuid(classificationVertex);
            RequestContext context = RequestContext.get();
            for (AtlasVertex entityVertex : entityVertices) {
                AtlasEdge propagatedEdge = GraphHelper.getPropagatedClassificationEdge(entityVertex, classificationName, entityGuid);
                if (propagatedEdge == null) continue;
                this.deletePropagatedEdge(propagatedEdge);
                context.recordRemovedPropagation(GraphHelper.getGuid((AtlasElement)entityVertex), classification);
            }
        }
    }

    public void removeTagPropagation(AtlasEdge edge, AtlasRelationshipDef.PropagateTags propagateTags) throws AtlasBaseException {
        if (edge == null) {
            return;
        }
        AtlasVertex outVertex = edge.getOutVertex();
        AtlasVertex inVertex = edge.getInVertex();
        if (propagateTags == AtlasRelationshipDef.PropagateTags.ONE_TO_TWO || propagateTags == AtlasRelationshipDef.PropagateTags.BOTH) {
            this.removeTagPropagation(outVertex, inVertex, edge);
        }
        if (propagateTags == AtlasRelationshipDef.PropagateTags.TWO_TO_ONE || propagateTags == AtlasRelationshipDef.PropagateTags.BOTH) {
            this.removeTagPropagation(inVertex, outVertex, edge);
        }
    }

    private void removeTagPropagation(AtlasVertex fromVertex, AtlasVertex toVertex, AtlasEdge edge) throws AtlasBaseException {
        List<AtlasVertex> impactedEntityVertices;
        List<AtlasVertex> classificationVertices = GraphHelper.getPropagationEnabledClassificationVertices(fromVertex);
        List<AtlasVertex> list = impactedEntityVertices = CollectionUtils.isNotEmpty(classificationVertices) ? graphHelper.getIncludedImpactedVerticesWithReferences(toVertex, GraphHelper.getRelationshipGuid((AtlasElement)edge)) : null;
        if (CollectionUtils.isNotEmpty(impactedEntityVertices)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Removing {} propagated tags: for {} from {} entities", new Object[]{classificationVertices.size(), GraphHelper.getTypeName((AtlasElement)fromVertex), impactedEntityVertices.size()});
            }
            for (AtlasVertex classificationVertex : classificationVertices) {
                String classificationName = GraphHelper.getTypeName((AtlasElement)classificationVertex);
                AtlasVertex associatedEntityVertex = GraphHelper.getAssociatedEntityVertex(classificationVertex);
                List<AtlasVertex> referrals = graphHelper.getIncludedImpactedVerticesWithReferences(associatedEntityVertex, GraphHelper.getRelationshipGuid((AtlasElement)edge));
                for (AtlasVertex impactedEntityVertex : impactedEntityVertices) {
                    if (referrals.contains(impactedEntityVertex)) {
                        if (!LOG.isDebugEnabled()) continue;
                        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)GraphHelper.getGuid((AtlasElement)impactedEntityVertex), (CharSequence)GraphHelper.getGuid((AtlasElement)associatedEntityVertex))) {
                            LOG.debug(" --> Not removing propagated classification edge from [{}] --> [{}][{}] with edge label: [{}], since [{}] is associated with [{}]", new Object[]{GraphHelper.getTypeName((AtlasElement)impactedEntityVertex), GraphHelper.getTypeName((AtlasElement)classificationVertex), GraphHelper.getTypeName((AtlasElement)associatedEntityVertex), "classifiedAs", classificationName, GraphHelper.getTypeName((AtlasElement)associatedEntityVertex)});
                            continue;
                        }
                        LOG.debug(" --> Not removing propagated classification edge from [{}] --> [{}][{}] with edge label: [{}], since [{}] is propagated through other path", new Object[]{GraphHelper.getTypeName((AtlasElement)impactedEntityVertex), GraphHelper.getTypeName((AtlasElement)classificationVertex), GraphHelper.getTypeName((AtlasElement)associatedEntityVertex), "classifiedAs", classificationName});
                        continue;
                    }
                    AtlasEdge propagatedEdge = GraphHelper.getPropagatedClassificationEdge(impactedEntityVertex, classificationVertex);
                    if (propagatedEdge != null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(" --> Removing propagated classification edge from [{}] --> [{}][{}] with edge label: [{}]", new Object[]{GraphHelper.getTypeName((AtlasElement)impactedEntityVertex), GraphHelper.getTypeName((AtlasElement)classificationVertex), GraphHelper.getTypeName((AtlasElement)associatedEntityVertex), "classifiedAs"});
                        }
                        graphHelper.removeEdge(propagatedEdge);
                        this.removeFromPropagatedTraitNames(impactedEntityVertex, classificationName);
                        continue;
                    }
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug(" --> Not removing propagated classification edge from [{}] --> [{}][{}] using edge label: [{}], since edge doesn't exist", new Object[]{GraphHelper.getTypeName((AtlasElement)impactedEntityVertex), GraphHelper.getTypeName((AtlasElement)classificationVertex), GraphHelper.getTypeName((AtlasElement)associatedEntityVertex), "classifiedAs"});
                }
            }
        }
    }

    public void deletePropagatedClassification(AtlasVertex entityVertex, String classificationName, String associatedEntityGuid) throws AtlasBaseException {
        AtlasEdge propagatedEdge = GraphHelper.getPropagatedClassificationEdge(entityVertex, classificationName, associatedEntityGuid);
        if (propagatedEdge == null) {
            throw new AtlasBaseException(AtlasErrorCode.PROPAGATED_CLASSIFICATION_NOT_ASSOCIATED_WITH_ENTITY, new String[]{classificationName, associatedEntityGuid, GraphHelper.getGuid((AtlasElement)entityVertex)});
        }
        AtlasVertex classificationVertex = propagatedEdge.getInVertex();
        if (GraphHelper.getClassificationEntityStatus((AtlasElement)classificationVertex) == AtlasEntity.Status.ACTIVE) {
            throw new AtlasBaseException(AtlasErrorCode.PROPAGATED_CLASSIFICATION_REMOVAL_NOT_SUPPORTED, new String[]{classificationName, associatedEntityGuid});
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing propagated classification: [{} - associatedEntityGuid: {}] from: [{}][{}] with edge label: [{}]", new Object[]{classificationName, associatedEntityGuid, GraphHelper.getTypeName((AtlasElement)entityVertex), GraphHelper.getGuid((AtlasElement)entityVertex), "classifiedAs"});
        }
        AtlasClassification classification = this.entityRetriever.toAtlasClassification(classificationVertex);
        this.deletePropagatedEdge(propagatedEdge);
        this.deleteClassificationVertex(classificationVertex, true);
        RequestContext.get().recordRemovedPropagation(GraphHelper.getGuid((AtlasElement)entityVertex), classification);
    }

    public void deletePropagatedEdge(AtlasEdge edge) throws AtlasBaseException {
        String classificationName = AtlasGraphUtilsV2.getEncodedProperty(edge, Constants.CLASSIFICATION_EDGE_NAME_PROPERTY_KEY, String.class);
        AtlasVertex entityVertex = edge.getOutVertex();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing propagated classification: [{}] from: [{}][{}] with edge label: [{}]", new Object[]{classificationName, GraphHelper.getTypeName((AtlasElement)entityVertex), GraphHelper.getGuid((AtlasElement)entityVertex), "classifiedAs"});
        }
        this.removeFromPropagatedTraitNames(entityVertex, classificationName);
        this.deleteEdge(edge, true);
        GraphHelper.updateModificationMetadata(entityVertex);
    }

    public void deleteEdgeReference(AtlasVertex outVertex, String edgeLabel, TypeCategory typeCategory, boolean isOwned) throws AtlasBaseException {
        AtlasEdge edge = graphHelper.getEdgeForLabel(outVertex, edgeLabel);
        if (edge != null) {
            this.deleteEdgeReference(edge, typeCategory, isOwned, false, outVertex);
        }
    }

    protected void deleteEdge(AtlasEdge edge, boolean updateInverseAttribute, boolean force) throws AtlasBaseException {
        AtlasEdgeLabel atlasEdgeLabel;
        AtlasType parentType;
        if (updateInverseAttribute && (parentType = this.typeRegistry.getType((atlasEdgeLabel = new AtlasEdgeLabel(edge.getLabel())).getTypeName())) instanceof AtlasEntityType) {
            AtlasEntityType parentEntityType = (AtlasEntityType)parentType;
            AtlasStructType.AtlasAttribute attribute = parentEntityType.getAttribute(atlasEdgeLabel.getAttributeName());
            if (attribute == null) {
                attribute = parentEntityType.getRelationshipAttribute(atlasEdgeLabel.getAttributeName(), AtlasGraphUtilsV2.getTypeName((AtlasElement)edge));
            }
            if (attribute != null && attribute.getInverseRefAttribute() != null) {
                this.deleteEdgeBetweenVertices(edge.getInVertex(), edge.getOutVertex(), attribute.getInverseRefAttribute());
            }
        }
        if (GraphHelper.isClassificationEdge(edge)) {
            AtlasVertex classificationVertex = edge.getInVertex();
            AtlasGraphUtilsV2.setEncodedProperty(classificationVertex, Constants.CLASSIFICATION_ENTITY_STATUS, AtlasEntity.Status.DELETED.name());
        }
        this.deleteEdge(edge, force);
    }

    protected void deleteTypeVertex(AtlasVertex instanceVertex, TypeCategory typeCategory, boolean force) throws AtlasBaseException {
        switch (typeCategory) {
            case STRUCT: {
                this.deleteTypeVertex(instanceVertex, force);
                break;
            }
            case CLASSIFICATION: {
                this.deleteClassificationVertex(instanceVertex, force);
                break;
            }
            case ENTITY: 
            case OBJECT_ID_TYPE: {
                this.deleteEntities(Collections.singletonList(instanceVertex));
                break;
            }
            default: {
                throw new IllegalStateException("Type category " + typeCategory + " not handled");
            }
        }
    }

    protected void deleteTypeVertex(AtlasVertex instanceVertex, boolean force) throws AtlasBaseException {
        String typeName;
        AtlasType parentType;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Deleting {}, force={}", (Object)GraphHelper.string(instanceVertex), (Object)force);
        }
        if ((parentType = this.typeRegistry.getType(typeName = GraphHelper.getTypeName((AtlasElement)instanceVertex))) instanceof AtlasStructType) {
            AtlasStructType structType = (AtlasStructType)parentType;
            boolean isEntityType = parentType instanceof AtlasEntityType;
            block7: for (AtlasStructType.AtlasAttribute attributeInfo : structType.getAllAttributes().values()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Deleting attribute {} for {}", (Object)attributeInfo.getName(), (Object)GraphHelper.string(instanceVertex));
                }
                boolean isOwned = isEntityType && attributeInfo.isOwnedRef();
                AtlasType attrType = attributeInfo.getAttributeType();
                String edgeLabel = attributeInfo.getRelationshipEdgeLabel();
                switch (attrType.getTypeCategory()) {
                    case OBJECT_ID_TYPE: {
                        this.deleteEdgeReference(instanceVertex, edgeLabel, attrType.getTypeCategory(), isOwned);
                        break;
                    }
                    case STRUCT: {
                        this.deleteEdgeReference(instanceVertex, edgeLabel, attrType.getTypeCategory(), false);
                        break;
                    }
                    case ARRAY: {
                        AtlasArrayType arrType = (AtlasArrayType)attrType;
                        AtlasType elemType = arrType.getElementType();
                        if (!AtlasGraphUtilsV2.isReference(elemType.getTypeCategory())) break;
                        List<AtlasEdge> edges = GraphHelper.getCollectionElementsUsingRelationship(instanceVertex, attributeInfo);
                        if (!CollectionUtils.isNotEmpty(edges)) continue block7;
                        for (AtlasEdge edge : edges) {
                            this.deleteEdgeReference(edge, elemType.getTypeCategory(), isOwned, false, instanceVertex);
                        }
                        continue block7;
                    }
                    case MAP: {
                        AtlasMapType mapType = (AtlasMapType)attrType;
                        TypeCategory valueTypeCategory = mapType.getValueType().getTypeCategory();
                        if (!AtlasGraphUtilsV2.isReference(valueTypeCategory)) break;
                        List<AtlasEdge> edges = GraphHelper.getMapValuesUsingRelationship(instanceVertex, attributeInfo);
                        for (AtlasEdge edge : edges) {
                            this.deleteEdgeReference(edge, valueTypeCategory, isOwned, false, instanceVertex);
                        }
                        continue block7;
                    }
                    case PRIMITIVE: {
                        if (attributeInfo.getVertexUniquePropertyName() == null) break;
                        instanceVertex.removeProperty(attributeInfo.getVertexUniquePropertyName());
                    }
                }
            }
        }
        this.deleteVertex(instanceVertex, force);
    }

    protected AtlasStructType.AtlasAttribute getAttributeForEdge(String edgeLabel) throws AtlasBaseException {
        AtlasEdgeLabel atlasEdgeLabel = new AtlasEdgeLabel(edgeLabel);
        AtlasType parentType = this.typeRegistry.getType(atlasEdgeLabel.getTypeName());
        AtlasStructType parentStructType = (AtlasStructType)parentType;
        return parentStructType.getAttribute(atlasEdgeLabel.getAttributeName());
    }

    protected abstract void _deleteVertex(AtlasVertex var1, boolean var2);

    protected abstract void deleteEdge(AtlasEdge var1, boolean var2) throws AtlasBaseException;

    protected void deleteEdgeBetweenVertices(AtlasVertex outVertex, AtlasVertex inVertex, AtlasStructType.AtlasAttribute attribute) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing edge from {} to {} with attribute name {}", new Object[]{GraphHelper.string(outVertex), GraphHelper.string(inVertex), attribute.getName()});
        }
        String typeName = GraphHelper.getTypeName((AtlasElement)outVertex);
        String outId = GraphHelper.getGuid((AtlasElement)outVertex);
        AtlasEntity.Status state = AtlasGraphUtilsV2.getState((AtlasElement)outVertex);
        if (state == AtlasEntity.Status.DELETED || outId != null && RequestContext.get().isDeletedEntity(outId)) {
            return;
        }
        AtlasStructType parentType = (AtlasStructType)this.typeRegistry.getType(typeName);
        String propertyName = AtlasGraphUtilsV2.getQualifiedAttributePropertyKey(parentType, attribute.getName());
        String edgeLabel = attribute.getRelationshipEdgeLabel();
        AtlasEdge edge = null;
        AtlasStructDef.AtlasAttributeDef attrDef = attribute.getAttributeDef();
        AtlasType attrType = attribute.getAttributeType();
        block0 : switch (attrType.getTypeCategory()) {
            case OBJECT_ID_TYPE: {
                if (attrDef.getIsOptional()) {
                    edge = graphHelper.getEdgeForLabel(outVertex, edgeLabel);
                    if (!this.shouldUpdateInverseReferences) break;
                    AtlasGraphUtilsV2.setEncodedProperty(outVertex, propertyName, null);
                    break;
                }
                throw new AtlasBaseException("Cannot unset required attribute " + propertyName + " on " + GraphHelper.vertexString(outVertex) + " edge = " + edgeLabel);
            }
            case ARRAY: {
                List<AtlasEdge> elementEdges = GraphHelper.getCollectionElementsUsingRelationship(outVertex, attribute);
                if (elementEdges == null) break;
                elementEdges = new ArrayList<AtlasEdge>(elementEdges);
                for (AtlasEdge elementEdge : elementEdges) {
                    AtlasVertex elementVertex;
                    if (elementEdge == null || !(elementVertex = elementEdge.getInVertex()).equals(inVertex)) continue;
                    edge = elementEdge;
                    if (attrDef.getIsOptional() || elementEdges.size() > attrDef.getValuesMinCount()) continue;
                    throw new AtlasBaseException("Cannot remove array element from required attribute " + propertyName + " on " + GraphHelper.getVertexDetails(outVertex) + " " + GraphHelper.getEdgeDetails(elementEdge));
                }
                break;
            }
            case MAP: {
                List<AtlasEdge> mapEdges = GraphHelper.getMapValuesUsingRelationship(outVertex, attribute);
                if (mapEdges == null) break;
                mapEdges = new ArrayList<AtlasEdge>(mapEdges);
                for (AtlasEdge mapEdge : mapEdges) {
                    AtlasVertex mapVertex;
                    if (mapEdge == null || !(mapVertex = mapEdge.getInVertex()).getId().toString().equals(inVertex.getId().toString())) continue;
                    if (attrDef.getIsOptional() || mapEdges.size() > attrDef.getValuesMinCount()) {
                        edge = mapEdge;
                        break block0;
                    }
                    throw new AtlasBaseException("Cannot remove map entry " + propertyName + " from required attribute " + propertyName + " on " + GraphHelper.getVertexDetails(outVertex) + " " + GraphHelper.getEdgeDetails(mapEdge));
                }
                break;
            }
            case STRUCT: 
            case CLASSIFICATION: {
                break;
            }
            default: {
                throw new IllegalStateException("There can't be an edge from " + GraphHelper.getVertexDetails(outVertex) + " to " + GraphHelper.getVertexDetails(inVertex) + " with attribute name " + attribute.getName() + " which is not class/array/map attribute. found " + attrType.getTypeCategory().name());
            }
        }
        if (edge != null) {
            this.deleteEdge(edge, this.isInternalType(inVertex) && this.isInternalType(outVertex));
            RequestContext requestContext = RequestContext.get();
            if (!requestContext.isUpdatedEntity(outId)) {
                AtlasGraphUtilsV2.setEncodedProperty(outVertex, Constants.MODIFICATION_TIMESTAMP_PROPERTY_KEY, requestContext.getRequestTime());
                AtlasGraphUtilsV2.setEncodedProperty(outVertex, Constants.MODIFIED_BY_KEY, requestContext.getUser());
                requestContext.recordEntityUpdate(this.entityRetriever.toAtlasEntityHeader(outVertex));
            }
        }
    }

    protected void deleteVertex(AtlasVertex instanceVertex, boolean force) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Setting the external references to {} to null(removing edges)", (Object)GraphHelper.string(instanceVertex));
        }
        Iterable incomingEdges = instanceVertex.getEdges(AtlasEdgeDirection.IN);
        for (AtlasEdge edge : incomingEdges) {
            AtlasEntity.Status edgeState = AtlasGraphUtilsV2.getState((AtlasElement)edge);
            if (edgeState != AtlasEntity.Status.ACTIVE) continue;
            if (this.isRelationshipEdge(edge)) {
                this.deleteRelationship(edge);
                continue;
            }
            AtlasVertex outVertex = edge.getOutVertex();
            AtlasVertex inVertex = edge.getInVertex();
            AtlasStructType.AtlasAttribute attribute = this.getAttributeForEdge(edge.getLabel());
            this.deleteEdgeBetweenVertices(outVertex, inVertex, attribute);
        }
        this._deleteVertex(instanceVertex, force);
    }

    public void deleteClassificationVertex(AtlasVertex classificationVertex, boolean force) {
        List<AtlasEdge> incomingClassificationEdges;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Deleting classification vertex", (Object)GraphHelper.string(classificationVertex));
        }
        if (CollectionUtils.isEmpty(incomingClassificationEdges = GraphHelper.getIncomingClassificationEdges(classificationVertex))) {
            this._deleteVertex(classificationVertex, force);
        }
    }

    private boolean isInternalType(AtlasVertex instanceVertex) {
        AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(GraphHelper.getTypeName((AtlasElement)instanceVertex));
        return Objects.nonNull(entityType) && entityType.isInternalType();
    }

    private void removeFromPropagatedTraitNames(AtlasVertex entityVertex, String classificationName) {
        if (entityVertex != null && StringUtils.isNotEmpty((String)classificationName)) {
            List<String> propagatedTraitNames = GraphHelper.getTraitNames(entityVertex, true);
            propagatedTraitNames.remove(classificationName);
            entityVertex.removeProperty(Constants.PROPAGATED_TRAIT_NAMES_PROPERTY_KEY);
            for (String propagatedTraitName : propagatedTraitNames) {
                GraphHelper.addToPropagatedTraitNames(entityVertex, propagatedTraitName);
            }
        }
    }

    private void deleteAllClassifications(AtlasVertex instanceVertex) throws AtlasBaseException {
        List<AtlasEdge> classificationEdges = GraphHelper.getAllClassificationEdges(instanceVertex);
        for (AtlasEdge edge : classificationEdges) {
            AtlasVertex classificationVertex = edge.getInVertex();
            boolean isClassificationEdge = GraphHelper.isClassificationEdge(edge);
            boolean removePropagations = GraphHelper.getRemovePropagations(classificationVertex);
            if (isClassificationEdge && removePropagations) {
                this.removeTagPropagation(classificationVertex);
            }
            this.deleteEdgeReference(edge, TypeCategory.CLASSIFICATION, false, false, instanceVertex);
        }
    }
}

