/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v1;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.atlas.RequestContext;
import org.apache.atlas.repository.store.graph.v1.DeleteHandlerV1;
import org.apache.atlas.repository.store.graph.v1.HardDeleteHandlerV1;
import org.apache.atlas.repository.store.graph.v1.SoftDeleteHandlerV1;
import org.apache.atlas.store.DeleteType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.util.AtlasRepositoryConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Singleton
@Component
public class DeleteHandlerDelegate {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteHandlerDelegate.class);
    private final SoftDeleteHandlerV1 softDeleteHandler;
    private final HardDeleteHandlerV1 hardDeleteHandler;
    private final DeleteHandlerV1 defaultHandler;

    @Inject
    public DeleteHandlerDelegate(AtlasTypeRegistry typeRegistry) {
        this.softDeleteHandler = new SoftDeleteHandlerV1(typeRegistry);
        this.hardDeleteHandler = new HardDeleteHandlerV1(typeRegistry);
        this.defaultHandler = this.getDefaultConfiguredHandler(typeRegistry);
    }

    public DeleteHandlerV1 getHandler() {
        return this.getHandler(RequestContext.get().getDeleteType());
    }

    public DeleteHandlerV1 getHandler(DeleteType deleteType) {
        if (deleteType == null) {
            deleteType = DeleteType.DEFAULT;
        }
        switch (deleteType) {
            case SOFT: {
                return this.softDeleteHandler;
            }
            case HARD: {
                return this.hardDeleteHandler;
            }
        }
        return this.defaultHandler;
    }

    private DeleteHandlerV1 getDefaultConfiguredHandler(AtlasTypeRegistry typeRegistry) {
        DeleteHandlerV1 ret = null;
        try {
            Class<? extends DeleteHandlerV1> handlerFromProperties = AtlasRepositoryConfiguration.getDeleteHandlerV1Impl();
            LOG.info("Default delete handler set to: {}", (Object)handlerFromProperties.getName());
            ret = handlerFromProperties.getConstructor(AtlasTypeRegistry.class).newInstance(typeRegistry);
        }
        catch (Exception ex) {
            LOG.error("Error instantiating default delete handler. Defaulting to: {}", (Object)this.softDeleteHandler.getClass().getName(), (Object)ex);
            ret = this.softDeleteHandler;
        }
        return ret;
    }
}

