/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.bootstrap;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.AtlasException;
import org.apache.atlas.RequestContext;
import org.apache.atlas.authorize.AtlasAuthorizerFactory;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.ha.HAConfiguration;
import org.apache.atlas.listener.ActiveStateChangeHandler;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.model.typedef.AtlasClassificationDef;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.model.typedef.AtlasEnumDef;
import org.apache.atlas.model.typedef.AtlasRelationshipDef;
import org.apache.atlas.model.typedef.AtlasRelationshipEndDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.store.AtlasTypeDefStore;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.type.AtlasTypeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AtlasTypeDefStoreInitializer
implements ActiveStateChangeHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasTypeDefStoreInitializer.class);
    public static final String PATCHES_FOLDER_NAME = "patches";
    public static final String RELATIONSHIP_LABEL = "relationshipLabel";
    public static final String RELATIONSHIP_CATEGORY = "relationshipCategory";
    public static final String RELATIONSHIP_SWAP_ENDS = "swapEnds";
    private final AtlasTypeDefStore atlasTypeDefStore;
    private final AtlasTypeRegistry atlasTypeRegistry;
    private final Configuration conf;

    @Inject
    public AtlasTypeDefStoreInitializer(AtlasTypeDefStore atlasTypeDefStore, AtlasTypeRegistry atlasTypeRegistry, Configuration conf) {
        this.atlasTypeDefStore = atlasTypeDefStore;
        this.atlasTypeRegistry = atlasTypeRegistry;
        this.conf = conf;
    }

    @PostConstruct
    public void init() throws AtlasBaseException {
        LOG.info("==> AtlasTypeDefStoreInitializer.init()");
        if (!HAConfiguration.isHAEnabled((Configuration)this.conf)) {
            this.atlasTypeDefStore.init();
            this.loadBootstrapTypeDefs();
            try {
                AtlasAuthorizerFactory.getAtlasAuthorizer();
            }
            catch (Throwable t) {
                LOG.error("AtlasTypeDefStoreInitializer.init(): Unable to obtain AtlasAuthorizer", t);
            }
        } else {
            LOG.info("AtlasTypeDefStoreInitializer.init(): deferring type loading until instance activation");
        }
        LOG.info("<== AtlasTypeDefStoreInitializer.init()");
    }

    private void loadBootstrapTypeDefs() {
        LOG.info("==> AtlasTypeDefStoreInitializer.loadBootstrapTypeDefs()");
        String atlasHomeDir = System.getProperty("atlas.home");
        String modelsDirName = (StringUtils.isEmpty((CharSequence)atlasHomeDir) ? "." : atlasHomeDir) + File.separator + "models";
        if (modelsDirName == null || modelsDirName.length() == 0) {
            LOG.info("Types directory {} does not exist or not readable or has no typedef files", (Object)modelsDirName);
        } else {
            Object[] modelsDirContents;
            File topModeltypesDir = new File(modelsDirName);
            Object[] objectArray = modelsDirContents = topModeltypesDir.exists() ? topModeltypesDir.listFiles() : null;
            if (modelsDirContents != null && modelsDirContents.length > 0) {
                Arrays.sort(modelsDirContents);
                for (Object folder : modelsDirContents) {
                    if (((File)folder).isFile() || ((File)folder).getName().equals(PATCHES_FOLDER_NAME)) continue;
                    this.loadModelsInFolder((File)folder);
                }
            }
            this.loadModelsInFolder(topModeltypesDir);
        }
        LOG.info("<== AtlasTypeDefStoreInitializer.loadBootstrapTypeDefs()");
    }

    private void loadModelsInFolder(File typesDir) {
        Object[] typeDefFiles;
        LOG.info("==> AtlasTypeDefStoreInitializer({})", (Object)typesDir);
        String typesDirName = typesDir.getName();
        Object[] objectArray = typeDefFiles = typesDir.exists() ? typesDir.listFiles() : null;
        if (typeDefFiles == null || typeDefFiles.length == 0) {
            LOG.info("Types directory {} does not exist or not readable or has no typedef files", (Object)typesDirName);
        } else {
            Arrays.sort(typeDefFiles);
            for (Object typeDefFile : typeDefFiles) {
                if (!((File)typeDefFile).isFile()) continue;
                try {
                    String jsonStr = new String(Files.readAllBytes(((File)typeDefFile).toPath()), StandardCharsets.UTF_8);
                    AtlasTypesDef typesDef = (AtlasTypesDef)AtlasType.fromJson((String)jsonStr, AtlasTypesDef.class);
                    if (typesDef == null || typesDef.isEmpty()) {
                        LOG.info("No type in file {}", (Object)((File)typeDefFile).getAbsolutePath());
                        continue;
                    }
                    AtlasTypesDef typesToCreate = AtlasTypeDefStoreInitializer.getTypesToCreate(typesDef, this.atlasTypeRegistry);
                    AtlasTypesDef typesToUpdate = AtlasTypeDefStoreInitializer.getTypesToUpdate(typesDef, this.atlasTypeRegistry, true);
                    if (!typesToCreate.isEmpty() || !typesToUpdate.isEmpty()) {
                        this.atlasTypeDefStore.createUpdateTypesDef(typesToCreate, typesToUpdate);
                        LOG.info("Created/Updated types defined in file {}", (Object)((File)typeDefFile).getAbsolutePath());
                        continue;
                    }
                    LOG.info("No new type in file {}", (Object)((File)typeDefFile).getAbsolutePath());
                }
                catch (Throwable t) {
                    LOG.error("error while registering types in file {}", (Object)((File)typeDefFile).getAbsolutePath(), (Object)t);
                }
            }
            this.applyTypePatches(typesDir.getPath());
        }
        LOG.info("<== AtlasTypeDefStoreInitializer({})", (Object)typesDir);
    }

    public static AtlasTypesDef getTypesToCreate(AtlasTypesDef typesDef, AtlasTypeRegistry typeRegistry) {
        AtlasTypesDef typesToCreate = new AtlasTypesDef();
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getEnumDefs())) {
            for (AtlasEnumDef enumDef : typesDef.getEnumDefs()) {
                if (typeRegistry.isRegisteredType(enumDef.getName())) continue;
                typesToCreate.getEnumDefs().add(enumDef);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getStructDefs())) {
            for (AtlasStructDef structDef : typesDef.getStructDefs()) {
                if (typeRegistry.isRegisteredType(structDef.getName())) continue;
                typesToCreate.getStructDefs().add(structDef);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getClassificationDefs())) {
            for (AtlasClassificationDef classificationDef : typesDef.getClassificationDefs()) {
                if (typeRegistry.isRegisteredType(classificationDef.getName())) continue;
                typesToCreate.getClassificationDefs().add(classificationDef);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getEntityDefs())) {
            for (AtlasEntityDef entityDef : typesDef.getEntityDefs()) {
                if (typeRegistry.isRegisteredType(entityDef.getName())) continue;
                typesToCreate.getEntityDefs().add(entityDef);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getRelationshipDefs())) {
            for (AtlasRelationshipDef relationshipDef : typesDef.getRelationshipDefs()) {
                if (typeRegistry.isRegisteredType(relationshipDef.getName())) continue;
                typesToCreate.getRelationshipDefs().add(relationshipDef);
            }
        }
        return typesToCreate;
    }

    public static AtlasTypesDef getTypesToUpdate(AtlasTypesDef typesDef, AtlasTypeRegistry typeRegistry, boolean checkTypeVersion) {
        AtlasTypesDef typesToUpdate = new AtlasTypesDef();
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getStructDefs())) {
            for (AtlasStructDef newStructDef : typesDef.getStructDefs()) {
                AtlasStructDef oldStructDef = typeRegistry.getStructDefByName(newStructDef.getName());
                if (oldStructDef == null || !AtlasTypeDefStoreInitializer.updateTypeAttributes(oldStructDef, newStructDef, checkTypeVersion)) continue;
                typesToUpdate.getStructDefs().add(newStructDef);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getClassificationDefs())) {
            for (AtlasClassificationDef newClassifDef : typesDef.getClassificationDefs()) {
                AtlasClassificationDef oldClassifDef = typeRegistry.getClassificationDefByName(newClassifDef.getName());
                if (oldClassifDef == null || !AtlasTypeDefStoreInitializer.updateTypeAttributes((AtlasStructDef)oldClassifDef, (AtlasStructDef)newClassifDef, checkTypeVersion)) continue;
                typesToUpdate.getClassificationDefs().add(newClassifDef);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getEntityDefs())) {
            for (AtlasEntityDef newEntityDef : typesDef.getEntityDefs()) {
                AtlasEntityDef oldEntityDef = typeRegistry.getEntityDefByName(newEntityDef.getName());
                if (oldEntityDef == null || !AtlasTypeDefStoreInitializer.updateTypeAttributes((AtlasStructDef)oldEntityDef, (AtlasStructDef)newEntityDef, checkTypeVersion)) continue;
                typesToUpdate.getEntityDefs().add(newEntityDef);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getEnumDefs())) {
            for (AtlasEnumDef newEnumDef : typesDef.getEnumDefs()) {
                AtlasEnumDef oldEnumDef = typeRegistry.getEnumDefByName(newEnumDef.getName());
                if (oldEnumDef == null || !AtlasTypeDefStoreInitializer.isTypeUpdateApplicable((AtlasBaseTypeDef)oldEnumDef, (AtlasBaseTypeDef)newEnumDef, checkTypeVersion)) continue;
                if (CollectionUtils.isNotEmpty((Collection)oldEnumDef.getElementDefs())) {
                    for (AtlasEnumDef.AtlasEnumElementDef oldEnumElem : oldEnumDef.getElementDefs()) {
                        if (newEnumDef.hasElement(oldEnumElem.getValue())) continue;
                        newEnumDef.addElement(oldEnumElem);
                    }
                }
                typesToUpdate.getEnumDefs().add(newEnumDef);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getRelationshipDefs())) {
            for (AtlasRelationshipDef relationshipDef : typesDef.getRelationshipDefs()) {
                AtlasRelationshipDef oldRelationshipDef = typeRegistry.getRelationshipDefByName(relationshipDef.getName());
                if (oldRelationshipDef == null || !AtlasTypeDefStoreInitializer.updateTypeAttributes((AtlasStructDef)oldRelationshipDef, (AtlasStructDef)relationshipDef, checkTypeVersion)) continue;
                typesToUpdate.getRelationshipDefs().add(relationshipDef);
            }
        }
        return typesToUpdate;
    }

    public void instanceIsActive() throws AtlasException {
        LOG.info("==> AtlasTypeDefStoreInitializer.instanceIsActive()");
        try {
            this.atlasTypeDefStore.init();
            this.loadBootstrapTypeDefs();
            try {
                AtlasAuthorizerFactory.getAtlasAuthorizer();
            }
            catch (Throwable t) {
                LOG.error("AtlasTypeDefStoreInitializer.instanceIsActive(): Unable to obtain AtlasAuthorizer", t);
            }
        }
        catch (AtlasBaseException e) {
            LOG.error("Failed to init after becoming active", (Throwable)e);
        }
        LOG.info("<== AtlasTypeDefStoreInitializer.instanceIsActive()");
    }

    public void instanceIsPassive() throws AtlasException {
        LOG.info("==> AtlasTypeDefStoreInitializer.instanceIsPassive()");
        LOG.info("<== AtlasTypeDefStoreInitializer.instanceIsPassive()");
    }

    public int getHandlerOrder() {
        return ActiveStateChangeHandler.HandlerOrder.TYPEDEF_STORE_INITIALIZER.getOrder();
    }

    private static boolean updateTypeAttributes(AtlasStructDef oldStructDef, AtlasStructDef newStructDef, boolean checkTypeVersion) {
        boolean ret = AtlasTypeDefStoreInitializer.isTypeUpdateApplicable((AtlasBaseTypeDef)oldStructDef, (AtlasBaseTypeDef)newStructDef, checkTypeVersion);
        if (ret && CollectionUtils.isNotEmpty((Collection)oldStructDef.getAttributeDefs())) {
            for (AtlasStructDef.AtlasAttributeDef oldAttrDef : oldStructDef.getAttributeDefs()) {
                if (newStructDef.hasAttribute(oldAttrDef.getName())) continue;
                newStructDef.addAttribute(oldAttrDef);
            }
        }
        return ret;
    }

    private static boolean isTypeUpdateApplicable(AtlasBaseTypeDef oldTypeDef, AtlasBaseTypeDef newTypeDef, boolean checkVersion) {
        boolean ret = true;
        if (checkVersion) {
            String oldTypeVersion = oldTypeDef.getTypeVersion();
            String newTypeVersion = newTypeDef.getTypeVersion();
            ret = ObjectUtils.compare((Comparable)((Object)newTypeVersion), (Comparable)((Object)oldTypeVersion)) > 0;
        }
        return ret;
    }

    private void applyTypePatches(String typesDirName) {
        Object[] typePatchFiles;
        String typePatchesDirName = typesDirName + File.separator + PATCHES_FOLDER_NAME;
        File typePatchesDir = new File(typePatchesDirName);
        Object[] objectArray = typePatchFiles = typePatchesDir.exists() ? typePatchesDir.listFiles() : null;
        if (typePatchFiles == null || typePatchFiles.length == 0) {
            LOG.info("Type patches directory {} does not exist or not readable or has no patches", (Object)typePatchesDirName);
        } else {
            LOG.info("Type patches directory {} is being processed", (Object)typePatchesDirName);
            Arrays.sort(typePatchFiles);
            PatchHandler[] patchHandlers = new PatchHandler[]{new AddAttributePatchHandler(this.atlasTypeDefStore, this.atlasTypeRegistry), new UpdateAttributePatchHandler(this.atlasTypeDefStore, this.atlasTypeRegistry), new RemoveLegacyRefAttributesPatchHandler(this.atlasTypeDefStore, this.atlasTypeRegistry), new UpdateTypeDefOptionsPatchHandler(this.atlasTypeDefStore, this.atlasTypeRegistry), new SetServiceTypePatchHandler(this.atlasTypeDefStore, this.atlasTypeRegistry)};
            HashMap<String, PatchHandler> patchHandlerRegistry = new HashMap<String, PatchHandler>();
            for (PatchHandler patchHandler : patchHandlers) {
                for (String supportedAction : patchHandler.getSupportedActions()) {
                    patchHandlerRegistry.put(supportedAction, patchHandler);
                }
            }
            for (Object typePatchFile : typePatchFiles) {
                if (!((File)typePatchFile).isFile()) continue;
                LOG.info("Applying patches in file {}", (Object)((File)typePatchFile).getAbsolutePath());
                try {
                    String jsonStr = new String(Files.readAllBytes(((File)typePatchFile).toPath()), StandardCharsets.UTF_8);
                    TypeDefPatches patches = (TypeDefPatches)AtlasType.fromJson((String)jsonStr, TypeDefPatches.class);
                    if (patches == null || CollectionUtils.isEmpty(patches.getPatches())) {
                        LOG.info("No patches in file {}", (Object)((File)typePatchFile).getAbsolutePath());
                        continue;
                    }
                    for (TypeDefPatch patch : patches.getPatches()) {
                        PatchHandler patchHandler = (PatchHandler)patchHandlerRegistry.get(patch.getAction());
                        if (patchHandler == null) {
                            LOG.error("Unknown patch action {} in file {}. Ignored", (Object)patch.getAction(), (Object)((File)typePatchFile).getAbsolutePath());
                            continue;
                        }
                        try {
                            patchHandler.applyPatch(patch);
                        }
                        catch (AtlasBaseException excp) {
                            LOG.error("Failed to apply {} patch in file {}. Ignored", new Object[]{patch.getAction(), ((File)typePatchFile).getAbsolutePath(), excp});
                        }
                    }
                }
                catch (Throwable t) {
                    LOG.error("Failed to apply patches in file {}. Ignored", (Object)((File)typePatchFile).getAbsolutePath(), (Object)t);
                }
            }
        }
    }

    class SetServiceTypePatchHandler
    extends PatchHandler {
        public SetServiceTypePatchHandler(AtlasTypeDefStore typeDefStore, AtlasTypeRegistry typeRegistry) {
            super(typeDefStore, typeRegistry, new String[]{"SET_SERVICE_TYPE"});
        }

        @Override
        public void applyPatch(TypeDefPatch patch) throws AtlasBaseException {
            String typeName = patch.getTypeName();
            AtlasBaseTypeDef typeDef = this.typeRegistry.getTypeDefByName(typeName);
            if (typeDef == null) {
                throw new AtlasBaseException(AtlasErrorCode.PATCH_FOR_UNKNOWN_TYPE, new String[]{patch.getAction(), typeName});
            }
            if (this.isPatchApplicable(patch, typeDef)) {
                typeDef.setServiceType(patch.getServiceType());
                typeDef.setTypeVersion(patch.getUpdateToVersion());
                this.typeDefStore.updateTypesDef(AtlasTypeUtil.getTypesDef((AtlasBaseTypeDef)typeDef));
            } else {
                LOG.info("patch skipped: typeName={}; applyToVersion={}; updateToVersion={}", new Object[]{patch.getTypeName(), patch.getApplyToVersion(), patch.getUpdateToVersion()});
            }
        }
    }

    class UpdateTypeDefOptionsPatchHandler
    extends PatchHandler {
        public UpdateTypeDefOptionsPatchHandler(AtlasTypeDefStore typeDefStore, AtlasTypeRegistry typeRegistry) {
            super(typeDefStore, typeRegistry, new String[]{"UPDATE_TYPEDEF_OPTIONS"});
        }

        @Override
        public void applyPatch(TypeDefPatch patch) throws AtlasBaseException {
            String typeName = patch.getTypeName();
            AtlasBaseTypeDef typeDef = this.typeRegistry.getTypeDefByName(typeName);
            if (typeDef == null) {
                throw new AtlasBaseException(AtlasErrorCode.PATCH_FOR_UNKNOWN_TYPE, new String[]{patch.getAction(), typeName});
            }
            if (MapUtils.isEmpty(patch.getTypeDefOptions())) {
                throw new AtlasBaseException(AtlasErrorCode.PATCH_INVALID_DATA, new String[]{patch.getAction(), typeName});
            }
            if (this.isPatchApplicable(patch, typeDef)) {
                if (typeDef.getOptions() == null) {
                    typeDef.setOptions(patch.getTypeDefOptions());
                } else {
                    typeDef.getOptions().putAll(patch.getTypeDefOptions());
                }
                typeDef.setTypeVersion(patch.getUpdateToVersion());
                this.typeDefStore.updateTypesDef(AtlasTypeUtil.getTypesDef((AtlasBaseTypeDef)typeDef));
            } else {
                LOG.info("patch skipped: typeName={}; applyToVersion={}; updateToVersion={}", new Object[]{patch.getTypeName(), patch.getApplyToVersion(), patch.getUpdateToVersion()});
            }
        }
    }

    class RemoveLegacyRefAttributesPatchHandler
    extends PatchHandler {
        public RemoveLegacyRefAttributesPatchHandler(AtlasTypeDefStore typeDefStore, AtlasTypeRegistry typeRegistry) {
            super(typeDefStore, typeRegistry, new String[]{"REMOVE_LEGACY_REF_ATTRIBUTES"});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void applyPatch(TypeDefPatch patch) throws AtlasBaseException {
            String typeName = patch.getTypeName();
            AtlasBaseTypeDef typeDef = this.typeRegistry.getTypeDefByName(typeName);
            if (typeDef == null) {
                throw new AtlasBaseException(AtlasErrorCode.PATCH_FOR_UNKNOWN_TYPE, new String[]{patch.getAction(), typeName});
            }
            if (this.isPatchApplicable(patch, typeDef)) {
                if (!typeDef.getClass().equals(AtlasRelationshipDef.class)) return;
                AtlasRelationshipDef relationshipDef = (AtlasRelationshipDef)typeDef;
                AtlasRelationshipEndDef end1Def = relationshipDef.getEndDef1();
                AtlasRelationshipEndDef end2Def = relationshipDef.getEndDef2();
                AtlasEntityType end1Type = this.typeRegistry.getEntityTypeByName(end1Def.getType());
                AtlasEntityType end2Type = this.typeRegistry.getEntityTypeByName(end2Def.getType());
                String newRelationshipLabel = null;
                AtlasRelationshipDef.RelationshipCategory newRelationshipCategory = null;
                boolean swapEnds = false;
                if (patch.getParams() != null) {
                    Object relLabel = patch.getParams().get(AtlasTypeDefStoreInitializer.RELATIONSHIP_LABEL);
                    Object relCategory = patch.getParams().get(AtlasTypeDefStoreInitializer.RELATIONSHIP_CATEGORY);
                    Object relSwapEnds = patch.getParams().get(AtlasTypeDefStoreInitializer.RELATIONSHIP_SWAP_ENDS);
                    if (relLabel != null) {
                        newRelationshipLabel = relLabel.toString();
                    }
                    if (relCategory != null) {
                        newRelationshipCategory = AtlasRelationshipDef.RelationshipCategory.valueOf((String)relCategory.toString());
                    }
                    if (relSwapEnds != null) {
                        swapEnds = Boolean.valueOf(relSwapEnds.toString());
                    }
                }
                if (StringUtils.isEmpty(newRelationshipLabel)) {
                    AtlasStructType.AtlasAttribute legacyAttribute;
                    if (end1Def.getIsLegacyAttribute()) {
                        if (end2Def.getIsLegacyAttribute()) throw new AtlasBaseException(AtlasErrorCode.PATCH_MISSING_RELATIONSHIP_LABEL, new String[]{patch.getAction(), typeName});
                        legacyAttribute = end1Type.getAttribute(end1Def.getName());
                        newRelationshipLabel = "__" + legacyAttribute.getQualifiedName();
                    } else if (end2Def.getIsLegacyAttribute()) {
                        legacyAttribute = end2Type.getAttribute(end2Def.getName());
                        newRelationshipLabel = "__" + legacyAttribute.getQualifiedName();
                    } else {
                        newRelationshipLabel = relationshipDef.getRelationshipLabel();
                    }
                }
                AtlasRelationshipDef updatedDef = new AtlasRelationshipDef(relationshipDef);
                if (swapEnds) {
                    AtlasRelationshipEndDef tmp = updatedDef.getEndDef1();
                    updatedDef.setEndDef1(updatedDef.getEndDef2());
                    updatedDef.setEndDef2(tmp);
                }
                end1Def = updatedDef.getEndDef1();
                end2Def = updatedDef.getEndDef2();
                end1Type = this.typeRegistry.getEntityTypeByName(end1Def.getType());
                end2Type = this.typeRegistry.getEntityTypeByName(end2Def.getType());
                updatedDef.setRelationshipLabel(newRelationshipLabel);
                if (newRelationshipCategory != null) {
                    updatedDef.setRelationshipCategory(newRelationshipCategory);
                }
                updatedDef.setTypeVersion(patch.getUpdateToVersion());
                AtlasEntityDef updatedEntityDef1 = new AtlasEntityDef(end1Type.getEntityDef());
                AtlasEntityDef updatedEntityDef2 = new AtlasEntityDef(end2Type.getEntityDef());
                updatedEntityDef1.removeAttribute(end1Def.getName());
                updatedEntityDef2.removeAttribute(end2Def.getName());
                AtlasTypesDef typesDef = new AtlasTypesDef();
                typesDef.setEntityDefs(Arrays.asList(updatedEntityDef1, updatedEntityDef2));
                typesDef.setRelationshipDefs(Collections.singletonList(updatedDef));
                try {
                    RequestContext.get().setInTypePatching(true);
                    this.typeDefStore.updateTypesDef(typesDef);
                    return;
                }
                finally {
                    RequestContext.get().setInTypePatching(false);
                }
            } else {
                LOG.info("patch skipped: typeName={}; applyToVersion={}; updateToVersion={}", new Object[]{patch.getTypeName(), patch.getApplyToVersion(), patch.getUpdateToVersion()});
            }
        }
    }

    class UpdateAttributePatchHandler
    extends PatchHandler {
        public UpdateAttributePatchHandler(AtlasTypeDefStore typeDefStore, AtlasTypeRegistry typeRegistry) {
            super(typeDefStore, typeRegistry, new String[]{"UPDATE_ATTRIBUTE"});
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void applyPatch(TypeDefPatch patch) throws AtlasBaseException {
            String typeName = patch.getTypeName();
            AtlasBaseTypeDef typeDef = this.typeRegistry.getTypeDefByName(typeName);
            if (typeDef == null) {
                throw new AtlasBaseException(AtlasErrorCode.PATCH_FOR_UNKNOWN_TYPE, new String[]{patch.getAction(), typeName});
            }
            if (this.isPatchApplicable(patch, typeDef)) {
                if (typeDef.getClass().equals(AtlasEntityDef.class)) {
                    AtlasEntityDef updatedDef = new AtlasEntityDef((AtlasEntityDef)typeDef);
                    this.addOrUpdateAttributes((AtlasStructDef)updatedDef, patch.getAttributeDefs());
                    updatedDef.setTypeVersion(patch.getUpdateToVersion());
                    this.typeDefStore.updateEntityDefByName(typeName, updatedDef);
                    return;
                } else if (typeDef.getClass().equals(AtlasClassificationDef.class)) {
                    AtlasClassificationDef updatedDef = new AtlasClassificationDef((AtlasClassificationDef)typeDef);
                    this.addOrUpdateAttributes((AtlasStructDef)updatedDef, patch.getAttributeDefs());
                    updatedDef.setTypeVersion(patch.getUpdateToVersion());
                    this.typeDefStore.updateClassificationDefByName(typeName, updatedDef);
                    return;
                } else {
                    if (!typeDef.getClass().equals(AtlasStructDef.class)) throw new AtlasBaseException(AtlasErrorCode.PATCH_NOT_APPLICABLE_FOR_TYPE, new String[]{patch.getAction(), typeDef.getClass().getSimpleName()});
                    AtlasStructDef updatedDef = new AtlasStructDef((AtlasStructDef)typeDef);
                    this.addOrUpdateAttributes(updatedDef, patch.getAttributeDefs());
                    updatedDef.setTypeVersion(patch.getUpdateToVersion());
                    this.typeDefStore.updateStructDefByName(typeName, updatedDef);
                }
                return;
            } else {
                LOG.info("patch skipped: typeName={}; applyToVersion={}; updateToVersion={}", new Object[]{patch.getTypeName(), patch.getApplyToVersion(), patch.getUpdateToVersion()});
            }
        }

        private void addOrUpdateAttributes(AtlasStructDef structDef, List<AtlasStructDef.AtlasAttributeDef> attributesToUpdate) {
            for (AtlasStructDef.AtlasAttributeDef attributeToUpdate : attributesToUpdate) {
                String attrName = attributeToUpdate.getName();
                if (structDef.hasAttribute(attrName)) {
                    structDef.removeAttribute(attrName);
                }
                structDef.addAttribute(attributeToUpdate);
            }
        }
    }

    class AddAttributePatchHandler
    extends PatchHandler {
        public AddAttributePatchHandler(AtlasTypeDefStore typeDefStore, AtlasTypeRegistry typeRegistry) {
            super(typeDefStore, typeRegistry, new String[]{"ADD_ATTRIBUTE"});
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void applyPatch(TypeDefPatch patch) throws AtlasBaseException {
            String typeName = patch.getTypeName();
            AtlasBaseTypeDef typeDef = this.typeRegistry.getTypeDefByName(typeName);
            if (typeDef == null) {
                throw new AtlasBaseException(AtlasErrorCode.PATCH_FOR_UNKNOWN_TYPE, new String[]{patch.getAction(), typeName});
            }
            if (this.isPatchApplicable(patch, typeDef)) {
                if (typeDef.getClass().equals(AtlasEntityDef.class)) {
                    AtlasEntityDef updatedDef = new AtlasEntityDef((AtlasEntityDef)typeDef);
                    for (AtlasStructDef.AtlasAttributeDef attributeDef : patch.getAttributeDefs()) {
                        updatedDef.addAttribute(attributeDef);
                    }
                    updatedDef.setTypeVersion(patch.getUpdateToVersion());
                    this.typeDefStore.updateEntityDefByName(typeName, updatedDef);
                    return;
                } else if (typeDef.getClass().equals(AtlasClassificationDef.class)) {
                    AtlasClassificationDef updatedDef = new AtlasClassificationDef((AtlasClassificationDef)typeDef);
                    for (AtlasStructDef.AtlasAttributeDef attributeDef : patch.getAttributeDefs()) {
                        updatedDef.addAttribute(attributeDef);
                    }
                    updatedDef.setTypeVersion(patch.getUpdateToVersion());
                    this.typeDefStore.updateClassificationDefByName(typeName, updatedDef);
                    return;
                } else {
                    if (!typeDef.getClass().equals(AtlasStructDef.class)) throw new AtlasBaseException(AtlasErrorCode.PATCH_NOT_APPLICABLE_FOR_TYPE, new String[]{patch.getAction(), typeDef.getClass().getSimpleName()});
                    AtlasStructDef updatedDef = new AtlasStructDef((AtlasStructDef)typeDef);
                    for (AtlasStructDef.AtlasAttributeDef attributeDef : patch.getAttributeDefs()) {
                        updatedDef.addAttribute(attributeDef);
                    }
                    updatedDef.setTypeVersion(patch.getUpdateToVersion());
                    this.typeDefStore.updateStructDefByName(typeName, updatedDef);
                }
                return;
            } else {
                LOG.info("patch skipped: typeName={}; applyToVersion={}; updateToVersion={}", new Object[]{patch.getTypeName(), patch.getApplyToVersion(), patch.getUpdateToVersion()});
            }
        }
    }

    abstract class PatchHandler {
        protected final AtlasTypeDefStore typeDefStore;
        protected final AtlasTypeRegistry typeRegistry;
        protected final String[] supportedActions;

        protected PatchHandler(AtlasTypeDefStore typeDefStore, AtlasTypeRegistry typeRegistry, String[] supportedActions) {
            this.typeDefStore = typeDefStore;
            this.typeRegistry = typeRegistry;
            this.supportedActions = supportedActions;
        }

        public String[] getSupportedActions() {
            return this.supportedActions;
        }

        public abstract void applyPatch(TypeDefPatch var1) throws AtlasBaseException;

        protected boolean isPatchApplicable(TypeDefPatch patch, AtlasBaseTypeDef currentTypeDef) {
            String currentVersion = currentTypeDef.getTypeVersion();
            String applyToVersion = patch.getApplyToVersion();
            return currentVersion == null || currentVersion.equalsIgnoreCase(applyToVersion) || currentVersion.startsWith(applyToVersion + ".");
        }
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    static class TypeDefPatches {
        private List<TypeDefPatch> patches;

        TypeDefPatches() {
        }

        public List<TypeDefPatch> getPatches() {
            return this.patches;
        }

        public void setPatches(List<TypeDefPatch> patches) {
            this.patches = patches;
        }
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    static class TypeDefPatch {
        private String action;
        private String typeName;
        private String applyToVersion;
        private String updateToVersion;
        private Map<String, Object> params;
        private List<AtlasStructDef.AtlasAttributeDef> attributeDefs;
        private Map<String, String> typeDefOptions;
        private String serviceType;

        TypeDefPatch() {
        }

        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public String getApplyToVersion() {
            return this.applyToVersion;
        }

        public void setApplyToVersion(String applyToVersion) {
            this.applyToVersion = applyToVersion;
        }

        public String getUpdateToVersion() {
            return this.updateToVersion;
        }

        public void setUpdateToVersion(String updateToVersion) {
            this.updateToVersion = updateToVersion;
        }

        public Map<String, Object> getParams() {
            return this.params;
        }

        public void setParams(Map<String, Object> params) {
            this.params = params;
        }

        public List<AtlasStructDef.AtlasAttributeDef> getAttributeDefs() {
            return this.attributeDefs;
        }

        public void setAttributeDefs(List<AtlasStructDef.AtlasAttributeDef> attributeDefs) {
            this.attributeDefs = attributeDefs;
        }

        public Map<String, String> getTypeDefOptions() {
            return this.typeDefOptions;
        }

        public void setTypeDefOptions(Map<String, String> typeDefOptions) {
            this.typeDefOptions = typeDefOptions;
        }

        public String getServiceType() {
            return this.serviceType;
        }

        public void setServiceType(String serviceType) {
            this.serviceType = serviceType;
        }
    }
}

