/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.ogm.glossary;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.glossary.AtlasGlossaryCategory;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.instance.AtlasRelatedObjectId;
import org.apache.atlas.model.instance.AtlasRelationship;
import org.apache.atlas.repository.ogm.glossary.AbstractGlossaryDTO;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AtlasGlossaryCategoryDTO
extends AbstractGlossaryDTO<AtlasGlossaryCategory> {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasGlossaryCategoryDTO.class);

    @Inject
    protected AtlasGlossaryCategoryDTO(AtlasTypeRegistry typeRegistry) {
        super(typeRegistry, AtlasGlossaryCategory.class);
    }

    @Override
    public AtlasGlossaryCategory from(AtlasEntity entity) {
        Object terms;
        Object childrenCategories;
        Object parentCategory;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasGlossaryCategoryDTO.from()", (Object)entity);
        }
        Objects.requireNonNull(entity, "entity");
        AtlasGlossaryCategory ret = new AtlasGlossaryCategory();
        ret.setGuid(entity.getGuid());
        ret.setQualifiedName((String)entity.getAttribute("qualifiedName"));
        ret.setName((String)entity.getAttribute("name"));
        ret.setShortDescription((String)entity.getAttribute("shortDescription"));
        ret.setLongDescription((String)entity.getAttribute("longDescription"));
        Object anchor = entity.getRelationshipAttribute("anchor");
        if (anchor instanceof AtlasRelatedObjectId) {
            LOG.debug("Processing anchor");
            ret.setAnchor(this.constructGlossaryId((AtlasRelatedObjectId)anchor));
        }
        if ((parentCategory = entity.getRelationshipAttribute("parentCategory")) instanceof AtlasRelatedObjectId) {
            LOG.debug("Processing parentCategory");
            ret.setParentCategory(this.constructRelatedCategoryId((AtlasRelatedObjectId)parentCategory));
        }
        if ((childrenCategories = entity.getRelationshipAttribute("childrenCategories")) instanceof Collection) {
            LOG.debug("Processing childrenCategories");
            for (Object child : (Collection)childrenCategories) {
                if (!(child instanceof AtlasRelatedObjectId) || ((AtlasRelatedObjectId)child).getRelationshipStatus() != AtlasRelationship.Status.ACTIVE) continue;
                ret.addChild(this.constructRelatedCategoryId((AtlasRelatedObjectId)child));
            }
        }
        if ((terms = entity.getRelationshipAttribute("terms")) instanceof Collection) {
            LOG.debug("Processing terms");
            for (Object term : (Collection)terms) {
                if (!(term instanceof AtlasRelatedObjectId)) continue;
                ret.addTerm(this.constructRelatedTermId((AtlasRelatedObjectId)term));
            }
        }
        return ret;
    }

    @Override
    public AtlasGlossaryCategory from(AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasGlossaryCategoryDTO.from()", (Object)entityWithExtInfo);
        }
        Objects.requireNonNull(entityWithExtInfo, "entity");
        AtlasGlossaryCategory ret = this.from(entityWithExtInfo.getEntity());
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasGlossaryCategoryDTO.from() : {}", (Object)ret);
        }
        return ret;
    }

    @Override
    public AtlasEntity toEntity(AtlasGlossaryCategory obj) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasGlossaryCategoryDTO.toEntity()", (Object)obj);
        }
        Objects.requireNonNull(obj, "atlasGlossaryCategory");
        Objects.requireNonNull(obj.getQualifiedName(), "atlasGlossaryCategory qualifiedName must be specified");
        Objects.requireNonNull(obj.getAnchor(), "atlasGlossaryCategory anchor must be specified");
        AtlasEntity ret = this.getDefaultAtlasEntity(obj);
        ret.setAttribute("qualifiedName", (Object)obj.getQualifiedName());
        ret.setAttribute("name", (Object)obj.getName());
        ret.setAttribute("shortDescription", (Object)obj.getShortDescription());
        ret.setAttribute("longDescription", (Object)obj.getLongDescription());
        ret.setAttribute("anchor", (Object)new AtlasObjectId(obj.getAnchor().getGlossaryGuid()));
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasGlossaryCategoryDTO.toEntity() : {}", (Object)ret);
        }
        return ret;
    }

    @Override
    public AtlasEntity.AtlasEntityWithExtInfo toEntityWithExtInfo(AtlasGlossaryCategory obj) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasGlossaryCategoryDTO.toEntityWithExtInfo()", (Object)obj);
        }
        Objects.requireNonNull(obj, "atlasGlossaryCategory");
        AtlasEntity.AtlasEntityWithExtInfo ret = new AtlasEntity.AtlasEntityWithExtInfo(this.toEntity(obj));
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasGlossaryCategoryDTO.toEntityWithExtInfo() : {}", (Object)ret);
        }
        return ret;
    }

    @Override
    public Map<String, Object> getUniqueAttributes(AtlasGlossaryCategory obj) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("qualifiedName", obj.getQualifiedName());
        return ret;
    }
}

