/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.ogm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.AtlasBaseModelObject;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.EntityMutationResponse;
import org.apache.atlas.repository.ogm.DTORegistry;
import org.apache.atlas.repository.ogm.DataTransferObject;
import org.apache.atlas.repository.store.graph.AtlasEntityStore;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityStream;
import org.apache.atlas.utils.AtlasPerfTracer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DataAccess {
    private static final Logger LOG = LoggerFactory.getLogger(DataAccess.class);
    private static final Logger PERF_LOG = AtlasPerfTracer.getPerfLogger((String)"repository.DataAccess");
    private final AtlasEntityStore entityStore;
    private final DTORegistry dtoRegistry;

    @Inject
    public DataAccess(AtlasEntityStore entityStore, DTORegistry dtoRegistry) {
        this.entityStore = entityStore;
        this.dtoRegistry = dtoRegistry;
    }

    public <T extends AtlasBaseModelObject> T save(T obj) throws AtlasBaseException {
        this.saveNoLoad(obj);
        return this.load(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends AtlasBaseModelObject> void saveNoLoad(T obj) throws AtlasBaseException {
        AtlasPerfTracer perf;
        block5: {
            Objects.requireNonNull(obj, "Can't save a null object");
            perf = null;
            try {
                DataTransferObject dto;
                AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo;
                EntityMutationResponse entityMutationResponse;
                if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                    perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)"DataAccess.save()");
                }
                if (this.noEntityMutation(entityMutationResponse = this.entityStore.createOrUpdate(new AtlasEntityStream(entityWithExtInfo = (dto = this.dtoRegistry.get(obj.getClass())).toEntityWithExtInfo(obj)), false))) {
                    throw new AtlasBaseException(AtlasErrorCode.DATA_ACCESS_SAVE_FAILED, new String[]{obj.toString()});
                }
                if (!CollectionUtils.isNotEmpty((Collection)entityMutationResponse.getCreatedEntities())) break block5;
                String assignedGuid = (String)entityMutationResponse.getGuidAssignments().get(obj.getGuid());
                if (!obj.getGuid().equals(assignedGuid)) {
                    obj.setGuid(assignedGuid);
                }
            }
            catch (Throwable throwable) {
                AtlasPerfTracer.log(perf);
                throw throwable;
            }
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends AtlasBaseModelObject> Iterable<T> save(Iterable<T> obj) throws AtlasBaseException {
        ArrayList<AtlasBaseModelObject> arrayList;
        Objects.requireNonNull(obj, "Can't save a null object");
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)"DataAccess.multiSave()");
            }
            ArrayList<AtlasBaseModelObject> ret = new ArrayList<AtlasBaseModelObject>();
            for (AtlasBaseModelObject o : obj) {
                ret.add(this.save(o));
            }
            arrayList = ret;
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends AtlasBaseModelObject> Iterable<T> load(Iterable<T> objects) throws AtlasBaseException {
        ArrayList<AtlasBaseModelObject> arrayList;
        Objects.requireNonNull(objects, "Objects to load");
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)"DataAccess.multiLoad()");
            }
            ArrayList<AtlasBaseModelObject> ret = new ArrayList<AtlasBaseModelObject>();
            for (AtlasBaseModelObject object : objects) {
                try {
                    ret.add(this.load(object));
                }
                catch (AtlasBaseException e) {
                    LOG.warn("Bulk load encountered an error.", (Throwable)e);
                }
            }
            arrayList = ret;
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        return arrayList;
    }

    public <T extends AtlasBaseModelObject> T load(T obj) throws AtlasBaseException {
        return this.load(obj, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends AtlasBaseModelObject> T load(T obj, boolean loadDeleted) throws AtlasBaseException {
        Object t;
        Objects.requireNonNull(obj, "Can't load a null object");
        AtlasPerfTracer perf = null;
        try {
            AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo;
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)"DataAccess.load()");
            }
            DataTransferObject dto = this.dtoRegistry.get(obj.getClass());
            String guid = obj.getGuid();
            if (StringUtils.isNotEmpty((CharSequence)guid) && guid.charAt(0) != '-') {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Load using GUID");
                }
                entityWithExtInfo = this.entityStore.getById(guid);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Load using unique attributes");
                }
                entityWithExtInfo = this.entityStore.getByUniqueAttributes(dto.getEntityType(), dto.getUniqueAttributes(obj));
            }
            String actualTypeName = entityWithExtInfo.getEntity().getTypeName();
            String expectedTypeName = dto.getEntityType().getTypeName();
            if (!actualTypeName.equals(expectedTypeName)) {
                throw new AtlasBaseException(AtlasErrorCode.UNEXPECTED_TYPE, new String[]{expectedTypeName, actualTypeName});
            }
            if (!loadDeleted && entityWithExtInfo.getEntity().getStatus() == AtlasEntity.Status.DELETED) {
                throw new AtlasBaseException(AtlasErrorCode.INSTANCE_GUID_DELETED, new String[]{guid});
            }
            t = dto.from(entityWithExtInfo);
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        return t;
    }

    public <T extends AtlasBaseModelObject> T load(String guid, Class<? extends AtlasBaseModelObject> clazz) throws AtlasBaseException {
        DataTransferObject dto = this.dtoRegistry.get(clazz);
        AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = null;
        if (StringUtils.isNotEmpty((CharSequence)guid)) {
            entityWithExtInfo = this.entityStore.getById(guid);
        }
        if (entityWithExtInfo == null) {
            return null;
        }
        return dto.from(entityWithExtInfo);
    }

    public void deleteUsingGuid(String guid) throws AtlasBaseException {
        this.entityStore.deleteById(guid);
    }

    public void delete(String guid) throws AtlasBaseException {
        Objects.requireNonNull(guid, "guid");
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)"DataAccess.delete()");
            }
            this.entityStore.deleteById(guid);
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
    }

    public void delete(List<String> guids) throws AtlasBaseException {
        Objects.requireNonNull(guids, "guids");
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)"DataAccess.multiDelete()");
            }
            this.entityStore.deleteByIds(guids);
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends AtlasBaseModelObject> void delete(T obj) throws AtlasBaseException {
        Objects.requireNonNull(obj, "Can't delete a null object");
        AtlasPerfTracer perf = null;
        try {
            T object;
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)"DataAccess.delete()");
            }
            if ((object = this.load(obj)) != null) {
                this.delete(object.getGuid());
            }
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
    }

    private boolean noEntityMutation(EntityMutationResponse er) {
        return er == null || CollectionUtils.isEmpty((Collection)er.getCreatedEntities()) && CollectionUtils.isEmpty((Collection)er.getUpdatedEntities());
    }
}

