/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.ogm;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.atlas.repository.ogm.DataTransferObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DTORegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DTORegistry.class);
    private final Map<Class, DataTransferObject> typeDTOMap = new HashMap<Class, DataTransferObject>();

    @Inject
    public DTORegistry(Set<DataTransferObject> availableDTOs) {
        for (DataTransferObject availableDTO : availableDTOs) {
            LOG.info("Registering DTO: {}", (Object)availableDTO.getClass().getSimpleName());
            this.registerDTO(availableDTO);
        }
    }

    public <T extends DataTransferObject> DataTransferObject get(Class t) {
        return this.typeDTOMap.get(t);
    }

    private void registerDTO(DataTransferObject dto) {
        this.typeDTOMap.put(dto.getObjectType(), dto);
    }
}

