/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.impexp;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.impexp.AtlasImportResult;
import org.apache.atlas.model.typedef.AtlasClassificationDef;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.model.typedef.AtlasEnumDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.store.AtlasTypeDefStore;
import org.apache.atlas.type.AtlasRelationshipType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.type.AtlasTypeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeAttributeDifference {
    private static final Logger LOG = LoggerFactory.getLogger(TypeAttributeDifference.class);
    private final AtlasTypeDefStore typeDefStore;
    private final AtlasTypeRegistry typeRegistry;

    public TypeAttributeDifference(AtlasTypeDefStore typeDefStore, AtlasTypeRegistry typeRegistry) {
        this.typeDefStore = typeDefStore;
        this.typeRegistry = typeRegistry;
    }

    public void updateTypes(AtlasTypesDef typeDefinitionMap, AtlasImportResult result) throws AtlasBaseException {
        this.updateEntityDef(typeDefinitionMap, result);
        this.updateClassificationDef(typeDefinitionMap, result);
        this.updateEnumDef(typeDefinitionMap, result);
        this.updateStructDef(typeDefinitionMap, result);
    }

    private void updateEntityDef(AtlasTypesDef typeDefinitionMap, AtlasImportResult result) throws AtlasBaseException {
        for (AtlasEntityDef def : typeDefinitionMap.getEntityDefs()) {
            AtlasEntityDef existing = this.typeRegistry.getEntityDefByName(def.getName());
            if (existing == null || !this.addAttributes((AtlasStructDef)existing, (AtlasStructDef)def)) continue;
            this.typeDefStore.updateEntityDefByName(existing.getName(), existing);
            result.incrementMeticsCounter("typedef:entitydef:update");
        }
    }

    private void updateClassificationDef(AtlasTypesDef typeDefinitionMap, AtlasImportResult result) throws AtlasBaseException {
        for (AtlasClassificationDef def : typeDefinitionMap.getClassificationDefs()) {
            AtlasClassificationDef existing = this.typeRegistry.getClassificationDefByName(def.getName());
            if (existing == null || !this.addAttributes((AtlasStructDef)existing, (AtlasStructDef)def)) continue;
            this.typeDefStore.updateClassificationDefByName(existing.getName(), existing);
            result.incrementMeticsCounter("typedef:classification:update");
        }
    }

    private void updateEnumDef(AtlasTypesDef typeDefinitionMap, AtlasImportResult result) throws AtlasBaseException {
        for (AtlasEnumDef def : typeDefinitionMap.getEnumDefs()) {
            AtlasEnumDef existing = this.typeRegistry.getEnumDefByName(def.getName());
            if (existing == null || !this.addElements(existing, def)) continue;
            this.typeDefStore.updateEnumDefByName(existing.getName(), existing);
            result.incrementMeticsCounter("typedef:enum:update");
        }
    }

    private void updateStructDef(AtlasTypesDef typeDefinitionMap, AtlasImportResult result) throws AtlasBaseException {
        for (AtlasStructDef def : typeDefinitionMap.getStructDefs()) {
            AtlasStructDef existing = this.typeRegistry.getStructDefByName(def.getName());
            if (existing == null || !this.addAttributes(existing, def)) continue;
            this.typeDefStore.updateStructDefByName(existing.getName(), existing);
            result.incrementMeticsCounter("typedef:struct:update");
        }
    }

    @VisibleForTesting
    boolean addElements(AtlasEnumDef existing, AtlasEnumDef incoming) throws AtlasBaseException {
        return this.addElements(existing, this.getElementsAbsentInExisting(existing, incoming));
    }

    private boolean addAttributes(AtlasStructDef existing, AtlasStructDef incoming) throws AtlasBaseException {
        return this.addAttributes(existing, this.getElementsAbsentInExisting(existing, incoming));
    }

    @VisibleForTesting
    List<AtlasStructDef.AtlasAttributeDef> getElementsAbsentInExisting(AtlasStructDef existing, AtlasStructDef incoming) throws AtlasBaseException {
        ArrayList<AtlasStructDef.AtlasAttributeDef> difference = new ArrayList<AtlasStructDef.AtlasAttributeDef>();
        for (AtlasStructDef.AtlasAttributeDef attr : incoming.getAttributeDefs()) {
            this.updateCollectionWithDifferingAttributes(difference, existing, attr);
        }
        return difference;
    }

    private void updateCollectionWithDifferingAttributes(List<AtlasStructDef.AtlasAttributeDef> difference, AtlasStructDef existing, AtlasStructDef.AtlasAttributeDef incoming) throws AtlasBaseException {
        AtlasStructDef.AtlasAttributeDef existingAttribute = existing.getAttribute(incoming.getName());
        if (existingAttribute == null) {
            AtlasRelationshipType relationshipType = AtlasTypeUtil.findRelationshipWithLegacyRelationshipEnd((String)existing.getName(), (String)incoming.getName(), (AtlasTypeRegistry)this.typeRegistry);
            if (relationshipType == null) {
                difference.add(incoming);
            }
        } else if (!existingAttribute.getTypeName().equals(incoming.getTypeName())) {
            LOG.error("Attribute definition difference found: {}, {}", (Object)existingAttribute, (Object)incoming);
            throw new AtlasBaseException(AtlasErrorCode.INVALID_IMPORT_ATTRIBUTE_TYPE_CHANGED, new String[]{existing.getName(), existingAttribute.getName(), existingAttribute.getTypeName(), incoming.getTypeName()});
        }
    }

    @VisibleForTesting
    List<AtlasEnumDef.AtlasEnumElementDef> getElementsAbsentInExisting(AtlasEnumDef existing, AtlasEnumDef incoming) throws AtlasBaseException {
        ArrayList<AtlasEnumDef.AtlasEnumElementDef> difference = new ArrayList<AtlasEnumDef.AtlasEnumElementDef>();
        for (AtlasEnumDef.AtlasEnumElementDef ed : incoming.getElementDefs()) {
            this.updateCollectionWithDifferingAttributes(existing, difference, ed);
        }
        return difference;
    }

    private void updateCollectionWithDifferingAttributes(AtlasEnumDef existing, List<AtlasEnumDef.AtlasEnumElementDef> difference, AtlasEnumDef.AtlasEnumElementDef ed) throws AtlasBaseException {
        AtlasEnumDef.AtlasEnumElementDef existingElement = existing.getElement(ed.getValue());
        if (existingElement == null) {
            difference.add(ed);
        }
    }

    private boolean addAttributes(AtlasStructDef def, List<AtlasStructDef.AtlasAttributeDef> list) {
        for (AtlasStructDef.AtlasAttributeDef ad : list) {
            def.addAttribute(ad);
        }
        return list.size() > 0;
    }

    private boolean addElements(AtlasEnumDef def, List<AtlasEnumDef.AtlasEnumElementDef> list) {
        for (AtlasEnumDef.AtlasEnumElementDef ad : list) {
            def.addElement(ad);
        }
        return list.size() > 0;
    }
}

