/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.impexp;

import com.google.common.annotations.VisibleForTesting;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.atlas.annotation.AtlasService;
import org.apache.atlas.model.impexp.MigrationStatus;
import org.apache.atlas.repository.graphdb.GraphDBMigrator;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AtlasService
@Singleton
public class MigrationProgressService {
    private static final Logger LOG = LoggerFactory.getLogger(MigrationProgressService.class);
    public static final String MIGRATION_QUERY_CACHE_TTL = "atlas.migration.query.cache.ttlInSecs";
    @VisibleForTesting
    static long DEFAULT_CACHE_TTL_IN_SECS = 30000L;
    private final long cacheValidity;
    private final GraphDBMigrator migrator;
    private MigrationStatus cachedStatus;
    private long cacheExpirationTime = 0L;

    @Inject
    public MigrationProgressService(Configuration configuration, GraphDBMigrator migrator) {
        this.migrator = migrator;
        this.cacheValidity = configuration != null ? configuration.getLong(MIGRATION_QUERY_CACHE_TTL, DEFAULT_CACHE_TTL_IN_SECS) : DEFAULT_CACHE_TTL_IN_SECS;
    }

    public MigrationStatus getStatus() {
        return this.fetchStatus();
    }

    private MigrationStatus fetchStatus() {
        long currentTime = System.currentTimeMillis();
        if (this.resetCache(currentTime)) {
            this.cachedStatus = this.migrator.getMigrationStatus();
        }
        return this.cachedStatus;
    }

    private boolean resetCache(long currentTime) {
        boolean ret;
        boolean bl = ret = this.cachedStatus == null || currentTime > this.cacheExpirationTime;
        if (ret) {
            this.cacheExpirationTime = currentTime + this.cacheValidity;
        }
        return ret;
    }
}

