/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.impexp;

import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.RequestContext;
import org.apache.atlas.entitytransform.BaseEntityHandler;
import org.apache.atlas.entitytransform.TransformerContext;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.impexp.AtlasImportRequest;
import org.apache.atlas.model.impexp.AtlasImportResult;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.repository.impexp.AuditsWriter;
import org.apache.atlas.repository.impexp.ImportTransforms;
import org.apache.atlas.repository.impexp.ImportTransformsShaper;
import org.apache.atlas.repository.impexp.ImportTypeDefProcessor;
import org.apache.atlas.repository.impexp.ZipSource;
import org.apache.atlas.repository.store.graph.BulkImporter;
import org.apache.atlas.store.AtlasTypeDefStore;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ImportService {
    private static final Logger LOG = LoggerFactory.getLogger(ImportService.class);
    private final AtlasTypeDefStore typeDefStore;
    private final AtlasTypeRegistry typeRegistry;
    private final BulkImporter bulkImporter;
    private final AuditsWriter auditsWriter;
    private final ImportTransformsShaper importTransformsShaper;
    private long startTimestamp;
    private long endTimestamp;

    @Inject
    public ImportService(AtlasTypeDefStore typeDefStore, AtlasTypeRegistry typeRegistry, BulkImporter bulkImporter, AuditsWriter auditsWriter, ImportTransformsShaper importTransformsShaper) {
        this.typeDefStore = typeDefStore;
        this.typeRegistry = typeRegistry;
        this.bulkImporter = bulkImporter;
        this.auditsWriter = auditsWriter;
        this.importTransformsShaper = importTransformsShaper;
    }

    public AtlasImportResult run(ZipSource source, String userName, String hostName, String requestingIP) throws AtlasBaseException {
        return this.run(source, null, userName, hostName, requestingIP);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AtlasImportResult run(ZipSource source, AtlasImportRequest request, String userName, String hostName, String requestingIP) throws AtlasBaseException {
        if (request == null) {
            request = new AtlasImportRequest();
        }
        AtlasImportResult result = new AtlasImportResult(request, userName, requestingIP, hostName, System.currentTimeMillis());
        try {
            LOG.info("==> import(user={}, from={}, request={})", new Object[]{userName, requestingIP, request});
            RequestContext.get().setImportInProgress(true);
            String transforms = MapUtils.isNotEmpty((Map)request.getOptions()) ? (String)request.getOptions().get("transforms") : null;
            this.setImportTransform(source, transforms);
            String transformers = MapUtils.isNotEmpty((Map)request.getOptions()) ? (String)request.getOptions().get("transformers") : null;
            this.setEntityTransformerHandlers(source, transformers);
            this.startTimestamp = System.currentTimeMillis();
            this.processTypes(source.getTypesDef(), result);
            this.setStartPosition(request, source);
            this.processEntities(userName, source, result);
        }
        catch (AtlasBaseException excp) {
            try {
                LOG.error("import(user={}, from={}): failed", new Object[]{userName, requestingIP, excp});
                throw excp;
                catch (Exception excp2) {
                    LOG.error("import(user={}, from={}): failed", new Object[]{userName, requestingIP, excp2});
                    throw new AtlasBaseException((Throwable)excp2);
                }
            }
            catch (Throwable throwable) {
                RequestContext.get().setImportInProgress(false);
                source.close();
                LOG.info("<== import(user={}, from={}): status={}", new Object[]{userName, requestingIP, result.getOperationStatus()});
                throw throwable;
            }
        }
        RequestContext.get().setImportInProgress(false);
        source.close();
        LOG.info("<== import(user={}, from={}): status={}", new Object[]{userName, requestingIP, result.getOperationStatus()});
        return result;
    }

    @VisibleForTesting
    void setImportTransform(ZipSource source, String transforms) throws AtlasBaseException {
        ImportTransforms importTransform = ImportTransforms.fromJson(transforms);
        if (importTransform == null) {
            return;
        }
        this.importTransformsShaper.shape(importTransform, source.getExportResult().getRequest());
        source.setImportTransform(importTransform);
        if (LOG.isDebugEnabled()) {
            this.debugLog("   => transforms: {}", AtlasType.toJson((Object)importTransform));
        }
    }

    @VisibleForTesting
    void setEntityTransformerHandlers(ZipSource source, String transformersJson) throws AtlasBaseException {
        if (StringUtils.isEmpty((CharSequence)transformersJson)) {
            return;
        }
        TransformerContext context = new TransformerContext(this.typeRegistry, this.typeDefStore, source.getExportResult().getRequest());
        List entityHandlers = BaseEntityHandler.fromJson((String)transformersJson, (TransformerContext)context);
        if (CollectionUtils.isEmpty((Collection)entityHandlers)) {
            return;
        }
        source.setEntityHandlers(entityHandlers);
    }

    private void debugLog(String s, Object ... params) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug(s, params);
    }

    private void setStartPosition(AtlasImportRequest request, ZipSource source) throws AtlasBaseException {
        if (request.getStartGuid() != null) {
            source.setPositionUsingEntityGuid(request.getStartGuid());
        } else if (request.getStartPosition() != null) {
            source.setPosition(Integer.parseInt(request.getStartPosition()));
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AtlasImportResult run(AtlasImportRequest request, String userName, String hostName, String requestingIP) throws AtlasBaseException {
        String fileName = request.getFileName();
        if (StringUtils.isBlank((CharSequence)fileName)) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"FILENAME parameter not found"});
        }
        AtlasImportResult result = null;
        try {
            LOG.info("==> import(user={}, from={}, fileName={})", new Object[]{userName, requestingIP, fileName});
            String transforms = MapUtils.isNotEmpty((Map)request.getOptions()) ? (String)request.getOptions().get("transforms") : null;
            File file = new File(fileName);
            ZipSource source = new ZipSource(new ByteArrayInputStream(FileUtils.readFileToByteArray((File)file)), ImportTransforms.fromJson(transforms));
            result = this.run(source, request, userName, hostName, requestingIP);
        }
        catch (AtlasBaseException excp) {
            try {
                LOG.error("import(user={}, from={}, fileName={}): failed", new Object[]{userName, requestingIP, excp});
                throw excp;
                catch (FileNotFoundException excp2) {
                    LOG.error("import(user={}, from={}, fileName={}): file not found", new Object[]{userName, requestingIP, excp2});
                    throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{fileName + ": file not found"});
                }
                catch (IOException excp3) {
                    LOG.error("import(user={}, from={}, fileName={}): cannot read file", new Object[]{userName, requestingIP, excp3});
                    throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{fileName + ": cannot read file"});
                }
                catch (Exception excp4) {
                    LOG.error("import(user={}, from={}, fileName={}): failed", new Object[]{userName, requestingIP, excp4});
                    throw new AtlasBaseException((Throwable)excp4);
                }
            }
            catch (Throwable throwable) {
                LOG.info("<== import(user={}, from={}, fileName={}): status={}", new Object[]{userName, requestingIP, fileName, result == null ? AtlasImportResult.OperationStatus.FAIL : result.getOperationStatus()});
                throw throwable;
            }
        }
        LOG.info("<== import(user={}, from={}, fileName={}): status={}", new Object[]{userName, requestingIP, fileName, result == null ? AtlasImportResult.OperationStatus.FAIL : result.getOperationStatus()});
        return result;
    }

    private void processTypes(AtlasTypesDef typeDefinitionMap, AtlasImportResult result) throws AtlasBaseException {
        if (result.getRequest().getUpdateTypeDefs() != null && !result.getRequest().getUpdateTypeDefs().equals("true")) {
            return;
        }
        ImportTypeDefProcessor importTypeDefProcessor = new ImportTypeDefProcessor(this.typeDefStore, this.typeRegistry);
        importTypeDefProcessor.processTypes(typeDefinitionMap, result);
    }

    private void processEntities(String userName, ZipSource importSource, AtlasImportResult result) throws AtlasBaseException {
        this.bulkImporter.bulkImport(importSource, result);
        this.endTimestamp = System.currentTimeMillis();
        result.incrementMeticsCounter("duration", this.getDuration(this.endTimestamp, this.startTimestamp));
        result.setExportResult(importSource.getExportResult());
        result.setOperationStatus(AtlasImportResult.OperationStatus.SUCCESS);
        this.auditsWriter.write(userName, result, this.startTimestamp, this.endTimestamp, importSource.getCreationOrder());
    }

    private int getDuration(long endTime, long startTime) {
        return (int)(endTime - startTime);
    }
}

