/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.impexp;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.instance.EntityMutationResponse;
import org.apache.atlas.repository.impexp.AuditsWriter;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityStoreV2;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityStream;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HdfsPathEntityCreator {
    protected static final Logger LOG = LoggerFactory.getLogger(HdfsPathEntityCreator.class);
    public static final String HDFS_PATH_TYPE = "hdfs_path";
    public static final String HDFS_PATH_ATTRIBUTE_NAME_NAME = "name";
    public static final String HDFS_PATH_ATTRIBUTE_NAME_CLUSTER_NAME = "clusterName";
    public static final String HDFS_PATH_ATTRIBUTE_NAME_PATH = "path";
    public static final String HDFS_PATH_ATTRIBUTE_QUALIFIED_NAME = "qualifiedName";
    private static final String QUALIFIED_NAME_FORMAT = "%s@%s";
    private final String PATH_SEPARATOR = "/";
    private AtlasTypeRegistry typeRegistry;
    private AtlasEntityStoreV2 entityStore;

    @Inject
    public HdfsPathEntityCreator(AtlasTypeRegistry typeRegistry, AtlasEntityStoreV2 entityStore) {
        this.typeRegistry = typeRegistry;
        this.entityStore = entityStore;
    }

    public AtlasEntity.AtlasEntityWithExtInfo getCreateEntity(AtlasObjectId item) throws AtlasBaseException {
        if (!item.getUniqueAttributes().containsKey(HDFS_PATH_ATTRIBUTE_NAME_PATH)) {
            return null;
        }
        return this.getCreateEntity((String)item.getUniqueAttributes().get(HDFS_PATH_ATTRIBUTE_NAME_PATH));
    }

    public AtlasEntity.AtlasEntityWithExtInfo getCreateEntity(String path) throws AtlasBaseException {
        return this.getCreateEntity(path, AuditsWriter.getCurrentClusterName());
    }

    public AtlasEntity.AtlasEntityWithExtInfo getCreateEntity(String path, String clusterName) throws AtlasBaseException {
        String pathWithTrailingSeparator = this.getPathWithTrailingSeparator(path);
        AtlasEntityType hdfsPathEntityType = this.getHdfsPathEntityType();
        AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = this.getHDFSPathEntity(hdfsPathEntityType, pathWithTrailingSeparator, clusterName);
        if (entityWithExtInfo != null) {
            return entityWithExtInfo;
        }
        AtlasEntity entity = this.createHDFSPathEntity(hdfsPathEntityType, pathWithTrailingSeparator, clusterName);
        AtlasEntityStream entityStream = new AtlasEntityStream(entity);
        EntityMutationResponse entityMutationResponse = this.entityStore.createOrUpdate(entityStream, false);
        if (entityMutationResponse.getCreatedEntities().size() == 0) {
            return null;
        }
        return this.getHDFSPathEntity(hdfsPathEntityType, pathWithTrailingSeparator, clusterName);
    }

    private AtlasEntity createHDFSPathEntity(AtlasEntityType hdfsPathEntityType, String path, String clusterName) {
        AtlasEntity entity = hdfsPathEntityType.createDefaultValue();
        entity.setAttribute(HDFS_PATH_ATTRIBUTE_QUALIFIED_NAME, (Object)HdfsPathEntityCreator.getQualifiedName(path, clusterName));
        entity.setAttribute(HDFS_PATH_ATTRIBUTE_NAME_PATH, (Object)path);
        entity.setAttribute(HDFS_PATH_ATTRIBUTE_NAME_NAME, (Object)path);
        entity.setAttribute(HDFS_PATH_ATTRIBUTE_NAME_CLUSTER_NAME, (Object)clusterName);
        return entity;
    }

    private AtlasEntity.AtlasEntityWithExtInfo getHDFSPathEntity(AtlasEntityType hdfsPathEntityType, String path, String clusterName) {
        try {
            return this.entityStore.getByUniqueAttributes(hdfsPathEntityType, this.getUniqueAttributes(path, clusterName));
        }
        catch (AtlasBaseException e) {
            return null;
        }
    }

    private AtlasEntityType getHdfsPathEntityType() throws AtlasBaseException {
        return (AtlasEntityType)this.typeRegistry.getType(HDFS_PATH_TYPE);
    }

    private Map<String, Object> getUniqueAttributes(String path, String clusterName) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put(HDFS_PATH_ATTRIBUTE_QUALIFIED_NAME, HdfsPathEntityCreator.getQualifiedName(path, clusterName));
        return ret;
    }

    private String getPathWithTrailingSeparator(String path) {
        if (path.endsWith("/")) {
            return path;
        }
        return path + "/";
    }

    public static String getQualifiedName(String path, String clusterName) {
        return String.format(QUALIFIED_NAME_FORMAT, path, clusterName);
    }
}

