/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.impexp;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.RequestContext;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.impexp.AtlasExportRequest;
import org.apache.atlas.model.impexp.AtlasExportResult;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.typedef.AtlasClassificationDef;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.model.typedef.AtlasEnumDef;
import org.apache.atlas.model.typedef.AtlasRelationshipDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.impexp.AuditsWriter;
import org.apache.atlas.repository.impexp.ExportTypeProcessor;
import org.apache.atlas.repository.impexp.HdfsPathEntityCreator;
import org.apache.atlas.repository.impexp.IncrementalExportEntityProvider;
import org.apache.atlas.repository.impexp.ZipSink;
import org.apache.atlas.repository.store.graph.v2.EntityGraphRetriever;
import org.apache.atlas.repository.util.UniqueList;
import org.apache.atlas.type.AtlasArrayType;
import org.apache.atlas.type.AtlasClassificationType;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasEnumType;
import org.apache.atlas.type.AtlasMapType;
import org.apache.atlas.type.AtlasRelationshipType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.type.AtlasTypeUtil;
import org.apache.atlas.util.AtlasGremlinQueryProvider;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ExportService {
    private static final Logger LOG = LoggerFactory.getLogger(ExportService.class);
    public static final String PROPERTY_GUID = "__guid";
    private static final String PROPERTY_IS_PROCESS = "isProcess";
    private final AtlasTypeRegistry typeRegistry;
    private final String QUERY_BINDING_START_GUID = "startGuid";
    private AuditsWriter auditsWriter;
    private final AtlasGraph atlasGraph;
    private final EntityGraphRetriever entityGraphRetriever;
    private final AtlasGremlinQueryProvider gremlinQueryProvider;
    private ExportTypeProcessor exportTypeProcessor;
    private final HdfsPathEntityCreator hdfsPathEntityCreator;
    private IncrementalExportEntityProvider incrementalExportEntityProvider;

    @Inject
    public ExportService(AtlasTypeRegistry typeRegistry, AtlasGraph atlasGraph, AuditsWriter auditsWriter, HdfsPathEntityCreator hdfsPathEntityCreator) {
        this.typeRegistry = typeRegistry;
        this.entityGraphRetriever = new EntityGraphRetriever(this.typeRegistry);
        this.atlasGraph = atlasGraph;
        this.gremlinQueryProvider = AtlasGremlinQueryProvider.INSTANCE;
        this.auditsWriter = auditsWriter;
        this.hdfsPathEntityCreator = hdfsPathEntityCreator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AtlasExportResult run(ZipSink exportSink, AtlasExportRequest request, String userName, String hostName, String requestingIP) throws AtlasBaseException {
        long startTime = System.currentTimeMillis();
        AtlasExportResult result = new AtlasExportResult(request, userName, requestingIP, hostName, startTime, this.getCurrentChangeMarker());
        ExportContext context = new ExportContext(this.atlasGraph, result, exportSink);
        this.exportTypeProcessor = new ExportTypeProcessor(this.typeRegistry, context);
        try {
            LOG.info("==> export(user={}, from={})", (Object)userName, (Object)requestingIP);
            AtlasExportResult.OperationStatus[] statuses = this.processItems(request, context);
            this.processTypesDef(context);
            long endTime = System.currentTimeMillis();
            this.updateSinkWithOperationMetrics(userName, context, statuses, startTime, endTime);
        }
        catch (Exception ex) {
            try {
                LOG.error("Operation failed: ", (Throwable)ex);
            }
            catch (Throwable throwable) {
                this.atlasGraph.releaseGremlinScriptEngine(context.scriptEngine);
                LOG.info("<== export(user={}, from={}): status {}: changeMarker: {}", new Object[]{userName, requestingIP, context.result.getOperationStatus(), context.result.getChangeMarker()});
                context.clear();
                result.clear();
                this.incrementalExportEntityProvider = null;
                throw throwable;
            }
            this.atlasGraph.releaseGremlinScriptEngine(context.scriptEngine);
            LOG.info("<== export(user={}, from={}): status {}: changeMarker: {}", new Object[]{userName, requestingIP, context.result.getOperationStatus(), context.result.getChangeMarker()});
            context.clear();
            result.clear();
            this.incrementalExportEntityProvider = null;
        }
        this.atlasGraph.releaseGremlinScriptEngine(context.scriptEngine);
        LOG.info("<== export(user={}, from={}): status {}: changeMarker: {}", new Object[]{userName, requestingIP, context.result.getOperationStatus(), context.result.getChangeMarker()});
        context.clear();
        result.clear();
        this.incrementalExportEntityProvider = null;
        return context.result;
    }

    private long getCurrentChangeMarker() {
        return RequestContext.earliestActiveRequestTime();
    }

    private void updateSinkWithOperationMetrics(String userName, ExportContext context, AtlasExportResult.OperationStatus[] statuses, long startTime, long endTime) throws AtlasBaseException {
        int duration = this.getOperationDuration(startTime, endTime);
        context.result.setSourceClusterName(AuditsWriter.getCurrentClusterName());
        context.addToEntityCreationOrder(context.lineageProcessed);
        context.sink.setExportOrder(context.entityCreationOrder.getList());
        context.sink.setTypesDef(context.result.getData().getTypesDef());
        context.result.setOperationStatus(this.getOverallOperationStatus(statuses));
        context.result.incrementMeticsCounter("duration", duration);
        this.auditsWriter.write(userName, context.result, startTime, endTime, context.entityCreationOrder.getList());
        context.result.setData(null);
        context.sink.setResult(context.result);
    }

    private int getOperationDuration(long startTime, long endTime) {
        return (int)(endTime - startTime);
    }

    private void processTypesDef(ExportContext context) {
        AtlasTypesDef typesDef = context.result.getData().getTypesDef();
        for (String entityType : context.entityTypes) {
            AtlasEntityDef entityDef = this.typeRegistry.getEntityDefByName(entityType);
            typesDef.getEntityDefs().add(entityDef);
        }
        for (String classificationType : context.classificationTypes) {
            AtlasClassificationDef classificationDef = this.typeRegistry.getClassificationDefByName(classificationType);
            typesDef.getClassificationDefs().add(classificationDef);
        }
        for (String structType : context.structTypes) {
            AtlasStructDef structDef = this.typeRegistry.getStructDefByName(structType);
            typesDef.getStructDefs().add(structDef);
        }
        for (String enumType : context.enumTypes) {
            AtlasEnumDef enumDef = this.typeRegistry.getEnumDefByName(enumType);
            typesDef.getEnumDefs().add(enumDef);
        }
        for (String relationshipType : context.relationshipTypes) {
            AtlasRelationshipDef relationshipDef = this.typeRegistry.getRelationshipDefByName(relationshipType);
            typesDef.getRelationshipDefs().add(relationshipDef);
        }
    }

    private AtlasExportResult.OperationStatus[] processItems(AtlasExportRequest request, ExportContext context) {
        AtlasExportResult.OperationStatus[] statuses = new AtlasExportResult.OperationStatus[request.getItemsToExport().size()];
        List itemsToExport = request.getItemsToExport();
        for (int i = 0; i < itemsToExport.size(); ++i) {
            AtlasObjectId item = (AtlasObjectId)itemsToExport.get(i);
            statuses[i] = this.processObjectId(item, context);
        }
        return statuses;
    }

    @VisibleForTesting
    AtlasExportResult.OperationStatus getOverallOperationStatus(AtlasExportResult.OperationStatus ... statuses) {
        AtlasExportResult.OperationStatus overall = statuses.length == 0 ? AtlasExportResult.OperationStatus.FAIL : statuses[0];
        for (AtlasExportResult.OperationStatus s : statuses) {
            if (overall == s) continue;
            overall = AtlasExportResult.OperationStatus.PARTIAL_SUCCESS;
        }
        return overall;
    }

    private AtlasExportResult.OperationStatus processObjectId(AtlasObjectId item, ExportContext context) {
        this.debugLog("==> processObjectId({})", item);
        try {
            List<String> entityGuids = this.getStartingEntity(item, context);
            if (entityGuids.size() == 0) {
                return AtlasExportResult.OperationStatus.FAIL;
            }
            for (String guid : entityGuids) {
                this.processEntityGuid(guid, context);
                this.populateEntitesForIncremental(guid, context);
            }
            while (!context.guidsToProcess.isEmpty()) {
                while (!context.guidsToProcess.isEmpty()) {
                    String guid = (String)context.guidsToProcess.remove(0);
                    this.processEntityGuid(guid, context);
                }
                if (context.lineageToProcess.isEmpty()) continue;
                context.guidsToProcess.addAll(context.lineageToProcess);
                context.lineageProcessed.addAll(context.lineageToProcess.getList());
                context.lineageToProcess.clear();
            }
        }
        catch (AtlasBaseException excp) {
            LOG.error("Fetching entity failed for: {}", (Object)item, (Object)excp);
            return AtlasExportResult.OperationStatus.FAIL;
        }
        this.debugLog("<== processObjectId({})", item);
        return AtlasExportResult.OperationStatus.SUCCESS;
    }

    private void debugLog(String s, Object ... params) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug(s, params);
    }

    private List<String> getStartingEntity(AtlasObjectId item, ExportContext context) throws AtlasBaseException {
        List<String> ret = null;
        if (item.getTypeName().equalsIgnoreCase("hdfs_path")) {
            this.hdfsPathEntityCreator.getCreateEntity(item);
        }
        if (StringUtils.isNotEmpty((CharSequence)item.getGuid())) {
            ret = Collections.singletonList(item.getGuid());
        } else if (StringUtils.equalsIgnoreCase((CharSequence)context.matchType, (CharSequence)"forType") && StringUtils.isNotEmpty((CharSequence)item.getTypeName())) {
            ret = this.getStartingEntityForMatchTypeForType(item, context);
        } else if (StringUtils.isNotEmpty((CharSequence)item.getTypeName()) && MapUtils.isNotEmpty((Map)item.getUniqueAttributes())) {
            ret = this.getStartingEntityUsingQueryTemplate(item, context, ret);
        }
        if (ret == null) {
            ret = Collections.emptyList();
        }
        this.logInfoStartingEntitiesFound(item, context, ret);
        return ret;
    }

    private List<String> getStartingEntityUsingQueryTemplate(AtlasObjectId item, ExportContext context, List<String> ret) throws AtlasBaseException {
        String queryTemplate = this.getQueryTemplateForMatchType(context);
        String typeName = item.getTypeName();
        AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(typeName);
        if (entityType == null) {
            throw new AtlasBaseException(AtlasErrorCode.UNKNOWN_TYPENAME, new String[]{typeName});
        }
        for (Map.Entry e : item.getUniqueAttributes().entrySet()) {
            String attrName = (String)e.getKey();
            Object attrValue = e.getValue();
            AtlasStructType.AtlasAttribute attribute = entityType.getAttribute(attrName);
            if (attribute == null || attrValue == null) continue;
            this.setupBindingsForTypeNameAttrNameAttrValue(context, typeName, attrValue, attribute);
            List<String> guids = this.executeGremlinQueryForGuids(queryTemplate, context);
            if (!CollectionUtils.isNotEmpty(guids)) continue;
            if (ret == null) {
                ret = new ArrayList<String>();
            }
            for (String guid : guids) {
                if (ret.contains(guid)) continue;
                ret.add(guid);
            }
        }
        return ret;
    }

    private List<String> getStartingEntityForMatchTypeForType(AtlasObjectId item, ExportContext context) {
        this.setupBindingsForTypeName(context, item.getTypeName());
        return this.executeGremlinQueryForGuids(this.getQueryTemplateForMatchType(context), context);
    }

    private void logInfoStartingEntitiesFound(AtlasObjectId item, ExportContext context, List<String> ret) {
        LOG.info("export(item={}; matchType={}, fetchType={}): found {} entities: options: {}", new Object[]{item, context.matchType, context.fetchType, ret.size(), AtlasType.toJson((Object)context.result.getRequest())});
    }

    private void setupBindingsForTypeName(ExportContext context, String typeName) {
        context.bindings.clear();
        context.bindings.put("typeName", new HashSet<String>(Arrays.asList(StringUtils.split((String)typeName, (String)","))));
    }

    private void setupBindingsForTypeNameAttrNameAttrValue(ExportContext context, String typeName, Object attrValue, AtlasStructType.AtlasAttribute attribute) {
        context.bindings.clear();
        context.bindings.put("typeName", typeName);
        context.bindings.put("attrName", attribute.getQualifiedName());
        context.bindings.put("attrValue", attrValue);
    }

    private String getQueryTemplateForMatchType(ExportContext context) {
        if (StringUtils.equalsIgnoreCase((CharSequence)context.matchType, (CharSequence)"startsWith")) {
            return this.gremlinQueryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.EXPORT_TYPE_STARTS_WITH);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)context.matchType, (CharSequence)"endsWith")) {
            return this.gremlinQueryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.EXPORT_TYPE_ENDS_WITH);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)context.matchType, (CharSequence)"contains")) {
            return this.gremlinQueryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.EXPORT_TYPE_CONTAINS);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)context.matchType, (CharSequence)"matches")) {
            return this.gremlinQueryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.EXPORT_TYPE_MATCHES);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)context.matchType, (CharSequence)"forType")) {
            return this.gremlinQueryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.EXPORT_TYPE_ALL_FOR_TYPE);
        }
        return this.gremlinQueryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.EXPORT_TYPE_DEFAULT);
    }

    private void processEntityGuid(String guid, ExportContext context) throws AtlasBaseException {
        this.debugLog("==> processEntityGuid({})", guid);
        if (context.guidsProcessed.contains(guid)) {
            return;
        }
        TraversalDirection direction = context.guidDirection.get(guid);
        AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = this.entityGraphRetriever.toAtlasEntityWithExtInfo(guid);
        this.processEntity(guid, entityWithExtInfo, context, direction);
        this.debugLog("<== processEntityGuid({})", guid);
    }

    public void processEntity(String guid, AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo, ExportContext context, TraversalDirection direction) throws AtlasBaseException {
        if (!context.lineageProcessed.contains(guid) && context.doesTimestampQualify(entityWithExtInfo.getEntity())) {
            context.addToEntityCreationOrder(entityWithExtInfo.getEntity().getGuid());
        }
        this.addEntity(entityWithExtInfo, context);
        this.exportTypeProcessor.addTypes(entityWithExtInfo.getEntity(), context);
        context.guidsProcessed.add(entityWithExtInfo.getEntity().getGuid());
        this.getConntedEntitiesBasedOnOption(entityWithExtInfo.getEntity(), context, direction);
        if (entityWithExtInfo.getReferredEntities() != null) {
            for (AtlasEntity e : entityWithExtInfo.getReferredEntities().values()) {
                this.exportTypeProcessor.addTypes(e, context);
                this.getConntedEntitiesBasedOnOption(e, context, direction);
            }
            context.guidsProcessed.addAll(entityWithExtInfo.getReferredEntities().keySet());
        }
    }

    private void getConntedEntitiesBasedOnOption(AtlasEntity entity, ExportContext context, TraversalDirection direction) {
        switch (context.fetchType) {
            case CONNECTED: {
                this.getEntityGuidsForConnectedFetch(entity, context, direction);
                break;
            }
            case INCREMENTAL: {
                if (context.isHiveDBIncrementalSkipLineage()) break;
            }
            default: {
                this.getEntityGuidsForFullFetch(entity, context);
            }
        }
    }

    private void populateEntitesForIncremental(String topLevelEntityGuid, ExportContext context) throws AtlasBaseException {
        if (!context.isHiveDBIncrementalSkipLineage() || this.incrementalExportEntityProvider != null) {
            return;
        }
        this.incrementalExportEntityProvider = new IncrementalExportEntityProvider(this.atlasGraph, context.scriptEngine);
        this.incrementalExportEntityProvider.populate(topLevelEntityGuid, context.changeMarker, context.guidsToProcess);
    }

    private void getEntityGuidsForConnectedFetch(AtlasEntity entity, ExportContext context, TraversalDirection direction) {
        if (direction == null || direction == TraversalDirection.UNKNOWN) {
            this.getConnectedEntityGuids(entity, context, TraversalDirection.OUTWARD, TraversalDirection.INWARD);
        } else {
            if (this.isProcessEntity(entity)) {
                direction = TraversalDirection.OUTWARD;
            }
            this.getConnectedEntityGuids(entity, context, direction);
        }
    }

    private boolean isProcessEntity(AtlasEntity entity) {
        String typeName = entity.getTypeName();
        AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(typeName);
        return entityType.isSubTypeOf("Process");
    }

    private void getConnectedEntityGuids(AtlasEntity entity, ExportContext context, TraversalDirection ... directions) {
        if (directions == null) {
            return;
        }
        for (TraversalDirection direction : directions) {
            String query = this.getQueryForTraversalDirection(direction);
            if (LOG.isDebugEnabled()) {
                this.debugLog("==> getConnectedEntityGuids({}): guidsToProcess {} query {}", AtlasTypeUtil.getAtlasObjectId((AtlasEntity)entity), context.guidsToProcess.size(), query);
            }
            context.bindings.clear();
            context.bindings.put("startGuid", entity.getGuid());
            List<Map<String, Object>> result = this.executeGremlinQuery(query, context);
            if (CollectionUtils.isEmpty(result)) continue;
            for (Map<String, Object> hashMap : result) {
                String guid = (String)hashMap.get(PROPERTY_GUID);
                TraversalDirection currentDirection = context.guidDirection.get(guid);
                boolean isLineage = (Boolean)hashMap.get(PROPERTY_IS_PROCESS);
                if (context.skipLineage && isLineage) continue;
                if (currentDirection == null) {
                    context.addToBeProcessed(isLineage, guid, direction);
                    continue;
                }
                if (currentDirection != TraversalDirection.OUTWARD || direction != TraversalDirection.INWARD) continue;
                context.guidsProcessed.remove(guid);
                context.addToBeProcessed(isLineage, guid, direction);
            }
            if (!LOG.isDebugEnabled()) continue;
            this.debugLog("<== getConnectedEntityGuids({}): found {} guids; guidsToProcess {}", entity.getGuid(), result.size(), context.guidsToProcess.size());
        }
    }

    private String getQueryForTraversalDirection(TraversalDirection direction) {
        switch (direction) {
            case INWARD: {
                return this.gremlinQueryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.EXPORT_BY_GUID_CONNECTED_IN_EDGE);
            }
        }
        return this.gremlinQueryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.EXPORT_BY_GUID_CONNECTED_OUT_EDGE);
    }

    private void getEntityGuidsForFullFetch(AtlasEntity entity, ExportContext context) {
        if (LOG.isDebugEnabled()) {
            this.debugLog("==> getEntityGuidsForFullFetch({}): guidsToProcess {}", AtlasTypeUtil.getAtlasObjectId((AtlasEntity)entity), context.guidsToProcess.size());
        }
        String query = this.gremlinQueryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.EXPORT_BY_GUID_FULL);
        context.bindings.clear();
        context.bindings.put("startGuid", entity.getGuid());
        List<Map<String, Object>> result = this.executeGremlinQuery(query, context);
        if (CollectionUtils.isEmpty(result)) {
            return;
        }
        for (Map<String, Object> hashMap : result) {
            String guid = (String)hashMap.get(PROPERTY_GUID);
            boolean isLineage = (Boolean)hashMap.get(PROPERTY_IS_PROCESS);
            if (context.getSkipLineage() && isLineage || context.guidsProcessed.contains(guid)) continue;
            context.addToBeProcessed(isLineage, guid, TraversalDirection.BOTH);
        }
        if (LOG.isDebugEnabled()) {
            this.debugLog("<== getEntityGuidsForFullFetch({}): found {} guids; guidsToProcess {}", entity.getGuid(), result.size(), context.guidsToProcess.size());
        }
    }

    private void addEntity(AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo, ExportContext context) throws AtlasBaseException {
        if (context.sink.hasEntity(entityWithExtInfo.getEntity().getGuid())) {
            return;
        }
        if (context.doesTimestampQualify(entityWithExtInfo.getEntity())) {
            context.addToSink(entityWithExtInfo);
            context.result.incrementMeticsCounter(String.format("entity:%s", entityWithExtInfo.getEntity().getTypeName()));
            if (entityWithExtInfo.getReferredEntities() != null) {
                for (AtlasEntity e : entityWithExtInfo.getReferredEntities().values()) {
                    context.result.incrementMeticsCounter(String.format("entity:%s", e.getTypeName()));
                }
            }
            context.result.incrementMeticsCounter("entity:withExtInfo");
        } else {
            List<AtlasEntity> entities = context.getEntitiesWithModifiedTimestamp(entityWithExtInfo);
            for (AtlasEntity e : entities) {
                context.addToEntityCreationOrder(e.getGuid());
                context.addToSink(new AtlasEntity.AtlasEntityWithExtInfo(e));
                context.result.incrementMeticsCounter(String.format("entity:%s", e.getTypeName()));
            }
        }
        context.reportProgress();
    }

    private void addTypes(AtlasEntity entity, ExportContext context) {
        this.addEntityType(entity.getTypeName(), context);
        if (CollectionUtils.isNotEmpty((Collection)entity.getClassifications())) {
            for (AtlasClassification c : entity.getClassifications()) {
                this.addClassificationType(c.getTypeName(), context);
            }
        }
    }

    private void addType(String typeName, ExportContext context) {
        AtlasType type = null;
        try {
            type = this.typeRegistry.getType(typeName);
            this.addType(type, context);
        }
        catch (AtlasBaseException excp) {
            LOG.error("unknown type {}", (Object)typeName);
        }
    }

    private void addEntityType(String typeName, ExportContext context) {
        if (!context.entityTypes.contains(typeName)) {
            AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(typeName);
            this.addEntityType(entityType, context);
        }
    }

    private void addClassificationType(String typeName, ExportContext context) {
        if (!context.classificationTypes.contains(typeName)) {
            AtlasClassificationType classificationType = this.typeRegistry.getClassificationTypeByName(typeName);
            this.addClassificationType(classificationType, context);
        }
    }

    private void addType(AtlasType type, ExportContext context) {
        if (type.getTypeCategory() == TypeCategory.PRIMITIVE) {
            return;
        }
        if (type instanceof AtlasArrayType) {
            AtlasArrayType arrayType = (AtlasArrayType)type;
            this.addType(arrayType.getElementType(), context);
        } else if (type instanceof AtlasMapType) {
            AtlasMapType mapType = (AtlasMapType)type;
            this.addType(mapType.getKeyType(), context);
            this.addType(mapType.getValueType(), context);
        } else if (type instanceof AtlasEntityType) {
            this.addEntityType((AtlasEntityType)type, context);
        } else if (type instanceof AtlasClassificationType) {
            this.addClassificationType((AtlasClassificationType)type, context);
        } else if (type instanceof AtlasStructType) {
            this.addStructType((AtlasStructType)type, context);
        } else if (type instanceof AtlasEnumType) {
            this.addEnumType((AtlasEnumType)type, context);
        } else if (type instanceof AtlasRelationshipType) {
            this.addRelationshipType(type.getTypeName(), context);
        }
    }

    private void addEntityType(AtlasEntityType entityType, ExportContext context) {
        if (!context.entityTypes.contains(entityType.getTypeName())) {
            context.entityTypes.add(entityType.getTypeName());
            this.addAttributeTypes((AtlasStructType)entityType, context);
            this.addRelationshipTypes(entityType, context);
            if (CollectionUtils.isNotEmpty((Collection)entityType.getAllSuperTypes())) {
                for (String superType : entityType.getAllSuperTypes()) {
                    this.addEntityType(superType, context);
                }
            }
        }
    }

    private void addClassificationType(AtlasClassificationType classificationType, ExportContext context) {
        if (!context.classificationTypes.contains(classificationType.getTypeName())) {
            context.classificationTypes.add(classificationType.getTypeName());
            this.addAttributeTypes((AtlasStructType)classificationType, context);
            if (CollectionUtils.isNotEmpty((Collection)classificationType.getAllSuperTypes())) {
                for (String superType : classificationType.getAllSuperTypes()) {
                    this.addClassificationType(superType, context);
                }
            }
        }
    }

    private void addStructType(AtlasStructType structType, ExportContext context) {
        if (!context.structTypes.contains(structType.getTypeName())) {
            context.structTypes.add(structType.getTypeName());
            this.addAttributeTypes(structType, context);
        }
    }

    private void addEnumType(AtlasEnumType enumType, ExportContext context) {
        if (!context.enumTypes.contains(enumType.getTypeName())) {
            context.enumTypes.add(enumType.getTypeName());
        }
    }

    private void addRelationshipType(String relationshipTypeName, ExportContext context) {
        AtlasRelationshipType relationshipType;
        if (!context.relationshipTypes.contains(relationshipTypeName) && (relationshipType = this.typeRegistry.getRelationshipTypeByName(relationshipTypeName)) != null) {
            context.relationshipTypes.add(relationshipTypeName);
            this.addAttributeTypes((AtlasStructType)relationshipType, context);
            this.addEntityType(relationshipType.getEnd1Type(), context);
            this.addEntityType(relationshipType.getEnd2Type(), context);
        }
    }

    private void addAttributeTypes(AtlasStructType structType, ExportContext context) {
        for (AtlasStructDef.AtlasAttributeDef attributeDef : structType.getStructDef().getAttributeDefs()) {
            this.addType(attributeDef.getTypeName(), context);
        }
    }

    private void addRelationshipTypes(AtlasEntityType entityType, ExportContext context) {
        for (Map.Entry entry : entityType.getRelationshipAttributes().entrySet()) {
            for (String relationshipType : ((Map)entry.getValue()).keySet()) {
                this.addRelationshipType(relationshipType, context);
            }
        }
    }

    private List<Map<String, Object>> executeGremlinQuery(String query, ExportContext context) {
        try {
            return (List)this.atlasGraph.executeGremlinScript(context.scriptEngine, context.bindings, query, false);
        }
        catch (ScriptException e) {
            LOG.error("Script execution failed for query: ", (Object)query, (Object)e);
            return null;
        }
    }

    private List<String> executeGremlinQueryForGuids(String query, ExportContext context) {
        try {
            return (List)this.atlasGraph.executeGremlinScript(context.scriptEngine, context.bindings, query, false);
        }
        catch (ScriptException e) {
            LOG.error("Script execution failed for query: ", (Object)query, (Object)e);
            return null;
        }
    }

    static class ExportContext {
        private static final int REPORTING_THREASHOLD = 1000;
        private static final String ATLAS_TYPE_HIVE_DB = "hive_db";
        final UniqueList<String> entityCreationOrder = new UniqueList();
        final Set<String> guidsProcessed = new HashSet<String>();
        private final UniqueList<String> guidsToProcess = new UniqueList();
        final UniqueList<String> lineageToProcess = new UniqueList();
        final Set<String> lineageProcessed = new HashSet<String>();
        final Map<String, TraversalDirection> guidDirection = new HashMap<String, TraversalDirection>();
        final Set<String> entityTypes = new HashSet<String>();
        final Set<String> classificationTypes = new HashSet<String>();
        final Set<String> structTypes = new HashSet<String>();
        final Set<String> enumTypes = new HashSet<String>();
        final Set<String> relationshipTypes = new HashSet<String>();
        final AtlasExportResult result;
        private final ZipSink sink;
        private final ScriptEngine scriptEngine;
        private final Map<String, Object> bindings;
        private final ExportFetchType fetchType;
        private final String matchType;
        private final boolean skipLineage;
        private final long changeMarker;
        private final boolean isHiveDBIncremental;
        private int progressReportCount = 0;

        ExportContext(AtlasGraph atlasGraph, AtlasExportResult result, ZipSink sink) throws AtlasBaseException {
            this.result = result;
            this.sink = sink;
            this.scriptEngine = atlasGraph.getGremlinScriptEngine();
            this.bindings = new HashMap<String, Object>();
            this.fetchType = ExportFetchType.from(result.getRequest().getFetchTypeOptionValue());
            this.matchType = result.getRequest().getMatchTypeOptionValue();
            this.skipLineage = result.getRequest().getSkipLineageOptionValue();
            this.changeMarker = result.getRequest().getChangeTokenFromOptions();
            this.isHiveDBIncremental = this.checkHiveDBIncrementalSkipLineage(result.getRequest());
        }

        private boolean checkHiveDBIncrementalSkipLineage(AtlasExportRequest request) {
            if (request.getItemsToExport().size() == 0) {
                return false;
            }
            return ((AtlasObjectId)request.getItemsToExport().get(0)).getTypeName().equalsIgnoreCase(ATLAS_TYPE_HIVE_DB) && request.getFetchTypeOptionValue().equalsIgnoreCase("incremental") && request.getSkipLineageOptionValue();
        }

        public List<AtlasEntity> getEntitiesWithModifiedTimestamp(AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo) {
            if (this.fetchType != ExportFetchType.INCREMENTAL) {
                return new ArrayList<AtlasEntity>();
            }
            ArrayList<AtlasEntity> ret = new ArrayList<AtlasEntity>();
            if (this.doesTimestampQualify(entityWithExtInfo.getEntity())) {
                ret.add(entityWithExtInfo.getEntity());
                return ret;
            }
            for (AtlasEntity entity : entityWithExtInfo.getReferredEntities().values()) {
                if (!this.doesTimestampQualify(entity)) continue;
                ret.add(entity);
            }
            return ret;
        }

        public void clear() {
            this.guidsToProcess.clear();
            this.guidsProcessed.clear();
            this.guidDirection.clear();
        }

        public void addToBeProcessed(boolean isSuperTypeProcess, String guid, TraversalDirection direction) {
            if (isSuperTypeProcess) {
                this.lineageToProcess.add(guid);
            } else {
                this.guidsToProcess.add(guid);
            }
            this.guidDirection.put(guid, direction);
        }

        public void reportProgress() {
            if (this.guidsProcessed.size() - this.progressReportCount > 1000) {
                this.progressReportCount = this.guidsProcessed.size();
                LOG.info("export(): in progress.. number of entities exported: {}", (Object)this.guidsProcessed.size());
            }
        }

        public boolean doesTimestampQualify(AtlasEntity entity) {
            if (this.fetchType != ExportFetchType.INCREMENTAL) {
                return true;
            }
            return this.changeMarker <= entity.getUpdateTime().getTime();
        }

        public boolean getSkipLineage() {
            return this.skipLineage;
        }

        public void addToSink(AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo) throws AtlasBaseException {
            this.sink.add(entityWithExtInfo);
        }

        public boolean isHiveDBIncrementalSkipLineage() {
            return this.isHiveDBIncremental;
        }

        public void addToEntityCreationOrder(String guid) {
            this.entityCreationOrder.add(guid);
        }

        public void addToEntityCreationOrder(Collection<String> guids) {
            this.entityCreationOrder.addAll(guids);
        }
    }

    public static enum ExportFetchType {
        FULL("full"),
        CONNECTED("connected"),
        INCREMENTAL("incremental");

        final String str;

        private ExportFetchType(String s) {
            this.str = s;
        }

        public static final ExportFetchType from(String s) {
            for (ExportFetchType b : ExportFetchType.values()) {
                if (!b.str.equalsIgnoreCase(s)) continue;
                return b;
            }
            return FULL;
        }
    }

    public static enum TraversalDirection {
        UNKNOWN,
        INWARD,
        OUTWARD,
        BOTH;

    }
}

