/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.impexp;

import java.util.List;
import javax.inject.Inject;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasException;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.impexp.AtlasExportRequest;
import org.apache.atlas.model.impexp.AtlasExportResult;
import org.apache.atlas.model.impexp.AtlasImportRequest;
import org.apache.atlas.model.impexp.AtlasImportResult;
import org.apache.atlas.model.impexp.AtlasServer;
import org.apache.atlas.repository.impexp.AtlasServerService;
import org.apache.atlas.repository.impexp.ExportImportAuditService;
import org.apache.atlas.type.AtlasType;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AuditsWriter {
    private static final Logger LOG = LoggerFactory.getLogger(AuditsWriter.class);
    private static final String CLUSTER_NAME_DEFAULT = "default";
    private static final String DC_SERVER_NAME_SEPARATOR = "$";
    private AtlasServerService atlasServerService;
    private ExportImportAuditService auditService;
    private ExportAudits auditForExport = new ExportAudits();
    private ImportAudits auditForImport = new ImportAudits();

    @Inject
    public AuditsWriter(AtlasServerService atlasServerService, ExportImportAuditService auditService) {
        this.atlasServerService = atlasServerService;
        this.auditService = auditService;
    }

    public void write(String userName, AtlasExportResult result, long startTime, long endTime, List<String> entityCreationOrder) throws AtlasBaseException {
        this.auditForExport.add(userName, result, startTime, endTime, entityCreationOrder);
    }

    public void write(String userName, AtlasImportResult result, long startTime, long endTime, List<String> entityCreationOrder) throws AtlasBaseException {
        this.auditForImport.add(userName, result, startTime, endTime, entityCreationOrder);
    }

    private void updateReplicationAttribute(boolean isReplicationSet, String serverName, String serverFullName, List<String> exportedGuids, String attrNameReplicated, long lastModifiedTimestamp) throws AtlasBaseException {
        if (!isReplicationSet || CollectionUtils.isEmpty(exportedGuids)) {
            return;
        }
        AtlasServer server = this.saveServer(serverName, serverFullName, exportedGuids.get(0), lastModifiedTimestamp);
        this.atlasServerService.updateEntitiesWithServer(server, exportedGuids, attrNameReplicated);
    }

    private AtlasServer saveServer(String clusterName, String serverFullName, String entityGuid, long lastModifiedTimestamp) throws AtlasBaseException {
        AtlasServer server = this.atlasServerService.getCreateAtlasServer(clusterName, serverFullName);
        server.setAdditionalInfoRepl(entityGuid, lastModifiedTimestamp);
        if (LOG.isDebugEnabled()) {
            LOG.debug("saveServer: {}", (Object)server);
        }
        return this.atlasServerService.save(server);
    }

    public static String getCurrentClusterName() {
        try {
            return ApplicationProperties.get().getString("atlas.cluster.name", CLUSTER_NAME_DEFAULT);
        }
        catch (AtlasException e) {
            LOG.error("getCurrentClusterName", (Throwable)e);
            return "";
        }
    }

    static String getServerNameFromFullName(String fullName) {
        if (StringUtils.isEmpty((String)fullName) || !fullName.contains(DC_SERVER_NAME_SEPARATOR)) {
            return fullName;
        }
        String[] splits = StringUtils.split((String)fullName, (String)DC_SERVER_NAME_SEPARATOR);
        if (splits == null || splits.length < 1) {
            return "";
        }
        if (splits.length >= 2) {
            return splits[1];
        }
        return splits[0];
    }

    private void saveCurrentServer() throws AtlasBaseException {
        this.atlasServerService.getCreateAtlasServer(AuditsWriter.getCurrentClusterName(), AuditsWriter.getCurrentClusterName());
    }

    private class ImportAudits {
        private AtlasImportRequest request;
        private boolean replicationOptionState;
        private String sourceServerName;
        private String optionKeyReplicatedFrom;
        private String sourceServerFullName;

        private ImportAudits() {
        }

        public void add(String userName, AtlasImportResult result, long startTime, long endTime, List<String> entityGuids) throws AtlasBaseException {
            this.optionKeyReplicatedFrom = "replicatedFrom";
            this.request = result.getRequest();
            this.replicationOptionState = this.request.isReplicationOptionSet();
            AuditsWriter.this.saveCurrentServer();
            this.sourceServerFullName = this.request.getOptionKeyReplicatedFrom();
            this.sourceServerName = AuditsWriter.getServerNameFromFullName(this.sourceServerFullName);
            AuditsWriter.this.auditService.add(userName, this.sourceServerName, AuditsWriter.getCurrentClusterName(), "IMPORT", AtlasType.toJson((Object)result), startTime, endTime, !entityGuids.isEmpty());
            if (result.getOperationStatus() == AtlasImportResult.OperationStatus.FAIL) {
                return;
            }
            AuditsWriter.this.updateReplicationAttribute(this.replicationOptionState, this.sourceServerName, this.sourceServerFullName, entityGuids, "replicatedFrom", result.getExportResult().getChangeMarker());
        }
    }

    private class ExportAudits {
        private AtlasExportRequest request;
        private String targetServerName;
        private boolean replicationOptionState;
        private String targetServerFullName;

        private ExportAudits() {
        }

        public void add(String userName, AtlasExportResult result, long startTime, long endTime, List<String> entityGuids) throws AtlasBaseException {
            this.request = result.getRequest();
            this.replicationOptionState = this.request.isReplicationOptionSet();
            AuditsWriter.this.saveCurrentServer();
            this.targetServerFullName = this.request.getOptionKeyReplicatedTo();
            this.targetServerName = AuditsWriter.getServerNameFromFullName(this.targetServerFullName);
            AuditsWriter.this.auditService.add(userName, AuditsWriter.getCurrentClusterName(), this.targetServerName, "EXPORT", AtlasType.toJson((Object)result), startTime, endTime, !entityGuids.isEmpty());
            if (result.getOperationStatus() == AtlasExportResult.OperationStatus.FAIL) {
                return;
            }
            AuditsWriter.this.updateReplicationAttribute(this.replicationOptionState, this.targetServerName, this.targetServerFullName, entityGuids, "replicatedTo", result.getChangeMarker());
        }
    }
}

