/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.impexp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.apache.atlas.annotation.AtlasService;
import org.apache.atlas.annotation.GraphTransaction;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.impexp.AtlasServer;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.ogm.DataAccess;
import org.apache.atlas.repository.store.graph.AtlasEntityStore;
import org.apache.atlas.repository.store.graph.v2.EntityGraphMapper;
import org.apache.atlas.repository.store.graph.v2.EntityGraphRetriever;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AtlasService
public class AtlasServerService {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasServerService.class);
    private final DataAccess dataAccess;
    private final AtlasEntityStore entityStore;
    private final AtlasTypeRegistry typeRegistry;
    private final EntityGraphRetriever entityGraphRetriever;

    @Inject
    public AtlasServerService(DataAccess dataAccess, AtlasEntityStore entityStore, AtlasTypeRegistry typeRegistry, EntityGraphRetriever entityGraphRetriever) {
        this.dataAccess = dataAccess;
        this.entityStore = entityStore;
        this.typeRegistry = typeRegistry;
        this.entityGraphRetriever = entityGraphRetriever;
    }

    public AtlasServer get(AtlasServer server) throws AtlasBaseException {
        return this.dataAccess.load(server);
    }

    public AtlasServer getCreateAtlasServer(String clusterName, String serverFullName) throws AtlasBaseException {
        AtlasServer defaultServer = new AtlasServer(clusterName, serverFullName);
        AtlasServer server = this.getAtlasServer(defaultServer);
        if (server == null) {
            return this.save(defaultServer);
        }
        return server;
    }

    private AtlasServer getAtlasServer(AtlasServer server) {
        try {
            return this.get(server);
        }
        catch (AtlasBaseException ex) {
            return null;
        }
    }

    @GraphTransaction
    public AtlasServer save(AtlasServer server) {
        try {
            return this.dataAccess.save(server);
        }
        catch (AtlasBaseException ex) {
            return server;
        }
    }

    @GraphTransaction
    public void updateEntitiesWithServer(AtlasServer server, List<String> entityGuids, String attributeName) throws AtlasBaseException {
        if (server != null && StringUtils.isEmpty((String)server.getGuid())) {
            return;
        }
        AtlasObjectId objectId = this.getObjectId(server);
        for (String guid : entityGuids) {
            AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = this.entityStore.getById(guid, false, true);
            this.updateAttribute(entityWithExtInfo, attributeName, objectId);
        }
    }

    private AtlasObjectId getObjectId(AtlasServer server) {
        return new AtlasObjectId(server.getGuid(), AtlasServer.class.getSimpleName());
    }

    private void updateAttribute(AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo, String propertyName, AtlasObjectId objectId) {
        String value = EntityGraphMapper.getSoftRefFormattedValue(objectId);
        this.updateAttribute(entityWithExtInfo.getEntity(), propertyName, value);
        for (AtlasEntity e : entityWithExtInfo.getReferredEntities().values()) {
            this.updateAttribute(e, propertyName, value);
        }
    }

    private void updateAttribute(AtlasEntity entity, String attributeName, Object value) {
        if (!entity.hasAttribute(attributeName)) {
            return;
        }
        try {
            AtlasVertex vertex = this.entityGraphRetriever.getEntityVertex(entity.getGuid());
            if (vertex == null) {
                return;
            }
            String qualifiedFieldName = this.getVertexPropertyName(entity, attributeName);
            ArrayList<Object> list = vertex.getListProperty(qualifiedFieldName);
            if (CollectionUtils.isEmpty((Collection)list)) {
                list = new ArrayList<Object>();
            }
            if (!list.contains(value)) {
                list.add(value);
                vertex.setListProperty(qualifiedFieldName, list);
            }
        }
        catch (AtlasBaseException ex) {
            LOG.error("error retrieving vertex from guid: {}", (Object)entity.getGuid(), (Object)ex);
        }
    }

    private String getVertexPropertyName(AtlasEntity entity, String attributeName) throws AtlasBaseException {
        AtlasEntityType type = (AtlasEntityType)this.typeRegistry.getType(entity.getTypeName());
        AtlasStructType.AtlasAttribute attribute = type.getAttribute(attributeName);
        return attribute.getVertexPropertyName();
    }
}

