/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graph;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.AtlasException;
import org.apache.atlas.discovery.SearchIndexer;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.ha.HAConfiguration;
import org.apache.atlas.listener.ActiveStateChangeHandler;
import org.apache.atlas.listener.ChangedTypeDefs;
import org.apache.atlas.listener.TypeDefChangeListener;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.model.typedef.AtlasEnumDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.IndexException;
import org.apache.atlas.repository.RepositoryException;
import org.apache.atlas.repository.graph.AtlasGraphProvider;
import org.apache.atlas.repository.graph.IAtlasGraphProvider;
import org.apache.atlas.repository.graphdb.AtlasCardinality;
import org.apache.atlas.repository.graphdb.AtlasEdgeDirection;
import org.apache.atlas.repository.graphdb.AtlasEdgeLabel;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.AtlasGraphIndex;
import org.apache.atlas.repository.graphdb.AtlasGraphManagement;
import org.apache.atlas.repository.graphdb.AtlasPropertyKey;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.type.AtlasArrayType;
import org.apache.atlas.type.AtlasClassificationType;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasEnumType;
import org.apache.atlas.type.AtlasMapType;
import org.apache.atlas.type.AtlasRelationshipType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.type.AtlasTypeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GraphBackedSearchIndexer
implements SearchIndexer,
ActiveStateChangeHandler,
TypeDefChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(GraphBackedSearchIndexer.class);
    private static final String VERTEX_ID_IN_IMPORT_KEY = "__vIdInImport";
    private static final String EDGE_ID_IN_IMPORT_KEY = "__eIdInImport";
    private static final List<Class> INDEX_EXCLUSION_CLASSES = new ArrayList(){
        {
            this.add(Boolean.class);
            this.add(BigDecimal.class);
            this.add(BigInteger.class);
        }
    };
    private final AtlasTypeRegistry typeRegistry;
    private IAtlasGraphProvider provider;
    private boolean recomputeIndexedKeys = true;
    private Set<String> vertexIndexKeys = new HashSet<String>();

    @Inject
    public GraphBackedSearchIndexer(AtlasTypeRegistry typeRegistry) throws AtlasException {
        this(new AtlasGraphProvider(), ApplicationProperties.get(), typeRegistry);
    }

    @VisibleForTesting
    GraphBackedSearchIndexer(IAtlasGraphProvider provider, Configuration configuration, AtlasTypeRegistry typeRegistry) throws IndexException, RepositoryException {
        this.provider = provider;
        this.typeRegistry = typeRegistry;
        if (!HAConfiguration.isHAEnabled((Configuration)configuration)) {
            this.initialize(provider.get());
        }
    }

    public void instanceIsActive() throws AtlasException {
        LOG.info("Reacting to active: initializing index");
        try {
            this.initialize();
        }
        catch (IndexException | RepositoryException e) {
            throw new AtlasException("Error in reacting to active on initialization", (Throwable)e);
        }
    }

    public void instanceIsPassive() {
        LOG.info("Reacting to passive state: No action right now.");
    }

    public int getHandlerOrder() {
        return ActiveStateChangeHandler.HandlerOrder.GRAPH_BACKED_SEARCH_INDEXER.getOrder();
    }

    public void onChange(ChangedTypeDefs changedTypeDefs) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing changed typedefs {}", (Object)changedTypeDefs);
        }
        AtlasGraphManagement management = null;
        try {
            management = this.provider.get().getManagementSystem();
            if (CollectionUtils.isNotEmpty((Collection)changedTypeDefs.getCreateTypeDefs())) {
                for (AtlasBaseTypeDef typeDef : changedTypeDefs.getCreateTypeDefs()) {
                    this.updateIndexForTypeDef(management, typeDef);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)changedTypeDefs.getUpdatedTypeDefs())) {
                for (AtlasBaseTypeDef typeDef : changedTypeDefs.getUpdatedTypeDefs()) {
                    this.updateIndexForTypeDef(management, typeDef);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)changedTypeDefs.getDeletedTypeDefs())) {
                for (AtlasBaseTypeDef typeDef : changedTypeDefs.getDeletedTypeDefs()) {
                    this.deleteIndexForType(management, typeDef);
                }
            }
            this.commit(management);
        }
        catch (IndexException | RepositoryException e) {
            LOG.error("Failed to update indexes for changed typedefs", (Throwable)e);
            this.attemptRollback(changedTypeDefs, management);
        }
    }

    public Set<String> getVertexIndexKeys() {
        block8: {
            if (this.recomputeIndexedKeys) {
                AtlasGraphManagement management = null;
                try {
                    management = this.provider.get().getManagementSystem();
                    if (management != null) {
                        AtlasGraphIndex vertexIndex = management.getGraphIndex("vertex_index");
                        if (vertexIndex != null) {
                            this.recomputeIndexedKeys = false;
                            HashSet<String> indexKeys = new HashSet<String>();
                            for (AtlasPropertyKey fieldKey : vertexIndex.getFieldKeys()) {
                                indexKeys.add(fieldKey.getName());
                            }
                            this.vertexIndexKeys = indexKeys;
                        }
                        management.commit();
                    }
                }
                catch (Exception excp) {
                    LOG.error("getVertexIndexKeys(): failed to get indexedKeys from graph", (Throwable)excp);
                    if (management == null) break block8;
                    try {
                        management.rollback();
                    }
                    catch (Exception e) {
                        LOG.error("getVertexIndexKeys(): rollback failed", (Throwable)e);
                    }
                }
            }
        }
        return this.vertexIndexKeys;
    }

    private void initialize() throws RepositoryException, IndexException {
        this.initialize(this.provider.get());
    }

    private void initialize(AtlasGraph graph) throws RepositoryException, IndexException {
        AtlasGraphManagement management = graph.getManagementSystem();
        try {
            LOG.info("Creating indexes for graph.");
            if (management.getGraphIndex("vertex_index") == null) {
                management.createVertexMixedIndex("vertex_index", "search", Collections.emptyList());
                LOG.info("Created index : {}", (Object)"vertex_index");
            }
            if (management.getGraphIndex("edge_index") == null) {
                management.createEdgeMixedIndex("edge_index", "search", Collections.emptyList());
                LOG.info("Created index : {}", (Object)"edge_index");
            }
            if (management.getGraphIndex("fulltext_index") == null) {
                management.createFullTextMixedIndex("fulltext_index", "search", Collections.emptyList());
                LOG.info("Created index : {}", (Object)"fulltext_index");
            }
            this.createVertexIndex(management, Constants.GUID_PROPERTY_KEY, UniqueKind.GLOBAL_UNIQUE, String.class, AtlasCardinality.SINGLE, true, false);
            this.createVertexIndex(management, Constants.TYPENAME_PROPERTY_KEY, UniqueKind.GLOBAL_UNIQUE, String.class, AtlasCardinality.SINGLE, true, false);
            this.createVertexIndex(management, Constants.TYPESERVICETYPE_PROPERTY_KEY, UniqueKind.NONE, String.class, AtlasCardinality.SINGLE, true, false);
            this.createVertexIndex(management, Constants.VERTEX_TYPE_PROPERTY_KEY, UniqueKind.NONE, String.class, AtlasCardinality.SINGLE, true, false);
            this.createVertexIndex(management, VERTEX_ID_IN_IMPORT_KEY, UniqueKind.NONE, Long.class, AtlasCardinality.SINGLE, true, false);
            this.createVertexIndex(management, Constants.ENTITY_TYPE_PROPERTY_KEY, UniqueKind.NONE, String.class, AtlasCardinality.SINGLE, true, false);
            this.createVertexIndex(management, Constants.SUPER_TYPES_PROPERTY_KEY, UniqueKind.NONE, String.class, AtlasCardinality.SET, true, false);
            this.createVertexIndex(management, Constants.TIMESTAMP_PROPERTY_KEY, UniqueKind.NONE, Long.class, AtlasCardinality.SINGLE, false, false);
            this.createVertexIndex(management, Constants.MODIFICATION_TIMESTAMP_PROPERTY_KEY, UniqueKind.NONE, Long.class, AtlasCardinality.SINGLE, false, false);
            this.createVertexIndex(management, Constants.STATE_PROPERTY_KEY, UniqueKind.NONE, String.class, AtlasCardinality.SINGLE, false, false);
            this.createVertexIndex(management, Constants.CREATED_BY_KEY, UniqueKind.NONE, String.class, AtlasCardinality.SINGLE, false, false);
            this.createVertexIndex(management, Constants.MODIFIED_BY_KEY, UniqueKind.NONE, String.class, AtlasCardinality.SINGLE, false, false);
            this.createVertexIndex(management, Constants.TRAIT_NAMES_PROPERTY_KEY, UniqueKind.NONE, String.class, AtlasCardinality.SET, true, true);
            this.createVertexIndex(management, Constants.PROPAGATED_TRAIT_NAMES_PROPERTY_KEY, UniqueKind.NONE, String.class, AtlasCardinality.LIST, true, true);
            this.createVertexCentricIndex(management, "classifiedAs", AtlasEdgeDirection.BOTH, Constants.CLASSIFICATION_EDGE_NAME_PROPERTY_KEY, String.class, AtlasCardinality.SINGLE);
            this.createVertexCentricIndex(management, "classifiedAs", AtlasEdgeDirection.BOTH, Constants.CLASSIFICATION_EDGE_IS_PROPAGATED_PROPERTY_KEY, Boolean.class, AtlasCardinality.SINGLE);
            this.createVertexCentricIndex(management, "classifiedAs", AtlasEdgeDirection.BOTH, Arrays.asList(Constants.CLASSIFICATION_EDGE_NAME_PROPERTY_KEY, Constants.CLASSIFICATION_EDGE_IS_PROPAGATED_PROPERTY_KEY));
            this.createEdgeIndex(management, Constants.RELATIONSHIP_GUID_PROPERTY_KEY, String.class, AtlasCardinality.SINGLE, true);
            this.createEdgeIndex(management, EDGE_ID_IN_IMPORT_KEY, String.class, AtlasCardinality.SINGLE, true);
            this.createFullTextIndex(management, Constants.ENTITY_TEXT_PROPERTY_KEY, String.class, AtlasCardinality.SINGLE);
            this.commit(management);
            LOG.info("Index creation for global keys complete.");
        }
        catch (Throwable t) {
            this.rollback(management);
            throw new RepositoryException(t);
        }
    }

    private void addIndexForType(AtlasGraphManagement management, AtlasBaseTypeDef typeDef) {
        if (typeDef instanceof AtlasEnumDef) {
            return;
        }
        if (typeDef instanceof AtlasStructDef) {
            AtlasStructDef structDef = (AtlasStructDef)typeDef;
            List attributeDefs = structDef.getAttributeDefs();
            if (CollectionUtils.isNotEmpty((Collection)attributeDefs)) {
                for (AtlasStructDef.AtlasAttributeDef attributeDef : attributeDefs) {
                    this.createIndexForAttribute(management, typeDef.getName(), attributeDef);
                }
            }
        } else if (!AtlasTypeUtil.isBuiltInType((String)typeDef.getName())) {
            throw new IllegalArgumentException("bad data type" + typeDef.getName());
        }
    }

    private void deleteIndexForType(AtlasGraphManagement management, AtlasBaseTypeDef typeDef) {
        AtlasStructDef structDef;
        List attributeDefs;
        Preconditions.checkNotNull((Object)typeDef, (Object)"Cannot process null typedef");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Deleting indexes for type {}", (Object)typeDef.getName());
        }
        if (typeDef instanceof AtlasStructDef && CollectionUtils.isNotEmpty((Collection)(attributeDefs = (structDef = (AtlasStructDef)typeDef).getAttributeDefs()))) {
            for (AtlasStructDef.AtlasAttributeDef attributeDef : attributeDefs) {
                this.deleteIndexForAttribute(management, typeDef.getName(), attributeDef);
            }
        }
        LOG.info("Completed deleting indexes for type {}", (Object)typeDef.getName());
    }

    private void createIndexForAttribute(AtlasGraphManagement management, String typeName, AtlasStructDef.AtlasAttributeDef attributeDef) {
        String propertyName = AtlasGraphUtilsV2.encodePropertyKey(typeName + "." + attributeDef.getName());
        AtlasCardinality cardinality = this.toAtlasCardinality(attributeDef.getCardinality());
        boolean isUnique = attributeDef.getIsUnique();
        boolean isIndexable = attributeDef.getIsIndexable();
        String attribTypeName = attributeDef.getTypeName();
        boolean isBuiltInType = AtlasTypeUtil.isBuiltInType((String)attribTypeName);
        boolean isArrayType = AtlasTypeUtil.isArrayType((String)attribTypeName);
        boolean isMapType = AtlasTypeUtil.isMapType((String)attribTypeName);
        String uniqPropName = isUnique ? AtlasGraphUtilsV2.encodePropertyKey(typeName + "." + "__u_" + attributeDef.getName()) : null;
        try {
            boolean isReference;
            AtlasType atlasType = this.typeRegistry.getType(typeName);
            AtlasType attributeType = this.typeRegistry.getType(attribTypeName);
            if (this.isClassificationType(attributeType)) {
                LOG.warn("Ignoring non-indexable attribute {}", (Object)attribTypeName);
            }
            if (isArrayType) {
                this.createLabelIfNeeded(management, propertyName, attribTypeName);
                AtlasArrayType arrayType = (AtlasArrayType)attributeType;
                isReference = AtlasGraphUtilsV2.isReference(arrayType.getElementType());
                if (!isReference) {
                    this.createPropertyKey(management, propertyName, ArrayList.class, AtlasCardinality.SINGLE);
                }
            }
            if (isMapType) {
                this.createLabelIfNeeded(management, propertyName, attribTypeName);
                AtlasMapType mapType = (AtlasMapType)attributeType;
                isReference = AtlasGraphUtilsV2.isReference(mapType.getValueType());
                if (!isReference) {
                    this.createPropertyKey(management, propertyName, HashMap.class, AtlasCardinality.SINGLE);
                }
            }
            if (this.isEntityType(attributeType)) {
                this.createEdgeLabel(management, propertyName);
            } else if (isBuiltInType) {
                if (this.isRelationshipType(atlasType)) {
                    this.createEdgeIndex(management, propertyName, this.getPrimitiveClass(attribTypeName), cardinality, false);
                } else {
                    this.createVertexIndex(management, propertyName, UniqueKind.NONE, this.getPrimitiveClass(attribTypeName), cardinality, isIndexable, false);
                    if (uniqPropName != null) {
                        this.createVertexIndex(management, uniqPropName, UniqueKind.PER_TYPE_UNIQUE, this.getPrimitiveClass(attribTypeName), cardinality, isIndexable, true);
                    }
                }
            } else if (this.isEnumType(attributeType)) {
                if (this.isRelationshipType(atlasType)) {
                    this.createEdgeIndex(management, propertyName, String.class, cardinality, false);
                } else {
                    this.createVertexIndex(management, propertyName, UniqueKind.NONE, String.class, cardinality, isIndexable, false);
                    if (uniqPropName != null) {
                        this.createVertexIndex(management, uniqPropName, UniqueKind.PER_TYPE_UNIQUE, String.class, cardinality, isIndexable, true);
                    }
                }
            } else if (this.isStructType(attributeType)) {
                AtlasStructDef structDef = this.typeRegistry.getStructDefByName(attribTypeName);
                this.updateIndexForTypeDef(management, (AtlasBaseTypeDef)structDef);
            }
        }
        catch (AtlasBaseException e) {
            LOG.error("No type exists for {}", (Object)attribTypeName, (Object)e);
        }
    }

    private void deleteIndexForAttribute(AtlasGraphManagement management, String typeName, AtlasStructDef.AtlasAttributeDef attributeDef) {
        String propertyName = AtlasGraphUtilsV2.encodePropertyKey(typeName + "." + attributeDef.getName());
        try {
            if (management.containsPropertyKey(propertyName)) {
                LOG.info("Deleting propertyKey {}, for attribute {}.{}", new Object[]{propertyName, typeName, attributeDef.getName()});
                management.deletePropertyKey(propertyName);
            }
        }
        catch (Exception excp) {
            LOG.warn("Failed to delete propertyKey {}, for attribute {}.{}", new Object[]{propertyName, typeName, attributeDef.getName()});
        }
    }

    private void createLabelIfNeeded(AtlasGraphManagement management, String propertyName, String attribTypeName) {
        for (String typeName : AtlasTypeUtil.getReferencedTypeNames((String)attribTypeName)) {
            if (this.typeRegistry.getEntityDefByName(typeName) == null && this.typeRegistry.getStructDefByName(typeName) == null) continue;
            this.createEdgeLabel(management, propertyName);
        }
    }

    private boolean isEntityType(AtlasType type) {
        return type instanceof AtlasEntityType;
    }

    private boolean isClassificationType(AtlasType type) {
        return type instanceof AtlasClassificationType;
    }

    private boolean isEnumType(AtlasType type) {
        return type instanceof AtlasEnumType;
    }

    private boolean isStructType(AtlasType type) {
        return type instanceof AtlasStructType;
    }

    private boolean isRelationshipType(AtlasType type) {
        return type instanceof AtlasRelationshipType;
    }

    private Class getPrimitiveClass(String attribTypeName) {
        String attributeTypeName;
        switch (attributeTypeName = attribTypeName.toLowerCase()) {
            case "boolean": {
                return Boolean.class;
            }
            case "byte": {
                return Byte.class;
            }
            case "short": {
                return Short.class;
            }
            case "int": {
                return Integer.class;
            }
            case "long": 
            case "date": {
                return Long.class;
            }
            case "float": {
                return Float.class;
            }
            case "double": {
                return Double.class;
            }
            case "biginteger": {
                return BigInteger.class;
            }
            case "bigdecimal": {
                return BigDecimal.class;
            }
            case "string": {
                return String.class;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown primitive typename %s", attribTypeName));
    }

    private AtlasCardinality toAtlasCardinality(AtlasStructDef.AtlasAttributeDef.Cardinality cardinality) {
        switch (cardinality) {
            case SINGLE: {
                return AtlasCardinality.SINGLE;
            }
            case LIST: {
                return AtlasCardinality.LIST;
            }
            case SET: {
                return AtlasCardinality.SET;
            }
        }
        throw new IllegalArgumentException(String.format("Bad cardinality %s", cardinality));
    }

    private void createEdgeLabel(AtlasGraphManagement management, String propertyName) {
        String label = "__" + propertyName;
        AtlasEdgeLabel edgeLabel = management.getEdgeLabel(label);
        if (edgeLabel == null) {
            management.makeEdgeLabel(label);
            LOG.info("Created edge label {} ", (Object)label);
        }
    }

    private AtlasPropertyKey createPropertyKey(AtlasGraphManagement management, String propertyName, Class propertyClass, AtlasCardinality cardinality) {
        AtlasPropertyKey propertyKey = management.getPropertyKey(propertyName);
        if (propertyKey == null) {
            propertyKey = management.makePropertyKey(propertyName, propertyClass, cardinality);
        }
        return propertyKey;
    }

    private void createVertexIndex(AtlasGraphManagement management, String propertyName, UniqueKind uniqueKind, Class propertyClass, AtlasCardinality cardinality, boolean createCompositeIndex, boolean createCompositeIndexWithTypeAndSuperTypes) {
        if (propertyName != null) {
            AtlasPropertyKey propertyKey = management.getPropertyKey(propertyName);
            if (propertyKey == null) {
                propertyKey = management.makePropertyKey(propertyName, propertyClass, cardinality);
                if (this.isIndexApplicable(propertyClass, cardinality)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Creating backing index for vertex property {} of type {} ", (Object)propertyName, (Object)propertyClass.getName());
                    }
                    management.addMixedIndex("vertex_index", propertyKey);
                    LOG.info("Created backing index for vertex property {} of type {} ", (Object)propertyName, (Object)propertyClass.getName());
                }
            }
            if (propertyKey != null) {
                if (createCompositeIndex || uniqueKind == UniqueKind.GLOBAL_UNIQUE || uniqueKind == UniqueKind.PER_TYPE_UNIQUE) {
                    this.createVertexCompositeIndex(management, propertyClass, propertyKey, uniqueKind == UniqueKind.GLOBAL_UNIQUE);
                }
                if (createCompositeIndexWithTypeAndSuperTypes) {
                    this.createVertexCompositeIndexWithTypeName(management, propertyClass, propertyKey, uniqueKind == UniqueKind.PER_TYPE_UNIQUE);
                    this.createVertexCompositeIndexWithSuperTypeName(management, propertyClass, propertyKey);
                }
            } else {
                LOG.warn("Index not created for {}: propertyKey is null", (Object)propertyName);
            }
        }
    }

    private void createVertexCentricIndex(AtlasGraphManagement management, String edgeLabel, AtlasEdgeDirection edgeDirection, String propertyName, Class propertyClass, AtlasCardinality cardinality) {
        String indexName;
        AtlasPropertyKey propertyKey = management.getPropertyKey(propertyName);
        if (propertyKey == null) {
            propertyKey = management.makePropertyKey(propertyName, propertyClass, cardinality);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating vertex-centric index for edge label: {} direction: {} for property: {} of type: {} ", new Object[]{edgeLabel, edgeDirection.name(), propertyName, propertyClass.getName()});
        }
        if (!management.edgeIndexExist(edgeLabel, indexName = edgeLabel + propertyKey.getName())) {
            management.createEdgeIndex(edgeLabel, indexName, edgeDirection, Collections.singletonList(propertyKey));
            LOG.info("Created vertex-centric index for edge label: {} direction: {} for property: {} of type: {}", new Object[]{edgeLabel, edgeDirection.name(), propertyName, propertyClass.getName()});
        }
    }

    private void createVertexCentricIndex(AtlasGraphManagement management, String edgeLabel, AtlasEdgeDirection edgeDirection, List<String> propertyNames) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating vertex-centric index for edge label: {} direction: {} for properties: {}", new Object[]{edgeLabel, edgeDirection.name(), propertyNames});
        }
        String indexName = edgeLabel;
        ArrayList<AtlasPropertyKey> propertyKeys = new ArrayList<AtlasPropertyKey>();
        for (String propertyName : propertyNames) {
            AtlasPropertyKey propertyKey = management.getPropertyKey(propertyName);
            if (propertyKey == null) continue;
            propertyKeys.add(propertyKey);
            indexName = indexName + propertyKey.getName();
        }
        if (!management.edgeIndexExist(edgeLabel, indexName) && CollectionUtils.isNotEmpty(propertyKeys)) {
            management.createEdgeIndex(edgeLabel, indexName, edgeDirection, propertyKeys);
            LOG.info("Created vertex-centric index for edge label: {} direction: {} for properties: {}", new Object[]{edgeLabel, edgeDirection.name(), propertyNames});
        }
    }

    private void createEdgeIndex(AtlasGraphManagement management, String propertyName, Class propertyClass, AtlasCardinality cardinality, boolean createCompositeIndex) {
        if (propertyName != null) {
            AtlasPropertyKey propertyKey = management.getPropertyKey(propertyName);
            if (propertyKey == null) {
                propertyKey = management.makePropertyKey(propertyName, propertyClass, cardinality);
                if (this.isIndexApplicable(propertyClass, cardinality)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Creating backing index for edge property {} of type {} ", (Object)propertyName, (Object)propertyClass.getName());
                    }
                    management.addMixedIndex("edge_index", propertyKey);
                    LOG.info("Created backing index for edge property {} of type {} ", (Object)propertyName, (Object)propertyClass.getName());
                }
            }
            if (propertyKey != null) {
                if (createCompositeIndex) {
                    this.createEdgeCompositeIndex(management, propertyClass, propertyKey);
                }
            } else {
                LOG.warn("Index not created for {}: propertyKey is null", (Object)propertyName);
            }
        }
    }

    private AtlasPropertyKey createFullTextIndex(AtlasGraphManagement management, String propertyName, Class propertyClass, AtlasCardinality cardinality) {
        AtlasPropertyKey propertyKey = management.getPropertyKey(propertyName);
        if (propertyKey == null) {
            propertyKey = management.makePropertyKey(propertyName, propertyClass, cardinality);
            if (this.isIndexApplicable(propertyClass, cardinality)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Creating backing index for vertex property {} of type {} ", (Object)propertyName, (Object)propertyClass.getName());
                }
                management.addMixedIndex("fulltext_index", propertyKey);
                LOG.info("Created backing index for vertex property {} of type {} ", (Object)propertyName, (Object)propertyClass.getName());
            }
            LOG.info("Created index {}", (Object)"fulltext_index");
        }
        return propertyKey;
    }

    private void createVertexCompositeIndex(AtlasGraphManagement management, Class propertyClass, AtlasPropertyKey propertyKey, boolean enforceUniqueness) {
        AtlasGraphIndex existingIndex;
        String propertyName = propertyKey.getName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating composite index for property {} of type {}; isUnique={} ", new Object[]{propertyName, propertyClass.getName(), enforceUniqueness});
        }
        if ((existingIndex = management.getGraphIndex(propertyName)) == null) {
            management.createVertexCompositeIndex(propertyName, enforceUniqueness, Collections.singletonList(propertyKey));
            LOG.info("Created composite index for property {} of type {}; isUnique={} ", new Object[]{propertyName, propertyClass.getName(), enforceUniqueness});
        }
    }

    private void createEdgeCompositeIndex(AtlasGraphManagement management, Class propertyClass, AtlasPropertyKey propertyKey) {
        AtlasGraphIndex existingIndex;
        String propertyName = propertyKey.getName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating composite index for property {} of type {}", (Object)propertyName, (Object)propertyClass.getName());
        }
        if ((existingIndex = management.getGraphIndex(propertyName)) == null) {
            management.createEdgeCompositeIndex(propertyName, false, Collections.singletonList(propertyKey));
            LOG.info("Created composite index for property {} of type {}", (Object)propertyName, (Object)propertyClass.getName());
        }
    }

    private void createVertexCompositeIndexWithTypeName(AtlasGraphManagement management, Class propertyClass, AtlasPropertyKey propertyKey, boolean isUnique) {
        this.createVertexCompositeIndexWithSystemProperty(management, propertyClass, propertyKey, Constants.ENTITY_TYPE_PROPERTY_KEY, AtlasCardinality.SINGLE, isUnique);
    }

    private void createVertexCompositeIndexWithSuperTypeName(AtlasGraphManagement management, Class propertyClass, AtlasPropertyKey propertyKey) {
        this.createVertexCompositeIndexWithSystemProperty(management, propertyClass, propertyKey, Constants.SUPER_TYPES_PROPERTY_KEY, AtlasCardinality.SET, false);
    }

    private void createVertexCompositeIndexWithSystemProperty(AtlasGraphManagement management, Class propertyClass, AtlasPropertyKey propertyKey, String systemPropertyKey, AtlasCardinality cardinality, boolean isUnique) {
        String indexName;
        AtlasGraphIndex existingIndex;
        AtlasPropertyKey typePropertyKey;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating composite index for property {} of type {} and {}", new Object[]{propertyKey.getName(), propertyClass.getName(), systemPropertyKey});
        }
        if ((typePropertyKey = management.getPropertyKey(systemPropertyKey)) == null) {
            typePropertyKey = management.makePropertyKey(systemPropertyKey, String.class, cardinality);
        }
        if ((existingIndex = management.getGraphIndex(indexName = propertyKey.getName() + systemPropertyKey)) == null) {
            ArrayList<AtlasPropertyKey> keys = new ArrayList<AtlasPropertyKey>(2);
            keys.add(typePropertyKey);
            keys.add(propertyKey);
            management.createVertexCompositeIndex(indexName, isUnique, keys);
            LOG.info("Created composite index for property {} of type {} and {}", new Object[]{propertyKey.getName(), propertyClass.getName(), systemPropertyKey});
        }
    }

    private boolean isIndexApplicable(Class propertyClass, AtlasCardinality cardinality) {
        return !INDEX_EXCLUSION_CLASSES.contains(propertyClass) && !cardinality.isMany();
    }

    private void commit(AtlasGraphManagement management) throws IndexException {
        try {
            management.commit();
            this.recomputeIndexedKeys = true;
        }
        catch (Exception e) {
            LOG.error("Index commit failed", (Throwable)e);
            throw new IndexException("Index commit failed ", e);
        }
    }

    private void rollback(AtlasGraphManagement management) throws IndexException {
        try {
            management.rollback();
            this.recomputeIndexedKeys = true;
        }
        catch (Exception e) {
            LOG.error("Index rollback failed ", (Throwable)e);
            throw new IndexException("Index rollback failed ", e);
        }
    }

    private void attemptRollback(ChangedTypeDefs changedTypeDefs, AtlasGraphManagement management) throws AtlasBaseException {
        if (null != management) {
            try {
                this.rollback(management);
            }
            catch (IndexException e) {
                LOG.error("Index rollback has failed", (Throwable)((Object)e));
                throw new AtlasBaseException(AtlasErrorCode.INDEX_ROLLBACK_FAILED, (Throwable)((Object)e), new String[]{changedTypeDefs.toString()});
            }
        }
    }

    private void updateIndexForTypeDef(AtlasGraphManagement management, AtlasBaseTypeDef typeDef) {
        Preconditions.checkNotNull((Object)typeDef, (Object)"Cannot index on null typedefs");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating indexes for type name={}, definition={}", (Object)typeDef.getName(), typeDef.getClass());
        }
        this.addIndexForType(management, typeDef);
        LOG.info("Index creation for type {} complete", (Object)typeDef.getName());
    }

    private static enum UniqueKind {
        NONE,
        GLOBAL_UNIQUE,
        PER_TYPE_UNIQUE;

    }
}

