/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graph;

import com.google.common.annotations.VisibleForTesting;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasException;
import org.apache.atlas.repository.RepositoryException;
import org.apache.atlas.repository.graph.IAtlasGraphProvider;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.GraphDatabase;
import org.apache.atlas.util.AtlasRepositoryConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AtlasGraphProvider
implements IAtlasGraphProvider {
    private static volatile GraphDatabase<?, ?> graphDb_;
    private static final Logger LOG;
    private static final Integer MAX_RETRY_COUNT;
    private static final Long RETRY_SLEEP_TIME_MS;
    private static final String GRAPH_REPOSITORY_MAX_RETRIES = "atlas.graph.repository.max.retries";
    private static final String GRAPH_REPOSITORY_RETRY_SLEEPTIME = "atlas.graph.repository.retry.sleeptime.ms";
    private static org.apache.commons.configuration.Configuration APPLICATION_PROPERTIES;

    public static <V, E> AtlasGraph<V, E> getGraphInstance() {
        GraphDatabase<?, ?> db = AtlasGraphProvider.getGraphDatabase();
        AtlasGraph graph = db.getGraph();
        return graph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <V, E> GraphDatabase<?, ?> getGraphDatabase() {
        try {
            if (graphDb_ != null) return graphDb_;
            Class<AtlasGraphProvider> clazz = AtlasGraphProvider.class;
            synchronized (AtlasGraphProvider.class) {
                if (graphDb_ != null) return graphDb_;
                Class<? extends GraphDatabase> implClass = AtlasRepositoryConfiguration.getGraphDatabaseImpl();
                graphDb_ = implClass.newInstance();
                // ** MonitorExit[var0] (shouldn't be in output)
                return graphDb_;
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Error initializing graph database", e);
        }
    }

    @VisibleForTesting
    public static void cleanup() {
        AtlasGraphProvider.getGraphDatabase().cleanup();
    }

    @Override
    @Bean(destroyMethod="")
    public AtlasGraph get() throws RepositoryException {
        try {
            return AtlasGraphProvider.getGraphInstance();
        }
        catch (Exception ex) {
            LOG.info("Failed to obtain graph instance, retrying " + MAX_RETRY_COUNT + " times, error: " + ex);
            return this.retry();
        }
    }

    private AtlasGraph retry() throws RepositoryException {
        int retryCounter = 0;
        while (retryCounter < MAX_RETRY_COUNT) {
            try {
                Thread.sleep(RETRY_SLEEP_TIME_MS);
                return AtlasGraphProvider.getGraphInstance();
            }
            catch (Exception ex) {
                LOG.warn("Failed to obtain graph instance on attempt " + ++retryCounter + " of " + MAX_RETRY_COUNT, (Throwable)ex);
                if (retryCounter < MAX_RETRY_COUNT) continue;
                LOG.info("Max retries exceeded.");
                break;
            }
        }
        throw new RepositoryException("Max retries exceeded. Failed to obtain graph instance after " + MAX_RETRY_COUNT + " retries");
    }

    private static Integer getMaxRetryCount() {
        AtlasGraphProvider.initApplicationProperties();
        return APPLICATION_PROPERTIES == null ? 3 : APPLICATION_PROPERTIES.getInt(GRAPH_REPOSITORY_MAX_RETRIES, 3);
    }

    private static Long getRetrySleepTime() {
        AtlasGraphProvider.initApplicationProperties();
        return APPLICATION_PROPERTIES == null ? 30000L : APPLICATION_PROPERTIES.getLong(GRAPH_REPOSITORY_RETRY_SLEEPTIME, 30000L);
    }

    private static void initApplicationProperties() {
        if (APPLICATION_PROPERTIES == null) {
            try {
                APPLICATION_PROPERTIES = ApplicationProperties.get();
            }
            catch (AtlasException atlasException) {
                // empty catch block
            }
        }
    }

    static {
        LOG = LoggerFactory.getLogger(AtlasGraphProvider.class);
        MAX_RETRY_COUNT = AtlasGraphProvider.getMaxRetryCount();
        RETRY_SLEEP_TIME_MS = AtlasGraphProvider.getRetrySleepTime();
        APPLICATION_PROPERTIES = null;
    }
}

