/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.converters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.typedef.AtlasClassificationDef;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.model.typedef.AtlasEnumDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.model.typedef.AtlasTypeDefHeader;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.repository.store.graph.v2.AtlasStructDefStoreV2;
import org.apache.atlas.type.AtlasClassificationType;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasEnumType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.type.AtlasTypeUtil;
import org.apache.atlas.v1.model.typedef.AttributeDefinition;
import org.apache.atlas.v1.model.typedef.ClassTypeDefinition;
import org.apache.atlas.v1.model.typedef.EnumTypeDefinition;
import org.apache.atlas.v1.model.typedef.Multiplicity;
import org.apache.atlas.v1.model.typedef.StructTypeDefinition;
import org.apache.atlas.v1.model.typedef.TraitTypeDefinition;
import org.apache.atlas.v1.model.typedef.TypesDef;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TypeConverterUtil {
    private static final Logger LOG = LoggerFactory.getLogger(TypeConverterUtil.class);

    private TypeConverterUtil() {
    }

    public static TypesDef toTypesDef(AtlasType type, AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
        TypesDef ret = type instanceof AtlasEnumType ? TypeConverterUtil.enumToTypesDef((AtlasEnumType)type) : (type instanceof AtlasEntityType ? TypeConverterUtil.entityToTypesDef((AtlasEntityType)type, typeRegistry) : (type instanceof AtlasClassificationType ? TypeConverterUtil.classificationToTypesDef((AtlasClassificationType)type, typeRegistry) : (type instanceof AtlasStructType ? TypeConverterUtil.structToTypesDef((AtlasStructType)type, typeRegistry) : new TypesDef())));
        return ret;
    }

    private static TypesDef enumToTypesDef(AtlasEnumType enumType) {
        AtlasEnumDef enumDef = enumType.getEnumDef();
        String enumName = enumDef.getName();
        String enumDesc = enumDef.getDescription();
        String enumVersion = enumDef.getTypeVersion();
        List<EnumTypeDefinition.EnumValue> enumValues = TypeConverterUtil.getEnumValues(enumDef.getElementDefs());
        EnumTypeDefinition enumTypeDef = new EnumTypeDefinition(enumName, enumDesc, enumVersion, enumValues);
        TypesDef ret = new TypesDef(Arrays.asList(enumTypeDef), null, null, null);
        return ret;
    }

    private static TypesDef structToTypesDef(AtlasStructType structType, AtlasTypeRegistry registry) {
        String typeName = structType.getStructDef().getName();
        String typeDesc = structType.getStructDef().getDescription();
        String typeVersion = structType.getStructDef().getTypeVersion();
        List<AttributeDefinition> attributes = TypeConverterUtil.getAttributes(structType, registry);
        StructTypeDefinition structTypeDef = new StructTypeDefinition(typeName, typeDesc, typeVersion, attributes);
        TypesDef ret = new TypesDef(null, Arrays.asList(structTypeDef), null, null);
        return ret;
    }

    private static TypesDef entityToTypesDef(AtlasEntityType entityType, AtlasTypeRegistry registry) {
        String typeName = entityType.getEntityDef().getName();
        String typeDesc = entityType.getEntityDef().getDescription();
        String typeVersion = entityType.getEntityDef().getTypeVersion();
        Set superTypes = entityType.getEntityDef().getSuperTypes();
        List<AttributeDefinition> attributes = TypeConverterUtil.getAttributes((AtlasStructType)entityType, registry);
        ClassTypeDefinition classTypeDef = new ClassTypeDefinition(typeName, typeDesc, typeVersion, attributes, superTypes);
        TypesDef ret = new TypesDef(null, null, null, Arrays.asList(classTypeDef));
        return ret;
    }

    private static TypesDef classificationToTypesDef(AtlasClassificationType classificationType, AtlasTypeRegistry registry) {
        String typeName = classificationType.getClassificationDef().getName();
        String typeDesc = classificationType.getClassificationDef().getDescription();
        String typeVersion = classificationType.getClassificationDef().getTypeVersion();
        HashSet superTypes = new HashSet(classificationType.getClassificationDef().getSuperTypes());
        List<AttributeDefinition> attributes = TypeConverterUtil.getAttributes((AtlasStructType)classificationType, registry);
        TraitTypeDefinition traitTypeDef = new TraitTypeDefinition(typeName, typeDesc, typeVersion, attributes, superTypes);
        TypesDef ret = new TypesDef(null, null, Arrays.asList(traitTypeDef), null);
        return ret;
    }

    public static AtlasTypesDef toAtlasTypesDef(String typeDefinition, AtlasTypeRegistry registry) throws AtlasBaseException {
        AtlasTypesDef ret = new AtlasTypesDef();
        try {
            if (StringUtils.isEmpty((String)typeDefinition)) {
                throw new AtlasBaseException(AtlasErrorCode.INVALID_TYPE_DEFINITION, new String[]{typeDefinition});
            }
            TypesDef typesDef = (TypesDef)AtlasType.fromV1Json((String)typeDefinition, TypesDef.class);
            if (CollectionUtils.isNotEmpty((Collection)typesDef.getEnumTypes())) {
                List<AtlasEnumDef> enumDefs = TypeConverterUtil.toAtlasEnumDefs(typesDef.getEnumTypes());
                ret.setEnumDefs(enumDefs);
            }
            if (CollectionUtils.isNotEmpty((Collection)typesDef.getStructTypes())) {
                List<AtlasStructDef> structDefs = TypeConverterUtil.toAtlasStructDefs(typesDef.getStructTypes());
                ret.setStructDefs(structDefs);
            }
            if (CollectionUtils.isNotEmpty((Collection)typesDef.getClassTypes())) {
                List<AtlasEntityDef> entityDefs = TypeConverterUtil.toAtlasEntityDefs(typesDef.getClassTypes(), registry);
                ret.setEntityDefs(entityDefs);
            }
            if (CollectionUtils.isNotEmpty((Collection)typesDef.getTraitTypes())) {
                List<AtlasClassificationDef> classificationDefs = TypeConverterUtil.toAtlasClassificationDefs(typesDef.getTraitTypes());
                ret.setClassificationDefs(classificationDefs);
            }
        }
        catch (Exception e) {
            LOG.error("Invalid type definition = {}", (Object)typeDefinition, (Object)e);
            throw new AtlasBaseException(AtlasErrorCode.INVALID_TYPE_DEFINITION, new String[]{typeDefinition});
        }
        return ret;
    }

    public static List<String> getTypeNames(List<AtlasTypeDefHeader> atlasTypesDefs) {
        ArrayList<String> ret = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(atlasTypesDefs)) {
            for (AtlasTypeDefHeader atlasTypesDef : atlasTypesDefs) {
                ret.add(atlasTypesDef.getName());
            }
        }
        return ret;
    }

    public static List<String> getTypeNames(AtlasTypesDef typesDef) {
        List atlasTypesDefs = AtlasTypeUtil.toTypeDefHeader((AtlasTypesDef)typesDef);
        return TypeConverterUtil.getTypeNames(atlasTypesDefs);
    }

    private static List<AtlasEnumDef> toAtlasEnumDefs(List<EnumTypeDefinition> enumTypeDefinitions) {
        ArrayList<AtlasEnumDef> ret = new ArrayList<AtlasEnumDef>();
        for (EnumTypeDefinition enumType : enumTypeDefinitions) {
            AtlasEnumDef enumDef = new AtlasEnumDef();
            enumDef.setName(enumType.getName());
            enumDef.setDescription(enumType.getDescription());
            enumDef.setTypeVersion(enumType.getVersion());
            enumDef.setElementDefs(TypeConverterUtil.getAtlasEnumElementDefs(enumType.getEnumValues()));
            ret.add(enumDef);
        }
        return ret;
    }

    private static List<AtlasStructDef> toAtlasStructDefs(List<StructTypeDefinition> structTypeDefinitions) {
        ArrayList<AtlasStructDef> ret = new ArrayList<AtlasStructDef>();
        for (StructTypeDefinition structType : structTypeDefinitions) {
            ArrayList<AtlasStructDef.AtlasAttributeDef> attrDefs = new ArrayList<AtlasStructDef.AtlasAttributeDef>();
            if (CollectionUtils.isNotEmpty((Collection)structType.getAttributeDefinitions())) {
                for (AttributeDefinition attrDefinition : structType.getAttributeDefinitions()) {
                    attrDefs.add(TypeConverterUtil.toAtlasAttributeDef(attrDefinition));
                }
            }
            AtlasStructDef structDef = new AtlasStructDef(structType.getTypeName(), structType.getTypeDescription(), structType.getTypeVersion(), attrDefs);
            ret.add(structDef);
        }
        return ret;
    }

    private static List<AtlasClassificationDef> toAtlasClassificationDefs(List<TraitTypeDefinition> traitTypeDefinitions) {
        ArrayList<AtlasClassificationDef> ret = new ArrayList<AtlasClassificationDef>();
        for (TraitTypeDefinition traitType : traitTypeDefinitions) {
            ArrayList<AtlasStructDef.AtlasAttributeDef> attrDefs = new ArrayList<AtlasStructDef.AtlasAttributeDef>();
            if (CollectionUtils.isNotEmpty((Collection)traitType.getAttributeDefinitions())) {
                for (AttributeDefinition attrDefinition : traitType.getAttributeDefinitions()) {
                    attrDefs.add(TypeConverterUtil.toAtlasAttributeDef(attrDefinition));
                }
            }
            AtlasClassificationDef classifDef = new AtlasClassificationDef(traitType.getTypeName(), traitType.getTypeDescription(), traitType.getTypeVersion(), attrDefs, traitType.getSuperTypes());
            ret.add(classifDef);
        }
        return ret;
    }

    private static List<AtlasEntityDef> toAtlasEntityDefs(List<ClassTypeDefinition> classTypeDefinitions, AtlasTypeRegistry registry) {
        ArrayList<AtlasEntityDef> ret = new ArrayList<AtlasEntityDef>();
        for (ClassTypeDefinition classType : classTypeDefinitions) {
            ArrayList<AtlasStructDef.AtlasAttributeDef> attrDefs = new ArrayList<AtlasStructDef.AtlasAttributeDef>();
            if (CollectionUtils.isNotEmpty((Collection)classType.getAttributeDefinitions())) {
                for (AttributeDefinition oldAttr : classType.getAttributeDefinitions()) {
                    AtlasStructDef.AtlasAttributeDef newAttr = TypeConverterUtil.toAtlasAttributeDef(oldAttr);
                    attrDefs.add(newAttr);
                }
            }
            AtlasEntityDef entityDef = new AtlasEntityDef(classType.getTypeName(), classType.getTypeDescription(), classType.getTypeVersion(), attrDefs, classType.getSuperTypes());
            ret.add(entityDef);
        }
        return ret;
    }

    private static String getArrayTypeName(String attrType) {
        Set typeNames;
        String ret = null;
        if (AtlasTypeUtil.isArrayType((String)attrType) && (typeNames = AtlasTypeUtil.getReferencedTypeNames((String)attrType)).size() > 0) {
            ret = (String)typeNames.iterator().next();
        }
        return ret;
    }

    private static List<AtlasEnumDef.AtlasEnumElementDef> getAtlasEnumElementDefs(List<EnumTypeDefinition.EnumValue> enums) {
        ArrayList<AtlasEnumDef.AtlasEnumElementDef> ret = new ArrayList<AtlasEnumDef.AtlasEnumElementDef>();
        for (EnumTypeDefinition.EnumValue enumElem : enums) {
            ret.add(new AtlasEnumDef.AtlasEnumElementDef(enumElem.getValue(), null, Integer.valueOf(enumElem.getOrdinal())));
        }
        return ret;
    }

    private static List<EnumTypeDefinition.EnumValue> getEnumValues(List<AtlasEnumDef.AtlasEnumElementDef> enumDefs) {
        ArrayList<EnumTypeDefinition.EnumValue> ret = new ArrayList<EnumTypeDefinition.EnumValue>();
        if (CollectionUtils.isNotEmpty(enumDefs)) {
            for (AtlasEnumDef.AtlasEnumElementDef enumDef : enumDefs) {
                if (enumDef == null) continue;
                ret.add(new EnumTypeDefinition.EnumValue(enumDef.getValue(), enumDef.getOrdinal().intValue()));
            }
        }
        return ret;
    }

    public static AtlasStructDef.AtlasAttributeDef toAtlasAttributeDef(final AttributeDefinition attrDefinition) {
        AtlasStructDef.AtlasAttributeDef ret = new AtlasStructDef.AtlasAttributeDef(attrDefinition.getName(), attrDefinition.getDataTypeName());
        ret.setIsIndexable(attrDefinition.getIsIndexable());
        ret.setIsUnique(attrDefinition.getIsUnique());
        if (attrDefinition.getIsComposite()) {
            ret.addConstraint(new AtlasStructDef.AtlasConstraintDef("ownedRef"));
        }
        if (StringUtils.isNotBlank((String)attrDefinition.getReverseAttributeName())) {
            ret.addConstraint(new AtlasStructDef.AtlasConstraintDef("inverseRef", (Map)new HashMap<String, Object>(){
                {
                    this.put("attribute", attrDefinition.getReverseAttributeName());
                }
            }));
        }
        Multiplicity multiplicity = attrDefinition.getMultiplicity();
        int minCount = multiplicity.getLower();
        int maxCount = multiplicity.getUpper();
        boolean isUnique = multiplicity.getIsUnique();
        if (minCount == 0) {
            ret.setIsOptional(true);
            ret.setValuesMinCount(0);
        } else {
            ret.setIsOptional(false);
            ret.setValuesMinCount(minCount);
        }
        if (maxCount < 2) {
            ret.setCardinality(AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE);
            ret.setValuesMaxCount(1);
        } else {
            if (!isUnique) {
                ret.setCardinality(AtlasStructDef.AtlasAttributeDef.Cardinality.LIST);
            } else {
                ret.setCardinality(AtlasStructDef.AtlasAttributeDef.Cardinality.SET);
            }
            ret.setValuesMaxCount(maxCount);
        }
        return ret;
    }

    private static List<AttributeDefinition> getAttributes(AtlasStructType structType, AtlasTypeRegistry registry) {
        ArrayList<AttributeDefinition> ret = new ArrayList<AttributeDefinition>();
        List attrDefs = structType.getStructDef().getAttributeDefs();
        if (CollectionUtils.isNotEmpty((Collection)attrDefs)) {
            for (AtlasStructDef.AtlasAttributeDef attrDef : attrDefs) {
                AtlasStructType.AtlasAttribute attribute = structType.getAttribute(attrDef.getName());
                AttributeDefinition oldAttrDef = AtlasStructDefStoreV2.toAttributeDefinition(attribute);
                ret.add(new AttributeDefinition(oldAttrDef.getName(), oldAttrDef.getDataTypeName(), new Multiplicity(oldAttrDef.getMultiplicity()), oldAttrDef.getIsComposite(), oldAttrDef.getIsUnique(), oldAttrDef.getIsIndexable(), oldAttrDef.getReverseAttributeName(), oldAttrDef.getOptions()));
            }
        }
        return ret;
    }
}

