/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.converters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.AtlasException;
import org.apache.atlas.CreateUpdateEntitiesResult;
import org.apache.atlas.EntityAuditEvent;
import org.apache.atlas.RequestContext;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.audit.EntityAuditEventV2;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.EntityMutationResponse;
import org.apache.atlas.model.instance.EntityMutations;
import org.apache.atlas.model.instance.GuidMapping;
import org.apache.atlas.model.legacy.EntityResult;
import org.apache.atlas.repository.converters.AtlasEntityFormatConverter;
import org.apache.atlas.repository.converters.AtlasFormatConverter;
import org.apache.atlas.repository.converters.AtlasFormatConverters;
import org.apache.atlas.repository.store.graph.v2.EntityGraphRetriever;
import org.apache.atlas.type.AtlasClassificationType;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.v1.model.instance.Referenceable;
import org.apache.atlas.v1.model.instance.Struct;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Singleton
@Component
public class AtlasInstanceConverter {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasInstanceConverter.class);
    private final AtlasTypeRegistry typeRegistry;
    private final AtlasFormatConverters instanceFormatters;
    private final EntityGraphRetriever entityGraphRetriever;

    @Inject
    public AtlasInstanceConverter(AtlasTypeRegistry typeRegistry, AtlasFormatConverters instanceFormatters) {
        this.typeRegistry = typeRegistry;
        this.instanceFormatters = instanceFormatters;
        this.entityGraphRetriever = new EntityGraphRetriever(typeRegistry);
    }

    public Referenceable[] getReferenceables(Collection<AtlasEntity> entities) throws AtlasBaseException {
        Referenceable[] ret = new Referenceable[entities.size()];
        AtlasFormatConverter.ConverterContext ctx = new AtlasFormatConverter.ConverterContext();
        Iterator<AtlasEntity> i = entities.iterator();
        while (i.hasNext()) {
            ctx.addEntity(i.next());
        }
        Iterator<AtlasEntity> entityIterator = entities.iterator();
        for (int i2 = 0; i2 < entities.size(); ++i2) {
            ret[i2] = this.getReferenceable(entityIterator.next(), ctx);
        }
        return ret;
    }

    public Referenceable getReferenceable(AtlasEntity entity) throws AtlasBaseException {
        return this.getReferenceable(entity, new AtlasFormatConverter.ConverterContext());
    }

    public Referenceable getReferenceable(String guid) throws AtlasBaseException {
        AtlasEntity.AtlasEntityWithExtInfo entity = this.getAndCacheEntityExtInfo(guid);
        return this.getReferenceable(entity);
    }

    public Referenceable getReferenceable(AtlasEntity.AtlasEntityWithExtInfo entity) throws AtlasBaseException {
        AtlasFormatConverter.ConverterContext ctx = new AtlasFormatConverter.ConverterContext();
        ctx.addEntity(entity.getEntity());
        for (Map.Entry entry : entity.getReferredEntities().entrySet()) {
            ctx.addEntity((AtlasEntity)entry.getValue());
        }
        return this.getReferenceable(entity.getEntity(), ctx);
    }

    public Referenceable getReferenceable(AtlasEntity entity, AtlasFormatConverter.ConverterContext ctx) throws AtlasBaseException {
        AtlasFormatConverter converter = this.instanceFormatters.getConverter(TypeCategory.ENTITY);
        AtlasType entityType = this.typeRegistry.getType(entity.getTypeName());
        Referenceable ref = (Referenceable)converter.fromV2ToV1(entity, entityType, ctx);
        return ref;
    }

    public Struct getTrait(AtlasClassification classification) throws AtlasBaseException {
        AtlasFormatConverter converter = this.instanceFormatters.getConverter(TypeCategory.CLASSIFICATION);
        AtlasType classificationType = this.typeRegistry.getType(classification.getTypeName());
        Struct trait = (Struct)converter.fromV2ToV1(classification, classificationType, new AtlasFormatConverter.ConverterContext());
        return trait;
    }

    public AtlasClassification toAtlasClassification(Struct classification) throws AtlasBaseException {
        AtlasFormatConverter converter = this.instanceFormatters.getConverter(TypeCategory.CLASSIFICATION);
        AtlasClassificationType classificationType = this.typeRegistry.getClassificationTypeByName(classification.getTypeName());
        if (classificationType == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_INVALID, new String[]{TypeCategory.CLASSIFICATION.name(), classification.getTypeName()});
        }
        AtlasClassification ret = (AtlasClassification)converter.fromV1ToV2(classification, (AtlasType)classificationType, new AtlasFormatConverter.ConverterContext());
        return ret;
    }

    public AtlasEntity.AtlasEntitiesWithExtInfo toAtlasEntity(Referenceable referenceable) throws AtlasBaseException {
        AtlasEntityFormatConverter converter = (AtlasEntityFormatConverter)this.instanceFormatters.getConverter(TypeCategory.ENTITY);
        AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(referenceable.getTypeName());
        if (entityType == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_INVALID, new String[]{TypeCategory.ENTITY.name(), referenceable.getTypeName()});
        }
        AtlasFormatConverter.ConverterContext ctx = new AtlasFormatConverter.ConverterContext();
        AtlasEntity entity = converter.fromV1ToV2(referenceable, (AtlasType)entityType, ctx);
        ctx.addEntity(entity);
        return ctx.getEntities();
    }

    public AtlasEntity.AtlasEntitiesWithExtInfo toAtlasEntities(List<Referenceable> referenceables) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> toAtlasEntities({})", referenceables);
        }
        AtlasFormatConverter.ConverterContext context = new AtlasFormatConverter.ConverterContext();
        for (Referenceable referenceable : referenceables) {
            AtlasEntity entity = this.fromV1toV2Entity(referenceable, context);
            context.addEntity(entity);
        }
        AtlasEntity.AtlasEntitiesWithExtInfo ret = context.getEntities();
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== toAtlasEntities({}): ret=", referenceables, (Object)ret);
        }
        return ret;
    }

    public AtlasEntity.AtlasEntitiesWithExtInfo toAtlasEntities(String[] jsonEntities) throws AtlasBaseException, AtlasException {
        Referenceable[] referenceables = new Referenceable[jsonEntities.length];
        for (int i = 0; i < jsonEntities.length; ++i) {
            referenceables[i] = (Referenceable)AtlasType.fromV1Json((String)jsonEntities[i], Referenceable.class);
        }
        AtlasEntityFormatConverter converter = (AtlasEntityFormatConverter)this.instanceFormatters.getConverter(TypeCategory.ENTITY);
        AtlasFormatConverter.ConverterContext context = new AtlasFormatConverter.ConverterContext();
        for (Referenceable referenceable : referenceables) {
            AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(referenceable.getTypeName());
            if (entityType == null) {
                throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_INVALID, new String[]{TypeCategory.ENTITY.name(), referenceable.getTypeName()});
            }
            AtlasEntity entity = converter.fromV1ToV2(referenceable, (AtlasType)entityType, context);
            context.addEntity(entity);
        }
        AtlasEntity.AtlasEntitiesWithExtInfo ret = context.getEntities();
        return ret;
    }

    private AtlasEntity fromV1toV2Entity(Referenceable referenceable, AtlasFormatConverter.ConverterContext context) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> fromV1toV2Entity({})", (Object)referenceable);
        }
        AtlasEntityFormatConverter converter = (AtlasEntityFormatConverter)this.instanceFormatters.getConverter(TypeCategory.ENTITY);
        AtlasEntity entity = converter.fromV1ToV2(referenceable, this.typeRegistry.getType(referenceable.getTypeName()), context);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== fromV1toV2Entity({}): {}", (Object)referenceable, (Object)entity);
        }
        return entity;
    }

    public CreateUpdateEntitiesResult toCreateUpdateEntitiesResult(EntityMutationResponse reponse) {
        CreateUpdateEntitiesResult ret = null;
        if (reponse != null) {
            Map mutatedEntities = reponse.getMutatedEntities();
            Map guidAssignments = reponse.getGuidAssignments();
            ret = new CreateUpdateEntitiesResult();
            if (MapUtils.isNotEmpty((Map)guidAssignments)) {
                ret.setGuidMapping(new GuidMapping(guidAssignments));
            }
            if (MapUtils.isNotEmpty((Map)mutatedEntities)) {
                EntityResult entityResult = new EntityResult();
                for (Map.Entry e : mutatedEntities.entrySet()) {
                    switch ((EntityMutations.EntityOperation)e.getKey()) {
                        case CREATE: {
                            List createdEntities = (List)mutatedEntities.get(EntityMutations.EntityOperation.CREATE);
                            if (!CollectionUtils.isNotEmpty((Collection)createdEntities)) break;
                            Collections.reverse(createdEntities);
                            entityResult.set("created", this.getGuids(createdEntities));
                            break;
                        }
                        case UPDATE: {
                            List updatedEntities = (List)mutatedEntities.get(EntityMutations.EntityOperation.UPDATE);
                            if (!CollectionUtils.isNotEmpty((Collection)updatedEntities)) break;
                            Collections.reverse(updatedEntities);
                            entityResult.set("updated", this.getGuids(updatedEntities));
                            break;
                        }
                        case PARTIAL_UPDATE: {
                            List partialUpdatedEntities = (List)mutatedEntities.get(EntityMutations.EntityOperation.PARTIAL_UPDATE);
                            if (!CollectionUtils.isNotEmpty((Collection)partialUpdatedEntities)) break;
                            Collections.reverse(partialUpdatedEntities);
                            entityResult.set("updated", this.getGuids(partialUpdatedEntities));
                            break;
                        }
                        case DELETE: {
                            List deletedEntities = (List)mutatedEntities.get(EntityMutations.EntityOperation.DELETE);
                            if (!CollectionUtils.isNotEmpty((Collection)deletedEntities)) break;
                            Collections.reverse(deletedEntities);
                            entityResult.set("deleted", this.getGuids(deletedEntities));
                        }
                    }
                }
                ret.setEntityResult(entityResult);
            }
        }
        return ret;
    }

    public List<String> getGuids(List<AtlasEntityHeader> entities) {
        ArrayList<String> ret = null;
        if (CollectionUtils.isNotEmpty(entities)) {
            ret = new ArrayList<String>();
            for (AtlasEntityHeader entity : entities) {
                ret.add(entity.getGuid());
            }
        }
        return ret;
    }

    public AtlasEntity getAndCacheEntity(String guid) throws AtlasBaseException {
        RequestContext context = RequestContext.get();
        AtlasEntity entity = context.getEntity(guid);
        if (entity == null && (entity = this.entityGraphRetriever.toAtlasEntity(guid)) != null) {
            context.cache(entity);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cache miss -> GUID = {}", (Object)guid);
            }
        }
        return entity;
    }

    public AtlasEntity.AtlasEntityWithExtInfo getAndCacheEntityExtInfo(String guid) throws AtlasBaseException {
        RequestContext context = RequestContext.get();
        AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = context.getEntityWithExtInfo(guid);
        if (entityWithExtInfo == null && (entityWithExtInfo = this.entityGraphRetriever.toAtlasEntityWithExtInfo(guid)) != null) {
            context.cache(entityWithExtInfo);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cache miss -> GUID = {}", (Object)guid);
            }
        }
        return entityWithExtInfo;
    }

    public EntityAuditEvent toV1AuditEvent(EntityAuditEventV2 v2Event) throws AtlasBaseException {
        EntityAuditEvent ret = new EntityAuditEvent();
        ret.setEntityId(v2Event.getEntityId());
        ret.setTimestamp(v2Event.getTimestamp());
        ret.setUser(v2Event.getUser());
        ret.setDetails(v2Event.getDetails());
        ret.setEventKey(v2Event.getEventKey());
        ret.setAction(this.getV1AuditAction(v2Event.getAction()));
        ret.setEntityDefinition(this.getReferenceable(v2Event.getEntityId()));
        return ret;
    }

    public EntityAuditEventV2 toV2AuditEvent(EntityAuditEvent v1Event) throws AtlasBaseException {
        EntityAuditEventV2 ret = new EntityAuditEventV2();
        ret.setEntityId(v1Event.getEntityId());
        ret.setTimestamp(v1Event.getTimestamp());
        ret.setUser(v1Event.getUser());
        ret.setDetails(v1Event.getDetails());
        ret.setEventKey(v1Event.getEventKey());
        ret.setAction(this.getV2AuditAction(v1Event.getAction()));
        AtlasEntity.AtlasEntitiesWithExtInfo entitiesWithExtInfo = this.toAtlasEntity(v1Event.getEntityDefinition());
        if (entitiesWithExtInfo != null && CollectionUtils.isNotEmpty((Collection)entitiesWithExtInfo.getEntities())) {
            AtlasEntity entity = (AtlasEntity)entitiesWithExtInfo.getEntities().get(0);
            ret.setEntity(entity);
        }
        return ret;
    }

    private EntityAuditEvent.EntityAuditAction getV1AuditAction(EntityAuditEventV2.EntityAuditActionV2 v2AuditAction) {
        switch (v2AuditAction) {
            case ENTITY_CREATE: {
                return EntityAuditEvent.EntityAuditAction.ENTITY_CREATE;
            }
            case ENTITY_UPDATE: {
                return EntityAuditEvent.EntityAuditAction.ENTITY_UPDATE;
            }
            case ENTITY_DELETE: {
                return EntityAuditEvent.EntityAuditAction.ENTITY_DELETE;
            }
            case ENTITY_IMPORT_CREATE: {
                return EntityAuditEvent.EntityAuditAction.ENTITY_IMPORT_CREATE;
            }
            case ENTITY_IMPORT_UPDATE: {
                return EntityAuditEvent.EntityAuditAction.ENTITY_IMPORT_UPDATE;
            }
            case ENTITY_IMPORT_DELETE: {
                return EntityAuditEvent.EntityAuditAction.ENTITY_IMPORT_DELETE;
            }
            case CLASSIFICATION_ADD: {
                return EntityAuditEvent.EntityAuditAction.TAG_ADD;
            }
            case CLASSIFICATION_DELETE: {
                return EntityAuditEvent.EntityAuditAction.TAG_DELETE;
            }
            case CLASSIFICATION_UPDATE: {
                return EntityAuditEvent.EntityAuditAction.TAG_UPDATE;
            }
            case PROPAGATED_CLASSIFICATION_ADD: {
                return EntityAuditEvent.EntityAuditAction.PROPAGATED_TAG_ADD;
            }
            case PROPAGATED_CLASSIFICATION_DELETE: {
                return EntityAuditEvent.EntityAuditAction.PROPAGATED_TAG_DELETE;
            }
            case PROPAGATED_CLASSIFICATION_UPDATE: {
                return EntityAuditEvent.EntityAuditAction.PROPAGATED_TAG_UPDATE;
            }
        }
        return null;
    }

    private EntityAuditEventV2.EntityAuditActionV2 getV2AuditAction(EntityAuditEvent.EntityAuditAction v1AuditAction) {
        switch (v1AuditAction) {
            case ENTITY_CREATE: {
                return EntityAuditEventV2.EntityAuditActionV2.ENTITY_CREATE;
            }
            case ENTITY_UPDATE: {
                return EntityAuditEventV2.EntityAuditActionV2.ENTITY_UPDATE;
            }
            case ENTITY_DELETE: {
                return EntityAuditEventV2.EntityAuditActionV2.ENTITY_DELETE;
            }
            case ENTITY_IMPORT_CREATE: {
                return EntityAuditEventV2.EntityAuditActionV2.ENTITY_IMPORT_CREATE;
            }
            case ENTITY_IMPORT_UPDATE: {
                return EntityAuditEventV2.EntityAuditActionV2.ENTITY_IMPORT_UPDATE;
            }
            case ENTITY_IMPORT_DELETE: {
                return EntityAuditEventV2.EntityAuditActionV2.ENTITY_IMPORT_DELETE;
            }
            case TAG_ADD: {
                return EntityAuditEventV2.EntityAuditActionV2.CLASSIFICATION_ADD;
            }
            case TAG_DELETE: {
                return EntityAuditEventV2.EntityAuditActionV2.CLASSIFICATION_DELETE;
            }
            case TAG_UPDATE: {
                return EntityAuditEventV2.EntityAuditActionV2.CLASSIFICATION_UPDATE;
            }
            case PROPAGATED_TAG_ADD: {
                return EntityAuditEventV2.EntityAuditActionV2.PROPAGATED_CLASSIFICATION_ADD;
            }
            case PROPAGATED_TAG_DELETE: {
                return EntityAuditEventV2.EntityAuditActionV2.PROPAGATED_CLASSIFICATION_DELETE;
            }
            case PROPAGATED_TAG_UPDATE: {
                return EntityAuditEventV2.EntityAuditActionV2.PROPAGATED_CLASSIFICATION_UPDATE;
            }
        }
        return null;
    }
}

