/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.converters;

import java.util.Map;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.typedef.AtlasEnumDef;
import org.apache.atlas.repository.converters.AtlasAbstractFormatConverter;
import org.apache.atlas.repository.converters.AtlasFormatConverter;
import org.apache.atlas.repository.converters.AtlasFormatConverters;
import org.apache.atlas.type.AtlasEnumType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.v1.model.typedef.EnumTypeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasEnumFormatConverter
extends AtlasAbstractFormatConverter {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasEnumFormatConverter.class);

    public AtlasEnumFormatConverter(AtlasFormatConverters registry, AtlasTypeRegistry typeRegistry) {
        super(registry, typeRegistry, TypeCategory.ENUM);
    }

    @Override
    public boolean isValidValueV1(Object v1Obj, AtlasType type) {
        boolean ret = false;
        if (v1Obj == null) {
            ret = true;
        } else if (type instanceof AtlasEnumType) {
            AtlasEnumType enumType = (AtlasEnumType)type;
            if (v1Obj instanceof EnumTypeDefinition.EnumValue) {
                String enumValue = ((EnumTypeDefinition.EnumValue)v1Obj).getValue();
                if (enumValue != null) {
                    ret = enumType.getEnumDef().hasElement(enumValue.toString());
                }
            } else if (v1Obj instanceof Map) {
                Object enumValue = ((Map)v1Obj).get("value");
                if (enumValue != null) {
                    ret = enumType.getEnumDef().hasElement(enumValue.toString());
                } else {
                    Object enumOrdinal = ((Map)v1Obj).get("ordinal");
                    if (enumOrdinal != null) {
                        ret = enumType.getEnumElementDef((Number)enumOrdinal) != null;
                    }
                }
            } else if (v1Obj instanceof Number) {
                ret = enumType.getEnumElementDef((Number)v1Obj) != null;
            } else {
                boolean bl = ret = enumType.getEnumElementDef(v1Obj.toString()) != null;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("AtlasEnumFormatConverter.isValidValueV1(type={}, value={}): {}", new Object[]{v1Obj != null ? v1Obj.getClass().getCanonicalName() : null, v1Obj, ret});
        }
        return ret;
    }

    @Override
    public Object fromV1ToV2(Object v1Obj, AtlasType type, AtlasFormatConverter.ConverterContext ctx) throws AtlasBaseException {
        AtlasEnumDef.AtlasEnumElementDef elementDef;
        Map mapValue;
        String ret = null;
        if (v1Obj == null || !(type instanceof AtlasEnumType)) {
            return ret;
        }
        Object v1Value = null;
        if (v1Obj instanceof EnumTypeDefinition.EnumValue) {
            EnumTypeDefinition.EnumValue enumValue = (EnumTypeDefinition.EnumValue)v1Obj;
            v1Value = enumValue.getValue();
            if (v1Value == null) {
                v1Value = enumValue.getOrdinal();
            }
        } else if (v1Obj instanceof Map && (v1Value = (mapValue = (Map)v1Obj).get("value")) == null) {
            v1Value = mapValue.get("ordinal");
        }
        if (v1Value == null) {
            v1Value = v1Obj;
        }
        if ((elementDef = v1Value instanceof Number ? ((AtlasEnumType)type).getEnumElementDef((Number)v1Value) : ((AtlasEnumType)type).getEnumElementDef(v1Value.toString())) != null) {
            ret = elementDef.getValue();
        }
        return ret;
    }

    @Override
    public Object fromV2ToV1(Object v2Obj, AtlasType type, AtlasFormatConverter.ConverterContext ctx) throws AtlasBaseException {
        EnumTypeDefinition.EnumValue ret = null;
        if (v2Obj == null || !(type instanceof AtlasEnumType)) {
            return ret;
        }
        AtlasEnumType enumType = (AtlasEnumType)type;
        AtlasEnumDef.AtlasEnumElementDef elementDef = enumType.getEnumElementDef(v2Obj.toString());
        if (elementDef != null) {
            ret = new EnumTypeDefinition.EnumValue(elementDef.getValue(), elementDef.getOrdinal().intValue());
        }
        return ret;
    }
}

