/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.converters;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.repository.converters.AtlasAbstractFormatConverter;
import org.apache.atlas.repository.converters.AtlasFormatConverter;
import org.apache.atlas.repository.converters.AtlasFormatConverters;
import org.apache.atlas.type.AtlasArrayType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasArrayFormatConverter
extends AtlasAbstractFormatConverter {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasArrayFormatConverter.class);

    public AtlasArrayFormatConverter(AtlasFormatConverters registry, AtlasTypeRegistry typeRegistry) {
        super(registry, typeRegistry, TypeCategory.ARRAY);
    }

    @Override
    public boolean isValidValueV1(Object v1Obj, AtlasType type) {
        boolean ret = false;
        if (v1Obj == null) {
            return true;
        }
        if (type instanceof AtlasArrayType) {
            AtlasArrayType arrType = (AtlasArrayType)type;
            AtlasType elemType = arrType.getElementType();
            AtlasFormatConverter elemConverter = null;
            try {
                elemConverter = this.converterRegistry.getConverter(elemType.getTypeCategory());
            }
            catch (AtlasBaseException excp) {
                LOG.warn("failed to get element converter. type={}", (Object)type.getTypeName(), (Object)excp);
                ret = false;
            }
            if (elemConverter != null) {
                if (v1Obj instanceof Collection) {
                    Object v1Elem;
                    ret = true;
                    Iterator iterator = ((Collection)v1Obj).iterator();
                    while (iterator.hasNext() && (ret = elemConverter.isValidValueV1(v1Elem = iterator.next(), elemType))) {
                    }
                } else {
                    ret = elemConverter.isValidValueV1(v1Obj, elemType);
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("AtlasArrayFormatConverter.isValidValueV1(type={}, value={}): {}", new Object[]{v1Obj != null ? v1Obj.getClass().getCanonicalName() : null, v1Obj, ret});
        }
        return ret;
    }

    @Override
    public Collection fromV1ToV2(Object v1Obj, AtlasType type, AtlasFormatConverter.ConverterContext ctx) throws AtlasBaseException {
        AbstractCollection ret = null;
        if (v1Obj != null) {
            ret = v1Obj instanceof Set ? new LinkedHashSet() : new ArrayList();
            AtlasArrayType arrType = (AtlasArrayType)type;
            AtlasType elemType = arrType.getElementType();
            AtlasFormatConverter elemConverter = this.converterRegistry.getConverter(elemType.getTypeCategory());
            if (v1Obj instanceof Collection) {
                Collection v1List = (Collection)v1Obj;
                for (Object v1Elem : v1List) {
                    Object convertedVal = elemConverter.fromV1ToV2(v1Elem, elemType, ctx);
                    ret.add(convertedVal);
                }
            } else {
                Object convertedVal = elemConverter.fromV1ToV2(v1Obj, elemType, ctx);
                ret.add(convertedVal);
            }
        }
        return ret;
    }

    @Override
    public Collection fromV2ToV1(Object v2Obj, AtlasType type, AtlasFormatConverter.ConverterContext ctx) throws AtlasBaseException {
        AbstractCollection ret = null;
        if (v2Obj != null) {
            if (v2Obj instanceof List) {
                ret = new ArrayList();
            } else if (v2Obj instanceof Set) {
                ret = new LinkedHashSet();
            } else {
                throw new AtlasBaseException(AtlasErrorCode.UNEXPECTED_TYPE, new String[]{"List or Set", v2Obj.getClass().getCanonicalName()});
            }
            AtlasArrayType arrType = (AtlasArrayType)type;
            AtlasType elemType = arrType.getElementType();
            AtlasFormatConverter elemConverter = this.converterRegistry.getConverter(elemType.getTypeCategory());
            Collection v2List = (Collection)v2Obj;
            for (Object v2Elem : v2List) {
                Object convertedVal = elemConverter.fromV2ToV1(v2Elem, elemType, ctx);
                ret.add(convertedVal);
            }
        }
        return ret;
    }
}

