/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.audit;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasException;
import org.apache.atlas.EntityAuditEvent;
import org.apache.atlas.annotation.ConditionalOnAtlasProperty;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.ha.HAConfiguration;
import org.apache.atlas.model.audit.EntityAuditEventV2;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.repository.audit.AbstractStorageBasedAuditRepository;
import org.apache.atlas.repository.audit.EntityAuditListener;
import org.apache.atlas.repository.converters.AtlasInstanceConverter;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.v1.model.instance.Referenceable;
import org.apache.atlas.v1.model.instance.Struct;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.BinaryPrefixComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.util.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Singleton
@Component
@ConditionalOnAtlasProperty(property="atlas.EntityAuditRepository.impl", isDefault=true)
public class HBaseBasedAuditRepository
extends AbstractStorageBasedAuditRepository {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseBasedAuditRepository.class);
    public static final String CONFIG_TABLE_NAME = "atlas.audit.hbase.tablename";
    public static final String DEFAULT_TABLE_NAME = "ATLAS_ENTITY_AUDIT_EVENTS";
    public static final byte[] COLUMN_FAMILY = Bytes.toBytes((String)"dt");
    public static final byte[] COLUMN_ACTION = Bytes.toBytes((String)"a");
    public static final byte[] COLUMN_DETAIL = Bytes.toBytes((String)"d");
    public static final byte[] COLUMN_USER = Bytes.toBytes((String)"u");
    public static final byte[] COLUMN_DEFINITION = Bytes.toBytes((String)"f");
    public static final byte[] COLUMN_TYPE = Bytes.toBytes((String)"t");
    private TableName tableName;
    private Connection connection;
    private final AtlasInstanceConverter instanceConverter;

    @Inject
    public HBaseBasedAuditRepository(AtlasInstanceConverter instanceConverter) {
        this.instanceConverter = instanceConverter;
    }

    @Override
    public void putEventsV1(List<EntityAuditEvent> events) throws AtlasException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Putting {} events", (Object)events.size());
        }
        Table table = null;
        try {
            table = this.connection.getTable(this.tableName);
            ArrayList<Put> puts = new ArrayList<Put>(events.size());
            for (int index = 0; index < events.size(); ++index) {
                EntityAuditEvent event = events.get(index);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding entity audit event {}", (Object)event);
                }
                Put put = new Put(this.getKey(event.getEntityId(), event.getTimestamp(), index));
                this.addColumn(put, COLUMN_ACTION, event.getAction());
                this.addColumn(put, COLUMN_USER, event.getUser());
                this.addColumn(put, COLUMN_DETAIL, event.getDetails());
                this.addColumn(put, COLUMN_TYPE, EntityAuditEventV2.EntityAuditType.ENTITY_AUDIT_V1);
                if (persistEntityDefinition) {
                    this.addColumn(put, COLUMN_DEFINITION, event.getEntityDefinitionString());
                }
                puts.add(put);
            }
            table.put(puts);
        }
        catch (IOException e) {
            try {
                throw new AtlasException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.close((Closeable)table);
                throw throwable;
            }
        }
        this.close((Closeable)table);
    }

    @Override
    public void putEventsV2(List<EntityAuditEventV2> events) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Putting {} events", (Object)events.size());
        }
        Table table = null;
        try {
            table = this.connection.getTable(this.tableName);
            ArrayList<Put> puts = new ArrayList<Put>(events.size());
            for (int index = 0; index < events.size(); ++index) {
                EntityAuditEventV2 event = events.get(index);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding entity audit event {}", (Object)event);
                }
                Put put = new Put(this.getKey(event.getEntityId(), event.getTimestamp(), index));
                this.addColumn(put, COLUMN_ACTION, event.getAction());
                this.addColumn(put, COLUMN_USER, event.getUser());
                this.addColumn(put, COLUMN_DETAIL, event.getDetails());
                this.addColumn(put, COLUMN_TYPE, EntityAuditEventV2.EntityAuditType.ENTITY_AUDIT_V2);
                if (persistEntityDefinition) {
                    this.addColumn(put, COLUMN_DEFINITION, event.getEntityDefinitionString());
                }
                puts.add(put);
            }
            table.put(puts);
        }
        catch (IOException e) {
            throw new AtlasBaseException((Throwable)e);
        }
        finally {
            try {
                this.close((Closeable)table);
            }
            catch (AtlasException e) {
                throw new AtlasBaseException((Throwable)e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<EntityAuditEventV2> listEventsV2(String entityId, String startKey, short n) throws AtlasBaseException {
        ArrayList<EntityAuditEventV2> arrayList;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Listing events for entity id {}, starting timestamp {}, #records {}", new Object[]{entityId, startKey, n});
        }
        Table table = null;
        ResultScanner scanner = null;
        try {
            Result result;
            table = this.connection.getTable(this.tableName);
            Scan scan = new Scan().setReversed(true).setFilter((Filter)new PageFilter((long)n)).setStopRow(Bytes.toBytes((String)entityId)).setCaching((int)n).setSmall(true);
            if (StringUtils.isEmpty((String)startKey)) {
                byte[] entityBytes = this.getKey(entityId, Long.MAX_VALUE, Integer.MAX_VALUE);
                scan = scan.setStartRow(entityBytes);
            } else {
                scan = scan.setStartRow(Bytes.toBytes((String)startKey));
            }
            scanner = table.getScanner(scan);
            ArrayList<EntityAuditEventV2> events = new ArrayList<EntityAuditEventV2>();
            while ((result = scanner.next()) != null && events.size() < n) {
                EntityAuditEventV2 event = this.fromKeyV2(result.getRow());
                if (!event.getEntityId().equals(entityId)) continue;
                event.setUser(this.getResultString(result, COLUMN_USER));
                event.setAction(EntityAuditEventV2.EntityAuditActionV2.fromString((String)this.getResultString(result, COLUMN_ACTION)));
                event.setDetails(this.getEntityDetails(result));
                event.setType(this.getAuditType(result));
                if (persistEntityDefinition) {
                    event.setEntityDefinition(this.getEntityDefinition(result));
                }
                events.add(event);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Got events for entity id {}, starting timestamp {}, #records {}", new Object[]{entityId, startKey, events.size()});
            }
            arrayList = events;
        }
        catch (IOException e) {
            try {
                throw new AtlasBaseException((Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    this.close((Closeable)scanner);
                    this.close((Closeable)table);
                    throw throwable;
                }
                catch (AtlasException e2) {
                    throw new AtlasBaseException((Throwable)e2);
                }
            }
        }
        try {
            this.close((Closeable)scanner);
            this.close((Closeable)table);
            return arrayList;
        }
        catch (AtlasException e) {
            throw new AtlasBaseException((Throwable)e);
        }
    }

    private String getEntityDefinition(Result result) throws AtlasBaseException {
        String ret = this.getResultString(result, COLUMN_DEFINITION);
        if (this.getAuditType(result) != EntityAuditEventV2.EntityAuditType.ENTITY_AUDIT_V2) {
            Referenceable referenceable = (Referenceable)AtlasType.fromV1Json((String)ret, Referenceable.class);
            AtlasEntity entity = this.toAtlasEntity(referenceable);
            ret = AtlasType.toJson((Object)entity);
        }
        return ret;
    }

    private String getEntityDetails(Result result) throws AtlasBaseException {
        String ret = this.getAuditType(result) == EntityAuditEventV2.EntityAuditType.ENTITY_AUDIT_V2 ? this.getResultString(result, COLUMN_DETAIL) : this.getV2Details(result);
        return ret;
    }

    private EntityAuditEventV2.EntityAuditType getAuditType(Result result) {
        String typeString = this.getResultString(result, COLUMN_TYPE);
        EntityAuditEventV2.EntityAuditType ret = typeString != null ? EntityAuditEventV2.EntityAuditType.valueOf((String)typeString) : EntityAuditEventV2.EntityAuditType.ENTITY_AUDIT_V1;
        return ret;
    }

    private String getV2Details(Result result) throws AtlasBaseException {
        String ret = null;
        String v1DetailsWithPrefix = this.getResultString(result, COLUMN_DETAIL);
        if (StringUtils.isNotEmpty((String)v1DetailsWithPrefix)) {
            EntityAuditEvent.EntityAuditAction v1AuditAction = EntityAuditEvent.EntityAuditAction.fromString((String)this.getResultString(result, COLUMN_ACTION));
            if (v1AuditAction == EntityAuditEvent.EntityAuditAction.TERM_ADD || v1AuditAction == EntityAuditEvent.EntityAuditAction.TERM_DELETE) {
                ret = v1DetailsWithPrefix;
            } else {
                String v1AuditPrefix = EntityAuditListener.getV1AuditPrefix(v1AuditAction);
                Object[] split = v1DetailsWithPrefix.split(v1AuditPrefix);
                if (ArrayUtils.isNotEmpty((Object[])split) && split.length == 2) {
                    Object v2Json;
                    Object v1AuditDetails = split[1];
                    Referenceable referenceable = (Referenceable)AtlasType.fromV1Json((String)v1AuditDetails, Referenceable.class);
                    Object object = v2Json = referenceable != null ? this.toV2Json(referenceable, v1AuditAction) : v1AuditDetails;
                    if (v2Json != null) {
                        ret = EntityAuditListener.getV2AuditPrefix(v1AuditAction) + (String)v2Json;
                    }
                } else {
                    ret = v1DetailsWithPrefix;
                }
            }
        }
        return ret;
    }

    private String toV2Json(Referenceable referenceable, EntityAuditEvent.EntityAuditAction action) throws AtlasBaseException {
        String ret;
        if (action == EntityAuditEvent.EntityAuditAction.TAG_ADD || action == EntityAuditEvent.EntityAuditAction.TAG_UPDATE || action == EntityAuditEvent.EntityAuditAction.TAG_DELETE) {
            AtlasClassification classification = this.instanceConverter.toAtlasClassification((Struct)referenceable);
            ret = AtlasType.toJson((Object)classification);
        } else {
            AtlasEntity entity = this.toAtlasEntity(referenceable);
            ret = AtlasType.toJson((Object)entity);
        }
        return ret;
    }

    private AtlasEntity toAtlasEntity(Referenceable referenceable) throws AtlasBaseException {
        AtlasEntity ret = null;
        AtlasEntity.AtlasEntitiesWithExtInfo entitiesWithExtInfo = this.instanceConverter.toAtlasEntity(referenceable);
        if (entitiesWithExtInfo != null && CollectionUtils.isNotEmpty((Collection)entitiesWithExtInfo.getEntities())) {
            ret = (AtlasEntity)entitiesWithExtInfo.getEntities().get(0);
        }
        return ret;
    }

    private <T> void addColumn(Put put, byte[] columnName, T columnValue) {
        if (columnValue != null && !columnValue.toString().isEmpty()) {
            put.addColumn(COLUMN_FAMILY, columnName, Bytes.toBytes((String)columnValue.toString()));
        }
    }

    @Override
    public List<EntityAuditEvent> listEventsV1(String entityId, String startKey, short n) throws AtlasException {
        ArrayList<EntityAuditEvent> arrayList;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Listing events for entity id {}, starting timestamp {}, #records {}", new Object[]{entityId, startKey, n});
        }
        Table table = null;
        ResultScanner scanner = null;
        try {
            Result result;
            table = this.connection.getTable(this.tableName);
            Scan scan = new Scan().setReversed(true).setFilter((Filter)new PageFilter((long)n)).setStopRow(Bytes.toBytes((String)entityId)).setCaching((int)n).setSmall(true);
            if (StringUtils.isEmpty((String)startKey)) {
                byte[] entityBytes = this.getKey(entityId, Long.MAX_VALUE, Integer.MAX_VALUE);
                scan = scan.setStartRow(entityBytes);
            } else {
                scan = scan.setStartRow(Bytes.toBytes((String)startKey));
            }
            scanner = table.getScanner(scan);
            ArrayList<EntityAuditEvent> events = new ArrayList<EntityAuditEvent>();
            while ((result = scanner.next()) != null && events.size() < n) {
                String colDef;
                EntityAuditEvent event = this.fromKey(result.getRow());
                if (!event.getEntityId().equals(entityId)) continue;
                event.setUser(this.getResultString(result, COLUMN_USER));
                event.setAction(EntityAuditEvent.EntityAuditAction.fromString((String)this.getResultString(result, COLUMN_ACTION)));
                event.setDetails(this.getResultString(result, COLUMN_DETAIL));
                if (persistEntityDefinition && (colDef = this.getResultString(result, COLUMN_DEFINITION)) != null) {
                    event.setEntityDefinition(colDef);
                }
                events.add(event);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Got events for entity id {}, starting timestamp {}, #records {}", new Object[]{entityId, startKey, events.size()});
            }
            arrayList = events;
        }
        catch (IOException e) {
            try {
                throw new AtlasException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.close((Closeable)scanner);
                this.close((Closeable)table);
                throw throwable;
            }
        }
        this.close((Closeable)scanner);
        this.close((Closeable)table);
        return arrayList;
    }

    private String getResultString(Result result, byte[] columnName) {
        byte[] rawValue = result.getValue(COLUMN_FAMILY, columnName);
        if (rawValue != null) {
            return Bytes.toString((byte[])rawValue);
        }
        return null;
    }

    private EntityAuditEvent fromKey(byte[] keyBytes) {
        String key = Bytes.toString((byte[])keyBytes);
        EntityAuditEvent event = new EntityAuditEvent();
        if (StringUtils.isNotEmpty((String)key)) {
            String[] parts = key.split(":");
            event.setEntityId(parts[0]);
            event.setTimestamp(Long.valueOf(parts[1]).longValue());
            event.setEventKey(key);
        }
        return event;
    }

    private EntityAuditEventV2 fromKeyV2(byte[] keyBytes) {
        String key = Bytes.toString((byte[])keyBytes);
        EntityAuditEventV2 event = new EntityAuditEventV2();
        if (StringUtils.isNotEmpty((String)key)) {
            String[] parts = key.split(":");
            event.setEntityId(parts[0]);
            event.setTimestamp(Long.valueOf(parts[1]).longValue());
            event.setEventKey(key);
        }
        return event;
    }

    private void close(Closeable closeable) throws AtlasException {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                throw new AtlasException((Throwable)e);
            }
        }
    }

    public static Configuration getHBaseConfiguration(org.apache.commons.configuration.Configuration atlasConf) throws AtlasException {
        Properties properties = ApplicationProperties.getSubsetAsProperties((org.apache.commons.configuration.Configuration)atlasConf, (String)"atlas.audit");
        Configuration hbaseConf = HBaseConfiguration.create();
        for (String key : properties.stringPropertyNames()) {
            String value = properties.getProperty(key);
            LOG.info("adding HBase configuration: {}={}", (Object)key, (Object)value);
            hbaseConf.set(key, value);
        }
        return hbaseConf;
    }

    private void createTableIfNotExists() throws AtlasException {
        Admin admin = null;
        try {
            admin = this.connection.getAdmin();
            LOG.info("Checking if table {} exists", (Object)this.tableName.getNameAsString());
            if (!admin.tableExists(this.tableName)) {
                LOG.info("Creating table {}", (Object)this.tableName.getNameAsString());
                HTableDescriptor tableDescriptor = new HTableDescriptor(this.tableName);
                HColumnDescriptor columnFamily = new HColumnDescriptor(COLUMN_FAMILY);
                columnFamily.setMaxVersions(1);
                columnFamily.setDataBlockEncoding(DataBlockEncoding.FAST_DIFF);
                columnFamily.setCompressionType(Compression.Algorithm.GZ);
                columnFamily.setBloomFilterType(BloomType.ROW);
                tableDescriptor.addFamily(columnFamily);
                admin.createTable(tableDescriptor);
            } else {
                LOG.info("Table {} exists", (Object)this.tableName.getNameAsString());
            }
        }
        catch (IOException e) {
            throw new AtlasException((Throwable)e);
        }
        finally {
            this.close((Closeable)admin);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Set<String> getEntitiesWithTagChanges(long fromTimestamp, long toTimestamp) throws AtlasBaseException {
        HashSet<String> hashSet;
        String classificationUpdatesAction = "CLASSIFICATION_";
        if (LOG.isDebugEnabled()) {
            LOG.debug("Listing events for fromTimestamp {}, toTimestamp {}, action {}", (Object)fromTimestamp, (Object)toTimestamp);
        }
        Table table = null;
        ResultScanner scanner = null;
        try {
            Result result;
            HashSet<String> guids = new HashSet<String>();
            table = this.connection.getTable(this.tableName);
            byte[] filterValue = Bytes.toBytes((String)"CLASSIFICATION_");
            BinaryPrefixComparator binaryPrefixComparator = new BinaryPrefixComparator(filterValue);
            SingleColumnValueFilter filter = new SingleColumnValueFilter(COLUMN_FAMILY, COLUMN_ACTION, CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)binaryPrefixComparator);
            Scan scan = new Scan().setFilter((Filter)filter).setTimeRange(fromTimestamp, toTimestamp);
            scanner = table.getScanner(scan);
            while ((result = scanner.next()) != null) {
                EntityAuditEvent event = this.fromKey(result.getRow());
                if (event == null) continue;
                guids.add(event.getEntityId());
            }
            hashSet = guids;
        }
        catch (IOException e) {
            try {
                throw new AtlasBaseException((Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    this.close((Closeable)scanner);
                    this.close((Closeable)table);
                    throw throwable;
                }
                catch (AtlasException e2) {
                    throw new AtlasBaseException((Throwable)e2);
                }
            }
        }
        try {
            this.close((Closeable)scanner);
            this.close((Closeable)table);
            return hashSet;
        }
        catch (AtlasException e) {
            throw new AtlasBaseException((Throwable)e);
        }
    }

    public void start() throws AtlasException {
        org.apache.commons.configuration.Configuration configuration = ApplicationProperties.get();
        this.startInternal(configuration, HBaseBasedAuditRepository.getHBaseConfiguration(configuration));
    }

    @VisibleForTesting
    void startInternal(org.apache.commons.configuration.Configuration atlasConf, Configuration hbaseConf) throws AtlasException {
        String tableNameStr = atlasConf.getString(CONFIG_TABLE_NAME, DEFAULT_TABLE_NAME);
        this.tableName = TableName.valueOf((String)tableNameStr);
        try {
            this.connection = this.createConnection(hbaseConf);
        }
        catch (IOException e) {
            throw new AtlasException((Throwable)e);
        }
        if (!HAConfiguration.isHAEnabled((org.apache.commons.configuration.Configuration)atlasConf)) {
            LOG.info("HA is disabled. Hence creating table on startup.");
            this.createTableIfNotExists();
        }
    }

    @VisibleForTesting
    protected Connection createConnection(Configuration hbaseConf) throws IOException {
        return ConnectionFactory.createConnection((Configuration)hbaseConf);
    }

    public void stop() throws AtlasException {
        this.close((Closeable)this.connection);
    }

    @Override
    public void instanceIsActive() throws AtlasException {
        LOG.info("Reacting to active: Creating HBase table for Audit if required.");
        this.createTableIfNotExists();
    }
}

