/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.audit;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.atlas.EntityAuditEvent;
import org.apache.atlas.RequestContext;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.listener.EntityChangeListenerV2;
import org.apache.atlas.model.audit.EntityAuditEventV2;
import org.apache.atlas.model.glossary.AtlasGlossaryTerm;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasRelatedObjectId;
import org.apache.atlas.repository.audit.EntityAuditRepository;
import org.apache.atlas.repository.converters.AtlasInstanceConverter;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.utils.AtlasPerfMetrics;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EntityAuditListenerV2
implements EntityChangeListenerV2 {
    private static final Logger LOG = LoggerFactory.getLogger(EntityAuditListenerV2.class);
    private final EntityAuditRepository auditRepository;
    private final AtlasTypeRegistry typeRegistry;
    private final AtlasInstanceConverter instanceConverter;

    @Inject
    public EntityAuditListenerV2(EntityAuditRepository auditRepository, AtlasTypeRegistry typeRegistry, AtlasInstanceConverter instanceConverter) {
        this.auditRepository = auditRepository;
        this.typeRegistry = typeRegistry;
        this.instanceConverter = instanceConverter;
    }

    public void onEntitiesAdded(List<AtlasEntity> entities, boolean isImport) throws AtlasBaseException {
        AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("entityAudit");
        ArrayList<EntityAuditEventV2> events = new ArrayList<EntityAuditEventV2>();
        for (AtlasEntity entity : entities) {
            EntityAuditEventV2 event = this.createEvent(entity, isImport ? EntityAuditEventV2.EntityAuditActionV2.ENTITY_IMPORT_CREATE : EntityAuditEventV2.EntityAuditActionV2.ENTITY_CREATE);
            events.add(event);
        }
        this.auditRepository.putEventsV2(events);
        RequestContext.get().endMetricRecord(metric);
    }

    public void onEntitiesUpdated(List<AtlasEntity> entities, boolean isImport) throws AtlasBaseException {
        AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("entityAudit");
        ArrayList<EntityAuditEventV2> events = new ArrayList<EntityAuditEventV2>();
        for (AtlasEntity entity : entities) {
            EntityAuditEventV2 event = this.createEvent(entity, isImport ? EntityAuditEventV2.EntityAuditActionV2.ENTITY_IMPORT_UPDATE : EntityAuditEventV2.EntityAuditActionV2.ENTITY_UPDATE);
            events.add(event);
        }
        this.auditRepository.putEventsV2(events);
        RequestContext.get().endMetricRecord(metric);
    }

    public void onEntitiesDeleted(List<AtlasEntity> entities, boolean isImport) throws AtlasBaseException {
        AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("entityAudit");
        ArrayList<EntityAuditEventV2> events = new ArrayList<EntityAuditEventV2>();
        for (AtlasEntity entity : entities) {
            EntityAuditEventV2 event = this.createEvent(entity, isImport ? EntityAuditEventV2.EntityAuditActionV2.ENTITY_IMPORT_DELETE : EntityAuditEventV2.EntityAuditActionV2.ENTITY_DELETE, "Deleted entity");
            events.add(event);
        }
        this.auditRepository.putEventsV2(events);
        RequestContext.get().endMetricRecord(metric);
    }

    public void onClassificationsAdded(AtlasEntity entity, List<AtlasClassification> classifications) throws AtlasBaseException {
        if (CollectionUtils.isNotEmpty(classifications)) {
            AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("entityAudit");
            ArrayList<EntityAuditEventV2> events = new ArrayList<EntityAuditEventV2>();
            for (AtlasClassification classification : classifications) {
                if (entity.getGuid().equals(classification.getEntityGuid())) {
                    events.add(this.createEvent(entity, EntityAuditEventV2.EntityAuditActionV2.CLASSIFICATION_ADD, "Added classification: " + AtlasType.toJson((Object)classification)));
                    continue;
                }
                events.add(this.createEvent(entity, EntityAuditEventV2.EntityAuditActionV2.PROPAGATED_CLASSIFICATION_ADD, "Added propagated classification: " + AtlasType.toJson((Object)classification)));
            }
            this.auditRepository.putEventsV2(events);
            RequestContext.get().endMetricRecord(metric);
        }
    }

    public void onClassificationsUpdated(AtlasEntity entity, List<AtlasClassification> classifications) throws AtlasBaseException {
        if (CollectionUtils.isNotEmpty(classifications)) {
            AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("entityAudit");
            ArrayList<EntityAuditEventV2> events = new ArrayList<EntityAuditEventV2>();
            String guid = entity.getGuid();
            for (AtlasClassification classification : classifications) {
                if (guid.equals(classification.getEntityGuid())) {
                    events.add(this.createEvent(entity, EntityAuditEventV2.EntityAuditActionV2.CLASSIFICATION_UPDATE, "Updated classification: " + AtlasType.toJson((Object)classification)));
                    continue;
                }
                if (this.isPropagatedClassificationAdded(guid, classification)) {
                    events.add(this.createEvent(entity, EntityAuditEventV2.EntityAuditActionV2.PROPAGATED_CLASSIFICATION_ADD, "Added propagated classification: " + AtlasType.toJson((Object)classification)));
                    continue;
                }
                if (this.isPropagatedClassificationDeleted(guid, classification)) {
                    events.add(this.createEvent(entity, EntityAuditEventV2.EntityAuditActionV2.PROPAGATED_CLASSIFICATION_DELETE, "Deleted propagated classification: " + classification.getTypeName()));
                    continue;
                }
                events.add(this.createEvent(entity, EntityAuditEventV2.EntityAuditActionV2.PROPAGATED_CLASSIFICATION_UPDATE, "Updated propagated classification: " + AtlasType.toJson((Object)classification)));
            }
            this.auditRepository.putEventsV2(events);
            RequestContext.get().endMetricRecord(metric);
        }
    }

    public void onClassificationsDeleted(AtlasEntity entity, List<AtlasClassification> classifications) throws AtlasBaseException {
        if (CollectionUtils.isNotEmpty(classifications)) {
            AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("entityAudit");
            ArrayList<EntityAuditEventV2> events = new ArrayList<EntityAuditEventV2>();
            for (AtlasClassification classification : classifications) {
                if (StringUtils.equals((CharSequence)entity.getGuid(), (CharSequence)classification.getEntityGuid())) {
                    events.add(this.createEvent(entity, EntityAuditEventV2.EntityAuditActionV2.CLASSIFICATION_DELETE, "Deleted classification: " + classification.getTypeName()));
                    continue;
                }
                events.add(this.createEvent(entity, EntityAuditEventV2.EntityAuditActionV2.PROPAGATED_CLASSIFICATION_DELETE, "Deleted propagated classification: " + classification.getTypeName()));
            }
            this.auditRepository.putEventsV2(events);
            RequestContext.get().endMetricRecord(metric);
        }
    }

    public void onTermAdded(AtlasGlossaryTerm term, List<AtlasRelatedObjectId> entities) throws AtlasBaseException {
        if (term != null && CollectionUtils.isNotEmpty(entities)) {
            AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("entityAudit");
            ArrayList<EntityAuditEventV2> events = new ArrayList<EntityAuditEventV2>();
            for (AtlasRelatedObjectId relatedObjectId : entities) {
                AtlasEntity entity = this.instanceConverter.getAndCacheEntity(relatedObjectId.getGuid());
                if (entity == null) continue;
                events.add(this.createEvent(entity, EntityAuditEventV2.EntityAuditActionV2.TERM_ADD, "Added term: " + term.toAuditString()));
            }
            this.auditRepository.putEventsV2(events);
            RequestContext.get().endMetricRecord(metric);
        }
    }

    public void onTermDeleted(AtlasGlossaryTerm term, List<AtlasRelatedObjectId> entities) throws AtlasBaseException {
        if (term != null && CollectionUtils.isNotEmpty(entities)) {
            AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("entityAudit");
            ArrayList<EntityAuditEventV2> events = new ArrayList<EntityAuditEventV2>();
            for (AtlasRelatedObjectId relatedObjectId : entities) {
                AtlasEntity entity = this.instanceConverter.getAndCacheEntity(relatedObjectId.getGuid());
                if (entity == null) continue;
                events.add(this.createEvent(entity, EntityAuditEventV2.EntityAuditActionV2.TERM_DELETE, "Deleted term: " + term.toAuditString()));
            }
            this.auditRepository.putEventsV2(events);
            RequestContext.get().endMetricRecord(metric);
        }
    }

    private EntityAuditEventV2 createEvent(AtlasEntity entity, EntityAuditEventV2.EntityAuditActionV2 action, String details) {
        return new EntityAuditEventV2(entity.getGuid(), RequestContext.get().getRequestTime(), RequestContext.get().getUser(), action, details, entity);
    }

    private EntityAuditEventV2 createEvent(AtlasEntity entity, EntityAuditEventV2.EntityAuditActionV2 action) {
        String detail = this.getAuditEventDetail(entity, action);
        return this.createEvent(entity, action, detail);
    }

    private String getAuditEventDetail(AtlasEntity entity, EntityAuditEventV2.EntityAuditActionV2 action) {
        Map<String, Object> prunedAttributes = this.pruneEntityAttributesForAudit(entity);
        String auditPrefix = this.getV2AuditPrefix(action);
        String auditString = auditPrefix + AtlasType.toJson((Object)entity);
        byte[] auditBytes = auditString.getBytes(StandardCharsets.UTF_8);
        long auditSize = auditBytes != null ? (long)auditBytes.length : 0L;
        long auditMaxSize = this.auditRepository.repositoryMaxSize();
        if (auditMaxSize >= 0L && auditSize > auditMaxSize) {
            LOG.warn("audit record too long: entityType={}, guid={}, size={}; maxSize={}. entity attribute values not stored in audit", new Object[]{entity.getTypeName(), entity.getGuid(), auditSize, auditMaxSize});
            Map attrValues = entity.getAttributes();
            Map relAttrValues = entity.getRelationshipAttributes();
            entity.setAttributes(null);
            entity.setRelationshipAttributes(null);
            auditString = auditPrefix + AtlasType.toJson((Object)entity);
            auditBytes = auditString.getBytes(StandardCharsets.UTF_8);
            long l = auditSize = auditBytes != null ? (long)auditBytes.length : 0L;
            if (auditMaxSize >= 0L && auditSize > auditMaxSize) {
                LOG.warn("audit record still too long: entityType={}, guid={}, size={}; maxSize={}. audit will have only summary details", new Object[]{entity.getTypeName(), entity.getGuid(), auditSize, auditMaxSize});
                AtlasEntity shallowEntity = new AtlasEntity();
                shallowEntity.setGuid(entity.getGuid());
                shallowEntity.setTypeName(entity.getTypeName());
                shallowEntity.setCreateTime(entity.getCreateTime());
                shallowEntity.setUpdateTime(entity.getUpdateTime());
                shallowEntity.setCreatedBy(entity.getCreatedBy());
                shallowEntity.setUpdatedBy(entity.getUpdatedBy());
                shallowEntity.setStatus(entity.getStatus());
                shallowEntity.setVersion(entity.getVersion());
                auditString = auditPrefix + AtlasType.toJson((Object)shallowEntity);
            }
            entity.setAttributes(attrValues);
            entity.setRelationshipAttributes(relAttrValues);
        }
        this.restoreEntityAttributes(entity, prunedAttributes);
        return auditString;
    }

    private boolean isPropagatedClassificationAdded(String guid, AtlasClassification classification) {
        Map addedPropagations = RequestContext.get().getAddedPropagations();
        return this.hasPropagatedEntry(addedPropagations, guid, classification);
    }

    private boolean isPropagatedClassificationDeleted(String guid, AtlasClassification classification) {
        Map removedPropagations = RequestContext.get().getRemovedPropagations();
        return this.hasPropagatedEntry(removedPropagations, guid, classification);
    }

    private boolean hasPropagatedEntry(Map<String, List<AtlasClassification>> propagationsMap, String guid, AtlasClassification classification) {
        boolean ret = false;
        if (MapUtils.isNotEmpty(propagationsMap) && propagationsMap.containsKey(guid) && CollectionUtils.isNotEmpty((Collection)propagationsMap.get(guid))) {
            List<AtlasClassification> classifications = propagationsMap.get(guid);
            String classificationName = classification.getTypeName();
            String entityGuid = classification.getEntityGuid();
            for (AtlasClassification c : classifications) {
                if (!StringUtils.equals((CharSequence)c.getTypeName(), (CharSequence)classificationName) || !StringUtils.equals((CharSequence)c.getEntityGuid(), (CharSequence)entityGuid)) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    private Map<String, Object> pruneEntityAttributesForAudit(AtlasEntity entity) {
        HashMap ret = null;
        Map entityAttributes = entity.getAttributes();
        List<String> excludeAttributes = this.auditRepository.getAuditExcludeAttributes(entity.getTypeName());
        AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(entity.getTypeName());
        if (CollectionUtils.isNotEmpty(excludeAttributes) && MapUtils.isNotEmpty((Map)entityAttributes) && entityType != null) {
            for (AtlasStructType.AtlasAttribute attribute : entityType.getAllAttributes().values()) {
                String attrName = attribute.getName();
                Object attrValue = entityAttributes.get(attrName);
                if (!excludeAttributes.contains(attrName)) continue;
                if (ret == null) {
                    ret = new HashMap();
                }
                ret.put(attrName, attrValue);
                entityAttributes.remove(attrName);
            }
        }
        return ret;
    }

    private void restoreEntityAttributes(AtlasEntity entity, Map<String, Object> prunedAttributes) {
        if (MapUtils.isEmpty(prunedAttributes)) {
            return;
        }
        AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(entity.getTypeName());
        if (entityType != null && MapUtils.isNotEmpty((Map)entityType.getAllAttributes())) {
            for (AtlasStructType.AtlasAttribute attribute : entityType.getAllAttributes().values()) {
                String attrName = attribute.getName();
                if (!prunedAttributes.containsKey(attrName)) continue;
                entity.setAttribute(attrName, prunedAttributes.get(attrName));
            }
        }
    }

    private String getV1AuditPrefix(EntityAuditEvent.EntityAuditAction action) {
        String ret;
        switch (action) {
            case ENTITY_CREATE: {
                ret = "Created: ";
                break;
            }
            case ENTITY_UPDATE: {
                ret = "Updated: ";
                break;
            }
            case ENTITY_DELETE: {
                ret = "Deleted: ";
                break;
            }
            case TAG_ADD: {
                ret = "Added classification: ";
                break;
            }
            case TAG_DELETE: {
                ret = "Deleted classification: ";
                break;
            }
            case TAG_UPDATE: {
                ret = "Updated classification: ";
                break;
            }
            case ENTITY_IMPORT_CREATE: {
                ret = "Created by import: ";
                break;
            }
            case ENTITY_IMPORT_UPDATE: {
                ret = "Updated by import: ";
                break;
            }
            case ENTITY_IMPORT_DELETE: {
                ret = "Deleted by import: ";
                break;
            }
            case TERM_ADD: {
                ret = "Added term: ";
                break;
            }
            case TERM_DELETE: {
                ret = "Deleted term: ";
                break;
            }
            default: {
                ret = "Unknown: ";
            }
        }
        return ret;
    }

    private String getV2AuditPrefix(EntityAuditEventV2.EntityAuditActionV2 action) {
        String ret;
        switch (action) {
            case ENTITY_CREATE: {
                ret = "Created: ";
                break;
            }
            case ENTITY_UPDATE: {
                ret = "Updated: ";
                break;
            }
            case ENTITY_DELETE: {
                ret = "Deleted: ";
                break;
            }
            case CLASSIFICATION_ADD: {
                ret = "Added classification: ";
                break;
            }
            case CLASSIFICATION_DELETE: {
                ret = "Deleted classification: ";
                break;
            }
            case CLASSIFICATION_UPDATE: {
                ret = "Updated classification: ";
                break;
            }
            case ENTITY_IMPORT_CREATE: {
                ret = "Created by import: ";
                break;
            }
            case ENTITY_IMPORT_UPDATE: {
                ret = "Updated by import: ";
                break;
            }
            case ENTITY_IMPORT_DELETE: {
                ret = "Deleted by import: ";
                break;
            }
            case TERM_ADD: {
                ret = "Added term: ";
                break;
            }
            case TERM_DELETE: {
                ret = "Deleted term: ";
                break;
            }
            default: {
                ret = "Unknown: ";
            }
        }
        return ret;
    }
}

