/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.audit;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasException;
import org.apache.atlas.EntityAuditEvent;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.listener.ActiveStateChangeHandler;
import org.apache.atlas.model.audit.EntityAuditEventV2;
import org.apache.atlas.repository.audit.EntityAuditRepository;
import org.apache.atlas.repository.audit.HBaseBasedAuditRepository;
import org.apache.atlas.service.Service;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.configuration.Configuration;
import org.apache.hadoop.hbase.util.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStorageBasedAuditRepository
implements Service,
EntityAuditRepository,
ActiveStateChangeHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseBasedAuditRepository.class);
    private static final String AUDIT_REPOSITORY_MAX_SIZE_PROPERTY = "atlas.hbase.client.keyvalue.maxsize";
    private static final String AUDIT_EXCLUDE_ATTRIBUTE_PROPERTY = "atlas.audit.hbase.entity";
    private static final long ATLAS_HBASE_KEYVALUE_DEFAULT_SIZE = 0x100000L;
    public static final String CONFIG_PREFIX = "atlas.audit";
    public static final String CONFIG_PERSIST_ENTITY_DEFINITION = "atlas.audit.persistEntityDefinition";
    protected static final String FIELD_SEPARATOR = ":";
    protected static Configuration APPLICATION_PROPERTIES = null;
    protected Map<String, List<String>> auditExcludedAttributesCache = new HashMap<String, List<String>>();
    protected static boolean persistEntityDefinition;

    public void instanceIsActive() throws AtlasException {
        LOG.info("Reacting to active: No action for now.");
    }

    public void instanceIsPassive() {
        LOG.info("Reacting to passive: No action for now.");
    }

    public int getHandlerOrder() {
        return ActiveStateChangeHandler.HandlerOrder.AUDIT_REPOSITORY.getOrder();
    }

    @Override
    public void putEventsV1(EntityAuditEvent ... events) throws AtlasException {
        this.putEventsV1(Arrays.asList(events));
    }

    @Override
    public void putEventsV2(EntityAuditEventV2 ... events) throws AtlasBaseException {
        this.putEventsV2(Arrays.asList(events));
    }

    @Override
    public List<Object> listEvents(String entityId, String startKey, short maxResults) throws AtlasBaseException {
        List ret = this.listEventsV2(entityId, startKey, maxResults);
        try {
            if (CollectionUtils.isEmpty((Collection)ret)) {
                ret = this.listEventsV1(entityId, startKey, maxResults);
            }
        }
        catch (AtlasException e) {
            throw new AtlasBaseException((Throwable)e);
        }
        return ret;
    }

    @Override
    public long repositoryMaxSize() {
        this.initApplicationProperties();
        long ret = APPLICATION_PROPERTIES == null ? 0x100000L : APPLICATION_PROPERTIES.getLong(AUDIT_REPOSITORY_MAX_SIZE_PROPERTY, 0x100000L);
        return ret;
    }

    @Override
    public List<String> getAuditExcludeAttributes(String entityType) {
        List<String> ret = null;
        this.initApplicationProperties();
        if (this.auditExcludedAttributesCache.containsKey(entityType)) {
            ret = this.auditExcludedAttributesCache.get(entityType);
        } else if (APPLICATION_PROPERTIES != null) {
            String[] excludeAttributes = APPLICATION_PROPERTIES.getStringArray("atlas.audit.hbase.entity." + entityType + ".attributes.exclude");
            if (excludeAttributes != null) {
                ret = Arrays.asList(excludeAttributes);
            }
            this.auditExcludedAttributesCache.put(entityType, ret);
        }
        return ret;
    }

    protected void initApplicationProperties() {
        if (APPLICATION_PROPERTIES == null) {
            try {
                APPLICATION_PROPERTIES = ApplicationProperties.get();
            }
            catch (AtlasException atlasException) {
                // empty catch block
            }
        }
    }

    @VisibleForTesting
    protected void setApplicationProperties(Configuration config) {
        APPLICATION_PROPERTIES = config;
    }

    protected byte[] getKey(String id, Long ts, int index) {
        assert (id != null) : "entity id can't be null";
        assert (ts != null) : "timestamp can't be null";
        String keyStr = id + FIELD_SEPARATOR + ts + FIELD_SEPARATOR + index;
        return Bytes.toBytes((String)keyStr);
    }

    static {
        try {
            persistEntityDefinition = ApplicationProperties.get().getBoolean(CONFIG_PERSIST_ENTITY_DEFINITION, false);
        }
        catch (AtlasException e) {
            throw new RuntimeException(e);
        }
    }
}

