/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.query;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringJoiner;
import org.apache.atlas.query.GremlinClause;

class SelectClauseComposer {
    private static final String COUNT_STR = "count";
    private static final String MIN_STR = "min";
    private static final String MAX_STR = "max";
    private static final String SUM_STR = "sum";
    public boolean isSelectNoop;
    private String[] labels;
    private String[] attributes;
    private String[] items;
    private Map<String, String> itemAssignmentExprs;
    private int countIdx = -1;
    private int sumIdx = -1;
    private int maxIdx = -1;
    private int minIdx = -1;
    private int aggCount = 0;
    private int introducedTypesCount = 0;
    private int primitiveTypeCount = 0;

    public static boolean isKeyword(String s) {
        return COUNT_STR.equals(s) || MIN_STR.equals(s) || MAX_STR.equals(s) || SUM_STR.equals(s);
    }

    public String[] getItems() {
        return this.items;
    }

    public void setItems(String[] items) {
        this.items = Arrays.copyOf(items, items.length);
    }

    public boolean updateAsApplicable(int currentIndex, String qualifiedName) {
        boolean ret = false;
        if (currentIndex == this.getCountIdx()) {
            ret = this.assign(currentIndex, COUNT_STR, GremlinClause.INLINE_COUNT.get(), GremlinClause.INLINE_ASSIGNMENT);
        } else if (currentIndex == this.getMinIdx()) {
            ret = this.assign(currentIndex, MIN_STR, qualifiedName, GremlinClause.INLINE_ASSIGNMENT, GremlinClause.INLINE_MIN);
        } else if (currentIndex == this.getMaxIdx()) {
            ret = this.assign(currentIndex, MAX_STR, qualifiedName, GremlinClause.INLINE_ASSIGNMENT, GremlinClause.INLINE_MAX);
        } else if (currentIndex == this.getSumIdx()) {
            ret = this.assign(currentIndex, SUM_STR, qualifiedName, GremlinClause.INLINE_ASSIGNMENT, GremlinClause.INLINE_SUM);
        } else {
            this.attributes[currentIndex] = qualifiedName;
        }
        return ret;
    }

    public String[] getAttributes() {
        return this.attributes;
    }

    public void setAttributes(String[] attributes) {
        this.attributes = Arrays.copyOf(attributes, attributes.length);
    }

    public boolean assign(int i, String qualifiedName, GremlinClause clause) {
        this.items[i] = clause.get(qualifiedName);
        return true;
    }

    public String[] getLabels() {
        return this.labels;
    }

    public void setLabels(String[] labels) {
        this.labels = labels;
    }

    public boolean hasAssignmentExpr() {
        return this.itemAssignmentExprs != null && !this.itemAssignmentExprs.isEmpty();
    }

    public boolean onlyAggregators() {
        return this.hasAggregators() && this.aggCount == this.items.length;
    }

    public boolean hasAggregators() {
        return this.aggCount > 0;
    }

    public String getLabelHeader() {
        return this.getJoinedQuotedStr(this.getLabels());
    }

    public String getItemsString() {
        return String.join((CharSequence)",", this.getItems());
    }

    public String getAssignmentExprString() {
        return String.join((CharSequence)" ", this.itemAssignmentExprs.values());
    }

    public String getItem(int i) {
        return this.items[i];
    }

    public String getAttribute(int i) {
        return this.attributes[i];
    }

    public String getLabel(int i) {
        return this.labels[i];
    }

    public int getAttrIndex(String attr) {
        int ret = -1;
        for (int i = 0; i < this.attributes.length; ++i) {
            if (!this.attributes[i].equals(attr)) continue;
            ret = i;
            break;
        }
        return ret;
    }

    private boolean assign(String item, String assignExpr) {
        if (this.itemAssignmentExprs == null) {
            this.itemAssignmentExprs = new LinkedHashMap<String, String>();
        }
        this.itemAssignmentExprs.put(item, assignExpr);
        return true;
    }

    private boolean assign(int i, String s, String p1, GremlinClause clause) {
        this.items[i] = s;
        return this.assign(this.items[i], clause.get(s, p1));
    }

    private boolean assign(int i, String s, String p1, GremlinClause inline, GremlinClause clause) {
        this.items[i] = s;
        return this.assign(this.items[i], inline.get(s, clause.get(p1, p1)));
    }

    public int getCountIdx() {
        return this.countIdx;
    }

    public void setCountIdx(int countIdx) {
        this.countIdx = countIdx;
        ++this.aggCount;
    }

    public int getSumIdx() {
        return this.sumIdx;
    }

    public void setSumIdx(int sumIdx) {
        this.sumIdx = sumIdx;
        ++this.aggCount;
    }

    public int getMaxIdx() {
        return this.maxIdx;
    }

    public void setMaxIdx(int maxIdx) {
        this.maxIdx = maxIdx;
        ++this.aggCount;
    }

    public int getMinIdx() {
        return this.minIdx;
    }

    public void setMinIdx(int minIdx) {
        this.minIdx = minIdx;
        ++this.aggCount;
    }

    public boolean isAggregatorIdx(int idx) {
        return this.getMinIdx() == idx || this.getMaxIdx() == idx || this.getCountIdx() == idx || this.getSumIdx() == idx;
    }

    private String getJoinedQuotedStr(String[] elements) {
        StringJoiner joiner = new StringJoiner(",");
        Arrays.stream(elements).map(x -> x.contains("'") ? "\"" + x + "\"" : "'" + x + "'").forEach(joiner::add);
        return joiner.toString();
    }

    public boolean isAggregatorWithArgument(int i) {
        return i == this.getMaxIdx() || i == this.getMinIdx() || i == this.getSumIdx();
    }

    public void incrementTypesIntroduced() {
        ++this.introducedTypesCount;
    }

    public int getIntroducedTypesCount() {
        return this.introducedTypesCount;
    }

    public void incrementPrimitiveType() {
        ++this.primitiveTypeCount;
    }

    public boolean hasMultipleReferredTypes() {
        return this.getIntroducedTypesCount() > 1;
    }

    public boolean hasMixedAttributes() {
        return this.getIntroducedTypesCount() > 0 && this.getPrimitiveTypeCount() > 0;
    }

    private int getPrimitiveTypeCount() {
        return this.primitiveTypeCount;
    }
}

